/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class PropagateWithinDetailDataItemRefName
extends Transformation {
    public PropagateWithinDetailDataItemRefName() {
        this.mName = "Propagate the Within Detail data item reference name.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String dataItemName = ((V5DataItem)node).getNameProperty();
        IXQEQueryNode withinClause = node.getAncestorOfType(201039);
        withinClause.setPropertyValue("refDataItemName", dataItemName);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(1002) == null) {
            this.traceNodeCondition(false, "The V5 expression function is not within a CogMDX query.", trace);
            return false;
        }
        if (node.getAncestorOfType(201039) == null) {
            this.traceNodeCondition(false, "The node is not under with clause", trace);
            return false;
        }
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node.getAncestorOfType(201039);
        if (withinClause.getWithinClauseType() != 1 && withinClause.getWithinClauseType() != 2) {
            this.traceNodeCondition(false, "The parent node is not within detail/aggregate clause.", trace);
            return false;
        }
        if (withinClause.getPropertyValue("refDataItemName") != null) {
            this.traceNodeCondition(false, "The data item name is already propagated.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The data item is within a within detail clause", trace);
        return true;
    }
}

