/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public final class ValidateV5ValueSummaryFunction
extends Transformation {
    public static final String PROP_APPLIED = "ValidateV5ValueSummaryFunctionApplied";

    public ValidateV5ValueSummaryFunction() {
        this.mName = "Validate Value Summary Function Usage.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201031};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5ValueSummaryFunction summaryFunction = (V5ValueSummaryFunction)node;
        V5DataItem v5DataItem = (V5DataItem)node.getAncestorOfType(101003);
        String dataItemName = "";
        if (summaryFunction.getDistinct()) {
            dataItemName = this.getDataItemName(node, v5DataItem);
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppDistinctInSummaryFunction, dataItemName);
        }
        int v5SummaryType = summaryFunction.getSubType();
        MDXSummaryFunctionTypeEnum mdxSummaryType = MDXSummaryFunctionTypeEnum.convertV5SummaryFunctionTypeToMDXSummaryFunctionType(v5SummaryType);
        if (mdxSummaryType == MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE && v5SummaryType != 2) {
            MDXQuery mdxquery = (MDXQuery)node.getAncestorOfType(1002);
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_ValueSummaryFunctionUnsupportedByDatasource, ((V5ValueSummaryFunction)node).getNativeName(), mdxquery.getDataSourceType());
        }
        IXQEQueryNode childNode = node.getChild(0);
        while (childNode.getType() == 101003) {
            childNode = childNode.getChild(0);
        }
        boolean isValid = false;
        IMeasure measure = null;
        IXQEQueryNode checkChild = childNode;
        if (childNode.getType() == 201113 && childNode.getNumberChildren() == 1 && (checkChild = childNode.getChild(0)).getType() == 201110 && checkChild.getNumberChildren() == 1) {
            checkChild = checkChild.getChild(0);
        }
        if (checkChild.getType() == 201116 && ((V5BoundModelIdentifier)checkChild).isMeasure()) {
            measure = (IMeasure)((V5BoundModelIdentifier)checkChild).getMetadata();
        }
        if (measure != null) {
            if (ValidateV5ValueSummaryFunction.isSummaryTypeValidForMeasure(v5SummaryType, mdxSummaryType, measure)) {
                isValid = true;
            }
        } else if (childNode.isOfCategory(201125)) {
            isValid = true;
        }
        if (!isValid) {
            V5Query query;
            boolean isQSDefinedCalculation;
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            dataItemName = this.getDataItemName(node, v5DataItem);
            boolean bl = isQSDefinedCalculation = v5DataItem != null && v5DataItem.getPropertyValue("isQSDefinedCalculation") == Boolean.TRUE;
            if ((childNode.isOfCategory(201125) || !mdxQuery.isRelationalStyleQuery() && v5SummaryType == 2) && measure == null) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedValueExpressionInSummaryFunction, dataItemName, summaryFunction.getNativeName());
            }
            if (!mdxQuery.isRelationalStyleQuery() && isQSDefinedCalculation) {
                RSAPIDataItem notApplicableDataItem = null;
                if (v5DataItem != null && v5DataItem.getParent() != null && v5DataItem.getParent().getType() == 101015 && v5DataItem.getParent().getParent() != null || v5DataItem.getParent().getParent().getType() == 101051 && v5DataItem.getParent().getParent().getParent() != null && v5DataItem.getParent().getParent().getParent().getType() == 101057) {
                    RSAPIDataItem[] refDataItems;
                    RSAPIEdgeRowset rsapiEdgeRowset = ((V5ValueSet)v5DataItem.getParent().getParent().getParent()).getRSAPIEdgeRowset();
                    for (RSAPIDataItem currDataItem : refDataItems = rsapiEdgeRowset.getDataItems()) {
                        if (!currDataItem.getName().equals(v5DataItem.getNameProperty())) continue;
                        currDataItem.setNotApplicable();
                        notApplicableDataItem = currDataItem;
                        break;
                    }
                }
                if (null == notApplicableDataItem) {
                    isQSDefinedCalculation = false;
                }
            }
            if (!(mdxQuery.isRelationalStyleQuery() || isQSDefinedCalculation || (query = DMRUtilities.findQuery(node)) != null && query.isDMR())) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppValueSummaryRollupMismatch, summaryFunction.getNativeName(), dataItemName);
            }
        }
        node.setPropertyValue(PROP_APPLIED, Boolean.TRUE);
    }

    public static boolean isSummaryTypeValidForMeasure(int v5SummaryType, MDXSummaryFunctionTypeEnum mdxSummaryType, IMeasure measure) {
        String measureAggrName = measure.getRegularAggregate().getModelName();
        switch (v5SummaryType) {
            case 2: {
                if (mdxSummaryType != MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE) break;
                return measureAggrName.compareToIgnoreCase("COUNT") == 0;
            }
            default: {
                if (mdxSummaryType == MDXSummaryFunctionTypeEnum.AGGREGATE) {
                    return true;
                }
                String summaryTypeName = mdxSummaryType.getMDXKeyword();
                if (measureAggrName.compareToIgnoreCase(summaryTypeName) != 0) break;
                return true;
            }
        }
        return false;
    }

    private String getDataItemName(IXQEQueryNode node, V5DataItem v5DataItem) {
        String dataItemName = "";
        if (v5DataItem != null) {
            dataItemName = v5DataItem.getNameProperty();
        } else if (node.getAncestorOfTypes(new int[]{101011, 101008, 1011}) != null) {
            dataItemName = "summaryFilter";
        }
        return dataItemName;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation has already been applied to the target node.", trace);
            return false;
        }
        if (node.getAncestorOfType(1002) == null) {
            this.traceQueryCondition(false, "The node does not have an ancestor MDXQuery node.", trace);
            return false;
        }
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (mdxDetailFilter != null && mdxDetailFilter.pushDetailFilterToRelationalProvider()) {
            this.traceNodeCondition(false, "Not applicable to detail filter expression pushed to relational planning.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation has not been applied to the target node.", trace);
        return true;
    }
}

