/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.validation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.util.fds.FunctionNode;
import com.cognos.xqe.util.fds.IFunctionDefinition;
import com.cognos.xqe.util.fds.IFunctionNode;
import java.util.ArrayList;

public final class ValidateV5ValueSummaryFunctionAgainstDatasource
extends AbstractV5ToCogMDXTransformation {
    public ValidateV5ValueSummaryFunctionAgainstDatasource() {
        this.mName = "Validate V5 value summary function against datasource.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201031};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws XQEOlapUnsupportedQueryException {
        MDXQuery mdxquery = (MDXQuery)node.getAncestorOfType(1002);
        throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_ValueSummaryFunctionUnsupportedByDatasource, ((V5ValueSummaryFunction)node).getNativeName(), mdxquery.getDataSourceType());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object[] functionsArray;
        ArrayList<IFunctionNode> functionList;
        XQETrace trace = environment.getTrace();
        if (((V5ValueSummaryFunction)node).getSubType() == 43) {
            return false;
        }
        if (node.getPropertyValue("ValidateV5ValueSummaryFunctionApplied") != Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation ValidateV5ValueSummaryFunction has not been applied to the target node.", trace);
            return false;
        }
        MDXQuery mdxquery = (MDXQuery)node.getAncestorOfType(1002);
        String dataSource = mdxquery.getDataSourceType();
        try {
            IFunctionDefinition functionDefinition = IFunctionDefinition.Factory.createFDAllLocales();
            functionList = functionDefinition.findFuncListByName(((V5ValueSummaryFunction)node).getNativeName().toLowerCase());
        }
        catch (RuntimeException e) {
            throw new XQERuntimeException(e);
        }
        if (functionList == null) {
            this.traceNodeCondition(false, "Unable to find the function definition.", trace);
            return false;
        }
        for (Object funcNode : functionsArray = functionList.toArray()) {
            if (!((FunctionNode)funcNode).isSupportedByModelDatasourceInterfaceID(dataSource)) continue;
            this.traceNodeCondition(false, "The value summary function is valid for the datasource.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The value summary function is not valid for the datasource.", trace);
        return true;
    }
}

