/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.BuildJoinPlan;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.optimization.RewriteAvgInTermsOfLowestScope;
import com.cognos.xqe.transformation.v5tocogsql.optimization.RewriteCountInTermsOfLowestScope;
import com.cognos.xqe.transformation.v5tocogsql.optimization.RewriteStdevVarInTermsOfLowestScope;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.itemNormalization.ItemNormalization;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqemoser.MoserEmbeddedFilter;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.MoserQuerySubjectWrapper;
import com.cognos.xqemoser.MoserRelationship;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class AggregateThenJoin
extends RQPTransformation {
    private static final String JOINKEYSTR = "joinKey";
    private static final String DYNAMIC_SQS_JOIN = "dynamicSQSJoin_";

    public AggregateThenJoin() {
        this.mName = "AggregateThenJoin.";
        this.mPassNumbers = new int[]{98};
        this.mTypes = new int[]{801039};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        V5Query v5Query = RQPNode.getV5Query(node);
        if (v5Query == null) {
            return false;
        }
        Boolean testingJoins = v5Query.getBooleanPropertyValue("queryForTestJoin");
        if (testingJoins != null && testingJoins.booleanValue()) {
            return false;
        }
        MetadataConnection md = environment.getMetadataConnection();
        if (!(md instanceof MoserMetadataConnection)) {
            return false;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        RQPQuery llSQ = this.getLLSQ(rqpQuery);
        if (llSQ == null) {
            return false;
        }
        RQPJoinPath joinPath = (RQPJoinPath)environment.getNodeFactory().deepCopyNode(node);
        RQPUtilities.bindV5MultiPartIdentifierToModel(joinPath, environment);
        if (!this.exprSpansMultipleSources(environment, joinPath)) {
            return false;
        }
        if (!this.projectionsOrFiltersFromFact((MoserMetadataConnection)md, RQPNode.getRQPQuery(node), joinPath)) {
            return false;
        }
        if (rqpQuery.getDetailFilterList() != null) {
            for (IXQEQueryNode f : rqpQuery.getDetailFilterList().getChildren()) {
                if (!this.exprSpansMultipleSources(environment, f)) continue;
                return false;
            }
        }
        if (this.distinctAggregateFromFactQS(environment, (MoserMetadataConnection)md, rqpQuery, (RQPJoinPath)node)) {
            long maxRowsLocalProcessing = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().fetchLongConfiguration("queryExecution.maxRowsLocalProcessing[@value]", 100000L);
            if (maxRowsLocalProcessing > 0L) {
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).setMaxRowsLocalProcessing(maxRowsLocalProcessing);
                String nagMessage = XQEMessages.getMessage(XQEMessageKeys.WRN_DistinctAggregateLocalProcessing, XQEMessages.getCurrProductLocale(), Long.toString(maxRowsLocalProcessing));
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nagMessage);
            }
            return false;
        }
        return !this.hasNestedAggregate(node, environment, rqpQuery);
    }

    private boolean hasNestedAggregate(IXQEQueryNode node, PlanningEnvironment environment, RQPQuery rqpQuery) {
        DynamicQuerySubjectInfo sqsInfo = this.createSQS(environment, rqpQuery, (RQPJoinPath)node);
        for (IXQEQueryNode p : rqpQuery.getProjectionList().getChildren()) {
            IXQEQueryNode[] refsToDI;
            V5BoundModelIdentifier bmID;
            IMetadata qs;
            RQPDataItem rqpDI = (RQPDataItem)p;
            IXQEQueryNode[] bmIDs = rqpDI.getDescendantsOfType(201116, false);
            if (bmIDs == null || bmIDs.length == 0 || !sqsInfo.containsKey(qs = RQPUtilities.getQSOrShortcut((bmID = (V5BoundModelIdentifier)bmIDs[0]).getMetadata()))) continue;
            for (IXQEQueryNode ref : refsToDI = rqpDI.getAllReferencesToMe()) {
                IXQEQueryNode[] refs;
                RQPDataItem di = (RQPDataItem)ref.getAncestorOfType(801008);
                if (di == null) continue;
                for (IXQEQueryNode r : refs = di.getDescendantsOfType(801009, false)) {
                    IXQEQueryNode exp = ((RQPDataItemRef)r).getReferencedItem().getExpression();
                    if (!RQPUtilities.hasAggregateInExpression(exp)) continue;
                    return true;
                }
            }
        }
        node.setPropertyValue("dynamicQSInfo", sqsInfo);
        return false;
    }

    private boolean distinctAggregateFromFactQS(PlanningEnvironment environment, MoserMetadataConnection mdConn, RQPQuery rqpQuery, RQPJoinPath joinPath) {
        IXQEQueryNode[] aggregates = rqpQuery.getRootRQPQuery().getDescendantsOfType(201031, false, 801017);
        if (aggregates != null) {
            for (IXQEQueryNode a : aggregates) {
                V5ValueSummaryFunction aggr = (V5ValueSummaryFunction)a;
                if (!aggr.getDistinct() || !this.exprReferencesFactQSInJoinPath(mdConn, rqpQuery, joinPath, aggr)) continue;
                return true;
            }
        }
        RQPQuery tabQuery = RQPNode.getRQPQuery(joinPath);
        for (IXQEQueryNode p : tabQuery.getProjectionList().getChildren()) {
            RQPDataItem proj = (RQPDataItem)p;
            if (!proj.getIsRowNumberForDistinct() || !this.exprReferencesFactQSInJoinPath(mdConn, rqpQuery, joinPath, proj)) continue;
            return true;
        }
        return false;
    }

    private boolean exprReferencesFactQSInJoinPath(MoserMetadataConnection mdConn, RQPQuery rqpQuery, RQPJoinPath joinPath, IXQEQueryNode expr) {
        TreeSet<IMetadata> factQuerySubjects = this.getFactQuerySubjects(rqpQuery, joinPath);
        for (IMetadata factQS : factQuerySubjects) {
            if (!AggregateThenJoin.inJoinPath(mdConn, factQS, joinPath)) continue;
            String factSource = this.getMDSource(mdConn, factQS);
            for (IXQEQueryNode b : RQPUtilities.getAllV5BoundReferences(expr)) {
                IAccessedViaShortcut sc;
                V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)b;
                IMetadata md = v5BoundID.getMetadata();
                IMetadata qs = null;
                if (!(md instanceof IQueryItem)) continue;
                qs = ((IQueryItem)md).getQuerySubject();
                if (qs instanceof IAccessedViaShortcut && (sc = (IAccessedViaShortcut)qs).isAccessedViaShortcut()) {
                    qs = sc.getShortcut();
                }
                if (!factSource.equals(this.getMDSource(mdConn, qs))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue("joinSpansMultipleSources", true);
        RQPJoinPath joinPath = (RQPJoinPath)node;
        RQPQuery rqpQuery = RQPNode.getRQPQuery(joinPath);
        DynamicQuerySubjectInfo sqsInfo = this.createSQS(environment, rqpQuery, joinPath);
        this.pushAggregateAndGroupingColumnsToSQS(environment, sqsInfo, rqpQuery);
        this.pushDetailFiltersToSQS(environment, sqsInfo, rqpQuery);
        this.joinSQS(environment, sqsInfo, joinPath.getJoinPath(), rqpQuery);
        joinPath.detach();
        rqpQuery.setPropertyValue("rebuildForDynamicSQS", Boolean.TRUE);
        BuildJoinPlan rebuildJoinPlan = new BuildJoinPlan();
        rebuildJoinPlan.apply((IXQEQueryNode)rqpQuery, environment);
        this.rewriteAggregatesInLLSQ(rqpQuery, environment);
    }

    private void rewriteAggregatesInLLSQ(RQPQuery rqpQuery, PlanningEnvironment environment) {
        RQPQuery llSQ = this.getLLSQ(rqpQuery);
        IXQEQueryNode[] stdAggregates = llSQ.getDescendantsOfType(201031, false);
        RewriteCountInTermsOfLowestScope rewriteCount = new RewriteCountInTermsOfLowestScope();
        RewriteStdevVarInTermsOfLowestScope rewriteAvg = new RewriteStdevVarInTermsOfLowestScope();
        RewriteAvgInTermsOfLowestScope rewriteStdevVar = new RewriteAvgInTermsOfLowestScope();
        for (IXQEQueryNode aggregate : stdAggregates) {
            if (rewriteCount.passesNodeCondition(aggregate, environment)) {
                rewriteCount.apply(aggregate, environment);
                continue;
            }
            if (rewriteAvg.passesNodeCondition(aggregate, environment)) {
                rewriteAvg.apply(aggregate, environment);
                continue;
            }
            if (!rewriteStdevVar.passesNodeCondition(aggregate, environment)) continue;
            rewriteStdevVar.apply(aggregate, environment);
        }
    }

    private RQPQuery getLLSQ(RQPQuery rqpQuery) {
        RQPQuery parentRQPQuery = rqpQuery.getParentRQPQuery();
        return parentRQPQuery.getLowestLevelSummaryQuery();
    }

    private void pushDetailFiltersToSQS(PlanningEnvironment environment, DynamicQuerySubjectInfo sqsInfo, RQPQuery rqpQuery) {
        if (rqpQuery.getDetailFilterList() == null) {
            return;
        }
        MoserMetadataConnection mdMoser = (MoserMetadataConnection)environment.getMetadataConnection();
        for (IXQEQueryNode f : rqpQuery.getDetailFilterList().getChildren()) {
            V5BoundModelIdentifier boundID;
            IMetadata qs;
            if (this.exprSpansMultipleSources(environment, f)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_FiltersSpanMDSources);
            }
            IXQEQueryNode bmID = f.getFirstDescendantOfTypeOrdered(201116, false);
            V5DetailFilter detailFilter = (V5DetailFilter)f;
            int filterID = 1;
            if (bmID == null || detailFilter.getPostAutoAggregation() || !sqsInfo.containsKey(qs = RQPUtilities.getQSOrShortcut((boundID = (V5BoundModelIdentifier)bmID).getMetadata()))) continue;
            MoserQuerySubject targetQS = sqsInfo.get(qs);
            IXQEQueryNode filterExpr = detailFilter.getChild(0);
            MoserEmbeddedFilter embeddedFilter = new MoserEmbeddedFilter(mdMoser.getNextId(), "embeddedFilter" + filterID);
            embeddedFilter.setQuerySubject(targetQS);
            embeddedFilter.setFilterExpression(environment.getNodeFactory().deepCopyNode(filterExpr));
            targetQS.addEmbeddedFilter(embeddedFilter);
            f.detach();
            ++filterID;
        }
        if (rqpQuery.getDetailFilterList().getNumberChildren() == 0) {
            rqpQuery.getDetailFilterList().detach();
        }
    }

    private void joinSQS(PlanningEnvironment environment, DynamicQuerySubjectInfo sqsInfo, List<IMetadata> joinPath, RQPQuery rqpQuery) {
        for (IMetadata j : joinPath) {
            this.addSQSJoin(environment, j, sqsInfo, rqpQuery);
        }
    }

    private void addSQSJoin(PlanningEnvironment environment, IMetadata inJoin, DynamicQuerySubjectInfo sqsInfo, RQPQuery rqpQuery) {
        MoserMetadataConnection mdMoser = (MoserMetadataConnection)environment.getMetadataConnection();
        IRelationship inRelationship = (IRelationship)inJoin;
        boolean isMultiFact = RQPUtilities.getRQPFactManager(rqpQuery).isMultiFact();
        if (isMultiFact ? !sqsInfo.containsKey(inRelationship.getLeftRefObject()) && !sqsInfo.containsKey(inRelationship.getRightRefObject()) : !this.joinSpansMultipleSources(mdMoser, inRelationship)) {
            return;
        }
        long joinID = mdMoser.getNextId();
        String joinName = DYNAMIC_SQS_JOIN + joinID;
        MoserRelationship dynamicJoinForDSQS = new MoserRelationship(joinID, joinName);
        IMetadata[] leftRight = ItemNormalization.getLeftRightObjFromSourceRelationship(mdMoser, inRelationship);
        IMetadata leftQS = leftRight[0];
        IMetadata rightQS = leftRight[1];
        if (sqsInfo.containsKey(leftQS)) {
            dynamicJoinForDSQS.setLeftRefObject(sqsInfo.get(leftQS));
        } else {
            dynamicJoinForDSQS.setLeftRefObject(leftQS);
        }
        dynamicJoinForDSQS.setLeftRefObjectId(mdMoser.getID(dynamicJoinForDSQS.getLeftRefObject()));
        if (sqsInfo.containsKey(rightQS)) {
            dynamicJoinForDSQS.setRightRefObject(sqsInfo.get(rightQS));
        } else {
            dynamicJoinForDSQS.setRightRefObject(rightQS);
        }
        dynamicJoinForDSQS.setRightRefObjectId(mdMoser.getID(dynamicJoinForDSQS.getRightRefObject()));
        dynamicJoinForDSQS.setLeftCardinality(inRelationship.getLeftCardinality());
        dynamicJoinForDSQS.setRightCardinality(inRelationship.getRightCardinality());
        ArrayList<MoserRelationship.MoserLink> links = null;
        if (inRelationship instanceof MoserRelationship && ((MoserRelationship)inRelationship).getLinks() != null) {
            links = new ArrayList<MoserRelationship.MoserLink>();
            for (MoserRelationship.MoserLink moserLink : ((MoserRelationship)inRelationship).getLinks()) {
                MoserRelationship.MoserLink newLink = new MoserRelationship.MoserLink(moserLink.getLeftRefId(), moserLink.getRightRefId(), moserLink.getComparisonOperator());
                links.add(newLink);
            }
            dynamicJoinForDSQS.setLinks(links);
        }
        IXQEQueryNode joinExpr = RQPUtilities.createV5ValueExpression(inRelationship, environment, null);
        RQPUtilities.unwindAndBindModelIdentifiers(environment, joinExpr, RQPNode.getV5Query(rqpQuery));
        for (IXQEQueryNode b : joinExpr.getDescendantsOfType(201116, false)) {
            IAccessedViaShortcut sc;
            V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)b;
            IMetadata md = v5BoundID.getMetadata();
            IMetadata qs = null;
            if (!(md instanceof IQueryItem)) continue;
            qs = ((IQueryItem)md).getQuerySubject();
            if (qs instanceof IAccessedViaShortcut && (sc = (IAccessedViaShortcut)qs).isAccessedViaShortcut()) {
                qs = sc.getShortcut();
            }
            if (!sqsInfo.containsKey(qs)) continue;
            MoserQuerySubject dsqs = sqsInfo.get(qs);
            MoserQueryItem qi = (MoserQueryItem)dsqs.getOrCreateQueryItem("none", "identifier", v5BoundID.getIdentifier(), null, JOINKEYSTR + dsqs.getQueryItemsAndMeasures().size());
            qi.setIsUsedAsJoinKey(true);
            V5BoundModelIdentifier idInDSQS = (V5BoundModelIdentifier)environment.getNodeFactory().createNode(201116);
            idInDSQS.setMetadata(qi);
            idInDSQS.setIdentifier(qi.getV5UniqueName());
            v5BoundID.exchange(idInDSQS);
            this.updateLinks(inRelationship, dynamicJoinForDSQS, links, v5BoundID, dsqs, idInDSQS);
        }
        String string = RQPUtilities.getExpressionString(joinExpr);
        dynamicJoinForDSQS.setExpression(string);
        dynamicJoinForDSQS.setJoinFilterType(inRelationship.getJoinFilterType());
        MoserModule module = mdMoser.getModule();
        dynamicJoinForDSQS.setUniqueID(module.getUniqueName() + "." + dynamicJoinForDSQS.getName());
        dynamicJoinForDSQS.setParentModule(module);
        mdMoser.getModule().addRelationship(dynamicJoinForDSQS);
        List<IMetadata> joinsForFactStream = rqpQuery.getParentRQPQuery().getJoinsForFactStream();
        if (joinsForFactStream != null) {
            joinsForFactStream.add(dynamicJoinForDSQS);
        }
        ((ExecutionEnvironment)environment.getExecutionEnvironment()).registerResource(dynamicJoinForDSQS);
    }

    private void updateLinks(IRelationship inRelationship, MoserRelationship dynamicJoinForDSQS, List<MoserRelationship.MoserLink> links, V5BoundModelIdentifier v5BoundID, IMetadata dsQS, V5BoundModelIdentifier idInDSQS) {
        if (links == null || links.isEmpty()) {
            return;
        }
        String[] nameParts = v5BoundID.getNameParts();
        if (nameParts == null || nameParts.length == 0) {
            return;
        }
        String newRefId = idInDSQS.getNameParts()[idInDSQS.getNameParts().length - 1];
        boolean updateLeft = dynamicJoinForDSQS.getLeftRefObject().equals(dsQS);
        String lastNamePart = nameParts[nameParts.length - 1];
        for (MoserRelationship.MoserLink link : links) {
            if (updateLeft) {
                if (!lastNamePart.equals(link.getLeftRefId()) && !lastNamePart.equals(UniqueNameGenerator.createSingleNamePart(link.getLeftRefId()))) continue;
                link.setLeftRefId(newRefId);
                continue;
            }
            if (!lastNamePart.equals(link.getRightRefId()) && !lastNamePart.equals(UniqueNameGenerator.createSingleNamePart(link.getRightRefId()))) continue;
            link.setRightRefId(newRefId);
        }
    }

    private boolean joinSpansMultipleSources(MoserMetadataConnection mdMoser, IRelationship r) {
        String rightSource;
        String leftSource = this.getMDSource(mdMoser, r.getLeftRefObject());
        return !leftSource.equals(rightSource = this.getMDSource(mdMoser, r.getRightRefObject()));
    }

    private void pushAggregateAndGroupingColumnsToSQS(PlanningEnvironment environment, DynamicQuerySubjectInfo sqsInfo, RQPQuery srcQuery) {
        for (IXQEQueryNode p : srcQuery.getProjectionList().getChildren()) {
            V5BoundModelIdentifier bmID;
            IMetadata qs;
            RQPDataItem rqpDI = (RQPDataItem)p;
            IXQEQueryNode[] bmIDs = rqpDI.getDescendantsOfType(201116, false);
            if (bmIDs == null || bmIDs.length == 0 || !sqsInfo.containsKey(qs = RQPUtilities.getQSOrShortcut((bmID = (V5BoundModelIdentifier)bmIDs[0]).getMetadata()))) continue;
            if (this.exprSpansMultipleSources(environment, p)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_CalcsSpanMDSources);
            }
            MoserQuerySubject dsQS = sqsInfo.get(qs);
            this.createQueryItemInDSQSFromAllReferences(environment, dsQS, rqpDI);
        }
    }

    private void createQueryItemInDSQSFromAllReferences(PlanningEnvironment environment, MoserQuerySubject dsQS, RQPDataItem rqpDI) {
        IXQEQueryNode[] refsToDI;
        RQPQuery rqpDIQuery = RQPNode.getRQPQuery(rqpDI);
        for (IXQEQueryNode ref : refsToDI = rqpDI.getAllReferencesToMe()) {
            RQPDataItemRef newRef;
            RQPDataItem diWithExprToDSQS;
            V5BoundModelIdentifier idInDSQS;
            RQPDataItem di = (RQPDataItem)ref.getAncestorOfType(801008);
            if (di == null) continue;
            IXQEQueryNode expr = null;
            if (di.isGroupingItem()) {
                boolean hasAggregate = RQPUtilities.hasAggregateInExpression(di.getExpression());
                if (hasAggregate) {
                    expr = environment.getNodeFactory().deepCopyNode(rqpDI.getExpression());
                } else {
                    this.replaceDataItemRefsWithExpression(environment, di);
                    expr = environment.getNodeFactory().deepCopyNode(di.getExpression());
                }
                idInDSQS = this.createQueryItemInDSQS(environment, dsQS, expr, "none", "identifier", rqpDI.getName());
                diWithExprToDSQS = rqpDIQuery.getRQPDataItem(environment, (IXQEQueryNode)idInDSQS, rqpDI);
                newRef = RQPDataItemRef.create(environment, diWithExprToDSQS);
                if (hasAggregate) {
                    ref.exchange(newRef);
                    continue;
                }
                di.getExpression().exchange(newRef);
                continue;
            }
            V5ValueSummaryFunction aggregate = (V5ValueSummaryFunction)ref.getAncestorOfType(201031);
            if (aggregate == null) continue;
            this.replaceDataItemRefsWithExpression(environment, aggregate);
            expr = aggregate.getChild(0);
            idInDSQS = this.createQueryItemInDSQS(environment, dsQS, expr, this.getV5Name(aggregate.getNativeName()), "fact", rqpDI.getName());
            diWithExprToDSQS = rqpDIQuery.getRQPDataItem(environment, (IXQEQueryNode)idInDSQS, rqpDI);
            newRef = RQPDataItemRef.create(environment, diWithExprToDSQS);
            expr.exchange(newRef);
        }
        rqpDI.detach();
    }

    private void replaceDataItemRefsWithExpression(PlanningEnvironment environment, IXQEQueryNode child) {
        IXQEQueryNode[] refs;
        for (IXQEQueryNode ref : refs = child.getDescendantsOfType(801009, false)) {
            ref.exchange(environment.getNodeFactory().deepCopyNode(((RQPDataItemRef)ref).getReferencedItem().getExpression()));
        }
    }

    private String getV5Name(String nativeName) {
        if ("standard-deviation".equals(nativeName)) {
            return "standardDeviation";
        }
        return nativeName;
    }

    private V5BoundModelIdentifier createQueryItemInDSQS(PlanningEnvironment environment, MoserQuerySubject dsQS, IXQEQueryNode expr, String aggName, String usage, String suggestedName) {
        String expression = null;
        if (expr.getNodeType() == 201116) {
            V5BoundModelIdentifier bmID = (V5BoundModelIdentifier)expr;
            IMetadata md = bmID.getMetadata();
            IMetadata qs = RQPUtilities.getQSOrShortcut(md);
            expression = UniqueNameGenerator.appendUniqueName(qs.getV5UniqueName(), md.getName());
        }
        if (expression == null) {
            StringBuilder sb = new StringBuilder();
            expr.writeFormattedText(sb);
            expression = sb.toString();
        }
        MoserQueryItem qi = (MoserQueryItem)dsQS.getOrCreateQueryItem(aggName, usage, expression, expr, suggestedName);
        V5BoundModelIdentifier idInDSQS = (V5BoundModelIdentifier)environment.getNodeFactory().createNode(201116);
        idInDSQS.setMetadata(qi);
        idInDSQS.setIdentifier(qi.getV5UniqueName());
        return idInDSQS;
    }

    private DynamicQuerySubjectInfo createSQS(PlanningEnvironment environment, RQPQuery rqpQuery, RQPJoinPath joinPath) {
        MoserMetadataConnection mdMoser = (MoserMetadataConnection)environment.getMetadataConnection();
        DynamicQuerySubjectInfo dynSQSInfo = new DynamicQuerySubjectInfo(mdMoser);
        RQPQuery srcQuery = RQPNode.getRQPQuery(joinPath).getRootRQPQuery();
        TreeSet<IMetadata> factQuerySubjects = this.getFactQuerySubjects(srcQuery, joinPath);
        boolean isMultiFact = srcQuery.getFactManager().isMultiFact();
        for (IMetadata factQS : factQuerySubjects) {
            if (!AggregateThenJoin.inJoinPath(mdMoser, factQS, joinPath)) continue;
            MoserQuerySubject dynamicSQS = mdMoser.createDynamicSQS(factQS.getName());
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).registerResource(dynamicSQS);
            dynamicSQS.setSelectControlList(((IQuerySubject)RQPUtilities.getTarget(factQS)).getSelectListControl());
            dynSQSInfo.put(factQS, dynamicSQS);
            if (isMultiFact) continue;
            String factSource = this.getMDSource(mdMoser, factQS);
            for (IMetadata j : joinPath.getJoinPath()) {
                IRelationship r = (IRelationship)j;
                if (factSource.equals(this.getMDSource(mdMoser, r.getLeftRefObject()))) {
                    dynSQSInfo.put(r.getLeftRefObject(), dynamicSQS);
                }
                if (!factSource.equals(this.getMDSource(mdMoser, r.getRightRefObject()))) continue;
                dynSQSInfo.put(r.getRightRefObject(), dynamicSQS);
            }
        }
        return dynSQSInfo;
    }

    private String getMDSource(MoserMetadataConnection moserMDConnection, IMetadata md) {
        MetadataConnection metadataConnection = md.getConnection();
        if (metadataConnection == null || metadataConnection instanceof MoserMetadataConnection) {
            IQuerySubject qs = md instanceof IQuerySubject ? (IQuerySubject)md : ((IQueryItem)md).getQuerySubject();
            return this.getQuerySubjectSource(moserMDConnection, qs);
        }
        return md.getConnection().getModelPath();
    }

    private static boolean inJoinPath(MoserMetadataConnection mdConn, IMetadata qs, RQPJoinPath joinPath) {
        List<IMetadata> joinPathJoins = joinPath.getJoinPath();
        for (IMetadata j : joinPathJoins) {
            IRelationship r = (IRelationship)j;
            if (!mdConn.getID(r.getLeftRefObject()).equals(mdConn.getID(qs)) && !mdConn.getID(r.getRightRefObject()).equals(mdConn.getID(qs))) continue;
            return true;
        }
        return false;
    }

    private boolean exprSpansMultipleSources(PlanningEnvironment environment, IXQEQueryNode node) {
        Set<String> sources = this.getSources(environment, node);
        return sources.size() > 1;
    }

    private Set<String> getSources(PlanningEnvironment environment, IXQEQueryNode node) {
        List<IXQEQueryNode> allBoundID = node.getDescendantsOfTypeOrdered(201116, false);
        MoserMetadataConnection md = (MoserMetadataConnection)environment.getMetadataConnection();
        TreeSet<String> sources = new TreeSet<String>();
        for (IXQEQueryNode b : allBoundID) {
            V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)b;
            String source = this.getQuerySubjectSource(md, v5BoundID.getQuerySubject());
            if (source == null) continue;
            sources.add(source);
        }
        return sources;
    }

    private String getQuerySubjectSource(MoserMetadataConnection moserMDConn, IQuerySubject querySubject) {
        MetadataConnection md = querySubject.getConnection();
        if (md instanceof MoserMetadataConnection) {
            MoserQuerySubject moserQS = querySubject instanceof MoserQuerySubjectWrapper ? ((MoserQuerySubjectWrapper)querySubject).getWrapped() : (MoserQuerySubject)querySubject;
            if (moserQS.getIsDynamicMini()) {
                return moserMDConn.getID(moserQS);
            }
            return moserMDConn.tryToGetPhysicalSource(moserQS);
        }
        return md.getModelPath();
    }

    private boolean projectionsOrFiltersFromFact(MoserMetadataConnection md, RQPQuery rqpQuery, RQPJoinPath joinPath) {
        TreeSet<IMetadata> factQuerySubjects = this.getFactQuerySubjects(rqpQuery, joinPath);
        for (IMetadata factQS : factQuerySubjects) {
            if (!AggregateThenJoin.inJoinPath(md, factQS, joinPath) || !this.projectionsOrFiltersFromQS(rqpQuery, factQS)) continue;
            return true;
        }
        return false;
    }

    private TreeSet<IMetadata> getFactQuerySubjects(RQPQuery rqpQuery, RQPJoinPath joinPath) {
        TreeSet<IMetadata> factQuerySubjects = new TreeSet<IMetadata>();
        FactFinder ff = RQPUtilities.getRQPFactManager(rqpQuery).getFactFinder();
        if (ff != null) {
            ff.getFactQuerySubjects(factQuerySubjects);
            TreeSet<IMetadata> retFactQS = new TreeSet<IMetadata>((SortedSet<IMetadata>)factQuerySubjects);
            for (IMetadata factQS : factQuerySubjects) {
                if (!this.factIsOnOneSide(factQS, joinPath)) continue;
                retFactQS.remove(factQS);
                break;
            }
            return retFactQS;
        }
        return factQuerySubjects;
    }

    private boolean factIsOnOneSide(IMetadata factQS, RQPJoinPath joinPath) {
        for (IMetadata md : joinPath.getJoinPath()) {
            IRelationship r = (IRelationship)md;
            if (r.getLeftRefObject().equals(factQS) && (r.getLeftCardinality() == IRelationship.Cardinality.ONE_ONE || r.getLeftCardinality() == IRelationship.Cardinality.ZERO_ONE)) {
                return true;
            }
            if (!r.getRightRefObject().equals(factQS) || r.getRightCardinality() != IRelationship.Cardinality.ONE_ONE && r.getRightCardinality() != IRelationship.Cardinality.ZERO_ONE) continue;
            return true;
        }
        return false;
    }

    private boolean projectionsOrFiltersFromQS(RQPQuery rqpQuery, IMetadata qs) {
        return this.subtreeReferencesQS(qs, rqpQuery.getProjectionList()) || this.subtreeReferencesQS(qs, rqpQuery.getDetailFilterList());
    }

    public boolean subtreeReferencesQS(IMetadata theQS, IXQEQueryNode node) {
        if (node == null) {
            return false;
        }
        IXQEQueryNode[] bmIDs = node.getDescendantsOfType(201116, true);
        if (bmIDs == null || bmIDs.length == 0) {
            return false;
        }
        for (IXQEQueryNode b : bmIDs) {
            V5BoundModelIdentifier bmID = (V5BoundModelIdentifier)b;
            IMetadata qs = RQPUtilities.getQSOrShortcut(bmID.getMetadata());
            if (!theQS.equals(qs)) continue;
            return true;
        }
        return false;
    }

    private class DynamicQuerySubjectInfo {
        private MoserMetadataConnection metadataConnection;
        Map<String, MoserQuerySubject> qsToDSQSMap = new TreeMap<String, MoserQuerySubject>();

        DynamicQuerySubjectInfo(MoserMetadataConnection mdConn) {
            this.metadataConnection = mdConn;
        }

        public void put(IMetadata qs, MoserQuerySubject dynamicSQS) {
            this.qsToDSQSMap.put(this.metadataConnection.getID(qs), dynamicSQS);
            if (qs instanceof MoserQuerySubjectWrapper) {
                MoserQuerySubjectWrapper qsWrapper = (MoserQuerySubjectWrapper)qs;
                this.qsToDSQSMap.put(this.metadataConnection.getID(qsWrapper.getWrapped()), dynamicSQS);
            }
        }

        public boolean containsKey(IMetadata qs) {
            return this.qsToDSQSMap.containsKey(this.metadataConnection.getID(qs));
        }

        public MoserQuerySubject get(IMetadata qs) {
            return this.qsToDSQSMap.get(this.metadataConnection.getID(qs));
        }
    }
}

