/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTNode;
import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLRowValueConstructor;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.sql.SQLTableValueConstructor;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.NagFilterJoinOptimizationSubquery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.executor.QueryExecutor;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5.binding.BindV5MultiPartIdentifierToModel;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.FJOCache;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ApplyJoinFilterOptimization
extends RQPTransformation {
    public static final String JOIN_FILTER_TYPE = "joinFilterType";
    public static final String PROP_ONE_SIDE_JOIN_KEY = "oneSideJoinKey";
    public static final String PROP_MANY_SIDE_JOIN_KEY = "manySideJoinKey";
    public static final String PROP_MANY_SIDE_RQP_QUERY = "manySideRQPQuery";
    protected static final String JOINKEYQUERY = "joinKeyQuery";
    protected static final String QRDNAME = "qrd1";
    protected static final String EDGENAME = "e";
    protected static final String VALUESETNAME = "vs";
    protected static final String GROUPBODYNAME = "gb";
    private static final String JOINKEYMINNAME = "joinKeyMin";
    private static final String JOINKEYMAXNAME = "joinKeyMax";
    protected static final String JOINKEYNAME = "joinKey";
    private static final String PROP_ORIGINAL_ONESIDE_QS = "originalOneSideQS";
    private static final String PROP_ONE_SIDE_JOIN_KEY_VALUE = "oneSideJoinKeyValue";
    private static final String CONFIG_FJOTRIMONESIDE = "general.FJOTrimOneSide[@enabled]";
    private static final String CONFIG_FJOGENERATEINONCLAUSE = "general.FJOGenerateInONClause[@enabled]";
    public static final String PROP_JOIN_PROP_RELATIONSHIP = "joinRelationship";
    private static final String PROP_FJO_NOT_APPLIED_REASON = "fjoNotAppliedReason";
    private static final String REASON_NO_APPLICABLE_FILTERS = "Filter join optimization is not applied because no query filters could be applied to the 1-side.";
    private static final String REASON_ABSOLUTE_LIMIT = "Filter join optimization is not applied because absolute limit reached.";
    private static final String REASON_PERCENTAGE_LIMIT = "Filter join optimization is not applied because percentage limit reached.";
    private static final int HUNDRED = 100;
    private static final String COUNTSTAR = "countStar";
    private static final String COUNTSTARQUERY = "countStarQuery";
    private static final String TRUE = "true";
    public static final String PROP_ABSOLUTE_LIMIT = "absoluteLimit";
    public static final String PROP_PERCENTAGE_LIMIT = "percentageLimit";
    public static final String PROP_FILTER_REQUIRED = "filterRequired";
    public static final String PROP_ABSOLUTE_LIMIT_UPPERCASE = "ABSOLUTELIMIT";
    public static final String PROP_PERCENTAGE_LIMIT_UPPERCASE = "PERCENTAGELIMIT";
    public static final String JOIN_FILTER_TYPE_UPPERCASE = "JOINFILTERTYPE";
    public static final String PROP_FILTER_REQUIRED_UPPERCASE = "FILTERREQUIRED";
    private static final int VALIDATION_LIMIT = 100;
    private static final String CONFIG_VALIDATION_LIMIT = "general.FJOAdvanced[@validationLimit]";
    private static final String FJODETACHFILTERFORTRIMMING = "fjoDetachFilterForTrimming";

    public ApplyJoinFilterOptimization() {
        this.mName = "ApplyJoinFilterOptimization";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{301011};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ArrayList<IXQEQueryNode> joinKeysForOneSideQS = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> joinKeysForManySideQS = new ArrayList<IXQEQueryNode>();
        this.getJoinKeys(node, nodeFactory, joinKeysForOneSideQS, joinKeysForManySideQS, environment);
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(environment.getRequestEnvironment());
        PlanningEnvironment subPlanEnv = V5SubQueryBuilder.createPlanningEnvironment((ExecutionEnvironment)environment.getExecutionEnvironment(), planEnv);
        ((RequestEnvironment)subPlanEnv.getRequestEnvironment()).setValidateRequest(false);
        RQPQuery rqpQuery = this.getRQPQueryToApplyFilter(node, joinKeysForManySideQS);
        IRelationship.JoinFilterType jft = (IRelationship.JoinFilterType)((Object)node.getPropertyValue(JOIN_FILTER_TYPE));
        boolean filterAdded = false;
        if (jft == IRelationship.JoinFilterType.FILTER_TYPE_IN) {
            filterAdded = this.addInFilter(node, environment, subPlanEnv, joinKeysForOneSideQS, joinKeysForManySideQS, rqpQuery);
        } else if (jft == IRelationship.JoinFilterType.FILTER_TYPE_BETWEEN) {
            filterAdded = this.addBetweenFilter(node, environment, subPlanEnv, joinKeysForOneSideQS, joinKeysForManySideQS, rqpQuery);
        } else if (jft == IRelationship.JoinFilterType.FILTER_TYPE_TABLE) {
            filterAdded = this.addInFilterTableConstructorValues(node, environment, subPlanEnv, joinKeysForOneSideQS, joinKeysForManySideQS, rqpQuery);
        }
        if (!filterAdded) {
            this.extractTNodesFromTree(node);
            return;
        }
        Object oneSideQS = ApplyJoinFilterOptimization.getOneSideQS(node, joinKeysForOneSideQS, environment);
        Object oneSideUnwoundQS = ApplyJoinFilterOptimization.getOneSideQSUnwound(node);
        this.extractTNodesFromTree(node);
        if (environment.getMultiRequestContext().fetchBooleanConfiguration(CONFIG_FJOTRIMONESIDE, true)) {
            this.removeOneSideIfPossible(node, oneSideQS, oneSideUnwoundQS, environment);
        }
    }

    private void removeOneSideIfPossible(IXQEQueryNode node, Object oneSideQS, Object oneSideUnwoundQS, PlanningEnvironment env) {
        SQLJoin.SubType joinType = ((SQLJoin)node).getJoinType();
        if (joinType != SQLJoin.SubType.INNER) {
            return;
        }
        IRelationship.JoinFilterType jft = (IRelationship.JoinFilterType)((Object)node.getPropertyValue(JOIN_FILTER_TYPE));
        if (jft == IRelationship.JoinFilterType.FILTER_TYPE_BETWEEN) {
            return;
        }
        RQPQuery rqpQuery = (RQPQuery)node.getAncestorOfCategory(801017);
        if (rqpQuery == null) {
            return;
        }
        if (this.oneSideReferencedInDetailFilters(node, oneSideQS, oneSideUnwoundQS, env)) {
            return;
        }
        int[] listsToCheck = new int[]{801016, 801023};
        for (int i = 0; i < listsToCheck.length; ++i) {
            IXQEQueryNode list = rqpQuery.getFirstChildByType(listsToCheck[i]);
            if (list == null || !this.oneSideReferenced(list, oneSideQS, oneSideUnwoundQS, env)) continue;
            return;
        }
        for (IXQEQueryNode parent = node.getParent(); parent != null && parent.getType() == 301011; parent = parent.getParent()) {
            SQLJoin parentJoin = (SQLJoin)parent;
            if (!this.oneSideReferenced(parentJoin.getPredicate(), oneSideQS, oneSideUnwoundQS, env)) continue;
            return;
        }
        List<IXQEQueryNode> descendantJoins = node.getDescendantsOfTypeOrdered(301011, 801017);
        for (IXQEQueryNode j : descendantJoins) {
            SQLJoin join;
            if (j == node || !this.oneSideReferenced((join = (SQLJoin)j).getPredicate(), oneSideQS, oneSideUnwoundQS, env)) continue;
            return;
        }
        this.detachFiltersFlaggedForRemoval(node, oneSideQS);
        SQLJoin relationship = (SQLJoin)node;
        IXQEQueryNode manySide = relationship.getLeftCardinality() == IRelationship.Cardinality.ZERO_ONE || relationship.getLeftCardinality() == IRelationship.Cardinality.ONE_ONE || relationship.getRightCardinality() == IRelationship.Cardinality.ZERO_MANY || relationship.getRightCardinality() == IRelationship.Cardinality.ONE_MANY ? node.detachChild(1) : node.detachChild(0);
        node.exchange(manySide);
    }

    private void detachFiltersFlaggedForRemoval(IXQEQueryNode node, Object oneSideQS) {
        RQPQuery rqpQuery = (RQPQuery)node.getAncestorOfCategory(801017);
        RQPDetailFilterList filters = rqpQuery.getDetailFilterList();
        if (filters == null) {
            return;
        }
        for (IXQEQueryNode filter : filters.getChildren()) {
            Object qs = filter.getPropertyValue(FJODETACHFILTERFORTRIMMING);
            if (qs == null || qs != oneSideQS) continue;
            filter.detach();
        }
        if (filters.getNumberChildren() == 0) {
            filters.detach();
        }
    }

    private boolean oneSideReferencedInDetailFilters(IXQEQueryNode node, Object oneSideQS, Object oneSideUnwoundQS, PlanningEnvironment env) {
        RQPQuery rqpQuery = (RQPQuery)node.getAncestorOfCategory(801017);
        RQPDetailFilterList filters = rqpQuery.getDetailFilterList();
        if (filters == null) {
            return false;
        }
        for (IXQEQueryNode filter : filters.getChildren()) {
            if (filter.getPropertyValue(FJODETACHFILTERFORTRIMMING) != null || !this.oneSideReferenced(filter, oneSideQS, oneSideUnwoundQS, env)) continue;
            return true;
        }
        return false;
    }

    private boolean oneSideReferenced(IXQEQueryNode expr, Object oneSideQS, Object oneSideUnwoundQS, PlanningEnvironment env) {
        List<IXQEQueryNode> ids = ApplyJoinFilterOptimization.getReferences(expr);
        for (IXQEQueryNode id : ids) {
            SQLRelation relation;
            V5BoundDataItemReference diRef;
            String[] nameParts;
            V5BoundModelIdentifier modelID;
            IQuerySubject qs;
            if (!(id.getType() == 201116 ? (qs = (modelID = (V5BoundModelIdentifier)id).getQuerySubject()).equals(oneSideQS) || qs.equals(oneSideUnwoundQS) || oneSideQS instanceof IQuerySubject && ((IQuerySubject)oneSideQS).getV5UniqueName().equals(ApplyJoinFilterOptimization.getRQPQueryQSName(id)) : oneSideQS instanceof SQLRelation && (nameParts = (diRef = (V5BoundDataItemReference)id).getNameParts())[0].equals((relation = (SQLRelation)oneSideQS).getName()))) continue;
            return true;
        }
        return false;
    }

    private void extractTNodesFromTree(IXQEQueryNode node) {
        IXQEQueryNode[] tnodes;
        for (IXQEQueryNode tnode : tnodes = node.getDescendantsOfType(801043, false, 301011)) {
            tnode.extract();
        }
    }

    private RQPQuery getRQPQueryToApplyFilter(IXQEQueryNode node, List<IXQEQueryNode> joinKeysForManySideQS) {
        RQPQuery manySideRqpQuery;
        if (ApplyJoinFilterOptimization.joinCreatedForJoinOperation(node)) {
            SQLRelation manySide = ApplyJoinFilterOptimization.getJoinOpSide(node, PROP_MANY_SIDE_JOIN_KEY);
            V5QuerySet rootQuerySet = (V5QuerySet)node.getAncestorOfType(101002);
            V5Query joinOperandQuery = rootQuerySet.getV5Query(manySide.getName());
            IXQEQueryNode queryPlan = joinOperandQuery.getQueryPlan();
            if (queryPlan.getType() == 801017) {
                return (RQPQuery)queryPlan;
            }
        }
        if ((manySideRqpQuery = (RQPQuery)joinKeysForManySideQS.get(0).getPropertyValue(PROP_MANY_SIDE_RQP_QUERY)) != null) {
            return manySideRqpQuery;
        }
        return (RQPQuery)node.getAncestorOfCategory(801017);
    }

    private boolean addInFilterTableConstructorValues(IXQEQueryNode node, PlanningEnvironment environment, PlanningEnvironment subPlanEnv, List<IXQEQueryNode> joinKeysOneSideQS, List<IXQEQueryNode> joinKeysManySideQS, RQPQuery rqpQuery) {
        List<IXQEQueryNode> applicableFilters = ApplyJoinFilterOptimization.getApplicableFilters(node, subPlanEnv.getNodeFactory(), joinKeysOneSideQS, environment);
        if (this.getFilterRequired(node, environment) && !this.filtersExistOnOneSide(node, environment, applicableFilters)) {
            this.nagFJONotApplied(node, environment, 0, XQEMessageKeys.PLN_FJOFilterRequiredOnRelationship);
            node.setPropertyValue(PROP_FJO_NOT_APPLIED_REASON, REASON_NO_APPLICABLE_FILTERS);
            return false;
        }
        FJOCache joinFilterCache = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().getOrCreateJoinFilterCache();
        IXQEQueryNode df = null;
        List<IXQEQueryNode> dflFromCache = joinFilterCache.getJoinFilter(environment.getNodeFactory(), node, environment.getMetadataConnection(), applicableFilters, ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters());
        if (dflFromCache == null) {
            df = this.queryDatabaseForTableRowConstructorFilter(node, environment, subPlanEnv, joinKeysOneSideQS, joinKeysManySideQS, applicableFilters);
            ArrayList<IXQEQueryNode> fl = new ArrayList<IXQEQueryNode>();
            if (df != null) {
                fl.add(df);
            }
            joinFilterCache.storeJoinFilter(environment.getNodeFactory(), fl, node, environment.getMetadataConnection(), applicableFilters, ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters());
        } else if (dflFromCache.size() > 0) {
            df = dflFromCache.get(0);
        }
        if (df != null) {
            this.addFJOFilter(environment, node, rqpQuery, df);
            return true;
        }
        return false;
    }

    private void nagFJONotApplied(IXQEQueryNode node, PlanningEnvironment environment, int limit, IMessageKey messageId) {
        XQELogger logger;
        RequestEnvironment parentReqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        String message = null;
        if ("validate".equals(parentReqEnv.getOperationName()) && parentReqEnv.getMaxSeverityLevel() == 3) {
            message = this.getFJONotAppliedMessage(node, limit, messageId);
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(message);
        }
        if ((logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "FJO", LogLevel.INFO)).isOn()) {
            if (message == null) {
                message = this.getFJONotAppliedMessage(node, limit, messageId);
            }
            logger.log(message);
        }
    }

    private String getFJONotAppliedMessage(IXQEQueryNode node, int limit, IMessageKey messageId) {
        String[] leftRight = this.getLeftRightNames(node);
        String left = leftRight[0];
        String right = leftRight[1];
        String message = messageId instanceof IMessageKey.Param2 ? XQEMessages.getMessage((IMessageKey.Param2)messageId, XQEMessages.getCurrProductLocale(), left, right) : XQEMessages.getMessage((IMessageKey.Param3)messageId, XQEMessages.getCurrProductLocale(), left, right, Integer.toString(limit));
        return message;
    }

    private String[] getLeftRightNames(IXQEQueryNode node) {
        String left = null;
        String right = null;
        if (ApplyJoinFilterOptimization.joinCreatedForJoinOperation(node)) {
            SQLRelation rightRelation;
            SQLRelation leftRelation = (SQLRelation)node.getChild(0).getFirstDescendantOfTypeOrdered(301016, true);
            if (leftRelation != null) {
                left = leftRelation.getName();
            }
            if ((rightRelation = (SQLRelation)node.getChild(1).getFirstDescendantOfTypeOrdered(301016, true)) != null) {
                right = rightRelation.getName();
            }
        } else {
            IRelationship modelRelationship = (IRelationship)node.getPropertyValue(PROP_JOIN_PROP_RELATIONSHIP);
            IMetadata leftObj = modelRelationship.getLeftRefObject();
            IMetadata rightObj = modelRelationship.getRightRefObject();
            if (leftObj != null) {
                left = leftObj.getV5UniqueName();
            }
            if (rightObj != null) {
                right = rightObj.getV5UniqueName();
            }
        }
        return new String[]{left, right};
    }

    private boolean getFilterRequired(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean filterRequiredInAdvancedProperty = (Boolean)node.getPropertyValue(PROP_FILTER_REQUIRED);
        if (filterRequiredInAdvancedProperty != null) {
            return filterRequiredInAdvancedProperty;
        }
        boolean filterRequiredInConfig = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().fetchBooleanConfiguration("general.FJOAdvanced[@filterRequired]", false);
        return filterRequiredInConfig;
    }

    protected static int getAbsoluteLimit(IXQEQueryNode node, PlanningEnvironment environment) {
        Integer absoluteLimit = (Integer)node.getPropertyValue(PROP_ABSOLUTE_LIMIT);
        if (absoluteLimit != null) {
            return absoluteLimit;
        }
        return ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().fetchgetIntConfiguration("general.FJOAdvanced[@absoluteLimit]", 0);
    }

    private int getPercentageLimit(IXQEQueryNode node, PlanningEnvironment environment) {
        Integer percentageLimit = (Integer)node.getPropertyValue(PROP_PERCENTAGE_LIMIT);
        if (percentageLimit != null) {
            return percentageLimit;
        }
        return ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().fetchgetIntConfiguration("general.FJOAdvanced[@percentageLimit]", 0);
    }

    private int calculateNumRowsForPercentageLimit(IXQEQueryNode node, PlanningEnvironment environment, List<IXQEQueryNode> joinKeysOneSideQS) {
        return this.getPercentageLimit(node, environment) * this.getNumRowsInOneSideTable(node, environment, joinKeysOneSideQS.get(0)) / 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumRowsInOneSideTable(IXQEQueryNode node, PlanningEnvironment environment, IXQEQueryNode joinKey) {
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(environment.getRequestEnvironment());
        PlanningEnvironment subPlanEnv = V5SubQueryBuilder.createPlanningEnvironment((ExecutionEnvironment)environment.getExecutionEnvironment(), planEnv);
        ((RequestEnvironment)subPlanEnv.getRequestEnvironment()).setValidateRequest(false);
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        RequestEnvironment subReqEnv = (RequestEnvironment)subExecEnv.getRequestEnvironment();
        XQENodeFactory nf = subPlanEnv.getNodeFactory();
        if (nf == null) {
            return 0;
        }
        V5QuerySet v5QuerySet = (V5QuerySet)nf.createNode(101002);
        v5QuerySet.addToIndex();
        IXQEQueryNode v5Query = nf.createNode(101006);
        v5Query.setPropertyValue("name", COUNTSTARQUERY);
        v5QuerySet.addChild(v5Query);
        V5Source v5Source = (V5Source)nf.createNode(101007);
        if (ApplyJoinFilterOptimization.joinCreatedForJoinOperation(node)) {
            this.addJoinOpSubqueryForOneSide(node, environment, subPlanEnv, nf, v5QuerySet, v5Source);
        } else {
            ApplyJoinFilterOptimization.setModelPathAndModelType(environment, v5Source);
        }
        v5Query.addChild(v5Source);
        IXQEQueryNode v5Selection = nf.createNode(101009);
        v5Query.addChild(v5Selection);
        IXQEQueryNode v5DataItem = nf.createNode(101003);
        v5DataItem.setPropertyValue("name", COUNTSTAR);
        v5DataItem.setPropertyValue("aggregate", "calculated");
        IXQEQueryNode v5Expression = nf.createNode(101004);
        v5Expression.setPropertyValue("expression", "count( rows " + joinKey.getPropertyValue("identifier") + " )");
        v5DataItem.addChild(v5Expression);
        v5Selection.addChild(v5DataItem);
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)nf.createNode(101055);
        v5QueryResultDefiniton.setPropertyValue("refQuery", COUNTSTARQUERY);
        v5QueryResultDefiniton.setPropertyValue("name", QRDNAME);
        v5QuerySet.addChild(v5QueryResultDefiniton);
        IXQEQueryNode v5Edge = nf.createNode(101049);
        v5Edge.setPropertyValue("name", EDGENAME);
        v5QueryResultDefiniton.addChild(v5Edge);
        IXQEQueryNode v5EdgeGroup = nf.createNode(101050);
        v5Edge.addChild(v5EdgeGroup);
        IXQEQueryNode v5ValueSet = nf.createNode(101057);
        v5ValueSet.setPropertyValue("name", VALUESETNAME);
        v5EdgeGroup.addChild(v5ValueSet);
        IXQEQueryNode v5GroupBody = nf.createNode(101051);
        v5GroupBody.setPropertyValue("name", GROUPBODYNAME);
        v5ValueSet.addChild(v5GroupBody);
        IXQEQueryNode dataItemRef = nf.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", COUNTSTAR);
        v5GroupBody.addChild(dataItemRef);
        ApplyJoinFilterOptimization.addGovernors(node, v5Query);
        TransformationEngine.getInstance().applyTransformations(v5QuerySet, subPlanEnv);
        ApplyJoinFilterOptimization.throwErrorForUnresolvedParameters(environment, subReqEnv, v5QuerySet);
        RSAPIDataset dataset = ApplyJoinFilterOptimization.getDataset(v5QuerySet);
        RSAPIPartialDataset partialDataset = ApplyJoinFilterOptimization.getPartialDataset(dataset, environment, subPlanEnv);
        if (partialDataset == null) {
            return 0;
        }
        RSAPIEdgeIterator it = partialDataset.edgeIterator(0);
        if (it == null) {
            return 0;
        }
        try {
            List<IValue> columns = ApplyJoinFilterOptimization.getNextRow(it);
            if (columns == null || this.hasNullValue(columns)) {
                int n = 0;
                return n;
            }
            IValue numRows = columns.get(0);
            if (numRows instanceof Value) {
                int n = ((Value)numRows).getInteger();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            it.close();
            partialDataset.release();
            dataset.releaseResultset(subExecEnv);
        }
    }

    private void addTopNProperty(IXQEQueryNode node, V5QueryResultDefinition qrd) {
        qrd.setStringPropertyValue("topNRows", Integer.toString(node.getGovernors().getFJOMaxKeys() + 1));
    }

    private boolean filtersExistOnOneSide(IXQEQueryNode node, PlanningEnvironment environment, List<IXQEQueryNode> applicableFilters) {
        return applicableFilters != null && applicableFilters.size() > 0;
    }

    private void addFJOFilter(PlanningEnvironment environment, IXQEQueryNode sqlJoin, RQPQuery rqpQuery, IXQEQueryNode fjoFilterExpression) {
        boolean isSubqueryGeneratedForNSide;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLJoin.SubType joinType = ((SQLJoin)sqlJoin).getJoinType();
        RQPQuery sqlJoinRQPQuery = RQPQuery.getRQPQuery(sqlJoin);
        boolean bl = isSubqueryGeneratedForNSide = rqpQuery != sqlJoinRQPQuery;
        if (!isSubqueryGeneratedForNSide && (joinType != SQLJoin.SubType.INNER || environment.getMultiRequestContext().fetchBooleanConfiguration(CONFIG_FJOGENERATEINONCLAUSE, false))) {
            IXQEQueryNode joinPredicate = ((SQLJoin)sqlJoin).getPredicate();
            V5LogicalExpression logicalAnd = (V5LogicalExpression)nodeFactory.createNode(201003);
            logicalAnd.setSubType(0);
            joinPredicate.insertParent(logicalAnd);
            logicalAnd.addChild(fjoFilterExpression);
        } else {
            RQPDetailFilterList dfl = rqpQuery.getOrCreateDetailFilters(environment);
            IXQEQueryNode df = nodeFactory.createNode(101008);
            df.addChild(fjoFilterExpression);
            dfl.addChild(df);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXQEQueryNode queryDatabaseForTableRowConstructorFilter(IXQEQueryNode node, PlanningEnvironment environment, PlanningEnvironment subPlanEnv, List<IXQEQueryNode> joinKeysOneSideQS, List<IXQEQueryNode> joinKeysManySideQS, List<IXQEQueryNode> applicableFilters) {
        boolean useRowValueConstructor;
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLIn in = (SQLIn)nodeFactory.createNode(301076);
        boolean bl = useRowValueConstructor = joinKeysManySideQS.size() > 1;
        if (useRowValueConstructor) {
            SQLRowValueConstructor rvc = (SQLRowValueConstructor)nodeFactory.createNode(301040);
            rvc.setPropertyValue("createdForFilterJoinOptimization", Boolean.TRUE);
            in.addChild(rvc);
            for (IXQEQueryNode key : joinKeysManySideQS) {
                rvc.addChild(key);
            }
        } else {
            in.addChild(joinKeysManySideQS.get(0));
        }
        SQLSubQuery inSubquery = (SQLSubQuery)nodeFactory.createNode(301059);
        in.addChild(inSubquery);
        SQLProject subqueryProj = (SQLProject)nodeFactory.createNode(301015);
        inSubquery.addChild(subqueryProj);
        SQLRangeVar subqueryRangeVar = (SQLRangeVar)nodeFactory.createNode(301007);
        subqueryRangeVar.setName(JOINKEYQUERY);
        ArrayList<String> derivedColumnList = new ArrayList<String>();
        subqueryRangeVar.setDerivedColumnList(derivedColumnList);
        subqueryProj.addChild(subqueryRangeVar);
        SQLTableValueConstructor tblVCtor = (SQLTableValueConstructor)nodeFactory.createNode(301039);
        tblVCtor.setPropertyValue("createdForFilterJoinOptimization", Boolean.TRUE);
        subqueryRangeVar.addChild(tblVCtor);
        SQLValueList vl = (SQLValueList)nodeFactory.createNode(301030);
        subqueryProj.addChild(vl);
        for (int i = 1; i <= joinKeysOneSideQS.size(); ++i) {
            SQLColumn col = (SQLColumn)nodeFactory.createNode(301005);
            col.setName(JOINKEYNAME + i);
            derivedColumnList.add(JOINKEYNAME + i);
            col.setTableName(JOINKEYQUERY);
            vl.addChild(col);
        }
        RSAPIDataset dataset = this.createOneSideQueryToGetJoinKeyValuesForIN(node, joinKeysOneSideQS, environment, subPlanEnv, applicableFilters);
        RSAPIPartialDataset partialDataset = ApplyJoinFilterOptimization.getPartialDataset(dataset, environment, subPlanEnv);
        RSAPIEdgeIterator it = partialDataset.edgeIterator(0);
        if (it == null) {
            return null;
        }
        int nRows = 0;
        int absoluteLimit = ApplyJoinFilterOptimization.getAbsoluteLimit(node, environment);
        int percentageLimitNumRows = 0;
        if (this.getPercentageLimit(node, environment) > 0) {
            percentageLimitNumRows = this.calculateNumRowsForPercentageLimit(node, environment, joinKeysOneSideQS);
        }
        boolean isValidateCmdAtInfoLevel = false;
        int validationLimit = 0;
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if ("validate".equals(reqEnv.getOperationName()) && reqEnv.getMaxSeverityLevel() == 3) {
            isValidateCmdAtInfoLevel = true;
            validationLimit = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().fetchgetIntConfiguration(CONFIG_VALIDATION_LIMIT, 100);
        }
        int fjoInClauseHardLimit = node.getGovernors().getFJOMaxKeys();
        try {
            List<IValue> columns;
            while ((columns = ApplyJoinFilterOptimization.getNextRow(it)) != null) {
                IXQEQueryNode iXQEQueryNode;
                if (this.hasNullValue(columns)) continue;
                if (fjoInClauseHardLimit > 0 && ++nRows > fjoInClauseHardLimit) {
                    this.throwExceptionHardLimitExceeded(environment, node, joinKeysOneSideQS, fjoInClauseHardLimit);
                }
                if (absoluteLimit > 0 && nRows > absoluteLimit) {
                    this.nagFJONotApplied(node, environment, absoluteLimit, XQEMessageKeys.PLN_FJOAbsoluteLimitReached);
                    node.setPropertyValue(PROP_FJO_NOT_APPLIED_REASON, REASON_ABSOLUTE_LIMIT);
                    iXQEQueryNode = null;
                    return iXQEQueryNode;
                }
                if (percentageLimitNumRows > 0 && nRows > percentageLimitNumRows) {
                    this.nagFJONotApplied(node, environment, this.getPercentageLimit(node, environment), XQEMessageKeys.PLN_FJOPercentageLimitReached);
                    node.setPropertyValue(PROP_FJO_NOT_APPLIED_REASON, REASON_PERCENTAGE_LIMIT);
                    iXQEQueryNode = null;
                    return iXQEQueryNode;
                }
                if (isValidateCmdAtInfoLevel && validationLimit > 0 && nRows > validationLimit) {
                    this.nagFJONotApplied(node, environment, validationLimit, XQEMessageKeys.PLN_FJOValidationLimitReached);
                    break;
                }
                SQLRowValueConstructor rvCtor = (SQLRowValueConstructor)nodeFactory.createNode(301040);
                if (nRows == 1) {
                    rvCtor.setPropertyValue("createdForFilterJoinOptimization", Boolean.TRUE);
                }
                tblVCtor.addChild(rvCtor);
                for (IValue column : columns) {
                    V5LiteralValue value = (V5LiteralValue)nodeFactory.createNode(201026);
                    value.setDataType(column.getDataType());
                    value.setValue(column.toString());
                    value.setNativeName(column.toString());
                    value.setDataType(column.getDataType());
                    value.setInclusive(true);
                    rvCtor.addChild(value);
                }
            }
        }
        finally {
            it.close();
            partialDataset.release();
            dataset.releaseResultset(subExecEnv);
        }
        IXQEQueryNode fjoFilterExpr = this.getFJOFilterExpression(environment, joinKeysManySideQS, nodeFactory, in, nRows);
        return fjoFilterExpr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throwExceptionHardLimitExceeded(PlanningEnvironment environment, IXQEQueryNode node, List<IXQEQueryNode> joinKeysOneSideQS, int fjoInClauseHardLimit) {
        String formattedNumber;
        NumberFormat numberFormatter;
        String[] names = this.getLeftRightNames(node);
        NumberFormat numberFormat = numberFormatter = NumberFormat.getInstance(XQEMessages.getCurrProductLocale());
        synchronized (numberFormat) {
            formattedNumber = numberFormatter.format(fjoInClauseHardLimit);
        }
        Object oneSideObj = ApplyJoinFilterOptimization.getOneSideQS(node, joinKeysOneSideQS, environment);
        String oneSideName = oneSideObj instanceof IQuerySubject ? ((IQuerySubject)oneSideObj).getV5UniqueName() : (oneSideObj instanceof SQLRelation ? ((SQLRelation)oneSideObj).getName() : "");
        throw new XQERuntimeException(XQEMessageKeys.PLN_FJOHardLimitReached, names[0], (Object)names[1], (Object)formattedNumber, (Object)oneSideName);
    }

    protected static List<IValue> getNextRow(RSAPIEdgeIterator it) {
        if (it.hasNext()) {
            RSAPIRow row = it.next();
            ArrayList<IValue> columns = new ArrayList<IValue>();
            for (int i = 0; i < row.getNumColumns(); ++i) {
                columns.add((IValue)row.getColumn(i).copy());
            }
            return columns;
        }
        return null;
    }

    private boolean addBetweenFilter(IXQEQueryNode node, PlanningEnvironment environment, PlanningEnvironment subPlanEnv, List<IXQEQueryNode> joinKeysOneSideQS, List<IXQEQueryNode> joinKeysManySideQS, RQPQuery rqpQuery) {
        List<IXQEQueryNode> applicableFilters = ApplyJoinFilterOptimization.getApplicableFilters(node, subPlanEnv.getNodeFactory(), joinKeysOneSideQS, environment);
        if (this.getFilterRequired(node, environment) && !this.filtersExistOnOneSide(node, environment, applicableFilters)) {
            this.nagFJONotApplied(node, environment, 0, XQEMessageKeys.PLN_FJOFilterRequiredOnRelationship);
            node.setPropertyValue(PROP_FJO_NOT_APPLIED_REASON, REASON_NO_APPLICABLE_FILTERS);
            return false;
        }
        FJOCache joinFilterCache = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().getOrCreateJoinFilterCache();
        List<IXQEQueryNode> factDetailFilters = joinFilterCache.getJoinFilter(environment.getNodeFactory(), node, environment.getMetadataConnection(), applicableFilters, ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters());
        if (factDetailFilters == null) {
            factDetailFilters = this.queryDatabaseForBetweenFilterValues(node, environment, subPlanEnv, joinKeysOneSideQS, joinKeysManySideQS, applicableFilters);
            joinFilterCache.storeJoinFilter(environment.getNodeFactory(), factDetailFilters, node, environment.getMetadataConnection(), applicableFilters, ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters());
        }
        if (factDetailFilters.size() > 0) {
            for (IXQEQueryNode fjoFilterExpr : factDetailFilters) {
                this.addFJOFilter(environment, node, rqpQuery, fjoFilterExpr);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IXQEQueryNode> queryDatabaseForBetweenFilterValues(IXQEQueryNode node, PlanningEnvironment environment, PlanningEnvironment subPlanEnv, List<IXQEQueryNode> joinKeysOneSideQS, List<IXQEQueryNode> joinKeysManySideQS, List<IXQEQueryNode> applicableFilters) {
        ArrayList<IXQEQueryNode> factDetailFilters = new ArrayList<IXQEQueryNode>();
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        RSAPIDataset dataset = this.createOneSideQueryForBETWEEN(node, joinKeysOneSideQS, environment, subPlanEnv, applicableFilters);
        RSAPIPartialDataset partialDataset = ApplyJoinFilterOptimization.getPartialDataset(dataset, environment, subPlanEnv);
        if (partialDataset == null) {
            return factDetailFilters;
        }
        RSAPIEdgeIterator it = partialDataset.edgeIterator(0);
        if (it == null) {
            return factDetailFilters;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLBetween between = null;
        int nRows = 0;
        try {
            List<IValue> columns;
            while ((columns = ApplyJoinFilterOptimization.getNextRow(it)) != null) {
                if (this.hasNullValue(columns)) continue;
                ++nRows;
                int i = 0;
                int j = 0;
                for (IValue column : columns) {
                    if (j == 0) {
                        between = (SQLBetween)nodeFactory.createNode(301045);
                        between.addChild(joinKeysManySideQS.get(i));
                        IXQEQueryNode fjoFilterExpr = this.getFJOFilterExpression(environment, joinKeysManySideQS, nodeFactory, between, nRows);
                        factDetailFilters.add(fjoFilterExpr);
                        ++i;
                    }
                    V5LiteralValue value = (V5LiteralValue)nodeFactory.createNode(201026);
                    value.setDataType(column.getDataType());
                    value.setValue(column.toString());
                    value.setNativeName(column.toString());
                    value.setDataType(column.getDataType());
                    value.setInclusive(true);
                    between.addChild(value);
                    if (++j != 2) continue;
                    j = 0;
                }
            }
        }
        finally {
            it.close();
            partialDataset.release();
            dataset.releaseResultset(subExecEnv);
        }
        if (nRows == 0) {
            IXQEQueryNode fjoFilterExpr = this.getFJOFilterExpression(environment, joinKeysManySideQS, nodeFactory, between, nRows);
            factDetailFilters.add(fjoFilterExpr);
        }
        return factDetailFilters;
    }

    private RSAPIDataset createOneSideQueryForBETWEEN(IXQEQueryNode node, List<IXQEQueryNode> joinKeysOneSideQS, PlanningEnvironment environment, PlanningEnvironment subPlanEnv, List<IXQEQueryNode> applicableFilters) {
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        RequestEnvironment subReqEnv = (RequestEnvironment)subExecEnv.getRequestEnvironment();
        XQENodeFactory nf = subPlanEnv.getNodeFactory();
        if (nf == null) {
            return null;
        }
        V5QuerySet v5QuerySet = (V5QuerySet)nf.createNode(101002);
        v5QuerySet.addToIndex();
        IXQEQueryNode v5Query = nf.createNode(101006);
        v5Query.setPropertyValue("name", JOINKEYQUERY);
        v5QuerySet.addChild(v5Query);
        V5Source v5Source = (V5Source)nf.createNode(101007);
        if (ApplyJoinFilterOptimization.joinCreatedForJoinOperation(node)) {
            this.addJoinOpSubqueryForOneSide(node, environment, subPlanEnv, nf, v5QuerySet, v5Source);
        } else {
            ApplyJoinFilterOptimization.setModelPathAndModelType(environment, v5Source);
        }
        v5Query.addChild(v5Source);
        IXQEQueryNode v5Selection = nf.createNode(101009);
        v5Query.addChild(v5Selection);
        ApplyJoinFilterOptimization.applyQueryFiltersToOneSide((V5Query)v5Query, applicableFilters, environment);
        int i = 1;
        for (IXQEQueryNode joinKey : joinKeysOneSideQS) {
            IXQEQueryNode v5DataItem = nf.createNode(101003);
            v5DataItem.setPropertyValue("name", JOINKEYMINNAME + i);
            v5DataItem.setPropertyValue("aggregate", "minimum");
            IXQEQueryNode v5Expression = nf.createNode(101004);
            v5Expression.setPropertyValue("expression", "minimum(" + joinKey.getPropertyValue("identifier") + ")");
            MetadataContext mc = (MetadataContext)joinKey.getPropertyValue("metadataContext");
            if (mc != null) {
                v5Expression.setPropertyValue("metadataContext", mc);
            }
            v5DataItem.addChild(v5Expression);
            v5Selection.addChild(v5DataItem);
            v5DataItem = nf.createNode(101003);
            v5DataItem.setPropertyValue("name", JOINKEYMAXNAME + i);
            v5DataItem.setPropertyValue("aggregate", "maximum");
            v5Selection.addChild(v5DataItem);
            v5Expression = nf.createNode(101004);
            v5Expression.setPropertyValue("expression", "maximum(" + joinKey.getPropertyValue("identifier") + ") ");
            if (mc != null) {
                v5Expression.setPropertyValue("metadataContext", mc);
            }
            v5DataItem.addChild(v5Expression);
            ++i;
        }
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)nf.createNode(101055);
        v5QueryResultDefiniton.setPropertyValue("refQuery", JOINKEYQUERY);
        v5QueryResultDefiniton.setPropertyValue("name", QRDNAME);
        v5QuerySet.addChild(v5QueryResultDefiniton);
        IXQEQueryNode v5Edge = nf.createNode(101049);
        v5Edge.setPropertyValue("name", EDGENAME);
        v5QueryResultDefiniton.addChild(v5Edge);
        IXQEQueryNode v5EdgeGroup = nf.createNode(101050);
        v5Edge.addChild(v5EdgeGroup);
        IXQEQueryNode v5ValueSet = nf.createNode(101057);
        v5ValueSet.setPropertyValue("name", VALUESETNAME);
        v5EdgeGroup.addChild(v5ValueSet);
        IXQEQueryNode v5GroupBody = nf.createNode(101051);
        v5GroupBody.setPropertyValue("name", GROUPBODYNAME);
        v5ValueSet.addChild(v5GroupBody);
        for (i = 1; i <= joinKeysOneSideQS.size(); ++i) {
            IXQEQueryNode v5DataItemRefMin = nf.createNode(101015);
            v5DataItemRefMin.setPropertyValue("refDataItem", JOINKEYMINNAME + i);
            v5GroupBody.addChild(v5DataItemRefMin);
            IXQEQueryNode v5DataItemRefMax = nf.createNode(101015);
            v5DataItemRefMax.setPropertyValue("refDataItem", JOINKEYMAXNAME + i);
            v5GroupBody.addChild(v5DataItemRefMax);
        }
        ApplyJoinFilterOptimization.addGovernors(node, v5Query);
        ApplyJoinFilterOptimization.addSQLFeedbackForValidate(environment, v5QueryResultDefiniton);
        TransformationEngine.getInstance().applyTransformations(v5QuerySet, subPlanEnv);
        ApplyJoinFilterOptimization.throwErrorForUnresolvedParameters(environment, subReqEnv, v5QuerySet);
        return ApplyJoinFilterOptimization.getDataset(v5QuerySet);
    }

    private static Object getOneSideQS(IXQEQueryNode node, List<IXQEQueryNode> joinKeysOneSideQS, PlanningEnvironment environment) {
        if (ApplyJoinFilterOptimization.joinCreatedForJoinOperation(node)) {
            return ApplyJoinFilterOptimization.getJoinOpSide(node, PROP_ONE_SIDE_JOIN_KEY);
        }
        for (IXQEQueryNode id : joinKeysOneSideQS) {
            if (id.getType() == 201116) {
                return ApplyJoinFilterOptimization.getQSOrShortcut(((V5BoundModelIdentifier)id).getQuerySubject());
            }
            if (id.getType() != 201030) continue;
            V5BoundModelIdentifier bID = BindV5MultiPartIdentifierToModel.bindV5MultiPartIdentifierToModel(environment, (V5MultiPartIdentifier)id);
            return ApplyJoinFilterOptimization.getQSOrShortcut(bID.getQuerySubject());
        }
        return null;
    }

    public static Object getQSOrShortcut(IQuerySubject querySubject) {
        if (querySubject instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)((Object)querySubject)).isAccessedViaShortcut()) {
            return ((IAccessedViaShortcut)((Object)querySubject)).getShortcut();
        }
        return querySubject;
    }

    private boolean addInFilter(IXQEQueryNode node, PlanningEnvironment environment, PlanningEnvironment subPlanEnv, List<IXQEQueryNode> joinKeysOneSideQS, List<IXQEQueryNode> joinKeysManySideQS, RQPQuery rqpQuery) {
        List<IXQEQueryNode> applicableFilters = ApplyJoinFilterOptimization.getApplicableFilters(node, subPlanEnv.getNodeFactory(), joinKeysOneSideQS, environment);
        if (this.getFilterRequired(node, environment) && !this.filtersExistOnOneSide(node, environment, applicableFilters)) {
            this.nagFJONotApplied(node, environment, 0, XQEMessageKeys.PLN_FJOFilterRequiredOnRelationship);
            node.setPropertyValue(PROP_FJO_NOT_APPLIED_REASON, REASON_NO_APPLICABLE_FILTERS);
            return false;
        }
        FJOCache joinFilterCache = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().getOrCreateJoinFilterCache();
        IXQEQueryNode df = null;
        List<IXQEQueryNode> dflFromCache = joinFilterCache.getJoinFilter(environment.getNodeFactory(), node, environment.getMetadataConnection(), applicableFilters, ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters());
        if (dflFromCache == null) {
            df = this.queryDatabaseForInFilterValues(node, environment, subPlanEnv, joinKeysOneSideQS, joinKeysManySideQS, applicableFilters);
            ArrayList<IXQEQueryNode> fl = new ArrayList<IXQEQueryNode>();
            if (df != null) {
                fl.add(df);
            }
            joinFilterCache.storeJoinFilter(environment.getNodeFactory(), fl, node, environment.getMetadataConnection(), applicableFilters, ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters());
        } else if (dflFromCache.size() > 0) {
            df = dflFromCache.get(0);
        }
        if (df != null) {
            this.addFJOFilter(environment, node, rqpQuery, df);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXQEQueryNode queryDatabaseForInFilterValues(IXQEQueryNode node, PlanningEnvironment environment, PlanningEnvironment subPlanEnv, List<IXQEQueryNode> joinKeysOneSideQS, List<IXQEQueryNode> joinKeysManySideQS, List<IXQEQueryNode> applicableFilters) {
        boolean useRowValueConstructor;
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        RSAPIDataset dataset = this.createOneSideQueryToGetJoinKeyValuesForIN(node, joinKeysOneSideQS, environment, subPlanEnv, applicableFilters);
        RSAPIPartialDataset partialDataset = ApplyJoinFilterOptimization.getPartialDataset(dataset, environment, subPlanEnv);
        if (partialDataset == null) {
            return null;
        }
        RSAPIEdgeIterator it = partialDataset.edgeIterator(0);
        if (it == null) {
            return null;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLIn in = (SQLIn)nodeFactory.createNode(301076);
        boolean bl = useRowValueConstructor = joinKeysManySideQS.size() > 1;
        if (useRowValueConstructor) {
            SQLRowValueConstructor rvc = (SQLRowValueConstructor)nodeFactory.createNode(301040);
            rvc.setPropertyValue("createdForFilterJoinOptimization", Boolean.TRUE);
            in.addChild(rvc);
            for (IXQEQueryNode key : joinKeysManySideQS) {
                rvc.addChild(key);
            }
        } else {
            in.addChild(joinKeysManySideQS.get(0));
        }
        SQLValueList vl = (SQLValueList)nodeFactory.createNode(301030);
        in.addChild(vl);
        int nRows = 0;
        int absoluteLimit = ApplyJoinFilterOptimization.getAbsoluteLimit(node, environment);
        int percentageLimitNumRows = 0;
        if (this.getPercentageLimit(node, environment) > 0) {
            percentageLimitNumRows = this.calculateNumRowsForPercentageLimit(node, environment, joinKeysOneSideQS);
        }
        boolean isValidateCmdAtInfoLevel = false;
        int validationLimit = 0;
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if ("validate".equals(reqEnv.getOperationName()) && reqEnv.getMaxSeverityLevel() == 3) {
            isValidateCmdAtInfoLevel = true;
            validationLimit = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().fetchgetIntConfiguration(CONFIG_VALIDATION_LIMIT, 100);
        }
        int fjoInClauseHardLimit = node.getGovernors().getFJOMaxKeys();
        try {
            List<IValue> columns;
            while ((columns = ApplyJoinFilterOptimization.getNextRow(it)) != null) {
                IXQEQueryNode parentOfColumnValue;
                Iterator<IValue> iterator;
                if (this.hasNullValue(columns)) continue;
                if (fjoInClauseHardLimit > 0 && ++nRows > fjoInClauseHardLimit) {
                    this.throwExceptionHardLimitExceeded(environment, node, joinKeysOneSideQS, fjoInClauseHardLimit);
                }
                if (absoluteLimit > 0 && nRows > absoluteLimit) {
                    this.nagFJONotApplied(node, environment, absoluteLimit, XQEMessageKeys.PLN_FJOAbsoluteLimitReached);
                    node.setPropertyValue(PROP_FJO_NOT_APPLIED_REASON, REASON_ABSOLUTE_LIMIT);
                    iterator = null;
                    return iterator;
                }
                if (percentageLimitNumRows > 0 && nRows > percentageLimitNumRows) {
                    this.nagFJONotApplied(node, environment, this.getPercentageLimit(node, environment), XQEMessageKeys.PLN_FJOPercentageLimitReached);
                    node.setPropertyValue(PROP_FJO_NOT_APPLIED_REASON, REASON_PERCENTAGE_LIMIT);
                    iterator = null;
                    return iterator;
                }
                if (isValidateCmdAtInfoLevel && validationLimit > 0 && nRows > validationLimit) {
                    this.nagFJONotApplied(node, environment, validationLimit, XQEMessageKeys.PLN_FJOValidationLimitReached);
                    break;
                }
                if (useRowValueConstructor) {
                    parentOfColumnValue = nodeFactory.createNode(301040);
                    vl.addChild(parentOfColumnValue);
                } else {
                    parentOfColumnValue = vl;
                }
                for (IValue column : columns) {
                    V5LiteralValue value = (V5LiteralValue)nodeFactory.createNode(201026);
                    value.setDataType(column.getDataType());
                    value.setValue(column.toString());
                    value.setNativeName(column.toString());
                    value.setDataType(column.getDataType());
                    value.setInclusive(true);
                    parentOfColumnValue.addChild(value);
                }
            }
        }
        finally {
            it.close();
            partialDataset.release();
            dataset.releaseResultset(subExecEnv);
        }
        IXQEQueryNode fjoFilterExpr = this.getFJOFilterExpression(environment, joinKeysManySideQS, nodeFactory, in, nRows);
        return fjoFilterExpr;
    }

    private boolean hasNullValue(List<IValue> columns) {
        for (IValue column : columns) {
            if (!column.isNull()) continue;
            return true;
        }
        return false;
    }

    private IXQEQueryNode getFJOFilterExpression(PlanningEnvironment environment, List<IXQEQueryNode> joinKeysManySideQS, XQENodeFactory nodeFactory, IXQEQueryNode filterExpr, int nRows) {
        if (nRows > 0) {
            return filterExpr;
        }
        V5ComparisonExpression equal = (V5ComparisonExpression)nodeFactory.createNode(201013);
        equal.setSubType(3);
        equal.addChild(nodeFactory.deepCopyNode(joinKeysManySideQS.get(0)));
        equal.addChild(nodeFactory.deepCopyNode(joinKeysManySideQS.get(0)));
        return equal;
    }

    private void getJoinKeys(IXQEQueryNode node, XQENodeFactory nodeFactory, List<IXQEQueryNode> joinKeysForOneSideQS, List<IXQEQueryNode> joinKeysForManySideQS, PlanningEnvironment environment) {
        SQLJoin join = (SQLJoin)node;
        if (ApplyJoinFilterOptimization.joinCreatedForJoinOperation(node)) {
            SQLRelation oneSideQS = ApplyJoinFilterOptimization.getJoinOpSide(node, PROP_ONE_SIDE_JOIN_KEY);
            List<IXQEQueryNode> ids = join.getPredicate().getDescendantsOfTypeOrdered(201060, false);
            for (IXQEQueryNode id : ids) {
                SQLRelation relation = oneSideQS;
                V5BoundDataItemReference diRef = (V5BoundDataItemReference)id;
                String[] nameParts = diRef.getNameParts();
                if (nameParts[0].equals(relation.getName())) {
                    joinKeysForOneSideQS.add(nodeFactory.deepCopyNode(diRef));
                    continue;
                }
                V5DataItem di = diRef.getRefDataItem();
                RQPDataItemSelfRef self = RQPDataItemSelfRef.create(environment, di.getNameProperty());
                joinKeysForManySideQS.add(self);
            }
        } else {
            List<IXQEQueryNode> tnodes = join.getPredicate().getDescendantsOfTypeOrdered(801043, false);
            int[] types = new int[]{201116, 801009};
            for (IXQEQueryNode tnode : tnodes) {
                if (tnode.getPropertyValue(PROP_ONE_SIDE_JOIN_KEY) != null) {
                    IXQEQueryNode key = (IXQEQueryNode)tnode.getPropertyValue(PROP_ONE_SIDE_JOIN_KEY_VALUE);
                    joinKeysForOneSideQS.add(nodeFactory.deepCopyNode(key));
                    continue;
                }
                for (IXQEQueryNode key : tnode.getChild(0).getDescendantsOfTypesOrdered(types, true)) {
                    if (key.getType() == 801009) {
                        RQPDataItem di = ((RQPDataItemRef)key).getReferencedItem();
                        RQPQuery manySideRQPQuery = (RQPQuery)di.getAncestorOfType(801017);
                        List<IXQEQueryNode> keys = di.getDescendantsOfCategoryOrdered(201120, false);
                        for (IXQEQueryNode k : keys) {
                            IXQEQueryNode manySideKey = nodeFactory.deepCopyNode(k);
                            manySideKey.setPropertyValue(PROP_MANY_SIDE_RQP_QUERY, manySideRQPQuery);
                            joinKeysForManySideQS.add(manySideKey);
                        }
                        continue;
                    }
                    joinKeysForManySideQS.add(nodeFactory.deepCopyNode(key));
                }
            }
        }
    }

    protected static RSAPIPartialDataset getPartialDataset(RSAPIDataset dataset, PlanningEnvironment environment, PlanningEnvironment subPlanEnv) {
        RequestEnvironment parentReqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if ("validate".equals(parentReqEnv.getOperationName()) && parentReqEnv.getMaxSeverityLevel() == 3) {
            NagFilterJoinOptimizationSubquery nag = new NagFilterJoinOptimizationSubquery();
            nag.setActualQueryName(dataset.getName());
            nag.setCognosSQL(dataset.getCognosSQL());
            for (IXQEQueryNode xSql : dataset.getDescendantsOfTypeOrdered(501013, false)) {
                nag.addNativeSQL(((XSql)xSql).getSqlText());
            }
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nag);
        }
        if (dataset.getNumEdges() != 1) {
            return null;
        }
        RSAPIEdge edge = dataset.getEdge(0);
        if (edge.getNumRowsets() != 1) {
            return null;
        }
        int[] startRowNumbers = new int[1];
        int[] numRows = new int[1];
        startRowNumbers[0] = 1;
        numRows[0] = 0;
        RSAPIPartialDataset partialDataset = null;
        boolean includeContext = false;
        boolean includeContextValues = false;
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        partialDataset = QueryExecutor.getInstance().getPartialDataset(dataset, startRowNumbers, numRows, includeContext, includeContextValues, subExecEnv);
        subPlanEnv.setPlanningActive(subPlanEnv.getRequestEnvironment());
        return partialDataset;
    }

    private RSAPIDataset createOneSideQueryToGetJoinKeyValuesForIN(IXQEQueryNode node, List<IXQEQueryNode> joinKeysOneSideQS, PlanningEnvironment environment, PlanningEnvironment subPlanEnv, List<IXQEQueryNode> applicableFilters) {
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        RequestEnvironment subReqEnv = (RequestEnvironment)subExecEnv.getRequestEnvironment();
        XQENodeFactory nf = subPlanEnv.getNodeFactory();
        if (nf == null) {
            return null;
        }
        V5QuerySet v5QuerySet = (V5QuerySet)nf.createNode(101002);
        v5QuerySet.addToIndex();
        V5Query v5Query = (V5Query)nf.createNode(101006);
        String joinKeyQuery = JOINKEYQUERY;
        v5Query.setPropertyValue("name", JOINKEYQUERY);
        v5Query.setDistinct(true);
        v5QuerySet.addChild(v5Query);
        V5Source v5Source = (V5Source)nf.createNode(101007);
        if (ApplyJoinFilterOptimization.joinCreatedForJoinOperation(node)) {
            this.addJoinOpSubqueryForOneSide(node, environment, subPlanEnv, nf, v5QuerySet, v5Source);
        } else {
            ApplyJoinFilterOptimization.setModelPathAndModelType(environment, v5Source);
        }
        v5Query.addChild(v5Source);
        V5Selection v5Selection = (V5Selection)nf.createNode(101009);
        v5Selection.setAutoSummary(false);
        v5Query.addChild(v5Selection);
        ApplyJoinFilterOptimization.applyQueryFiltersToOneSide(v5Query, applicableFilters, environment);
        int i = 1;
        for (IXQEQueryNode joinKey : joinKeysOneSideQS) {
            IXQEQueryNode v5DataItem = nf.createNode(101003);
            v5Selection.addChild(v5DataItem);
            v5DataItem.setPropertyValue("name", JOINKEYNAME + i);
            v5DataItem.setPropertyValue("aggregate", "none");
            if (((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().fetchBooleanConfiguration("general.FJOSortInList[@value]", false)) {
                v5DataItem.setPropertyValue("sort", "ascending");
            }
            IXQEQueryNode v5Expression = nf.createNode(101004);
            v5Expression.setPropertyValue("expression", joinKey.getPropertyValue("identifier"));
            MetadataContext mc = (MetadataContext)joinKey.getPropertyValue("metadataContext");
            if (mc != null) {
                v5Expression.setPropertyValue("metadataContext", mc);
            }
            v5DataItem.addChild(v5Expression);
            ++i;
        }
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)nf.createNode(101055);
        v5QueryResultDefiniton.setPropertyValue("refQuery", JOINKEYQUERY);
        v5QueryResultDefiniton.setPropertyValue("name", QRDNAME);
        v5QuerySet.addChild(v5QueryResultDefiniton);
        this.addTopNProperty(node, v5QueryResultDefiniton);
        IXQEQueryNode v5Edge = nf.createNode(101049);
        v5Edge.setPropertyValue("name", EDGENAME);
        v5QueryResultDefiniton.addChild(v5Edge);
        IXQEQueryNode v5EdgeGroup = nf.createNode(101050);
        v5Edge.addChild(v5EdgeGroup);
        IXQEQueryNode v5ValueSet = nf.createNode(101057);
        v5ValueSet.setPropertyValue("name", VALUESETNAME);
        v5EdgeGroup.addChild(v5ValueSet);
        IXQEQueryNode v5GroupBody = nf.createNode(101051);
        v5GroupBody.setPropertyValue("name", GROUPBODYNAME);
        v5ValueSet.addChild(v5GroupBody);
        for (i = 1; i <= joinKeysOneSideQS.size(); ++i) {
            IXQEQueryNode v5DataItemRef = nf.createNode(101015);
            v5DataItemRef.setPropertyValue("refDataItem", JOINKEYNAME + i);
            v5GroupBody.addChild(v5DataItemRef);
        }
        ApplyJoinFilterOptimization.addGovernors(node, v5Query);
        ApplyJoinFilterOptimization.addSQLFeedbackForValidate(environment, v5QueryResultDefiniton);
        TransformationEngine.getInstance().applyTransformations(v5QuerySet, subPlanEnv);
        ApplyJoinFilterOptimization.throwErrorForUnresolvedParameters(environment, subReqEnv, v5QuerySet);
        return ApplyJoinFilterOptimization.getDataset(v5QuerySet);
    }

    protected static void setModelPathAndModelType(PlanningEnvironment environment, V5Source v5Source) {
        v5Source.setModel(environment.getMetadataConnection().getModelPath());
        String modelType = environment.getMetadataConnection().getModelType();
        if (modelType != null) {
            v5Source.setModelType(modelType);
        }
    }

    protected static void addGovernors(IXQEQueryNode node, IXQEQueryNode v5Query) {
        Governors parentGovernors = node.getGovernors();
        if (parentGovernors.getFJOUseRelationalCache().equals((Object)Governors.FJOUseRelationalCache.USE_LOCAL_CACHE)) {
            v5Query.setPropertyValue("governors", parentGovernors);
        } else if (parentGovernors.getFJOUseRelationalCache().equals((Object)Governors.FJOUseRelationalCache.ALWAYS)) {
            Governors subGovernors = parentGovernors.copy();
            subGovernors.setLocalCache(TRUE);
            subGovernors.setLocalCachePolicy(Governors.LocalCachePolicy.QUERY_REFERENCED_BY_LAYOUT.toString());
            v5Query.setPropertyValue("governors", subGovernors);
        } else {
            Governors subGovernors = parentGovernors.copy();
            subGovernors.setLocalCache("false");
            v5Query.setPropertyValue("governors", subGovernors);
        }
    }

    private static Object getOneSideQSUnwound(IXQEQueryNode node) {
        if (ApplyJoinFilterOptimization.joinCreatedForJoinOperation(node)) {
            return ApplyJoinFilterOptimization.getJoinOpSide(node, PROP_ONE_SIDE_JOIN_KEY);
        }
        List<IXQEQueryNode> tnodes = ((SQLJoin)node).getPredicate().getDescendantsOfTypeOrdered(801043, false);
        int[] types = new int[]{201116, 801009};
        for (IXQEQueryNode tnode : tnodes) {
            if (tnode.getPropertyValue(PROP_ONE_SIDE_JOIN_KEY) == null) continue;
            for (IXQEQueryNode key : tnode.getChild(0).getDescendantsOfTypesOrdered(types, true)) {
                if (key.getType() == 801009) {
                    Object qs = ApplyJoinFilterOptimization.getQueryFromBMI((RQPDataItemRef)key);
                    if (qs == null) continue;
                    return qs;
                }
                return ((V5BoundModelIdentifier)key).getQuerySubject();
            }
        }
        return null;
    }

    private static Object getQueryFromBMI(RQPDataItemRef ref) {
        RQPDataItem di = ref.getReferencedItem();
        List<IXQEQueryNode> keys = di.getDescendantsOfTypeOrdered(201116, false);
        if (keys.isEmpty()) {
            keys = di.getDescendantsOfTypeOrdered(801009, false);
            for (IXQEQueryNode key : keys) {
                Object ret = ApplyJoinFilterOptimization.getQueryFromBMI((RQPDataItemRef)key);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }
        return ((V5BoundModelIdentifier)keys.get(0)).getQuerySubject();
    }

    private void addJoinOpSubqueryForOneSide(IXQEQueryNode node, PlanningEnvironment environment, PlanningEnvironment subPlanEnv, XQENodeFactory nf, V5QuerySet newV5QuerySet, V5Source v5Source) {
        V5QuerySet expandedQuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5QuerySet initialQuerySet = (V5QuerySet)expandedQuerySet.getPropertyValue("initialQuerySet");
        newV5QuerySet.setPropertyValue("initialQuerySet", initialQuerySet);
        newV5QuerySet.setPropertyValue("modelPath", initialQuerySet.getPropertyValue("modelPath"));
        newV5QuerySet.setPropertyValue("expressionLocale", initialQuerySet.getPropertyValue("expressionLocale"));
        SQLRelation relation = ApplyJoinFilterOptimization.getJoinOpSide(node, PROP_ONE_SIDE_JOIN_KEY);
        String relationName = relation.getName();
        V5Query initialOneSideSubquery = initialQuerySet.getV5Query(relationName);
        V5Query expandedOneSideSubquery = expandedQuerySet.getV5Query(relationName);
        newV5QuerySet.addChild(nf.deepCopyNode(initialOneSideSubquery));
        HashSet<String> allSubQueriesString = new HashSet<String>();
        expandedOneSideSubquery.getAllSubQueryNames(allSubQueriesString, expandedQuerySet, environment);
        for (String subQueryString : allSubQueriesString) {
            V5Query initialQuery = initialQuerySet.getV5Query(subQueryString);
            V5Query clonedSubQuery = (V5Query)nf.deepCopyNode(initialQuery);
            newV5QuerySet.addChild(clonedSubQuery);
        }
        subPlanEnv.setMetdataConnection(environment.getMetadataConnection());
    }

    protected static void applyQueryFiltersToOneSide(V5Query v5Query, List<IXQEQueryNode> applicableFilters, PlanningEnvironment environment) {
        for (IXQEQueryNode detailFilter : applicableFilters) {
            IXQEQueryNode rootNode;
            if (ApplyJoinFilterOptimization.hasParameters(detailFilter) && (rootNode = environment.getRoot()).getType() == 101002) {
                ((V5QuerySet)rootNode).setNonReusable(true);
            }
            v5Query.addChild(detailFilter);
        }
    }

    public static List<IXQEQueryNode> getApplicableFilters(IXQEQueryNode node, XQENodeFactory nodeFactory, List<IXQEQueryNode> joinKeysOneSideQS, PlanningEnvironment environment) {
        ArrayList<IXQEQueryNode> applicableFilters = new ArrayList<IXQEQueryNode>();
        RQPQuery rqpQuery = (RQPQuery)node.getAncestorOfCategory(801017);
        RQPDetailFilterList filters = rqpQuery.getDetailFilterList();
        if (filters == null) {
            return applicableFilters;
        }
        Object oneSideQS = ApplyJoinFilterOptimization.getOneSideQS(node, joinKeysOneSideQS, environment);
        Object oneSideUnwoundQS = ApplyJoinFilterOptimization.getOneSideQSUnwound(node);
        for (IXQEQueryNode filter : filters.getChildren()) {
            boolean applyFilter = ApplyJoinFilterOptimization.allModelReferencesFromOneSide(filter, oneSideQS, oneSideUnwoundQS, environment);
            if (!applyFilter || ApplyJoinFilterOptimization.hasMasterDetailLinkParameterUnresolved(filter, environment)) continue;
            V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            IXQEQueryNode fexpr = filter.getType() == 101008 ? nodeFactory.deepCopyNode(filter.getChild(0)) : nodeFactory.deepCopyNode(filter);
            detailFilter.addChild(fexpr);
            applicableFilters.add(detailFilter);
            detailFilter.setPropertyValue("doNotValidate", Boolean.TRUE);
            ApplyJoinFilterOptimization.replaceRQPDataItemRefsWithReferencedExpression(environment, oneSideQS, filter, fexpr);
            if (!environment.getMultiRequestContext().fetchBooleanConfiguration(CONFIG_FJOTRIMONESIDE, true)) continue;
            filter.setPropertyValue(FJODETACHFILTERFORTRIMMING, oneSideQS);
        }
        return applicableFilters;
    }

    private static boolean hasParameters(IXQEQueryNode filter) {
        int[] parmTypes = new int[]{301051, 201024};
        List<IXQEQueryNode> filterParms = filter.getDescendantsOfTypesOrdered(parmTypes, false);
        return filterParms != null && filterParms.size() > 0;
    }

    public static void replaceRQPDataItemRefsWithReferencedExpression(PlanningEnvironment environment, Object oneSideQS, IXQEQueryNode filter, IXQEQueryNode fexpr) {
        List<IXQEQueryNode> refs1 = fexpr.getDescendantsOfTypeOrdered(801009, true);
        List<IXQEQueryNode> refs2 = filter.getDescendantsOfTypeOrdered(801009, true);
        if (refs1.size() > 0) {
            int j = 0;
            IMetadata qs = (IMetadata)oneSideQS;
            if (MetadataType.isShortcut(qs)) {
                qs = RQPUtilities.getShortcutTarget((IShortcut)oneSideQS);
            }
            List<IMetadata> queryItems = ((IQuerySubject)qs).getQueryItemsAndMeasures();
            for (IXQEQueryNode r : refs1) {
                RQPDataItem di = ((RQPDataItemRef)refs2.get(j)).getReferencedItem();
                for (IMetadata qi : queryItems) {
                    if (!RQPNameGenerator.generateUniqueAliasQueryItem(qi).equals(di.getName())) continue;
                    if (MetadataType.isShortcut((IMetadata)oneSideQS)) {
                        IQuerySubject querySubject = ((IQueryItem)qi).getQuerySubject();
                        ((IAccessedViaShortcut)((Object)querySubject)).setShortcut((IShortcut)oneSideQS);
                    }
                    XQENodeFactory nodeFactory = environment.getNodeFactory();
                    IXQEQueryNode expr = nodeFactory.createNode(201116);
                    ((V5BoundModelIdentifier)expr).setMetadata(qi);
                    r.exchange(expr);
                    break;
                }
                ++j;
            }
        }
    }

    protected static boolean allModelReferencesFromOneSide(IXQEQueryNode expr, Object oneSideQS, Object oneSideUnwoundQS, PlanningEnvironment env) {
        List<IXQEQueryNode> ids = ApplyJoinFilterOptimization.getReferences(expr);
        boolean applyFilter = false;
        for (IXQEQueryNode id : ids) {
            if (id.getType() == 201116) {
                V5BoundModelIdentifier modelID = (V5BoundModelIdentifier)id;
                Object qs = ApplyJoinFilterOptimization.getQSOrShortcut(modelID.getQuerySubject());
                if (qs.equals(oneSideQS) || qs.equals(oneSideUnwoundQS) || oneSideQS instanceof IQuerySubject && ((IQuerySubject)oneSideQS).getV5UniqueName().equals(ApplyJoinFilterOptimization.getRQPQueryQSName(id))) {
                    applyFilter = true;
                    continue;
                }
                applyFilter = false;
                break;
            }
            V5BoundDataItemReference diRef = (V5BoundDataItemReference)id;
            String[] nameParts = diRef.getNameParts();
            if (oneSideQS instanceof SQLRelation) {
                SQLRelation relation = (SQLRelation)oneSideQS;
                if (!nameParts[0].equals(relation.getName())) {
                    applyFilter = false;
                    break;
                }
                applyFilter = true;
                continue;
            }
            applyFilter = false;
            break;
        }
        return applyFilter;
    }

    private static String getRQPQueryQSName(IXQEQueryNode id) {
        RQPQuery rqpQuery = RQPQuery.getRQPQuery(id);
        if (rqpQuery == null) {
            return null;
        }
        String qsName = (String)rqpQuery.getPropertyValue("QSNAME");
        return qsName;
    }

    private static List<IXQEQueryNode> getReferences(IXQEQueryNode parent) {
        int[] types = new int[]{201116, 201060};
        List<IXQEQueryNode> ids = parent.getDescendantsOfTypesOrdered(types, false);
        List<IXQEQueryNode> refs = parent.getDescendantsOfTypeOrdered(801009, false);
        for (IXQEQueryNode ref : refs) {
            RQPDataItem di = ((RQPDataItemRef)ref).getReferencedItem();
            if (di == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Can't find expression of the reference " + ((RQPDataItemRef)ref).getQueryName() + "." + ((RQPDataItemRef)ref).getName());
            }
            List<IXQEQueryNode> idsFromRefs = ApplyJoinFilterOptimization.getReferences(di);
            if (idsFromRefs == null || ids.containsAll(idsFromRefs)) continue;
            ids.addAll(idsFromRefs);
        }
        return ids;
    }

    protected static RSAPIDataset getDataset(V5QuerySet v5QuerySet) {
        IXQEQueryNode[] results = v5QuerySet.getChildrenOfType(401005);
        if (results == null || results.length != 1) {
            return null;
        }
        RSAPIDataset dataset = (RSAPIDataset)results[0];
        return dataset;
    }

    protected static void throwErrorForUnresolvedParameters(PlanningEnvironment environment, RequestEnvironment subReqEnv, V5QuerySet v5QuerySet) {
        Parameters parameters = subReqEnv.getRequestParameters();
        if (parameters.hasUnresolvedParameters()) {
            throw new UnresolvedParameterException((IRequestEnvironment)((ExecutionEnvironment)environment.getExecutionEnvironment()).getRequestEnvironment(), v5QuerySet, parameters);
        }
    }

    protected static void addSQLFeedbackForValidate(PlanningEnvironment environment, V5QueryResultDefinition v5QueryResultDefiniton) {
        RequestEnvironment reqEnv = (RequestEnvironment)((ExecutionEnvironment)environment.getExecutionEnvironment()).getRequestEnvironment();
        if ("validate".equals(reqEnv.getOperationName()) && reqEnv.getMaxSeverityLevel() == 3) {
            v5QueryResultDefiniton.addQueryFeedback("CognosCommandText");
            v5QueryResultDefiniton.addQueryFeedback("nativeCommandText");
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IRelationship.JoinFilterType jft = (IRelationship.JoinFilterType)((Object)node.getPropertyValue(JOIN_FILTER_TYPE));
        if (jft == null || jft == IRelationship.JoinFilterType.FILTER_TYPE_NONE || jft == IRelationship.JoinFilterType.FILTER_TYPE_FLEXIBLE) {
            return false;
        }
        SQLJoin join = (SQLJoin)node;
        List<IXQEQueryNode> exprs = join.getPredicate().getDescendantsOfTypeOrdered(201013, true);
        for (IXQEQueryNode compareExpr : exprs) {
            if (((V5ComparisonExpression)compareExpr).getSubType() == 2) continue;
            this.extractTNodesFromTree(node);
            this.nagFJONotApplied(node, environment, 0, XQEMessageKeys.PLN_FJONonEquiJoinRelationship);
            return false;
        }
        exprs = join.getPredicate().getDescendantsOfTypeOrdered(201003, true);
        for (IXQEQueryNode logicalExpr : exprs) {
            if (((V5LogicalExpression)logicalExpr).getSubType() == 0) continue;
            this.extractTNodesFromTree(node);
            this.nagFJONotApplied(node, environment, 0, XQEMessageKeys.PLN_FJONonLogicalAND);
            return false;
        }
        return true;
    }

    public static boolean joinCreatedForJoinOperation(IXQEQueryNode node) {
        return node.getPropertyValue("createdForJoinOperation") != null;
    }

    public static void markJoinKeysForFilterJoinOptimization(PlanningEnvironment environment, IRelationship relationship, IXQEQueryNode joinExpr) {
        IMetadata oneSideQS = relationship.getLeftCardinality() == IRelationship.Cardinality.ZERO_ONE || relationship.getLeftCardinality() == IRelationship.Cardinality.ONE_ONE || relationship.getRightCardinality() == IRelationship.Cardinality.ZERO_MANY || relationship.getRightCardinality() == IRelationship.Cardinality.ONE_MANY ? relationship.getLeftRefObject() : relationship.getRightRefObject();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        List<IXQEQueryNode> ids = joinExpr.getDescendantsOfTypeOrdered(201030, false);
        for (IXQEQueryNode id : ids) {
            V5MultiPartIdentifier modelID = (V5MultiPartIdentifier)id;
            Object qs = null;
            qs = MetadataContext.isQSforQIName(oneSideQS, modelID.getIdentifier()) ? oneSideQS : ApplyJoinFilterOptimization.getQSOrShortcut(V5BoundModelIdentifier.getQuerySubject(environment, modelID.getIdentifier()));
            RQPTNode tnode = (RQPTNode)nodeFactory.createNode(801043);
            if (qs.equals(oneSideQS)) {
                tnode.setPropertyValue(PROP_ONE_SIDE_JOIN_KEY, true);
                tnode.setPropertyValue(PROP_ORIGINAL_ONESIDE_QS, oneSideQS);
                tnode.setPropertyValue(PROP_ONE_SIDE_JOIN_KEY_VALUE, modelID);
            } else {
                tnode.setPropertyValue(PROP_MANY_SIDE_JOIN_KEY, true);
            }
            id.insertParent(tnode);
        }
    }

    private static SQLRelation getJoinOpSide(IXQEQueryNode node, String oneOrManyProp) {
        IXQEQueryNode[] tnodes;
        for (IXQEQueryNode tnode : tnodes = node.getChildrenOfTypeOrdered(801043)) {
            if (tnode.getPropertyValue(oneOrManyProp) == null) continue;
            return (SQLRelation)tnode.getChild(0);
        }
        return null;
    }

    public static void setJoinFilterProperties(PlanningEnvironment environment, SQLJoin join, IRelationship relationship) {
        join.setPropertyValue(PROP_JOIN_PROP_RELATIONSHIP, relationship);
        ApplyJoinFilterOptimization.setJoinFilterProperties(environment, join, relationship.getJoinFilterType(), relationship.getFJOAdvancedProperty());
    }

    public static void setJoinFilterProperties(PlanningEnvironment environment, SQLJoin sqlJoin, IRelationship.JoinFilterType joinFilterType, String fjoAdvanced) {
        if (joinFilterType != IRelationship.JoinFilterType.FILTER_TYPE_NONE) {
            sqlJoin.setPropertyValue(JOIN_FILTER_TYPE, (Object)joinFilterType);
        }
        if (fjoAdvanced != null) {
            if (MacroExpander.isMacro(fjoAdvanced)) {
                MacroExpander me = new MacroExpander();
                fjoAdvanced = me.expand(null, environment, fjoAdvanced);
            }
            if (fjoAdvanced != null && !fjoAdvanced.isEmpty()) {
                Properties props = new Properties();
                try {
                    fjoAdvanced = fjoAdvanced.replaceAll("[,;]", "\n").toUpperCase();
                    ByteArrayInputStream inStream = new ByteArrayInputStream(fjoAdvanced.getBytes("UTF-8"));
                    props.load(inStream);
                    String propertyValue = props.getProperty(JOIN_FILTER_TYPE_UPPERCASE);
                    if (propertyValue != null) {
                        joinFilterType = IRelationship.JoinFilterType.toJoinFilterType(propertyValue);
                        sqlJoin.setPropertyValue(JOIN_FILTER_TYPE, (Object)joinFilterType);
                    }
                    if ((propertyValue = props.getProperty(PROP_FILTER_REQUIRED_UPPERCASE)) != null) {
                        sqlJoin.setPropertyValue(PROP_FILTER_REQUIRED, Boolean.valueOf(propertyValue));
                    }
                    if ((propertyValue = props.getProperty(PROP_ABSOLUTE_LIMIT_UPPERCASE)) != null) {
                        sqlJoin.setPropertyValue(PROP_ABSOLUTE_LIMIT, Integer.valueOf(propertyValue));
                    }
                    if ((propertyValue = props.getProperty(PROP_PERCENTAGE_LIMIT_UPPERCASE)) != null) {
                        sqlJoin.setPropertyValue(PROP_PERCENTAGE_LIMIT, Integer.valueOf(propertyValue));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static IRelationship.JoinFilterType getJoinFilterType(PlanningEnvironment environment, IRelationship relationship) {
        IRelationship.JoinFilterType joinFilterType = relationship.getJoinFilterType();
        String fjoAdvanced = relationship.getFJOAdvancedProperty();
        if (fjoAdvanced != null) {
            SQLJoin join = new SQLJoin();
            ApplyJoinFilterOptimization.setJoinFilterProperties(environment, join, joinFilterType, fjoAdvanced);
            IRelationship.JoinFilterType jftFromAdvancedProperties = (IRelationship.JoinFilterType)((Object)join.getPropertyValue(JOIN_FILTER_TYPE));
            if (jftFromAdvancedProperties != null) {
                joinFilterType = jftFromAdvancedProperties;
            }
        }
        return joinFilterType;
    }

    protected static boolean hasMasterDetailLinkParameterUnresolved(IXQEQueryNode filter, PlanningEnvironment environment) {
        boolean hasMasterDetailLinkParameterUnresolved = false;
        Parameters parameters = ((RequestEnvironment)((ExecutionEnvironment)environment.getExecutionEnvironment()).getRequestEnvironment()).getRequestParameters();
        List<IXQEQueryNode> sqlParameters = filter.getDescendantsOfTypeOrdered(301051, false);
        for (IXQEQueryNode p : sqlParameters) {
            Parameter parameter = parameters.getParameter(((SQLParameter)p).getName());
            if (!parameter.isMasterDetailLinkParameter() || parameter.isResolved()) continue;
            hasMasterDetailLinkParameterUnresolved = true;
            break;
        }
        return hasMasterDetailLinkParameterUnresolved;
    }
}

