/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMModelQueryAsView;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RMSqlAsView;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLTableSample;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.ast.sql.util.SQLPlainQueryFormatter;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.relational.SQLCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQETableSampleRowCountException;
import com.cognos.xqe.function.numeric.Random;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemFolder;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.BaseExecutionEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTree;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.transformation.relational.binding.BindSQLRelation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindRelationNotFoundException;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Properties;

public class ApplySamplingQueryHintToTables
extends RQPTransformation {
    public static final String SAMPLING_QUERY_HINT_APPLIED = "SamplingQueryHintApplied";
    private static final int TEN = 10;
    private static final int ONE_HUNDRED = 100;
    private static final double ONE_POINT_ONE = 1.1;
    private static final String COUNT_COLUMN_ALIAS = "C";
    private static final String DELIMITER = "\"";
    private static final String TABLE_ALIAS = "\"T\"";
    private static final String TABLE_ALIAS_PREFIX = "\"T\".";
    private static final String SELECT_COUNT_SQL = "select COUNT(*) as C from ";
    private static final IDataType[] RAND_SEED_DATATYPE_ARR = new IDataType[]{Random.getOutputType(null)};
    private static final IDataType[] EMPTY_ARGS_ARRAY = new IDataType[0];

    public ApplySamplingQueryHintToTables() {
        this.mName = "Apply Sampling QueryHInt To Tables";
        this.mPassNumbers = new int[]{110};
        this.mTypes = new int[]{301016};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Governors governors = node.getGovernors();
        SQLRelation relation = (SQLRelation)node;
        IDataSource dataSource = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getDataSourceByModelName(relation.getModelDatasourceName());
        String samplingTable = governors.getTableSamplingTable();
        boolean doSampling = true;
        if (samplingTable == null || samplingTable.length() == 0) {
            doSampling = this.checkForUnsupportedJoin(relation);
        }
        try {
            BindSQLRelation.queryPhysicalModel(relation, environment);
        }
        catch (BindRelationNotFoundException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unable to bind SQL relation for sampling.");
        }
        IDataSourceCapabilities capabilities = relation.getDataSource().getCapabilities();
        String tableSampleCapability = capabilities.getStringValue("sampling.tablesample", null);
        String rowSampleCapability = capabilities.getStringValue("sampling.rowsample", null);
        String samplingMethod = governors.getTableSamplingMethod();
        if (doSampling && (samplingMethod.equalsIgnoreCase(SQLTableSample.SubType.BERNOULLI.name()) || samplingMethod.equalsIgnoreCase(SQLTableSample.SubType.SYSTEM.name())) && (tableSampleCapability == null || tableSampleCapability.isEmpty())) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedFeature, "sampling.tablesample capability");
        }
        if (doSampling && samplingMethod.equalsIgnoreCase("NTH") && (rowSampleCapability == null || rowSampleCapability.isEmpty())) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedFeature, "sampling.rowsample capability");
        }
        double samplingPercent = governors.getTableSamplingPercent();
        if (doSampling && samplingPercent <= 0.0) {
            Long pqRowCount;
            int rowCount = governors.getTableSamplingRowCount();
            if (rowCount <= 0) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid sampling row count value, less than or equal to zero.");
            }
            if (dataSource != null && (DataSourceTypeEnum.isFlint(dataSource.getType()) || DataSourceTypeEnum.isColumnar(dataSource.getType())) && (pqRowCount = (Long)dataSource.getMetadataProperties().get("numRows")) != null && pqRowCount.intValue() > 0) {
                samplingPercent = ApplySamplingQueryHintToTables.calculatePercent(rowCount, pqRowCount.intValue(), true);
            }
            if (samplingPercent <= 0.0) {
                samplingPercent = this.calculateSamplingPercent(relation, rowCount, environment, dataSource, governors.getTableSamplingThrowOnSubquery());
            }
        }
        if (doSampling && samplingPercent < 100.0) {
            this.createSQLSampling(relation, environment, samplingPercent);
        }
        node.setPropertyValue(SAMPLING_QUERY_HINT_APPLIED, Boolean.TRUE);
    }

    private boolean checkForUnsupportedJoin(SQLRelation relation) {
        IXQEQueryNode rsapiDataset = relation.getAncestorOfType(401005);
        IXQEQueryNode[] joinPathNodes = rsapiDataset.getDescendantsOfType(801039, false);
        if (joinPathNodes == null || joinPathNodes.length == 0) {
            return true;
        }
        RQPJoinPath[] joinPaths = null;
        RQPJoinPath joinPath = null;
        if (joinPathNodes.length == 1) {
            joinPath = (RQPJoinPath)joinPathNodes[0];
        } else {
            joinPaths = new RQPJoinPath[joinPathNodes.length];
            for (int i = 0; i < joinPaths.length; ++i) {
                joinPaths[i] = (RQPJoinPath)joinPathNodes[i];
                if (joinPath != null || !joinPaths[i].getParent().isOfCategory(801017)) continue;
                joinPath = joinPaths[i];
            }
        }
        RMQuery rmQuery = (RMQuery)relation.getAncestorOfCategory(801026);
        if (rmQuery == null || rmQuery.getQuerySubject() == null) {
            return false;
        }
        String rmQuerySubjectID = rmQuery.getQuerySubject().getID();
        int maxDepth = joinPathNodes.length * 2;
        for (int depth = 0; joinPath != null && depth < maxDepth; ++depth) {
            IQuerySubject potentialTable = this.getPotentialTableToSample(joinPath);
            if (potentialTable == null) {
                return false;
            }
            if (rmQuerySubjectID.equals(potentialTable.getID())) {
                return true;
            }
            if (potentialTable.getQuerySubjectType() != IQuerySubject.QuerySubjectTypeEnum.MODELQUERYSUBJECT) break;
            joinPath = null;
            if (joinPaths != null) {
                joinPath = this.findJoinPath(joinPaths, potentialTable);
            }
            if (joinPath != null) continue;
            RQPQuery rqpQuery = (RQPQuery)relation.getAncestorOfCategory(801017);
            SQLRelation potentialRelation = this.getInvolvedSQLRelation(rqpQuery, potentialTable);
            return potentialRelation != null && potentialRelation == relation;
        }
        return false;
    }

    private RQPJoinPath findJoinPath(RQPJoinPath[] joinPaths, IQuerySubject querySubject) {
        for (RQPJoinPath joinPath : joinPaths) {
            RMQuery rmQuery;
            IQuerySubject rmQuerySubject;
            if (!joinPath.getParent().isOfCategory(801026) || !(rmQuerySubject = (rmQuery = (RMQuery)joinPath.getParent()).getQuerySubject()).getID().equals(querySubject.getID())) continue;
            return joinPath;
        }
        return null;
    }

    private IQuerySubject getPotentialTableToSample(RQPJoinPath joinPath) {
        ArrayList<IQuerySubject> potentialTables = new ArrayList<IQuerySubject>();
        ArrayList<IQuerySubject> oneCardTables = new ArrayList<IQuerySubject>();
        for (IMetadata path : joinPath.getJoinPath()) {
            if (!(path instanceof IRelationship)) {
                return null;
            }
            IRelationship rel = (IRelationship)path;
            Enum<IRelationship.Cardinality> leftCard = rel.getLeftCardinality();
            Enum<IRelationship.Cardinality> rightCard = rel.getRightCardinality();
            IQuerySubject leftQuerySubject = this.getRefObjectQuerySubject(rel.getLeftRefObject());
            IQuerySubject rightQuerySubject = this.getRefObjectQuerySubject(rel.getRightRefObject());
            boolean oneFound = false;
            if (leftCard.equals((Object)IRelationship.Cardinality.ONE_ONE) || leftCard.equals((Object)IRelationship.Cardinality.ZERO_ONE)) {
                oneCardTables.add(leftQuerySubject);
                oneFound = true;
            }
            if (rightCard.equals((Object)IRelationship.Cardinality.ONE_ONE) || rightCard.equals((Object)IRelationship.Cardinality.ZERO_ONE)) {
                oneCardTables.add(rightQuerySubject);
                oneFound = true;
            }
            if (!oneFound) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot apply sampling to query with joins, no querysubject found with cardinality of one.");
            }
            IQuerySubject potentialTable = null;
            if (leftCard.equals((Object)IRelationship.Cardinality.ONE_MANY) || leftCard.equals((Object)IRelationship.Cardinality.ZERO_MANY)) {
                potentialTable = leftQuerySubject;
            }
            if (rightCard.equals((Object)IRelationship.Cardinality.ONE_MANY) || rightCard.equals((Object)IRelationship.Cardinality.ZERO_MANY)) {
                potentialTable = rightQuerySubject;
            }
            if (potentialTable == null || potentialTables.contains(potentialTable)) continue;
            potentialTables.add(potentialTable);
        }
        for (int i = potentialTables.size() - 1; i >= 0; --i) {
            IQuerySubject table = (IQuerySubject)potentialTables.get(i);
            if (!oneCardTables.contains(table)) continue;
            potentialTables.remove(i);
        }
        if (potentialTables.size() == 1) {
            return (IQuerySubject)potentialTables.get(0);
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot apply sampling to query with joins, could not identify one querysubject for sampling.");
    }

    private IQuerySubject getRefObjectQuerySubject(IMetadata refObject) {
        IQuerySubject querySubject = null;
        querySubject = refObject.getObjectType() == MetadataType.SHORTCUT ? (IQuerySubject)((IShortcut)refObject).getTarget() : (refObject.getObjectType() == MetadataType.FOLDER ? ((IQueryItemFolder)refObject).getQuerySubject() : (IQuerySubject)refObject);
        return querySubject;
    }

    private SQLRelation getInvolvedSQLRelation(RQPQuery rqpQuery, IQuerySubject querySubject) {
        SQLRelation relation = null;
        IXQEQueryNode[] listOfRmQueryList = rqpQuery.getDescendantsOfType(801032, false);
        for (IMetadata queryItem : querySubject.getQueryItemsAndMeasures()) {
            for (IXQEQueryNode rmQueryList : listOfRmQueryList) {
                SQLRelation queryItemRelation = this.getSQLRelation(queryItem, rmQueryList);
                if (queryItemRelation == null) continue;
                if (relation == null) {
                    relation = queryItemRelation;
                    continue;
                }
                if (relation == queryItemRelation) continue;
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot apply sampling to model query subject with multiple tables with only one RQPJoinPath in plan.");
            }
        }
        return relation;
    }

    private SQLRelation getSQLRelation(IMetadata metadata, IXQEQueryNode rmQueryList) {
        RMQuery rmQuery = null;
        String uniqueName = null;
        IQueryItem queryItem = (IQueryItem)metadata;
        IQuerySubject querySubject = queryItem.getQuerySubject();
        rmQuery = ((RMQueryList)rmQueryList).getRMQuery(querySubject);
        uniqueName = queryItem.getV5UniqueName();
        if (rmQuery == null) {
            return null;
        }
        if (rmQuery.getType() == 801029) {
            IXQEQueryNode[] items;
            IXQEQueryNode rmQueryItemList = rmQuery.getFirstChildByType(801034);
            for (IXQEQueryNode rmItem : items = rmQueryItemList.getChildren()) {
                RMQueryItem rmQI = (RMQueryItem)rmItem;
                String rmQIName = rmQI.getV5UniqueName();
                if (!rmQIName.equals(uniqueName)) continue;
                IXQEQueryNode[] identifiers = rmQI.getDescendantsOfType(201116, false);
                SQLRelation relation = null;
                for (IXQEQueryNode id : identifiers) {
                    V5BoundModelIdentifier v5BMId = (V5BoundModelIdentifier)id;
                    IMetadata met = v5BMId.getMetadata();
                    SQLRelation unwoundRelation = this.getSQLRelation(met, rmQueryList);
                    if (relation == null) {
                        relation = unwoundRelation;
                        continue;
                    }
                    if (unwoundRelation == null || relation == unwoundRelation) continue;
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot apply sampling to query with joins, RMModelQueryAsView using multiple tables.");
                }
                return relation;
            }
        } else if (rmQuery.getType() == 801028 || rmQuery.getType() == 801027) {
            IXQEQueryNode[] sqlRelations = rmQuery.getDescendantsOfType(301016, false);
            if (sqlRelations.length == 0) {
                return null;
            }
            if (sqlRelations.length > 1) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot apply sampling to query with joins, found more than one SQLRelation.");
            }
            return (SQLRelation)sqlRelations[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double calculateSamplingPercent(SQLRelation relation, int rowCount, PlanningEnvironment environment, IDataSource dataSource, boolean throwOnSubquery) {
        int actualRowCount;
        ExecutionEnvironmentContext env;
        PlanningEnvironment subQueryEnvironment;
        block13: {
            ExecutionEnvironment execEnvironment = (ExecutionEnvironment)environment.getExecutionEnvironment();
            subQueryEnvironment = V5SubQueryBuilder.createPlanningEnvironment(execEnvironment, environment);
            Properties props = new Properties();
            props.setProperty("printDbName", "true");
            props.setProperty("preferredDelimiter", DELIMITER);
            SQLPlainQueryFormatter formatter = new SQLPlainQueryFormatter(props);
            relation.getCognosSQL(SQLCapabilities.getInstance(), formatter);
            String sql = SELECT_COUNT_SQL + formatter.bufferToString();
            String[] projectedColumns = new String[]{COUNT_COLUMN_ALIAS};
            V5QuerySet v5QuerySet = V5SubQueryBuilder.createTypeInSQLQuery(sql, projectedColumns, subQueryEnvironment, dataSource);
            RequestEnvironment subRequestEnvironment = (RequestEnvironment)subQueryEnvironment.getRequestEnvironment();
            BaseExecutionEnvironment execEnv = null;
            env = null;
            XDataContext dataContext = null;
            actualRowCount = 1;
            try {
                PlannedV5QuerySet plannedQuery = QueryPlanner.getInstance().planQuery(v5QuerySet, subQueryEnvironment);
                subQueryEnvironment.setPlanningActive(subRequestEnvironment);
                execEnv = (ExecutionEnvironment)subQueryEnvironment.getExecutionEnvironment();
                env = ExecutionEnvironmentContext.enter(execEnv);
                dataContext = execEnv.pushDataContext();
                IHybridResultSet hybridResultSet = null;
                XSql xSql = (XSql)plannedQuery.getFirstDescendantOfTypeOrdered(501013, false);
                if (xSql == null) {
                    XTree xTree = (XTree)plannedQuery.getFirstDescendantOfTypeOrdered(501021, false);
                    hybridResultSet = V5SubQueryBuilder.executeSubQuery(dataContext, xTree);
                } else {
                    hybridResultSet = V5SubQueryBuilder.executeSubQuery(dataContext, xSql);
                }
                try {
                    IValue value = V5SubQueryBuilder.getValueFromSubQuery(hybridResultSet);
                    if (value != null && value.getDataType().isNumeric()) {
                        NumericValue numericValue = null;
                        numericValue = value instanceof ContextValue ? (NumericValue)((ContextValue)value).getValue() : (NumericValue)value;
                        actualRowCount = numericValue.getInteger();
                    }
                }
                finally {
                    hybridResultSet.release();
                }
                if (execEnv == null || dataContext == null) break block13;
            }
            catch (Throwable throwable) {
                if (execEnv != null && dataContext != null) {
                    execEnv.popDataContext(dataContext);
                }
                if (env != null) {
                    env.exit();
                }
                throw throwable;
            }
            execEnv.popDataContext(dataContext);
        }
        if (env != null) {
            env.exit();
        }
        subQueryEnvironment.setPlanningInactive();
        if (throwOnSubquery) {
            throw new XQETableSampleRowCountException(actualRowCount);
        }
        return ApplySamplingQueryHintToTables.calculatePercent(rowCount, actualRowCount, true);
    }

    public static double calculatePercent(int rowCount, int totalRowCount, boolean adjustPercentage) {
        double percentage;
        if (adjustPercentage) {
            percentage = (double)rowCount * 1.1 / (double)totalRowCount * 100.0;
            if (percentage > 10.0) {
                percentage *= 1.1;
            }
        } else {
            percentage = (double)rowCount / (double)totalRowCount * 100.0;
        }
        return percentage;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (node.getPropertyValue(SAMPLING_QUERY_HINT_APPLIED) == null) {
            Governors governors = node.getGovernors();
            String samplingTable = governors.getTableSamplingTable();
            String samplingMethod = governors.getTableSamplingMethod();
            if (samplingMethod == null || samplingMethod.length() == 0) {
                return false;
            }
            if (samplingTable == null || samplingTable.length() == 0) {
                return true;
            }
            ((SQLRelation)node).isDatabaseTable();
            SQLRangeVar rangeVar = (SQLRangeVar)node.getAncestorOfType(301007);
            if (rangeVar != null) {
                String qsName = (String)rangeVar.getPropertyValue("fullQSName");
                return qsName != null && qsName.equals(samplingTable);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createSQLSampling(SQLRelation relation, PlanningEnvironment environment, double samplingPercent) {
        IDataSourceCapabilities capabilities = relation.getDataSource().getCapabilities();
        Governors governors = relation.getGovernors();
        String samplingMethod = governors.getTableSamplingMethod();
        if (samplingMethod.equalsIgnoreCase(SQLTableSample.SubType.BERNOULLI.name()) || samplingMethod.equalsIgnoreCase(SQLTableSample.SubType.SYSTEM.name())) {
            String desiredSamplingMethod = capabilities.getStringValue("sampling.tablesample", SQLTableSample.SubType.BERNOULLI.name());
            if (SQLTableSample.SubType.BERNOULLI.name().equalsIgnoreCase(desiredSamplingMethod)) {
                this.createSQLTableSampling(relation, environment, SQLTableSample.SubType.BERNOULLI.name(), samplingPercent);
            } else {
                if (!SQLTableSample.SubType.SYSTEM.name().equalsIgnoreCase(desiredSamplingMethod)) throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedFeature, "sampling.tablesample capability");
                this.createSQLTableSampling(relation, environment, SQLTableSample.SubType.SYSTEM.name(), samplingPercent);
            }
        } else {
            String desiredSamplingMethod = capabilities.getStringValue("sampling.rowsample", "NTH");
            if ("RANDOM".equalsIgnoreCase(desiredSamplingMethod)) {
                this.createSQLRandRowSampling(relation, environment, samplingPercent);
            } else {
                if (!"NTH".equalsIgnoreCase(desiredSamplingMethod)) throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedFeature, "sampling.rowsample capability");
                this.createSQLNthRowSampling(relation, environment, samplingPercent);
            }
        }
        governors.setLocalCache("false");
    }

    private void createSQLRandRowSampling(SQLRelation relation, PlanningEnvironment environment, double samplingPercent) {
        String originalName;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryItemList itemList = relation.getQueryItemList();
        if (itemList.isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unable to find query items in the relation.");
        }
        double probability = samplingPercent / 100.0;
        IDataSourceCapabilities capabilities = relation.getDataSource().getCapabilities();
        String randWithSeedCapability = capabilities.getFunctionPattern("functions.Random", RAND_SEED_DATATYPE_ARR);
        Governors governors = relation.getGovernors();
        int seed = governors.getTableSamplingSeed();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM  ( SELECT ");
        sql.append(TABLE_ALIAS_PREFIX);
        if (seed != -1 && null != randWithSeedCapability && !randWithSeedCapability.isEmpty()) {
            sql.append("* , RANDOM(");
            sql.append(seed);
            sql.append(") AS rn FROM ");
        } else {
            sql.append("* , RANDOM() AS rn FROM ");
        }
        sql.append(DELIMITER);
        sql.append(relation.getDatabaseName());
        sql.append(DELIMITER);
        sql.append(" ");
        sql.append(TABLE_ALIAS);
        sql.append(") RANDSAMPLE  where  RANDSAMPLE.rn < ");
        sql.append(probability);
        SQLProcessor parser = new SQLProcessor(nodeFactory);
        IXQEQueryNode node = null;
        try {
            node = parser.parseQuery(sql.toString());
        }
        catch (ParseException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unable to generate SQL tree using RANDOM scalar function.");
        }
        relation.getParent().exchange(node);
        IXQEQueryNode rel = node.getFirstDescendantOfTypeOrdered(301016, false);
        rel.exchange(relation, true);
        SQLRangeVar rangeVar = (SQLRangeVar)node.getAncestorOfType(301007);
        String correlationName = originalName = rangeVar.getName();
        RMQueryList rmQueryList = (RMQueryList)node.getAncestorOfType(801032);
        for (IXQEQueryNode child : rmQueryList.getChildren()) {
            RMSqlAsView sqlAsView;
            if (801029 == child.getType()) {
                RMModelQueryAsView modelQueryAsView = (RMModelQueryAsView)child;
                if (!originalName.equals(modelQueryAsView.getNameParts()[modelQueryAsView.getNameParts().length - 1])) continue;
                correlationName = correlationName + "0";
                modelQueryAsView.setCorrelationName(correlationName);
                continue;
            }
            if (801028 != child.getType() || !originalName.equals((sqlAsView = (RMSqlAsView)child).getNameParts()[sqlAsView.getNameParts().length - 1])) continue;
            correlationName = correlationName + "0";
            sqlAsView.setCorrelationName(correlationName);
            if (sqlAsView.getChildren().length == 0 || 301007 != sqlAsView.getChild(0).getType()) continue;
            rangeVar = (SQLRangeVar)sqlAsView.getChild(0);
            rangeVar.setName(correlationName);
        }
        IXQEQueryNode dataSet = relation.getAncestorOfType(401005);
        if (dataSet != null) {
            ((RSAPIDataset)dataSet).setHasSampledData();
        }
    }

    private void createSQLNthRowSampling(SQLRelation relation, PlanningEnvironment environment, double samplingPercent) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryItemList itemList = relation.getQueryItemList();
        if (itemList.isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unable to find query items in the relation.");
        }
        int nthRow = new Double(100.0 / samplingPercent).intValue();
        IDataSourceCapabilities capabilities = relation.getDataSource().getCapabilities();
        String rowNumberCapability = capabilities.getFunctionPattern("olap.RowNumber", EMPTY_ARGS_ARRAY);
        boolean supportsConstantsInWindows = capabilities.isSupported("supports.constantsInWindows");
        StringBuilder select = new StringBuilder();
        select.append("SELECT * FROM  ( SELECT ");
        select.append(TABLE_ALIAS_PREFIX);
        if (null != rowNumberCapability && !rowNumberCapability.isEmpty() && (capabilities.isSupported("supports.rowNumberNoOrderBy") || capabilities.isSupported("supports.sqlserverWindowBehaviour"))) {
            select.append("* , ROW_NUMBER() OVER ( ) AS rn FROM ");
        } else if (null != rowNumberCapability && !rowNumberCapability.isEmpty() && supportsConstantsInWindows) {
            select.append("* , ROW_NUMBER() OVER ( ORDER BY NULL ) AS rn FROM ");
        } else if ((null == rowNumberCapability || rowNumberCapability.isEmpty()) && supportsConstantsInWindows && capabilities.isSupported("olap.Window.Frame.Moving")) {
            select.append("* , SUM(1) OVER ( ORDER BY NULL ROWS UNBOUNDED PRECEDING ) AS rn FROM ");
        } else {
            select.append("* , ROW_NUMBER() OVER ( ORDER BY ");
            select.append(TABLE_ALIAS_PREFIX);
            select.append(DELIMITER);
            select.append(((SQLQueryItem)itemList.get(0)).getName());
            select.append(DELIMITER);
            select.append(") AS rn FROM ");
        }
        select.append(DELIMITER);
        select.append(relation.getDatabaseName());
        select.append(DELIMITER);
        select.append(" ");
        select.append(TABLE_ALIAS);
        select.append(") SAMPLENTH  where  MOD(SAMPLENTH.rn, ");
        select.append(nthRow);
        select.append(") = 0");
        SQLProcessor parser = new SQLProcessor(nodeFactory);
        IXQEQueryNode node = null;
        try {
            node = parser.parseQuery(select.toString());
        }
        catch (ParseException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unable to generate SQL tree for selecting Nth row.");
        }
        relation.getParent().exchange(node);
        IXQEQueryNode rel = node.getFirstDescendantOfTypeOrdered(301016, false);
        rel.exchange(relation, true);
        IXQEQueryNode dataSet = relation.getAncestorOfType(401005);
        if (dataSet != null) {
            ((RSAPIDataset)dataSet).setHasSampledData();
        }
        for (IXQEQueryNode aggrNode : node.getDescendantsOfCategory(301034, false)) {
            SQLAggregate sqlAggr = (SQLAggregate)aggrNode;
            if (SQLAggregate.SubType.ROW_NUMBER != sqlAggr.getSubType()) continue;
            SQLWindow sqlWindow = (SQLWindow)sqlAggr.getChild(0);
            sqlWindow.setSamplingScope(true);
            break;
        }
    }

    private void createSQLTableSampling(SQLRelation relation, PlanningEnvironment environment, String samplingMethod, double samplingPercent) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode parent = relation.getParent();
        IXQEQueryNode grandParent = parent.getParent();
        if (parent.getType() == 301015 && grandParent.getType() == 301007) {
            grandParent.extract();
            relation.insertParent(grandParent);
        }
        SQLTableSample tableSample = (SQLTableSample)nodeFactory.createNode(301092);
        relation.insertParent(tableSample);
        if (samplingMethod.equalsIgnoreCase(SQLTableSample.SubType.BERNOULLI.name())) {
            tableSample.setSubType(SQLTableSample.SubType.BERNOULLI);
        } else if (samplingMethod.equalsIgnoreCase(SQLTableSample.SubType.SYSTEM.name())) {
            tableSample.setSubType(SQLTableSample.SubType.SYSTEM);
        }
        SQLLiteral literalPercent = (SQLLiteral)nodeFactory.createNode(301031);
        BigDecimal decimalPercent = BigDecimal.valueOf(samplingPercent);
        DecimalType dataType = DataTypeFactory.getDecimalType(Integer.MAX_VALUE, decimalPercent.scale());
        DecimalValue decimalValue = DataValueFactory.createDecimalValue(dataType);
        decimalValue.set(decimalPercent);
        literalPercent.setValue(decimalValue);
        tableSample.addChild(literalPercent);
        Governors governors = relation.getGovernors();
        int seed = governors.getTableSamplingSeed();
        if (seed != -1) {
            SQLLiteral literalSeed = (SQLLiteral)nodeFactory.createNode(301031);
            literalSeed.setDataType(IntegerType.INTEGERTYPE);
            literalSeed.setValue(Integer.toString(seed));
            tableSample.addChild(literalSeed);
        }
    }
}

