/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSortList;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLCoalesce;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundSQLQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.dynamic.DMQuerySubject;
import com.cognos.xqe.metadata.dynamic.DMRelationship;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.NagExceptionWithCognosSQL;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.itemNormalization.ItemNormalization;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class BuildFullOuterJoin
extends RQPTransformation {
    public BuildFullOuterJoin() {
        this.mName = "Build Full Outer Join for stitching the fact streams";
        this.mPassNumbers = new int[]{27};
        this.mTypes = new int[]{801017};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int i;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RQPFactManager rqpFactManager = RQPUtilities.getRQPFactManager(node);
        RQPQuery rootQuery = (RQPQuery)node;
        if (rootQuery.getRefV5Query() == null) {
            rootQuery = RQPQuery.getRQPQuery(node).getRootRQPQuery();
        }
        List<Object> joinPath = new ArrayList();
        HashMap<String, IXQEQueryNode> joinPathToJoinExpression = new HashMap<String, IXQEQueryNode>();
        RQPJoinPath rqpJoinPath = (RQPJoinPath)node.getFirstChildByType(801039);
        if (rqpJoinPath == null) {
            rqpJoinPath = (RQPJoinPath)nodeFactory.createNode(801039);
            node.addChild(rqpJoinPath);
        } else {
            joinPath = rqpJoinPath.getJoinPath();
        }
        Set<String> subqueriesAlreadyJoined = this.getJoinedSubqueryNames(rqpJoinPath);
        FactInfo[] allFactStreamData = this.getAllFactStreamData(node, rqpFactManager, subqueriesAlreadyJoined);
        Governors.JoinOperator multiFactJoinOperator = node.getGovernors().getMultiFactJoinOperator();
        HashSet<String> setOfFactStreamsInJoinPath = new HashSet<String>();
        for (i = 1; i < allFactStreamData.length; ++i) {
            IXQEQueryNode joinExpression = this.buildJoinPathExpressionTree(environment, multiFactJoinOperator, allFactStreamData, i);
            if (joinExpression == null) continue;
            String key = Integer.toString(i);
            FactInfo fi1 = allFactStreamData[i - 1];
            FactInfo fi2 = allFactStreamData[i];
            DMQuerySubject qsa = new DMQuerySubject(fi1.factName);
            setOfFactStreamsInJoinPath.add(fi1.factName);
            DMQuerySubject qsb = new DMQuerySubject(fi2.factName);
            setOfFactStreamsInJoinPath.add(fi2.factName);
            DMRelationship join = new DMRelationship(fi1.factName + "----" + fi2.factName, qsa, qsb, key);
            joinPath.add(join);
            joinPathToJoinExpression.put(key, joinExpression);
        }
        if (joinPath.size() > 0) {
            rqpJoinPath.setJoinPath(joinPath);
            rqpJoinPath.setJoinPathToJoinExpression(joinPathToJoinExpression);
        }
        for (i = 0; i < allFactStreamData.length; ++i) {
            if (allFactStreamData[i].rsumProjections.size() <= 0) continue;
            RQPQuery rqpQuery = (RQPQuery)allFactStreamData[i].sqlRangeVar.getChild(0);
            if (rqpQuery.getIsMergedQuery()) {
                RQPProjectionList rqpProjectionList = rqpQuery.getProjectionList();
                for (int j = 0; j < allFactStreamData[i].rsumProjections.size(); ++j) {
                    rqpProjectionList.addChild(allFactStreamData[i].rsumProjections.get(j));
                }
                continue;
            }
            this.createInnerFactQuery(environment, allFactStreamData[i]);
        }
        if (rootQuery.getPropertyValue("rowStitch") != null) {
            String projectionName = "stitchedColumns";
            RQPSortList sqlSortKeyList = rootQuery.getOrCreateRQPSortList(environment);
            SQLSortKey sqlSortKey = (SQLSortKey)environment.getNodeFactory().createNode(301020);
            sqlSortKeyList.addChild(sqlSortKey);
            sqlSortKey.setAscending(true);
            SQLColumn sortColumn = (SQLColumn)environment.getNodeFactory().createNode(301005);
            sortColumn.setName(projectionName);
            sqlSortKey.addChild(sortColumn);
            RQPProjectionList projectionList = rootQuery.getOrCreateProjectionList(environment);
            SQLAlias sqlAlias = (SQLAlias)environment.getNodeFactory().createNode(301028);
            projectionList.addChild(sqlAlias);
            sqlAlias.setName(projectionName);
            SQLCoalesce sqlCoalesce = (SQLCoalesce)environment.getNodeFactory().createNode(301072);
            sqlAlias.addChild(sqlCoalesce);
            SQLValueList sqlValueList = (SQLValueList)environment.getNodeFactory().createNode(301030);
            sqlCoalesce.addChild(sqlValueList);
            for (int i2 = 0; i2 < allFactStreamData.length; ++i2) {
                FactInfo fact = allFactStreamData[i2];
                SQLAlias rsumAlias = (SQLAlias)fact.rsumProjections.get(0);
                String rsumAliasName = rsumAlias.getName();
                SQLColumn column = (SQLColumn)environment.getNodeFactory().createNode(301005);
                column.setName(rsumAliasName);
                column.setTableName(fact.factName);
                sqlValueList.addChild(column);
            }
        }
        this.throwExceptionCrossProductOnDetailRows(allFactStreamData, setOfFactStreamsInJoinPath);
    }

    private void throwExceptionCrossProductOnDetailRows(FactInfo[] allFactStreamData, Set<String> factStreamsInJoinPath) {
        for (FactInfo factInfo : allFactStreamData) {
            RQPGroupByList rqpGroupByList;
            IXQEQueryNode sqlRangeVar = factInfo.sqlRangeVar;
            RQPQuery rqpQuery = (RQPQuery)sqlRangeVar.getFirstChildByType(801017);
            if (rqpQuery.getLowestLevelSummaryQueryProperty() != null || (rqpGroupByList = rqpQuery.getGroupByList()) != null) continue;
            boolean allProjectionsHaveAggregates = true;
            RQPProjectionList rqpProjList = rqpQuery.getProjectionList();
            for (int i = 0; i < rqpProjList.getNumberChildren(); ++i) {
                IXQEQueryNode projection = rqpProjList.getChild(i);
                if (projection.getDescendantsOfType(301034, false).length > 0) continue;
                allProjectionsHaveAggregates = false;
                break;
            }
            if (allProjectionsHaveAggregates) continue;
            boolean factInJoinPath = false;
            for (String factName : factStreamsInJoinPath) {
                if (!factName.equals(factInfo.factName)) continue;
                factInJoinPath = true;
                break;
            }
            if (factInJoinPath) continue;
            IMessageKey.Param1 parameter = XQEMessageKeys.PLN_MultifactCrossProductOnDetailFactStream;
            XQEMessage xqeMessage = new XQEMessage(parameter, factInfo.factName, (IXQEQueryNode)rqpQuery);
            XQERuntimeException xqeRE = new XQERuntimeException(xqeMessage);
            NagExceptionWithCognosSQL exception = new NagExceptionWithCognosSQL(xqeRE);
            ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            execEnv.addNag(exception);
            break;
        }
    }

    public static boolean getRowNumberStitch(RQPQuery rootQuery) {
        if (!rootQuery.isAutoSummaryTRUE()) {
            return true;
        }
        return rootQuery.getGovernors() == null || rootQuery.getGovernors().getSuppressDuplicateMeasureValues() == Governors.SuppressDuplicateMeasureValues.ENABLE;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPQuery parentQuery = RQPNode.getRQPQuery(node);
        if (!(parentQuery == null || rqpQuery.isSubqueryForSummaryFilters() || rqpQuery.getIsMergedQuery() || rqpQuery.isBridgeTabularQuery())) {
            this.traceNodeCondition(false, "This is not the root RQPQuery, nor the subquery for summaryFilters, merged or tabularBridge.", xqeTrace);
            return false;
        }
        if (rqpQuery.getPropertyValue("rowStitch") != null) {
            this.traceNodeCondition(true, "This is a row stitched query", xqeTrace);
            return true;
        }
        RQPFactManager rqpFactManager = RQPUtilities.getRQPFactManager(node);
        if (rqpFactManager == null) {
            this.traceNodeCondition(false, "No factManager to drive the stitching process.", xqeTrace);
            return false;
        }
        int numberOfFactStreams = rqpFactManager.getNumberOfFactStreams();
        if (numberOfFactStreams < 2) {
            this.traceNodeCondition(false, "No fact streams to stitch.", xqeTrace);
            return false;
        }
        IXQEQueryNode fromClause = node.getFirstChildByType(301043);
        if (fromClause == null) {
            this.traceNodeCondition(false, "Missing from clause, nothing to stitch.", xqeTrace);
            return false;
        }
        IXQEQueryNode[] sqlRangeVars = fromClause.getChildren();
        int numberOfFactQueriesInFromClause = 0;
        int allQueries = 0;
        for (IXQEQueryNode sqlRangeVar : sqlRangeVars) {
            RQPQuery rangeVarRQPQuery = (RQPQuery)sqlRangeVar.getFirstChildByType(801017);
            if (rangeVarRQPQuery == null) continue;
            ++allQueries;
            if (!rangeVarRQPQuery.isFactQuery()) continue;
            ++numberOfFactQueriesInFromClause;
        }
        if (numberOfFactQueriesInFromClause < 2) {
            this.traceNodeCondition(false, "There are less than two facts in the From Clause, nothing to stitch.", xqeTrace);
            return false;
        }
        IXQEQueryNode rqpJoinPath = node.getFirstChildByType(801039);
        if (rqpJoinPath != null) {
            if (rqpQuery.isBridgeTabularQuery()) {
                Set<String> subqueriesAlreadyJoined = this.getJoinedSubqueryNames(rqpJoinPath);
                if (subqueriesAlreadyJoined.size() == allQueries) {
                    this.traceNodeCondition(false, "RQPJoinPath is complete.", xqeTrace);
                    return false;
                }
            } else {
                this.traceNodeCondition(false, "RQPJoinPath has already been computed.", xqeTrace);
                return false;
            }
        }
        this.traceNodeCondition(true, "Compute the FullOuterJoin.", xqeTrace);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private FactInfo[] getAllFactStreamData(IXQEQueryNode node, RQPFactManager rqpFactManager, Set<String> subqueriesAlreadyJoined) {
        void var10_13;
        IXQEQueryNode[] children;
        IXQEQueryNode fromClause = node.getFirstChildByType(301043);
        ArrayList<RQPQuery> factQueries = new ArrayList<RQPQuery>();
        ArrayList<RQPQuery> factQueriesAlreadyJoined = new ArrayList<RQPQuery>();
        IXQEQueryNode[] iXQEQueryNodeArray = children = fromClause.getChildren();
        int n = iXQEQueryNodeArray.length;
        boolean bl = false;
        while (var10_13 < n) {
            RQPQuery rQPQuery;
            IXQEQueryNode iXQEQueryNode = iXQEQueryNodeArray[var10_13];
            IXQEQueryNode child = iXQEQueryNode.getFirstChildByType(801017);
            if (child != null && (rQPQuery = (RQPQuery)child).isFactQuery()) {
                if (!subqueriesAlreadyJoined.contains(rQPQuery.getName())) {
                    factQueries.add(rQPQuery);
                } else {
                    factQueriesAlreadyJoined.add(rQPQuery);
                }
            }
            ++var10_13;
        }
        if (factQueriesAlreadyJoined.size() != 0) {
            boolean done = false;
            for (IXQEQueryNode iXQEQueryNode : factQueries) {
                RQPQuery rQPQuery = (RQPQuery)iXQEQueryNode;
                for (IXQEQueryNode iXQEQueryNode2 : factQueriesAlreadyJoined) {
                    RQPQuery rqpQuery2 = (RQPQuery)iXQEQueryNode2;
                    if (!rqpFactManager.areStreamsSiblings(rQPQuery.getName(), rqpQuery2.getName())) continue;
                    factQueries.add(rqpQuery2);
                    done = true;
                    break;
                }
                if (!done) continue;
                break;
            }
            if (!done) {
                factQueries.add((RQPQuery)factQueriesAlreadyJoined.get(0));
            }
        }
        FactInfo[] allFactInfo = new FactInfo[factQueries.size()];
        int i = 0;
        for (IXQEQueryNode iXQEQueryNode : factQueries) {
            FactInfo fi = (FactInfo)iXQEQueryNode.getParent().getPropertyValue("streamData");
            if (fi == null) {
                fi = BuildFullOuterJoin.getFactStreamData((SQLRangeVar)iXQEQueryNode.getParent(), rqpFactManager);
            }
            allFactInfo[i++] = fi;
        }
        return allFactInfo;
    }

    public static FactInfo getFactStreamData(SQLRangeVar node, RQPFactManager rqpFactManager) {
        RQPQuery query = (RQPQuery)node.getChild(0);
        String factName = query.getName();
        FactInfo fi = new FactInfo();
        fi.sqlRangeVar = node;
        fi.factName = factName;
        fi.innerQueryName = factName + "_inner";
        RQPProjectionList projectionList = (RQPProjectionList)query.getFirstChildByType(801016);
        List<IXQEQueryNode> allProjections = projectionList.getDescendantsOfTypeOrdered(301028, false);
        for (IXQEQueryNode p : allProjections) {
            Set<String> dimensionNames = BuildFullOuterJoin.stitchableProjection(rqpFactManager, query, (SQLAlias)p);
            if (dimensionNames == null) continue;
            ProjectionInfo pi = new ProjectionInfo();
            pi.dimensionNames = dimensionNames;
            pi.aliasName = ((SQLAlias)p).getName();
            String origColumnName = ((SQLAlias)p).getOrigColumnName();
            pi.origColumnName = origColumnName != null ? origColumnName : pi.aliasName;
            fi.projectionItems.add(pi);
            fi.allProjections.add(pi.origColumnName);
            pi.isNullable = BuildFullOuterJoin.getIsNullable(p);
            fi.origColumnNameToAlias.put(pi.origColumnName, pi.aliasName);
        }
        return fi;
    }

    public static Set<String> stitchableProjection(RQPFactManager rqpFactManager, RQPQuery query, SQLAlias aliasNode) {
        HashSet<String> dimensionNames = new HashSet<String>();
        if (!BuildFullOuterJoin.findDimensionNames(rqpFactManager, aliasNode, dimensionNames, null) || dimensionNames.size() == 0) {
            return null;
        }
        return dimensionNames;
    }

    public static boolean findDimensionNames(RQPFactManager rqpFactManager, IXQEQueryNode rootNode, Set<String> dimensionNames, Boolean bInGroup) {
        List<IXQEQueryNode> allDescendants = rootNode.getDescendantsOfTypesOrdered(new int[]{201116, 801009}, false);
        for (IXQEQueryNode descendant : allDescendants) {
            if (RQPUtilities.isIdentifierInAggregateFunction(descendant)) {
                return false;
            }
            boolean success = true;
            if (descendant.getType() == 201116) {
                success = BuildFullOuterJoin.addDimensionName(rqpFactManager, (V5BoundModelIdentifier)descendant, dimensionNames);
            } else {
                RQPDataItemRef dataItemRef = (RQPDataItemRef)descendant;
                if (bInGroup == null && rqpFactManager.getItemNormalization() && BuildFullOuterJoin.isIdentifierInGroupBy(dataItemRef)) {
                    bInGroup = Boolean.TRUE;
                }
                if (dataItemRef.createdFromQS()) {
                    success = BuildFullOuterJoin.addDimensionName(rqpFactManager, dataItemRef, dimensionNames, bInGroup);
                } else {
                    RQPDataItem dataItem = dataItemRef.getNextReferencedItem();
                    success = BuildFullOuterJoin.findDimensionNames(rqpFactManager, dataItem, dimensionNames, bInGroup);
                }
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    private static boolean getIsNullable(IXQEQueryNode node) {
        for (IXQEQueryNode child : node.getChildren()) {
            RQPDataItemRef dataItemRef;
            RQPDataItem dataItem;
            if (!(child.getType() == 801008 ? BuildFullOuterJoin.getIsNullable(child) : (child.getType() == 801009 ? BuildFullOuterJoin.getIsNullable(dataItem = (dataItemRef = (RQPDataItemRef)child).getNextReferencedItem()) : BuildFullOuterJoin.currentNodeIsNullable(child)))) continue;
            return true;
        }
        return false;
    }

    private static boolean currentNodeIsNullable(IXQEQueryNode node) {
        if (node.isOfCategory(201120)) {
            return ((V5SimpleNode)node).isNullable();
        }
        return true;
    }

    public static boolean addDimensionName(RQPFactManager rqpFactManager, RQPDataItemRef dataItemRef, Set<String> dimensionNames, Boolean bInGroup) {
        RQPQuery refQuery = BuildFullOuterJoin.findRefRQPQuery(dataItemRef);
        String qsName = (String)refQuery.getPropertyValue("QSNAME");
        if (qsName != null && (rqpFactManager.isDimension(qsName) || BuildFullOuterJoin.isIdentifierInGroupBy(dataItemRef) || bInGroup == Boolean.TRUE)) {
            dimensionNames.add(qsName);
            return true;
        }
        return false;
    }

    public static boolean addDimensionName(RQPFactManager rqpFactManager, V5BoundModelIdentifier v5BoundId, Set<String> dimensionNames) {
        IQuerySubject qs = v5BoundId.getQuerySubject();
        String qsName = null;
        if (qs != null) {
            qsName = qs.getV5UniqueName();
        }
        if (qsName != null && (rqpFactManager.isDimension(qsName) || BuildFullOuterJoin.isIdentifierInGroupBy(v5BoundId))) {
            dimensionNames.add(qsName);
            return true;
        }
        return false;
    }

    public static boolean isIdentifierInGroupBy(IXQEQueryNode identifier) {
        RQPDataItem dataItem = (RQPDataItem)identifier.getAncestorOfType(801008);
        return dataItem.isGroupingItem();
    }

    public static RQPQuery findRefRQPQuery(RQPDataItemRef dataItemRef) {
        int[] types = new int[]{801017, 801025, 801024, 801012};
        RQPQuery rqpQuery = (RQPQuery)dataItemRef.getAncestorOfTypes(types);
        IXQEQueryNode fromClause = rqpQuery.getFirstChildByType(301043);
        ArrayList<IXQEQueryNode> childQueries = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode[] children = fromClause.getChildren();
        for (IXQEQueryNode sqlRangeVar : children) {
            IXQEQueryNode child = sqlRangeVar.getFirstChildByType(801017);
            if (child == null) continue;
            childQueries.add(child);
        }
        for (IXQEQueryNode childNode : childQueries) {
            RQPQuery childQuery = (RQPQuery)childNode;
            if (!dataItemRef.getQueryName().equals(childQuery.getName())) continue;
            return childQuery;
        }
        return null;
    }

    private boolean isMatchingProjection(FactInfo factToStitch, FactInfo stitchedFact, String origColumnName) {
        ProjectionInfo p2;
        ProjectionInfo p1;
        return stitchedFact.allProjections.contains(origColumnName) && (p1 = this.getMatchingProjection(factToStitch, origColumnName)).equals(p2 = this.getMatchingProjection(stitchedFact, origColumnName));
    }

    private String getMatchingAlias(FactInfo factToStitch, String origColumnName) {
        return factToStitch.origColumnNameToAlias.get(origColumnName);
    }

    private String generateRowNumberProjectionForFact(PlanningEnvironment environment, Set<String> sharedProjections, FactInfo fi) {
        String aliasName;
        block8: {
            RQPQuery currentRqpQuery;
            RQPProjectionList fiProjs;
            IXQEQueryNode[] iXQEQueryNodeArray;
            int n;
            int n2;
            RQPDataItemRef projRef;
            String projName;
            ProjectionInfo pi;
            int i;
            if (!this.sharedProjectionsInStream(sharedProjections, fi)) {
                return null;
            }
            aliasName = this.getRowNumberProjection(sharedProjections, fi);
            if (aliasName != null) {
                return aliasName;
            }
            aliasName = "sc" + String.valueOf(fi.stitchedColumnNumber++);
            SQLAlias sqlAlias = (SQLAlias)environment.getNodeFactory().createNode(301028);
            sqlAlias.setName(aliasName);
            fi.rsumProjections.add(sqlAlias);
            SQLAggregate sqlAggregate = (SQLAggregate)environment.getNodeFactory().createNode(301034);
            sqlAlias.addChild(sqlAggregate);
            sqlAggregate.setSubType(SQLAggregate.SubType.SUM);
            SQLLiteral sqlLiteral = (SQLLiteral)environment.getNodeFactory().createNode(301031);
            sqlAggregate.addChild(sqlLiteral);
            sqlLiteral.setDataType(DataTypeFactory.getSmallintType());
            sqlLiteral.setValue("1");
            SQLWindow sqlWindow = (SQLWindow)environment.getNodeFactory().createNode(301041);
            sqlAggregate.addChild(sqlWindow);
            sqlWindow.setWindowFrameUnits("ROWS");
            sqlWindow.setWindowFrameUpperBound(0);
            sqlWindow.setWindowFrameLowerBound(Integer.MIN_VALUE);
            SQLSortKeyList sqlSortKeyList = (SQLSortKeyList)environment.getNodeFactory().createNode(301021);
            sqlWindow.addChild(sqlSortKeyList);
            SQLPartition sqlPartition = null;
            String tabName = fi.innerQueryName;
            RQPQuery rqpQuery = (RQPQuery)fi.sqlRangeVar.getChild(0);
            List<ProjectionInfo> projectionItems = fi.projectionItems;
            for (i = 0; i < projectionItems.size(); ++i) {
                pi = projectionItems.get(i);
                projName = pi.aliasName;
                if (rqpQuery.getIsMergedQuery()) {
                    projRef = this.findProj(rqpQuery, pi.aliasName);
                    projName = this.getReferencedAliasName(projRef);
                    tabName = projRef.getQueryName();
                }
                if (!sharedProjections.contains(pi.aliasName)) continue;
                if (sqlPartition == null) {
                    sqlPartition = (SQLPartition)environment.getNodeFactory().createNode(301042);
                    sqlWindow.addChild(sqlPartition, 0);
                }
                this.addToPartitionByClause(environment, sqlPartition, projName, tabName);
                this.addToOrderByClause(environment, sqlSortKeyList, projName, tabName);
            }
            for (i = 0; i < projectionItems.size(); ++i) {
                pi = projectionItems.get(i);
                projName = pi.aliasName;
                if (rqpQuery.getIsMergedQuery()) {
                    projRef = this.findProj(rqpQuery, pi.aliasName);
                    projName = this.getReferencedAliasName(projRef);
                    tabName = projRef.getQueryName();
                }
                if (sharedProjections.contains(pi.aliasName)) continue;
                this.addToOrderByClause(environment, sqlSortKeyList, projName, tabName);
            }
            if (0 != sqlSortKeyList.getNumberChildren() || (n2 = 0) >= (n = (iXQEQueryNodeArray = (fiProjs = (currentRqpQuery = (RQPQuery)fi.sqlRangeVar.getChild(0)).getProjectionList()).getChildren()).length)) break block8;
            IXQEQueryNode childProj = iXQEQueryNodeArray[n2];
            SQLAlias alias = (SQLAlias)childProj;
            String projName2 = alias.getName();
            if (rqpQuery.getIsMergedQuery()) {
                RQPDataItemRef projRef2 = this.findProj(rqpQuery, alias.getName());
                projName2 = this.getReferencedAliasName(projRef2);
                tabName = projRef2.getQueryName();
            }
            this.addToOrderByClause(environment, sqlSortKeyList, projName2, tabName);
        }
        return aliasName;
    }

    public String getReferencedAliasName(RQPDataItemRef projRef) {
        RQPDataItem di = projRef.getNextReferencedItem();
        SQLAlias alias = (SQLAlias)di.getParent();
        String projName = alias.getName();
        return projName;
    }

    private RQPDataItemRef findProj(RQPQuery rqpQuery, String aliasName) {
        IXQEQueryNode[] projections;
        for (IXQEQueryNode proj : projections = rqpQuery.getProjectionList().getChildren()) {
            if (!((SQLAlias)proj).getName().equals(aliasName)) continue;
            return (RQPDataItemRef)proj.getChild(0).getChild(0);
        }
        return null;
    }

    private void addToPartitionByClause(PlanningEnvironment environment, SQLPartition sqlPartition, String aliasName, String innerQueryName) {
        SQLColumn column = (SQLColumn)environment.getNodeFactory().createNode(301005);
        column.setName(aliasName);
        column.setTableName(innerQueryName);
        sqlPartition.addChild(column);
    }

    private void addToOrderByClause(PlanningEnvironment environment, SQLSortKeyList sqlSortKeyList, String aliasName, String innerQueryName) {
        SQLColumn column = (SQLColumn)environment.getNodeFactory().createNode(301005);
        column.setName(aliasName);
        column.setTableName(innerQueryName);
        SQLSortKey sqlSortKey = (SQLSortKey)environment.getNodeFactory().createNode(301020);
        sqlSortKey.addChild(column);
        sqlSortKey.setAscending(true);
        sqlSortKeyList.addChild(sqlSortKey);
    }

    private String getRowNumberProjection(Set<String> sharedProjections, FactInfo fi) {
        for (int i = 0; i < fi.rsumProjections.size(); ++i) {
            SQLAlias sqlAlias = (SQLAlias)fi.rsumProjections.get(i);
            if (!this.isMatchingRowNumber(sharedProjections, fi, sqlAlias)) continue;
            return sqlAlias.getName();
        }
        return null;
    }

    private boolean sharedProjectionsInStream(Set<String> sharedProjections, FactInfo fi) {
        if (sharedProjections.size() > fi.projectionItems.size()) {
            return false;
        }
        List<ProjectionInfo> dimensionDataItems = fi.projectionItems;
        for (String aliasName : sharedProjections) {
            boolean match = false;
            for (int i = 0; i < dimensionDataItems.size(); ++i) {
                ProjectionInfo pi = dimensionDataItems.get(i);
                if (!aliasName.equals(pi.aliasName)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private boolean isMatchingRowNumber(Set<String> sharedDimensions, FactInfo fi, SQLAlias sqlAlias) {
        List<IXQEQueryNode> partitions = sqlAlias.getDescendantsOfTypeOrdered(301042, false);
        if (partitions.size() == 0) {
            return sharedDimensions.size() == 0;
        }
        SQLPartition sqlPartition = (SQLPartition)partitions.get(0);
        List<IXQEQueryNode> sqlColumns = sqlPartition.getDescendantsOfTypeOrdered(301005, false);
        if (sqlColumns.size() == 0) {
            return false;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        List<ProjectionInfo> dimensionDataItems = fi.projectionItems;
        for (int i = 0; i < dimensionDataItems.size(); ++i) {
            ProjectionInfo pi = dimensionDataItems.get(i);
            if (!sharedDimensions.contains(pi.aliasName)) continue;
            columnNames.add(pi.aliasName);
        }
        if (columnNames.size() != sqlColumns.size()) {
            return false;
        }
        int innerIndex = 0;
        for (IXQEQueryNode c : sqlColumns) {
            SQLColumn sqlColumn = (SQLColumn)c;
            if (sqlColumn.getName().equals(columnNames.get(innerIndex++))) continue;
            return false;
        }
        return true;
    }

    private String buildTwoPartsName(String factName1, String aliasName1) {
        String dot = ".";
        String openBracket = "[";
        String closeBracket = "]";
        StringBuilder expression = new StringBuilder();
        expression.append(openBracket);
        expression.append(factName1);
        expression.append(closeBracket);
        expression.append(dot);
        expression.append(openBracket);
        expression.append(aliasName1);
        expression.append(closeBracket);
        return expression.toString();
    }

    private void createInnerFactQuery(PlanningEnvironment environment, FactInfo fi) {
        RQPQuery currentRqpQuery = (RQPQuery)fi.sqlRangeVar.getChild(0);
        RQPQuery rqpQuery = currentRqpQuery.createQueryWrapper(environment, fi.innerQueryName);
        fi.sqlRangeVar.addChild(rqpQuery);
        RQPProjectionList rqpProjectionList = rqpQuery.getProjectionList();
        for (int i = 0; i < fi.rsumProjections.size(); ++i) {
            rqpProjectionList.addChild(fi.rsumProjections.get(i));
        }
    }

    private ProjectionInfo getMatchingProjection(FactInfo fi, String origColumnName) {
        List<ProjectionInfo> projectionItems = fi.projectionItems;
        for (int i = 0; i < projectionItems.size(); ++i) {
            ProjectionInfo pi = projectionItems.get(i);
            if (!pi.origColumnName.equals(origColumnName)) continue;
            return pi;
        }
        return null;
    }

    private IXQEQueryNode buildJoinPathExpressionTree(PlanningEnvironment environment, Governors.JoinOperator multiFactJoinOperator, FactInfo[] allFactStreamData, int streamToStitchPos) {
        for (int i = streamToStitchPos; i >= 0; --i) {
            FactInfo fi = allFactStreamData[i];
            fi.sharedProjections.clear();
        }
        ArrayList<IXQEQueryNode> subExpression = new ArrayList<IXQEQueryNode>();
        FactInfo factToStitch = allFactStreamData[streamToStitchPos];
        for (String aliasName : factToStitch.allProjections) {
            IXQEQueryNode singleExp = this.buildJoinExpressionForSharedDimensionAcrossAllStreams(environment, multiFactJoinOperator, allFactStreamData, streamToStitchPos, factToStitch, aliasName);
            if (singleExp == null) continue;
            subExpression.add(singleExp);
        }
        IXQEQueryNode rootExpression = null;
        Iterator it = subExpression.iterator();
        while (it.hasNext()) {
            rootExpression = this.andJoinClauses(environment, rootExpression, (IXQEQueryNode)it.next());
        }
        RQPQuery rootQuery = RQPQuery.getRQPQuery(factToStitch.sqlRangeVar).getRootRQPQuery();
        boolean forceRowNumberStitch = BuildFullOuterJoin.getRowNumberStitch(rootQuery);
        if (factToStitch.sharedProjections.size() < factToStitch.allProjections.size() || forceRowNumberStitch) {
            XQEBaseQueryNode sqlCoalesce = null;
            SQLValueList sqlValueList = null;
            for (int i = streamToStitchPos - 1; i >= 0; --i) {
                String aliasName;
                FactInfo stitchedFact = allFactStreamData[i];
                if (stitchedFact.sharedProjections.size() >= stitchedFact.allProjections.size() && !forceRowNumberStitch || (aliasName = this.generateRowNumberProjectionForFact(environment, stitchedFact.sharedProjections, stitchedFact)) == null) continue;
                if (sqlCoalesce == null) {
                    sqlCoalesce = (SQLCoalesce)environment.getNodeFactory().createNode(301072);
                    sqlValueList = (SQLValueList)environment.getNodeFactory().createNode(301030);
                    sqlCoalesce.addChild(sqlValueList);
                }
                SQLColumn column = (SQLColumn)environment.getNodeFactory().createNode(301005);
                column.setName(aliasName);
                column.setTableName(stitchedFact.factName);
                sqlValueList.addChild(column);
            }
            if (sqlCoalesce == null) {
                return rootExpression;
            }
            if (sqlCoalesce.getChild(0).getChildren().length == 1) {
                SQLColumn column = (SQLColumn)sqlCoalesce.getChild(0).getChild(0);
                String aliasName = this.generateRowNumberProjectionForFact(environment, factToStitch.sharedProjections, factToStitch);
                boolean localIsDistinctFrom = false;
                IXQEQueryNode sqlComparison = this.buildJoinExpressionForSharedDimension(environment, localIsDistinctFrom, this.buildTwoPartsName(column.getTableName(), column.getName()), this.buildTwoPartsName(factToStitch.factName, aliasName));
                rootExpression = this.andJoinClauses(environment, rootExpression, sqlComparison);
            } else {
                String aliasName = this.generateRowNumberProjectionForFact(environment, factToStitch.sharedProjections, factToStitch);
                V5BoundSQLQueryItemReference sqlQueryItemRefRight = (V5BoundSQLQueryItemReference)environment.getNodeFactory().createNode(201103);
                sqlQueryItemRefRight.setIdentifier(this.buildTwoPartsName(factToStitch.factName, aliasName));
                SQLComparison sqlComparison = (SQLComparison)environment.getNodeFactory().createNode(301026);
                sqlComparison.setSubType(SQLComparison.SubType.EQUAL);
                sqlComparison.addChild(sqlCoalesce);
                sqlComparison.addChild(sqlQueryItemRefRight);
                rootExpression = this.andJoinClauses(environment, rootExpression, sqlComparison);
            }
        }
        return rootExpression;
    }

    private IXQEQueryNode buildJoinExpressionForSharedDimensionAcrossAllStreams(PlanningEnvironment environment, Governors.JoinOperator multiFactJoinOperator, FactInfo[] allFactStreamData, int streamToStitchPos, FactInfo factToStitch, String origColumnName) {
        IXQEQueryNode singleExp = null;
        String firstTableName = null;
        String firstColumnName = null;
        SQLCoalesce sqlCoalesce = null;
        SQLValueList sqlValueList = null;
        boolean stitchWithNulls = true;
        if (multiFactJoinOperator == Governors.JoinOperator.EQUAL) {
            stitchWithNulls = false;
        }
        for (int i = streamToStitchPos - 1; i >= 0; --i) {
            FactInfo stitchedFact = allFactStreamData[i];
            if (!this.isMatchingProjection(factToStitch, stitchedFact, origColumnName)) continue;
            if (multiFactJoinOperator == Governors.JoinOperator.EQUAL_ALL_NOTNULL) {
                ProjectionInfo pi = this.getMatchingProjection(factToStitch, origColumnName);
                stitchWithNulls = pi.isNullable;
            }
            stitchedFact.sharedProjections.add(this.getMatchingAlias(stitchedFact, origColumnName));
            if (factToStitch.sharedProjections.contains(this.getMatchingAlias(factToStitch, origColumnName))) {
                SQLColumn column;
                if (sqlCoalesce == null) {
                    sqlCoalesce = (SQLCoalesce)environment.getNodeFactory().createNode(301072);
                    sqlValueList = (SQLValueList)environment.getNodeFactory().createNode(301030);
                    sqlCoalesce.addChild(sqlValueList);
                    column = (SQLColumn)environment.getNodeFactory().createNode(301005);
                    column.setName(firstColumnName);
                    column.setTableName(firstTableName);
                    sqlValueList.addChild(column);
                }
                column = (SQLColumn)environment.getNodeFactory().createNode(301005);
                column.setName(this.getMatchingAlias(stitchedFact, origColumnName));
                column.setTableName(stitchedFact.factName);
                sqlValueList.addChild(column);
                continue;
            }
            factToStitch.sharedProjections.add(this.getMatchingAlias(factToStitch, origColumnName));
            singleExp = this.buildJoinExpressionForSharedDimension(environment, stitchWithNulls, this.buildTwoPartsName(stitchedFact.factName, this.getMatchingAlias(stitchedFact, origColumnName)), this.buildTwoPartsName(factToStitch.factName, this.getMatchingAlias(factToStitch, origColumnName)));
            firstTableName = stitchedFact.factName;
            firstColumnName = this.getMatchingAlias(stitchedFact, origColumnName);
        }
        if (sqlCoalesce != null) {
            SQLAbstractBooleanFunction sqlComparisonNode;
            V5BoundSQLQueryItemReference sqlQueryItemRefRight = (V5BoundSQLQueryItemReference)environment.getNodeFactory().createNode(201103);
            sqlQueryItemRefRight.setIdentifier(this.buildTwoPartsName(factToStitch.factName, this.getMatchingAlias(factToStitch, origColumnName)));
            if (stitchWithNulls) {
                SQLIsDistinctFrom isNotDistinctFrom = (SQLIsDistinctFrom)environment.getNodeFactory().createNode(301075);
                isNotDistinctFrom.setNegated(true);
                sqlComparisonNode = isNotDistinctFrom;
            } else {
                SQLComparison sqlNode = (SQLComparison)environment.getNodeFactory().createNode(301026);
                sqlNode.setSubType(SQLComparison.SubType.EQUAL);
                sqlComparisonNode = sqlNode;
            }
            sqlComparisonNode.addChild(sqlCoalesce);
            sqlComparisonNode.addChild(sqlQueryItemRefRight);
            return sqlComparisonNode;
        }
        return singleExp;
    }

    private IXQEQueryNode buildJoinExpressionForSharedDimension(PlanningEnvironment environment, boolean stitchWithNulls, String left, String right) {
        SQLAbstractBooleanFunction sqlComparisonNode;
        if (stitchWithNulls) {
            SQLIsDistinctFrom isNotDistinctFrom = (SQLIsDistinctFrom)environment.getNodeFactory().createNode(301075);
            isNotDistinctFrom.setNegated(true);
            sqlComparisonNode = isNotDistinctFrom;
        } else {
            SQLComparison sqlNode = (SQLComparison)environment.getNodeFactory().createNode(301026);
            sqlNode.setSubType(SQLComparison.SubType.EQUAL);
            sqlComparisonNode = sqlNode;
        }
        V5BoundSQLQueryItemReference sqlQueryItemRefLeft = (V5BoundSQLQueryItemReference)environment.getNodeFactory().createNode(201103);
        sqlQueryItemRefLeft.setIdentifier(left);
        V5BoundSQLQueryItemReference sqlQueryItemRefRight = (V5BoundSQLQueryItemReference)environment.getNodeFactory().createNode(201103);
        sqlQueryItemRefRight.setIdentifier(right);
        sqlComparisonNode.addChild(sqlQueryItemRefLeft);
        sqlComparisonNode.addChild(sqlQueryItemRefRight);
        return sqlComparisonNode;
    }

    private IXQEQueryNode andJoinClauses(PlanningEnvironment environment, IXQEQueryNode rootExpression, IXQEQueryNode newExpression) {
        if (rootExpression != null) {
            SQLLogical logicalAndNode = (SQLLogical)environment.getNodeFactory().createNode(301027);
            logicalAndNode.setSubType(SQLLogical.SubType.AND);
            logicalAndNode.addChild(rootExpression);
            logicalAndNode.addChild(newExpression);
            return logicalAndNode;
        }
        return newExpression;
    }

    private Set<String> getJoinedSubqueryNames(IXQEQueryNode rqpJoinPath) {
        IXQEQueryNode[] dataItemRefs;
        HashSet<String> names = new HashSet<String>();
        for (IXQEQueryNode dataItemRef : dataItemRefs = rqpJoinPath.getDescendantsOfType(801009, false)) {
            RQPDataItemRef di = (RQPDataItemRef)dataItemRef;
            names.add(di.getQueryName());
        }
        return names;
    }

    static class FactInfo {
        String factName = null;
        String innerQueryName = null;
        List<IXQEQueryNode> rsumProjections = null;
        List<ProjectionInfo> projectionItems = null;
        HashMap<String, String> origColumnNameToAlias = new HashMap();
        Set<String> allProjections = null;
        Set<String> sharedProjections = null;
        int stitchedColumnNumber = 1;
        IXQEQueryNode sqlRangeVar;

        FactInfo() {
            this.projectionItems = new ArrayList<ProjectionInfo>();
            this.rsumProjections = new ArrayList<IXQEQueryNode>();
            this.allProjections = new LinkedHashSet<String>();
            this.sharedProjections = new LinkedHashSet<String>();
        }
    }

    static class ProjectionInfo {
        String aliasName = null;
        String origColumnName = null;
        Set<String> dimensionNames = new HashSet<String>();
        boolean isNullable = false;

        ProjectionInfo() {
        }

        public boolean equals(Object pi) {
            if (!(pi instanceof ProjectionInfo)) {
                return false;
            }
            return this.origColumnName.equals(((ProjectionInfo)pi).origColumnName) && ItemNormalization.namesEquals(this.dimensionNames, ((ProjectionInfo)pi).dimensionNames);
        }

        public int hashCode() {
            return this.origColumnName.hashCode();
        }
    }
}

