/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RMSqlCalcFilter;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSubqueryList;
import com.cognos.xqe.ast.rqp.RQPTNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.utils.SimpleSaxParser;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IDbDimension;
import com.cognos.xqe.metadata.IFolder;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemFolder;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.dynamic.DMRelationship;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.binding.BindV5MultiPartIdentifierToModel;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ApplyJoinFilterOptimization;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.OData.ODataUtilities;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.itemNormalization.ItemNormalization;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathSelector;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RepositoryInfoFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.IUndirectedGraph;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.UndirectedGraph;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Element;

public class BuildJoinPlan
extends RQPTransformation {
    private static boolean sgOpt05 = false;
    private static final String PROJECT_PRIMARY_QSS = "projectedPrimaryQSs";
    private static final String PROJECT_SECONDARY_QSS = "projectedSecondaryQSs";
    public static final String PROP_REBUILD_FOR_DYNAMICSQS = "rebuildForDynamicSQS";

    public BuildJoinPlan() {
        this.mName = "Build Join Plan";
        this.mPassNumbers = new int[]{78, 99, 114};
        this.mTypes = new int[]{801025, 801027, 801029};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        sgOpt05 = config.getBooleanProperty("general.joinpath[@opt05]", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        try (MetadataConnectionContext metadataConnectionContext = null;){
            RQPFactManager factManager;
            FactFinder ff;
            ResponseMessage msg;
            V5Query v5query;
            MetadataConnection mc = null;
            if (environment.isMultiModelForQueryEnabled() && (v5query = RQPNode.getV5Query(node)) != null) {
                metadataConnectionContext = environment.pushMetadataConnectionContext(v5query.getMetadataPath());
                mc = metadataConnectionContext.getMetadataConnection();
            }
            if (metadataConnectionContext == null) {
                mc = environment.getMetadataConnection();
            }
            List<List<IMetadata>> allJoinPaths = null;
            List<IMetadata> joinPath = null;
            List<IMetadata> joinPathFromAlphabeticalFirstFact = null;
            RQPQuery parentRqpQuery = null;
            RQPFactManager parentFactManager = null;
            HashSet<IRelationship> requiredDummyJoinForItemNorm = new HashSet<IRelationship>();
            if (node.getType() == 801025 && node.getPropertyValue(PROP_REBUILD_FOR_DYNAMICSQS) == null && (parentFactManager = (parentRqpQuery = RQPNode.getRQPQuery(node)).getFactManager()) != null) {
                allJoinPaths = (List)parentFactManager.getPropertyValue("computedSingleFactJoinPaths");
            }
            HashMap<String, Set<IMetadata>> primarySecodanyQS = new HashMap<String, Set<IMetadata>>();
            if (allJoinPaths == null) {
                MoserQuerySubject moduleQS;
                List<IRelationship> jns;
                IQuerySubject qs;
                RQPQuery qq;
                RQPQuery tmpRQPQuery;
                String nameOfRMQuery;
                Set<IQuerySubject> qsSetInV5Query;
                V5Query v5Query;
                RMQueryList rmQueryList = RQPUtilities.getRMQueryList(node);
                List<IXQEQueryNode> v5BoundIdentifiers = node.getDescendantsOfTypeOrdered(201116, 801017);
                if (this.isRMQueryForMiniQS(node)) {
                    ArrayList<IXQEQueryNode> allV5BoundIdentifiers = new ArrayList<IXQEQueryNode>();
                    this.incrementRefCountOfItemsReferencedInEmbeddedFilters((RMQuery)node, v5BoundIdentifiers);
                    for (IXQEQueryNode c : node.getChildren()) {
                        this.getBoundModelIdentifierSkipUnreferencedQueryItem(c, allV5BoundIdentifiers);
                    }
                    v5BoundIdentifiers = allV5BoundIdentifiers;
                }
                RQPQuery rqpQuery = (RQPQuery)rmQueryList.getParent();
                List filters = (List)rqpQuery.getPropertyValue("filterOnUnProjectedItem");
                if (node.getType() == 801025 && null != filters) {
                    for (IXQEQueryNode filter : filters) {
                        V5BoundModelIdentifier v5Id = (V5BoundModelIdentifier)filter.getDescendantsOfType(201116, false)[0];
                        v5BoundIdentifiers.add(v5Id);
                    }
                }
                ArrayList<IMetadata> querySubjectsInQuery = new ArrayList<IMetadata>();
                if (node.getType() == 801025 && (v5Query = RQPNode.getV5Query(node)) != null && (qsSetInV5Query = v5Query.getQSToJoin()) != null && !qsSetInV5Query.isEmpty()) {
                    querySubjectsInQuery.addAll(qsSetInV5Query);
                    qsSetInV5Query.clear();
                }
                for (IXQEQueryNode q : v5BoundIdentifiers) {
                    Set<IMetadata> st;
                    RMQuery rmQuery;
                    V5BoundModelIdentifier v5Identifier = (V5BoundModelIdentifier)q;
                    IQuerySubject querySubject = v5Identifier.getQuerySubject();
                    if (querySubject == null || (rmQuery = rmQueryList.getRMQuery(v5Identifier)) == node) continue;
                    this.addQuerySubject(querySubjectsInQuery, querySubject);
                    String key = PROJECT_PRIMARY_QSS;
                    RQPDataItem item = (RQPDataItem)v5Identifier.getAncestorOfType(801008);
                    if (item != null && item.getPropertyValue("lookup") == Boolean.TRUE) {
                        key = PROJECT_SECONDARY_QSS;
                    }
                    if ((st = primarySecodanyQS.get(key)) == null) {
                        st = new HashSet<IMetadata>();
                        primarySecodanyQS.put(key, st);
                    }
                    st.add(querySubject);
                }
                if (node.getType() == 801027) {
                    IMetadata target;
                    IAccessedViaShortcut accessViaSCObj;
                    IQuerySubject qs2 = ((RMQuery)node).getQuerySubject();
                    RQPFactManager factManager2 = RQPUtilities.getRQPFactManager(node);
                    RMSqlCalcFilter rmSqlCalcFilter = (RMSqlCalcFilter)node;
                    if ((null == node.getPropertyValue("isAlias") || factManager2 != null && factManager2.isInvolvedInFactStream(rmSqlCalcFilter.getName())) && qs2 instanceof IAccessedViaShortcut && (accessViaSCObj = (IAccessedViaShortcut)((Object)qs2)).isAccessedViaShortcut() && (target = mc.bindMetadataReference(qs2.getV5UniqueName())) instanceof IQuerySubject) {
                        qs2 = (IQuerySubject)target;
                    }
                    this.addQuerySubject(querySubjectsInQuery, qs2);
                }
                if (querySubjectsInQuery.size() == 1) {
                    this.joinPlanHasBeenComputed(node);
                    return;
                }
                if (node.getType() == 801017 && (nameOfRMQuery = (String)(tmpRQPQuery = (RQPQuery)node).getPropertyValue("QSNAME")) != null) {
                    RQPSubqueryList subqueryList = (RQPSubqueryList)tmpRQPQuery.getSubqueryList();
                    for (int idx = 0; idx < subqueryList.getNumberChildren(); ++idx) {
                        RQPQuery subquery = (RQPQuery)subqueryList.getChild(idx);
                        String nameOfRefRMQuery = (String)subquery.getPropertyValue("QSNAME");
                        RMQuery rmQuery = rmQueryList.getRMQuery(nameOfRefRMQuery);
                        if (rmQuery == null) continue;
                        this.addQuerySubject(querySubjectsInQuery, rmQuery.getQuerySubject());
                    }
                }
                joinPathFromAlphabeticalFirstFact = this.getJoinsFromAlphabeticalFirstFact(environment, node, querySubjectsInQuery);
                joinPath = joinPathFromAlphabeticalFirstFact;
                Set<IMetadata> preferredQS = null;
                List<IMetadata> allJoinsComputedInPrePlan = null;
                List<IMetadata> joinsForFactStream = null;
                List<IMetadata> preferredJoins = null;
                if (node.getType() == 801025) {
                    if (rqpQuery.isFactQuery() || parentFactManager != null && parentFactManager.getItemNormalization()) {
                        joinsForFactStream = rqpQuery.getJoinsForFactStream();
                        ItemNormalization.recordMoserRelationshipWrapper(requiredDummyJoinForItemNorm, joinsForFactStream);
                    }
                    if ((preferredQS = BuildJoinPlan.getPreferredQuerySubjects(rqpQuery, environment)) != null) {
                        rqpQuery.setJoinSelectionIsContextSensitive(false);
                    } else if (rqpQuery.getParent().getType() == 801022) {
                        qq = (RQPQuery)rqpQuery.getParent().getParent();
                        allJoinsComputedInPrePlan = qq.getAllJoinsForOuterMostQuery();
                    } else {
                        allJoinsComputedInPrePlan = rqpQuery.getAllJoinsForOuterMostQuery();
                    }
                    V5Query query = rqpQuery.getRefV5Query();
                    if (query != null) {
                        preferredJoins = query.getPreferredJoins();
                    }
                } else if (node.getType() == 801017) {
                    qq = (RQPQuery)node;
                    allJoinsComputedInPrePlan = qq.getAllJoinsForOuterMostQuery();
                } else if (node.getType() == 801029 && (qs = ((RMQuery)node).getQuerySubject()) instanceof MoserQuerySubject && (jns = (moduleQS = (MoserQuerySubject)qs).getPreferredJoins()) != null && !jns.isEmpty()) {
                    preferredJoins = new ArrayList<IRelationship>(jns);
                    preferredJoins.addAll(moduleQS.getRelationshipsParentModule());
                }
                if (joinPath == null || allJoinsComputedInPrePlan != null || joinsForFactStream != null) {
                    RepositoryInfoFinder reposInfoFinder = new RepositoryInfoFinder(mc, node.getGovernors());
                    List<IMetadata> querySubjects = reposInfoFinder.getEntities();
                    List<IMetadata> joins = reposInfoFinder.getJoins();
                    if (preferredJoins != null && !preferredJoins.isEmpty()) {
                        if (querySubjectsInQuery.size() <= 1) {
                            this.joinPlanHasBeenComputed(node);
                            return;
                        }
                    } else if (querySubjects == null || joins == null || querySubjects.isEmpty() || joins.isEmpty()) {
                        RQPJoinPathFinder.checkCrossProdAllowed(querySubjectsInQuery, node.getGovernors(), environment);
                        this.joinPlanHasBeenComputed(node);
                        return;
                    }
                    List<IMetadata> joinsToBeUsedInNewGraph = null;
                    if (joinsForFactStream != null) {
                        joinsToBeUsedInNewGraph = joinsForFactStream;
                    } else if (allJoinsComputedInPrePlan != null) {
                        joinsToBeUsedInNewGraph = allJoinsComputedInPrePlan;
                    } else if (preferredJoins != null && !preferredJoins.isEmpty()) {
                        joinsToBeUsedInNewGraph = preferredJoins;
                    }
                    if (joinsToBeUsedInNewGraph != null) {
                        HashMap<String, IMetadata> idToJoin = new HashMap<String, IMetadata>();
                        IUndirectedGraph graph = RQPUtilities.buildGraph(environment, joinsToBeUsedInNewGraph, idToJoin, querySubjectsInQuery);
                        RQPJoinPathFinder joinPathFinder = new RQPJoinPathFinder(graph, idToJoin, querySubjectsInQuery, node.getGovernors(), environment);
                        allJoinPaths = joinPathFinder.getAllJoinPaths();
                    } else {
                        if (preferredQS != null && BuildJoinPlan.isPreferredModelIdHintPassed(rqpQuery)) {
                            preferredQS.addAll(querySubjectsInQuery);
                        }
                        RQPJoinPathFinder joinPathFinder = new RQPJoinPathFinder(querySubjectsInQuery, preferredQS, node.getGovernors(), environment);
                        allJoinPaths = joinPathFinder.getAllJoinPaths();
                    }
                    if (allJoinPaths == null || allJoinPaths.isEmpty()) {
                        this.joinPlanHasBeenComputed(node);
                        return;
                    }
                }
            }
            if (allJoinPaths != null) {
                if (allJoinPaths.size() == 1) {
                    joinPath = (List)allJoinPaths.get(0);
                } else {
                    boolean validationAtInfoLevel;
                    RQPJoinPathSelector joinSelector = new RQPJoinPathSelector();
                    joinPath = joinSelector.selectBestJoinPath(allJoinPaths);
                    RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
                    boolean bl = validationAtInfoLevel = "validate".equals(reqEnv.getOperationName()) && reqEnv.getMaxSeverityLevel() == 3;
                    if (validationAtInfoLevel) {
                        ResponseMessage msg2;
                        String name = null;
                        if (node instanceof RMQuery) {
                            RMQuery rmQuery = (RMQuery)node;
                            name = rmQuery.getName();
                        }
                        if ((msg2 = joinSelector.getRankedJoinPathWarning(name)) != null) {
                            environment.getResponseMessageFolder().appendPlanningResponseMessage(msg2);
                        }
                    }
                }
            }
            if (joinPath == null || joinPath.isEmpty()) {
                this.joinPlanHasBeenComputed(node);
                return;
            }
            if (joinPath.equals(joinPathFromAlphabeticalFirstFact) && (msg = (ff = (factManager = ((RQPNode)node).getRootRQPQuery().getFactManager()).getFactFinder()).getAlphaFirstFactRetainedMessage()) != null) {
                environment.getResponseMessageFolder().appendPlanningResponseMessage(msg);
            }
            ArrayList<IMetadata> joinPathWithDummyJoins = new ArrayList<IMetadata>();
            joinPathWithDummyJoins.addAll(joinPath);
            Iterator<IMetadata> jnIter = joinPath.iterator();
            while (jnIter.hasNext()) {
                IRelationship join = (IRelationship)jnIter.next();
                if (!join.isDummy()) continue;
                jnIter.remove();
            }
            RQPJoinPath rqpJoinPath = (RQPJoinPath)nodeFactory.createNode(801039);
            rqpJoinPath.setJoinPath(joinPath);
            rqpJoinPath.setJoinPathWithDummyJoins(joinPathWithDummyJoins);
            node.addChild(rqpJoinPath);
            if (!this.createJoinPathForPrimarySecondary(environment, rqpJoinPath, joinPath, primarySecodanyQS)) {
                for (int i = 0; i < joinPath.size(); ++i) {
                    IRelationship currentRelationship = (IRelationship)joinPath.get(i);
                    boolean b = this.createJoin(currentRelationship, environment, rqpJoinPath, node, i, joinPath);
                    if (!b || !requiredDummyJoinForItemNorm.contains(currentRelationship)) continue;
                    ItemNormalization.markRMQueryListWithMoserQuerySubjectWrapper(parentRqpQuery, currentRelationship);
                }
            }
            this.joinPlanHasBeenComputed(node);
        }
    }

    private void incrementRefCountOfItemsReferencedInEmbeddedFilters(RMQuery rmQuery, List<IXQEQueryNode> v5BoundIdentifiers) {
        for (IXQEQueryNode boundID : v5BoundIdentifiers) {
            RMQueryItem qi;
            if (boundID.getAncestorOfType(801035) == null || (qi = rmQuery.getRMQueryItem((V5BoundModelIdentifier)boundID)) == null) continue;
            qi.incrementCount();
        }
    }

    protected boolean createJoin(IRelationship currentRelationship, PlanningEnvironment environment, RQPJoinPath rqpJoinPath, IXQEQueryNode node, int i, List<IMetadata> joinPath) {
        IXQEQueryNode enode = RQPUtilities.createV5ValueExpression(currentRelationship, environment, (IXQEQueryNode)rqpJoinPath);
        if (enode == null) {
            return false;
        }
        if (node instanceof RMQuery && node.getPropertyValue("isAlias") != null) {
            RMQuery aliasRMQuery = (RMQuery)node;
            RQPUtilities.updateModelIDsToReferenceCurrentAlias(aliasRMQuery, enode);
            IQuerySubject aliasTargetQS = aliasRMQuery.getQuerySubject();
            IMetadata leftSide = currentRelationship.getLeftRefObject();
            boolean relationInvolvesCurrentAliasTarget = true;
            IMetadata rightSide = currentRelationship.getRightRefObject();
            if (leftSide.getID().equals(aliasTargetQS.getID())) {
                leftSide = ((IAccessedViaShortcut)((Object)aliasTargetQS)).getShortcut();
            } else if (rightSide.getID().equals(aliasTargetQS.getID())) {
                rightSide = ((IAccessedViaShortcut)((Object)aliasTargetQS)).getShortcut();
            } else {
                relationInvolvesCurrentAliasTarget = false;
            }
            if (relationInvolvesCurrentAliasTarget) {
                Enum<IRelationship.Cardinality> leftCard = currentRelationship.getLeftCardinality();
                Enum<IRelationship.Cardinality> rightCard = currentRelationship.getRightCardinality();
                String relationshipName = leftSide.getV5UniqueName() + " <---> " + rightSide.getV5UniqueName();
                DMRelationship newRelationshipWithAliasShortcut = new DMRelationship(relationshipName, leftSide, rightSide, IRelationship.Cardinality.getMinCard(leftCard), IRelationship.Cardinality.getMaxCard(leftCard), IRelationship.Cardinality.getMinCard(rightCard), IRelationship.Cardinality.getMaxCard(rightCard));
                joinPath.set(i, newRelationshipWithAliasShortcut);
                currentRelationship = newRelationshipWithAliasShortcut;
            }
        }
        rqpJoinPath.addChild(enode);
        enode.setPropertyValue("parsedJoinExpression", currentRelationship);
        IRelationship.JoinFilterType fjoType = ApplyJoinFilterOptimization.getJoinFilterType(environment, currentRelationship);
        if (fjoType != IRelationship.JoinFilterType.FILTER_TYPE_NONE && fjoType != IRelationship.JoinFilterType.FILTER_TYPE_FLEXIBLE) {
            ApplyJoinFilterOptimization.markJoinKeysForFilterJoinOptimization(environment, currentRelationship, enode);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean createJoinPathForPrimarySecondary(PlanningEnvironment environment, RQPJoinPath rqpJoinPath, List<IMetadata> joinPath, HashMap<String, Set<IMetadata>> primarySecodanyQS) {
        void var18_25;
        IXQEQueryNode[] identifiers;
        if (primarySecodanyQS.size() != 2) {
            return false;
        }
        Set<IMetadata> primaryQSs = primarySecodanyQS.get(PROJECT_PRIMARY_QSS);
        Set<IMetadata> secondaryQSs = primarySecodanyQS.get(PROJECT_SECONDARY_QSS);
        IXQEQueryNode[] unprojectedFactQS = null;
        IRelationship joinToPrimary = null;
        IXQEQueryNode[] primaryQS = null;
        HashMap<IRelationship, IXQEQueryNode[]> joinsToSecondary = new HashMap<IRelationship, IXQEQueryNode[]>();
        ArrayList<IMetadata> newJoinPath = new ArrayList<IMetadata>();
        for (IMetadata q : joinPath) {
            IRelationship relationship = (IRelationship)q;
            IXQEQueryNode[] left = relationship.getLeftRefObject();
            IXQEQueryNode[] right = relationship.getRightRefObject();
            if (!primaryQSs.contains(left) && !secondaryQSs.contains(left)) {
                if (unprojectedFactQS == null) {
                    unprojectedFactQS = left;
                } else if (unprojectedFactQS != left) {
                    return false;
                }
                if (primaryQSs.contains(right)) {
                    if (joinToPrimary == null) {
                        joinToPrimary = relationship;
                        primaryQS = right;
                        continue;
                    }
                    if (joinToPrimary == relationship) continue;
                    return false;
                }
                if (secondaryQSs.contains(right)) {
                    joinsToSecondary.put(relationship, right);
                    continue;
                }
                return false;
            }
            if (!primaryQSs.contains(right) && !secondaryQSs.contains(right)) {
                if (unprojectedFactQS == null) {
                    unprojectedFactQS = right;
                } else if (unprojectedFactQS != right) {
                    return false;
                }
                if (primaryQSs.contains(left)) {
                    if (joinToPrimary == null) {
                        joinToPrimary = relationship;
                        primaryQS = left;
                        continue;
                    }
                    if (joinToPrimary == relationship) continue;
                    return false;
                }
                if (secondaryQSs.contains(left)) {
                    joinsToSecondary.put(relationship, left);
                    continue;
                }
                return false;
            }
            newJoinPath.add(relationship);
        }
        if (unprojectedFactQS == null || joinToPrimary == null || joinsToSecondary.isEmpty()) {
            return false;
        }
        HashMap<IMetadata, Pair> unprojectedToPrimaryCols = new HashMap<IMetadata, Pair>();
        IXQEQueryNode enode = RQPUtilities.createV5ValueExpression(joinToPrimary, environment, null);
        if (enode == null) {
            return false;
        }
        for (IXQEQueryNode iXQEQueryNode : identifiers = enode.getDescendantsOfType(201030, true)) {
            BindV5MultiPartIdentifierToModel.bindV5MultiPartIdentifierToModel(environment, (V5MultiPartIdentifier)iXQEQueryNode);
        }
        if (!this.getJoinedColumns(enode, unprojectedToPrimaryCols, (IMetadata)unprojectedFactQS)) {
            return false;
        }
        ArrayList<Object> toSecondaries = new ArrayList<Object>();
        ArrayList<IXQEQueryNode> joinExpressions = new ArrayList<IXQEQueryNode>();
        ArrayList secondaryQSsInJoin = new ArrayList();
        for (Map.Entry entry : joinsToSecondary.entrySet()) {
            enode = RQPUtilities.createV5ValueExpression((IRelationship)entry.getKey(), environment, null);
            if (enode == null) {
                return false;
            }
            for (IXQEQueryNode identifier : identifiers = enode.getDescendantsOfType(201030, true)) {
                BindV5MultiPartIdentifierToModel.bindV5MultiPartIdentifierToModel(environment, (V5MultiPartIdentifier)identifier);
            }
            HashMap aMap = new HashMap();
            if (!this.getJoinedColumns(enode, aMap, (IMetadata)unprojectedFactQS)) {
                return false;
            }
            if (aMap.size() != unprojectedToPrimaryCols.size() || !aMap.keySet().equals(unprojectedToPrimaryCols.keySet())) {
                return false;
            }
            toSecondaries.add(aMap);
            joinExpressions.add(enode);
            secondaryQSsInJoin.add(entry.getValue());
        }
        for (IMetadata iMetadata : newJoinPath) {
            enode = RQPUtilities.createV5ValueExpression((IRelationship)iMetadata, environment, (IXQEQueryNode)rqpJoinPath);
            if (enode == null) continue;
            rqpJoinPath.addChild(enode);
            enode.setPropertyValue("parsedJoinExpression", iMetadata);
        }
        boolean bl = false;
        while (var18_25 < toSecondaries.size()) {
            Map map = (Map)toSecondaries.get((int)var18_25);
            for (Map.Entry e : map.entrySet()) {
                Pair p = (Pair)unprojectedToPrimaryCols.get(e.getKey());
                IXQEQueryNode primaryCol = (IXQEQueryNode)p.getSecond();
                p = (Pair)e.getValue();
                IXQEQueryNode unprojCol = (IXQEQueryNode)p.getFirst();
                unprojCol.exchange(environment.getNodeFactory().deepCopyNode(primaryCol));
            }
            enode = (IXQEQueryNode)joinExpressions.get((int)var18_25);
            rqpJoinPath.addChild(enode);
            IRelationship tempJ = ODataUtilities.createArelationship((IMetadata)primaryQS, (IMetadata)secondaryQSsInJoin.get((int)var18_25), IRelationship.Cardinality.ONE_ONE, IRelationship.Cardinality.ZERO_ONE, false);
            enode.setPropertyValue("parsedJoinExpression", tempJ);
            newJoinPath.add(tempJ);
            ++var18_25;
        }
        rqpJoinPath.setJoinPath(newJoinPath);
        return true;
    }

    private boolean getJoinedColumns(IXQEQueryNode node, Map<IMetadata, Pair> unprojectedToPrimaryCols, IMetadata unprojectedFactQS) {
        if (node.getType() == 201003) {
            IXQEQueryNode[] children;
            V5LogicalExpression logical = (V5LogicalExpression)node;
            if (logical.getSubType() != 0) {
                return false;
            }
            for (IXQEQueryNode c : children = node.getChildren()) {
                if (this.getJoinedColumns(c, unprojectedToPrimaryCols, unprojectedFactQS)) continue;
                return false;
            }
            return true;
        }
        if (node.getType() == 201013) {
            V5ComparisonExpression comp = (V5ComparisonExpression)node;
            if (comp.getSubType() != 2) {
                return false;
            }
            IXQEQueryNode[] children = node.getChildren();
            if (children[0].getType() != 201116 || children[1].getType() != 201116) {
                return false;
            }
            V5BoundModelIdentifier c1 = (V5BoundModelIdentifier)children[0];
            V5BoundModelIdentifier c2 = (V5BoundModelIdentifier)children[1];
            if (c1.getQuerySubject() == unprojectedFactQS) {
                Pair p = new Pair(c1, c2);
                unprojectedToPrimaryCols.put(c1.getMetadata(), p);
            } else if (c2.getQuerySubject() == unprojectedFactQS) {
                Pair p = new Pair(c2, c1);
                unprojectedToPrimaryCols.put(c2.getMetadata(), p);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public static Set<IMetadata> getPreferredQuerySubjects(RQPQuery rqpQuery, PlanningEnvironment environment) {
        Set<IMetadata> preferredQS = BuildJoinPlan.getPreferredQSFromContextSensitiveJoinSelection(rqpQuery, environment);
        preferredQS.addAll(BuildJoinPlan.getPreferredQSFromQueryHint(rqpQuery, environment));
        if (preferredQS.isEmpty()) {
            return null;
        }
        return preferredQS;
    }

    private static Set<IMetadata> getPreferredQSFromContextSensitiveJoinSelection(RQPQuery rqpQuery, PlanningEnvironment environment) {
        Set<IMetadata> preferredQS = new HashSet<IMetadata>();
        ArrayList<IMetadata> allQuerySubjects = new ArrayList<IMetadata>();
        if (rqpQuery.getJoinSelectionIsContextSensitive() && rqpQuery.getOriginalFolders() != null) {
            Governors.ContextSensitiveJoinSelection csjs = rqpQuery.getGovernors().getContextSensitiveJoinSelection();
            Set<IMetadata> originalFolders = rqpQuery.getOriginalFolders();
            if (csjs == Governors.ContextSensitiveJoinSelection.EXPLICIT) {
                HashSet<IMetadata> originalNamespaces = new HashSet<IMetadata>();
                for (IMetadata iMetadata : originalFolders) {
                    IMetadata nameSpace = BuildJoinPlan.getNameSpace(iMetadata);
                    if (nameSpace == null) continue;
                    originalNamespaces.add(nameSpace);
                }
                boolean automatic = false;
                for (IMetadata n : originalNamespaces) {
                    BuildJoinPlan.collectAllQuerySubjectsAndShortcuts(n, allQuerySubjects, automatic);
                }
            } else {
                boolean automatic = true;
                for (IMetadata iMetadata : originalFolders) {
                    BuildJoinPlan.collectAllQuerySubjectsAndShortcuts(iMetadata, allQuerySubjects, automatic);
                }
            }
            if (!allQuerySubjects.isEmpty()) {
                ArrayList<IMetadata> allQueryItems = new ArrayList<IMetadata>();
                for (IMetadata iMetadata : allQuerySubjects) {
                    if (iMetadata instanceof IShortcut) {
                        IShortcut shortcut = (IShortcut)iMetadata;
                        IMetadata qs = shortcut.getTarget();
                        BuildJoinPlan.collectAllQueryItems(qs, allQueryItems);
                        continue;
                    }
                    BuildJoinPlan.collectAllQueryItems(iMetadata, allQueryItems);
                }
                boolean enabledPreferredModelItemsHint = true;
                preferredQS = enabledPreferredModelItemsHint ? BuildJoinPlan.unwindQueryItemsToLowestQuerySubjects(environment, rqpQuery, allQueryItems, enabledPreferredModelItemsHint) : new HashSet();
                preferredQS.addAll(allQuerySubjects);
            }
        }
        return preferredQS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<IMetadata> getPreferredQSFromQueryHint(RQPQuery rqpQuery, PlanningEnvironment environment) {
        List preferredModelItems;
        HashSet<IMetadata> preferredQS = new HashSet<IMetadata>();
        V5Query v5Query = (V5Query)rqpQuery.getRootRQPQuery().getPropertyValue("v5ref");
        if (v5Query != null && (preferredModelItems = (List)v5Query.getPropertyValue("preferredModelItems")) != null && !preferredModelItems.isEmpty()) {
            rqpQuery.setUnwindContext(RQPNode.UNWINDCONTEXT_PREFERREDQS);
            try {
                for (String preferredItem : preferredModelItems) {
                    preferredQS.addAll(RQPUtilities.getUnwoundQSInExpression(environment, preferredItem, rqpQuery));
                }
            }
            finally {
                rqpQuery.clearUnwindContext();
            }
        }
        return preferredQS;
    }

    private static IMetadata getNameSpace(IMetadata folder) {
        if (folder == null || folder instanceof INamespace) {
            return folder;
        }
        return BuildJoinPlan.getNameSpace(folder.getParentObject());
    }

    private void addQuerySubject(List<IMetadata> querySubjectsInQuery, IMetadata querySubject) {
        for (IMetadata qs : querySubjectsInQuery) {
            if (qs != querySubject) continue;
            return;
        }
        querySubjectsInQuery.add(querySubject);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundModelIdentifier v5Identifier;
        IXQEQueryNode[] v5Identifiers;
        XQETrace xqeTrace = environment.getTrace();
        if (node instanceof RQPQuery) {
            RQPQuery rqpQuery = (RQPQuery)node;
            if (rqpQuery.getComputedJoinPlan()) {
                this.traceNodeCondition(false, "The joinPlan has been computed for the RQPTabularQuery", xqeTrace);
                return false;
            }
        } else {
            RMQuery rmQuery = (RMQuery)node;
            if (rmQuery.getComputedJoinPlan()) {
                this.traceNodeCondition(false, "The joinPlan has been computed for the RMQuery", xqeTrace);
                return false;
            }
        }
        if ((v5Identifiers = node.getDescendantsOfType(201030, false, 801017)).length > 0) {
            this.traceNodeCondition(false, "Some V5MultiPartIdentifier are not bound yet.", xqeTrace);
            return false;
        }
        IXQEQueryNode[] v5BoundIdentifiers = node.getDescendantsOfType(201116, false, 801017);
        if (v5BoundIdentifiers.length == 0) {
            this.traceNodeCondition(false, "No V5BoundModelIdentifier to process.", xqeTrace);
            return false;
        }
        for (IXQEQueryNode q : v5BoundIdentifiers) {
            v5Identifier = (V5BoundModelIdentifier)q;
            if (v5Identifier.isUnwound()) continue;
            this.traceNodeCondition(false, "Still need to unwind some V5BoundModelIdentifiers.", xqeTrace);
            return false;
        }
        if (this.isRMQueryForMiniQS(node)) {
            if (this.needDefer((RMQuery)node)) {
                this.traceNodeCondition(false, "Still need to bind some V5MultiPartIdentifier.", xqeTrace);
                return false;
            }
            ArrayList<IXQEQueryNode> allV5BoundIdentifiers = new ArrayList<IXQEQueryNode>();
            IXQEQueryNode[] iXQEQueryNodeArray = node.getChildren();
            int n = iXQEQueryNodeArray.length;
            for (int q = 0; q < n; ++q) {
                IXQEQueryNode c = iXQEQueryNodeArray[q];
                this.getBoundModelIdentifierSkipUnreferencedQueryItem(c, allV5BoundIdentifiers);
            }
            v5BoundIdentifiers = allV5BoundIdentifiers.toArray(new IXQEQueryNode[0]);
        }
        for (IXQEQueryNode q : v5BoundIdentifiers) {
            v5Identifier = (V5BoundModelIdentifier)q;
            IQuerySubject querySubject = v5Identifier.getQuerySubject();
            if (querySubject == null || !(querySubject instanceof IQuerySubject) && !(querySubject instanceof IDbDimension)) continue;
            this.traceNodeCondition(true, "Compute the joinPlan", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "No querySubject to connect.", xqeTrace);
        return false;
    }

    protected boolean needDefer(RMQuery rmQuery) {
        IXQEQueryNode[] joinPaths;
        RQPQuery rqpQuery = rmQuery.getRootRQPQuery();
        if (rqpQuery == null) {
            return false;
        }
        for (IXQEQueryNode j : joinPaths = rqpQuery.getDescendantsOfType(801039, false)) {
            IXQEQueryNode[] v5Bound;
            if (j.isAncestor(rmQuery)) continue;
            IXQEQueryNode[] v5Multi = j.getDescendantsOfType(201030, false);
            if (v5Multi.length > 0) {
                return true;
            }
            for (IXQEQueryNode bnd : v5Bound = j.getDescendantsOfType(201116, false)) {
                Boolean b = (Boolean)bnd.getPropertyValue("buildMD");
                if (Boolean.TRUE.equals(b)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isRMQueryForMiniQS(IXQEQueryNode node) {
        if (node instanceof RQPQuery) {
            return false;
        }
        RMQuery rmQuery = (RMQuery)node;
        IQuerySubject qs = rmQuery.getQuerySubject();
        if (qs == null) {
            return false;
        }
        IQuerySubject.SelectListControl selectControl = qs.getSelectListControl();
        return IQuerySubject.SelectListControl.USEDQUERYITEMS == selectControl;
    }

    protected void getBoundModelIdentifierSkipUnreferencedQueryItem(IXQEQueryNode node, List<IXQEQueryNode> allV5BoundIdentifiers) {
        RMQueryItem rmQI;
        int type = node.getType();
        if (801017 == type) {
            return;
        }
        if (201116 == type) {
            allV5BoundIdentifiers.add(node);
            return;
        }
        if (801033 == type && (rmQI = (RMQueryItem)node).getCount() == 0) {
            return;
        }
        for (IXQEQueryNode c : node.getChildren()) {
            this.getBoundModelIdentifierSkipUnreferencedQueryItem(c, allV5BoundIdentifiers);
        }
    }

    private void joinPlanHasBeenComputed(IXQEQueryNode node) {
        if (node instanceof RQPQuery) {
            RQPQuery rqpQuery = (RQPQuery)node;
            rqpQuery.setComputedJoinPlan(true);
        } else {
            RMQuery rmQuery = (RMQuery)node;
            rmQuery.setComputedJoinPlan(true);
        }
    }

    private List<IMetadata> getJoinsFromAlphabeticalFirstFact(PlanningEnvironment environment, IXQEQueryNode node, List<IMetadata> entitiesToJoin) {
        RQPFactManager factManager = ((RQPNode)node).getRootRQPQuery().getFactManager();
        FactFinder ff = factManager.getFactFinder();
        if (ff == null || !ff.getIsFirstFactRetained()) {
            return null;
        }
        RQPTNode inputNode = factManager.getInputNode();
        HashSet<String> namesOfEntsToJoinInFactFinder = new HashSet<String>();
        for (IXQEQueryNode child : inputNode.getChildren()) {
            String entName = ((RQPTNode)child).getTarget();
            if (entName == null) {
                entName = ((RQPNode)child).getName();
            }
            namesOfEntsToJoinInFactFinder.add(entName);
        }
        HashSet<String> nameOfEntsToJoin = new HashSet<String>();
        for (IMetadata ent : entitiesToJoin) {
            nameOfEntsToJoin.add(ent.getV5UniqueName());
        }
        List<IMetadata> joins = null;
        HashSet setIntersection = new HashSet(nameOfEntsToJoin);
        setIntersection.retainAll(namesOfEntsToJoinInFactFinder);
        if (nameOfEntsToJoin.size() == namesOfEntsToJoinInFactFinder.size() && setIntersection.size() == nameOfEntsToJoin.size()) {
            boolean opt05;
            TreeSet<IMetadata> joinSet = new TreeSet<IMetadata>();
            ff.getJoins(ff.getAlphabeticalFirstFact(), joinSet);
            joins = new ArrayList<IMetadata>(joinSet);
            HashMap<String, IMetadata> idToJoin = new HashMap<String, IMetadata>();
            UndirectedGraph graph = (UndirectedGraph)RQPUtilities.buildGraph(environment, joins, idToJoin, entitiesToJoin);
            boolean bl = opt05 = !sgOpt05;
            if (opt05) {
                graph.getAllShortestPathTrees3LikeClassic();
            }
            Governors governors = node.getGovernors();
            RQPJoinPathFinder joinPathFinder = new RQPJoinPathFinder(graph, idToJoin, entitiesToJoin, governors, environment);
            List<List<IMetadata>> allJoinPaths = joinPathFinder.getAllJoinPaths();
            RQPJoinPathSelector joinSelector = new RQPJoinPathSelector();
            joinSelector.doNotRankBasedOnNumberOfFact();
            joins = joinSelector.selectBestJoinPath(allJoinPaths);
        }
        return joins;
    }

    private static void collectAllQuerySubjectsAndShortcuts(IMetadata folder, List<IMetadata> allQuerySubjects, boolean automatic) {
        List<IMetadata> children = folder.getChildMetadataObjects();
        for (IMetadata child : children) {
            if (child instanceof IFolder || child instanceof INamespace) {
                BuildJoinPlan.collectAllQuerySubjectsAndShortcuts(child, allQuerySubjects, automatic);
                continue;
            }
            if (child instanceof IQuerySubject) {
                if (automatic) {
                    allQuerySubjects.add(child);
                    continue;
                }
                IQuerySubject querySubject = (IQuerySubject)child;
                if (!querySubject.getUseInJoinPath()) continue;
                allQuerySubjects.add(child);
                continue;
            }
            if (!(child instanceof IShortcut)) continue;
            if (automatic) {
                allQuerySubjects.add(child);
                continue;
            }
            IShortcut shortcut = (IShortcut)child;
            if (!shortcut.getUseInJoinPath()) continue;
            allQuerySubjects.add(child);
        }
    }

    private static void collectAllQueryItems(IMetadata parent, List<IMetadata> allQueryItems) {
        List<IMetadata> children = parent.getChildMetadataObjects();
        for (IMetadata child : children) {
            if (child instanceof IQueryItemFolder) {
                BuildJoinPlan.collectAllQueryItems(child, allQueryItems);
                continue;
            }
            if (!(child instanceof IQueryItem)) continue;
            allQueryItems.add(child);
        }
    }

    private static Set<IMetadata> unwindQueryItemsToLowestQuerySubjects(PlanningEnvironment environment, RQPQuery rootQuery, List<IMetadata> passedInQueryItems, boolean allVisited) {
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = reqEnv.getRequestParameters();
        HashSet<String> originalParameters = new HashSet<String>();
        int originalSize = parameters.size();
        for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            originalParameters.add(key);
        }
        HashSet<IMetadata> querySubjects = new HashSet<IMetadata>();
        HashSet<IMetadata> visitedQuerySubjects = new HashSet<IMetadata>();
        for (IMetadata iMetadata : passedInQueryItems) {
            LoopDetectionChain ldc = new LoopDetectionChain();
            BuildJoinPlan.unwindQueryItem(iMetadata, environment, ldc, visitedQuerySubjects, querySubjects);
        }
        block2: while (parameters.size() > originalSize) {
            for (Map.Entry entry : parameters.entrySet()) {
                if (originalParameters.contains(entry.getKey())) continue;
                parameters.remove(entry.getKey());
                continue block2;
            }
        }
        if (allVisited) {
            return visitedQuerySubjects;
        }
        return querySubjects;
    }

    private static void unwindQueryItem(IMetadata metadata, PlanningEnvironment environment, LoopDetectionChain ldc, Set<IMetadata> visitedQuerySubjects, Set<IMetadata> querySubjects) {
        if (metadata.getObjectType() == MetadataType.QUERY_ITEM) {
            if (!ldc.push(metadata.getV5UniqueName())) {
                return;
            }
            IQueryItem qi = (IQueryItem)metadata;
            visitedQuerySubjects.add(qi.getQuerySubject());
            if (qi.getExpression() != null) {
                BuildJoinPlan.unwindExpression(qi.getExpression(), environment, ldc, visitedQuerySubjects, querySubjects, metadata);
            } else {
                querySubjects.add(qi.getQuerySubject());
            }
            ldc.pop();
        }
    }

    private static void unwindExpression(String expression, PlanningEnvironment environment, LoopDetectionChain ldc, Set<IMetadata> visitedQuerySubjects, Set<IMetadata> querySubjects, IMetadata metadata) {
        if (expression.contains("#")) {
            BuildJoinPlan.createV5ValueExpression(expression, environment, ldc, visitedQuerySubjects, querySubjects, metadata);
        } else if (!expression.startsWith("<expression>")) {
            BuildJoinPlan.processQueryItemExpression(expression, environment, ldc, visitedQuerySubjects, querySubjects, metadata);
        } else {
            SimpleSaxParser saxParser = new SimpleSaxParser();
            try {
                saxParser.parseStream(new ByteArrayInputStream(expression.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new XQERuntimeException(e);
            }
            Element rootElement = saxParser.getDocument().getRootElement();
            if (rootElement != null) {
                Set<String> refObjs = BuildJoinPlan.getRefObjs(rootElement, environment);
                for (String identifier : refObjs) {
                    BuildJoinPlan.processIdentifier(identifier, environment, ldc, visitedQuerySubjects, querySubjects);
                }
            }
        }
    }

    private static void createV5ValueExpression(String expression, PlanningEnvironment environment, LoopDetectionChain ldc, Set<IMetadata> visitedQuerySubjects, Set<IMetadata> querySubjects, IMetadata metadata) {
        IXQEQueryNode[] allV5Nodes;
        IXQEQueryNode v5Expr = RQPUtilities.createV5ValueExpressionMetadata(expression, environment, null, metadata);
        for (IXQEQueryNode v5Node : allV5Nodes = v5Expr.getDescendantsOfType(201030, true)) {
            String identifier = ((V5MultiPartIdentifier)v5Node).getIdentifier();
            BuildJoinPlan.processIdentifier(identifier, environment, ldc, visitedQuerySubjects, querySubjects);
        }
    }

    private static void processQueryItemExpression(String identifier, PlanningEnvironment environment, LoopDetectionChain ldc, Set<IMetadata> visitedQuerySubjects, Set<IMetadata> querySubjects, IMetadata metadataItem) {
        try {
            BuildJoinPlan.processIdentifier(identifier, environment, ldc, visitedQuerySubjects, querySubjects);
        }
        catch (XQERuntimeException e) {
            BuildJoinPlan.createV5ValueExpression(identifier, environment, ldc, visitedQuerySubjects, querySubjects, metadataItem);
        }
    }

    private static void processIdentifier(String identifier, PlanningEnvironment environment, LoopDetectionChain ldc, Set<IMetadata> visitedQuerySubjects, Set<IMetadata> querySubjects) {
        IQueryItem qi;
        IQuerySubject qs;
        MetadataConnection mc = environment.getMetadataConnection();
        IMetadata metadata = mc.bindMetadataReference(identifier);
        if (metadata != null && metadata.getObjectType() == MetadataType.QUERY_ITEM && !visitedQuerySubjects.contains(qs = (qi = (IQueryItem)metadata).getQuerySubject())) {
            BuildJoinPlan.unwindQueryItem(metadata, environment, ldc, visitedQuerySubjects, querySubjects);
        }
    }

    private static Set<String> getRefObjs(Element rootElement, PlanningEnvironment environment) {
        HashSet<String> refObjs = new HashSet<String>();
        List children = rootElement.elements();
        for (Element childElement : children) {
            if (childElement.getName().equals("refobj")) {
                refObjs.add(childElement.getText());
                continue;
            }
            if (!childElement.getName().equals("refobjViaShortcut")) continue;
            List refObjsElems = childElement.elements();
            Element firstNestedChild = (Element)refObjsElems.get(0);
            Element lastNestedChild = (Element)refObjsElems.get(1);
            String shortcutRef = firstNestedChild.getText();
            String queryItemRefObj = lastNestedChild.getText();
            if (RQPUtilities.isShortcutTreatedAsAliasForUnwinding(shortcutRef, environment)) {
                String[] parts;
                try {
                    parts = UniqueNameParser.parse(queryItemRefObj, -1);
                }
                catch (UniqueNameParserException e) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_ParsingException, (Throwable)e, queryItemRefObj);
                }
                String itemName = shortcutRef + ".[" + parts[2] + "]";
                refObjs.add(itemName);
                continue;
            }
            refObjs.add(queryItemRefObj);
        }
        return refObjs;
    }

    public static boolean isPreferredModelIdHintPassed(RQPQuery rqpQuery) {
        List preferredModelItems;
        IXQEQueryNode v5Query = (IXQEQueryNode)rqpQuery.getRootRQPQuery().getPropertyValue("v5ref");
        return v5Query != null && (preferredModelItems = (List)v5Query.getPropertyValue("preferredModelItems")) != null && !preferredModelItems.isEmpty();
    }
}

