/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.HashSet;
import java.util.List;

public class ConvertJoinsToWherePredicate
extends RQPTransformation {
    public ConvertJoinsToWherePredicate() {
        this.mName = "Convert Joins To Where Predicate";
        this.mPassNumbers = new int[]{25};
        this.mTypes = new int[]{801017, 801024, 801025};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] joinPaths;
        RQPQuery rqpQuery = (RQPQuery)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RQPDetailFilterList filterList = (RQPDetailFilterList)rqpQuery.getFirstChildByType(801011);
        if (filterList == null) {
            filterList = (RQPDetailFilterList)nodeFactory.createNode(801011);
            rqpQuery.addChild(filterList);
        }
        for (IXQEQueryNode joinPath : joinPaths = this.getJoinPaths(rqpQuery)) {
            String failingRelationshipName = this.getRelationshipWithOptionalCardinality(joinPath);
            if (failingRelationshipName != null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_OuterJoinCannotBeGenerated, failingRelationshipName);
            }
            V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            filterList.addChild(detailFilter);
            if (joinPath.getNumberChildren() > 1) {
                IXQEQueryNode[] children = joinPath.getChildren();
                joinPath.detachChildren();
                V5LogicalExpression filterExpression = (V5LogicalExpression)nodeFactory.createNode(201003);
                filterExpression.setSubType(0);
                filterExpression.addChild(children[0]);
                filterExpression.addChild(children[1]);
                for (int i = 2; i < children.length; ++i) {
                    V5LogicalExpression logicalExpression = (V5LogicalExpression)nodeFactory.createNode(201003);
                    logicalExpression.setSubType(0);
                    logicalExpression.addChild(filterExpression);
                    logicalExpression.addChild(children[i]);
                    filterExpression = logicalExpression;
                }
                detailFilter.addChild(filterExpression);
                continue;
            }
            IXQEQueryNode child = joinPath.detachChild(0);
            detailFilter.addChild(child);
        }
        rqpQuery.getFirstChildByType(801039).detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        IXQEQueryNode[] joinPaths = this.getJoinPaths((RQPQuery)node);
        if (joinPaths == null || joinPaths.length == 0) {
            this.traceNodeCondition(false, "No join path to convert.", xqeTrace);
            return false;
        }
        for (IXQEQueryNode joinPath : joinPaths) {
            if (!this.joinReferencesMoreThan2QuerySubjects((RQPJoinPath)joinPath)) continue;
            this.traceNodeCondition(true, "Need to convert joins to where-clause predicate.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "Do not need to convert joins.", xqeTrace);
        return false;
    }

    private boolean joinReferencesMoreThan2QuerySubjects(RQPJoinPath joinPath) {
        IXQEQueryNode[] joinExpressions;
        for (IXQEQueryNode expression : joinExpressions = joinPath.getChildren()) {
            List<IXQEQueryNode> identifiersAndQueries = expression.getDescendantsOfTypesOrdered(new int[]{201116, 801009}, false);
            if (identifiersAndQueries.size() == 0) continue;
            HashSet<String> uniqueIdentifier = new HashSet<String>(identifiersAndQueries.size());
            for (IXQEQueryNode identifier : identifiersAndQueries) {
                if (identifier.getType() == 201116) {
                    uniqueIdentifier.add(((V5BoundModelIdentifier)identifier).getQuerySubject().getV5UniqueName());
                    continue;
                }
                uniqueIdentifier.add(((RQPDataItemRef)identifier).getQueryName());
            }
            if (uniqueIdentifier.size() <= 2) continue;
            return true;
        }
        return false;
    }

    private IXQEQueryNode[] getJoinPaths(RQPQuery rqpQuery) {
        IXQEQueryNode[] joinPaths = rqpQuery.getChildrenOfType(801039);
        return joinPaths;
    }

    private String getRelationshipWithOptionalCardinality(IXQEQueryNode rqpJoinPath) {
        RQPJoinPath joinPath = (RQPJoinPath)rqpJoinPath;
        List<IMetadata> joins = joinPath.getJoinPath();
        for (IMetadata join : joins) {
            if (!(join instanceof IRelationship)) continue;
            IRelationship joinObj = (IRelationship)join;
            if (joinObj.getLeftCardinality() == IRelationship.Cardinality.ZERO_ONE || joinObj.getLeftCardinality() == IRelationship.Cardinality.ZERO_MANY) {
                return joinObj.getName();
            }
            if (joinObj.getRightCardinality() != IRelationship.Cardinality.ZERO_ONE && joinObj.getRightCardinality() != IRelationship.Cardinality.ZERO_MANY) continue;
            return joinObj.getName();
        }
        return null;
    }
}

