/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.List;

public class ConvertStandardAggrToWindowedAggrInRQPQueryFromRMQuery
extends RQPTransformation {
    public ConvertStandardAggrToWindowedAggrInRQPQueryFromRMQuery() {
        this.mName = "Convert standard aggregates to windowed aggregates in RQPQuery from RMQuery";
        this.mPassNumbers = new int[]{20};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPProjectionList projList = rqpQuery.getProjectionList();
        List<IXQEQueryNode> aggrs = projList.getDescendantsOfTypeOrdered(301034, false);
        ArrayList<IXQEQueryNode> windowedAggrs = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> standardAggrs = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode aggr : aggrs) {
            if (((SQLAggregate)aggr).isWindowedAggregate()) {
                windowedAggrs.add(aggr);
                continue;
            }
            if (!this.isStandardAggregate(((SQLAggregate)aggr).getSubType())) continue;
            standardAggrs.add(aggr);
        }
        IXQEQueryNode[] groupingItems = rqpQuery.getGroupingItems();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (IXQEQueryNode standardAggr : standardAggrs) {
            SQLAggregate sa = (SQLAggregate)standardAggr;
            IXQEQueryNode parent = sa.getAncestorOfType(301034);
            if (parent != null) continue;
            SQLWindow window = sa.createOrGetWindow(nodeFactory);
            if (groupingItems.length <= 0) continue;
            SQLPartition partition = window.createOrGetPartition(nodeFactory);
            for (int m = 0; m < groupingItems.length; ++m) {
                partition.addChild(nodeFactory.deepCopyNode(groupingItems[m]));
            }
        }
    }

    public boolean isStandardAggregate(SQLAggregate.SubType aggregateSubtype) {
        switch (aggregateSubtype) {
            case SUM: 
            case COUNT: 
            case AVG: 
            case MIN: 
            case MAX: 
            case STDDEV_SAMP: 
            case VAR_SAMP: {
                return true;
            }
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private boolean validateConvertStandardAggrToWindowedAggr(IXQEQueryNode node) {
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPProjectionList projList = rqpQuery.getProjectionList();
        RQPGroupByList groupByList = rqpQuery.getGroupByList();
        List<IXQEQueryNode> aggrs = projList.getDescendantsOfTypeOrdered(301034, false);
        ArrayList<IXQEQueryNode> windowedAggrs = new ArrayList<IXQEQueryNode>();
        ArrayList<Object> standardAggrs = new ArrayList<Object>();
        for (Object aggr : aggrs) {
            if (((SQLAggregate)aggr).isWindowedAggregate()) {
                windowedAggrs.add((IXQEQueryNode)aggr);
                continue;
            }
            if (!this.isStandardAggregate(((SQLAggregate)aggr).getSubType())) continue;
            standardAggrs.add(aggr);
        }
        if (standardAggrs.size() == 0 || windowedAggrs.size() == 0) {
            return false;
        }
        boolean windowedAggrInGroupBy = false;
        for (IXQEQueryNode windowedAggr : windowedAggrs) {
            windowedAggrInGroupBy = false;
            SQLAggregate wa = (SQLAggregate)windowedAggr;
            RQPDataItem rqpDataItem = (RQPDataItem)wa.getAncestorOfType(801008);
            for (IXQEQueryNode groupby : groupByList.getChildren()) {
                if (!groupby.isSameExpression(rqpDataItem, false)) continue;
                windowedAggrInGroupBy = true;
                break;
            }
            if (windowedAggrInGroupBy) continue;
            break;
        }
        if (windowedAggrInGroupBy) {
            return false;
        }
        boolean stdAggrUnderWindowedAggr = false;
        for (IXQEQueryNode windowedAggr : windowedAggrs) {
            stdAggrUnderWindowedAggr = false;
            SQLAggregate wa = (SQLAggregate)windowedAggr;
            IXQEQueryNode waFirstChild = wa.getChild(0);
            if (!(waFirstChild instanceof SQLAggregate)) continue;
            for (IXQEQueryNode standardAggr : standardAggrs) {
                SQLAggregate sa = (SQLAggregate)standardAggr;
                if (waFirstChild == null || !waFirstChild.isSameExpression(sa, false)) continue;
                stdAggrUnderWindowedAggr = true;
                break;
            }
            if (stdAggrUnderWindowedAggr) continue;
            break;
        }
        return !stdAggrUnderWindowedAggr;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        if (!rqpQuery.isAsViewModelQuery()) {
            this.traceNodeCondition(false, "This RQPQuery is not created from RMQuery", xqeTrace);
            return false;
        }
        IXQEQueryNode groupByList = node.getFirstChildByType(801013);
        if (groupByList == null) {
            return false;
        }
        if (!this.validateConvertStandardAggrToWindowedAggr(node)) {
            this.traceNodeCondition(true, "This RQPQuery created from RMQuery does not need to convert starndard aggregate to windowed aggregate", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "This RQPQuery created from RMQuery needs to convert starndard aggregate to windowed aggregate", xqeTrace);
        return true;
    }
}

