/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryItemRef;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RMQueryOperation;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSubqueryList;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.binding.BindIdentifierNotFoundException;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class CreateRQPQueriesForSetOperation
extends RQPTransformation {
    public CreateRQPQueriesForSetOperation() {
        this.mName = "Create RQPQueries for the setOperation";
        this.mPassNumbers = new int[]{19};
        this.mTypes = new int[]{801031};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws BindIdentifierNotFoundException {
        SQLSetOperator setOperator = (SQLSetOperator)node.getFirstDescendantOfTypeOrdered(301018, false);
        RMQueryOperation queryOperation = (RMQueryOperation)node;
        RMQueryList rmQueryList = (RMQueryList)queryOperation.getParent();
        List<String> nameList = this.getNameList(environment, queryOperation);
        SQLRangeVar rangeVar = (SQLRangeVar)setOperator.getAncestorOfType(301007);
        rangeVar.setDerivedColumnList(nameList);
        List<IQuerySubject> participants = queryOperation.getParticipants();
        if (participants.isEmpty()) {
            RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
            String queryName = "";
            if (rqpQuery != null) {
                queryName = rqpQuery.getName();
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidQueryOperationOperand, queryName);
        }
        for (IQuerySubject participant : participants) {
            RMQuery rmQuery = rmQueryList.getRMQuery(participant);
            RQPQuery child = this.createRQPQuery(environment, rmQuery, rmQuery.getName());
            setOperator.addChild(child);
        }
        if (queryOperation.getPropertyValue("sqsOwner") != null) {
            setOperator.setPropertyValue("sqsOwner", queryOperation.getPropertyValue("sqsOwner"));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        IXQEQueryNode sqlSetOperator = node.getFirstDescendantOfTypeOrdered(301018, false);
        if (sqlSetOperator.getChildren().length >= 2) {
            this.traceNodeCondition(false, "The RMQueryOperation is complete", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The RMQueryOperation is not completed.", xqeTrace);
        return true;
    }

    private List<String> getNameList(PlanningEnvironment environment, RMQueryOperation queryOperation) {
        List<IXQEQueryNode> rmQueryItems = queryOperation.getDescendantsOfTypeOrdered(801033, false);
        int count = rmQueryItems.size();
        ArrayList<String> nameList = new ArrayList<String>(count);
        for (IXQEQueryNode i : rmQueryItems) {
            RMQueryItem queryItem = (RMQueryItem)i;
            IXQEQueryNode[] v5Expression = queryItem.getChildren();
            if (v5Expression.length != 0) continue;
            String caption = queryItem.getCaption();
            if (queryItem.getQueryItem() instanceof MoserQueryItem) {
                caption = queryItem.getName();
            }
            nameList.add(caption);
        }
        return nameList;
    }

    private RQPQuery createRQPQuery(PlanningEnvironment environment, RMQuery rmQuery, String newQueryName) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RQPQuery query = (RQPQuery)nodeFactory.createNode(801017);
        query.setPropertyValue("refQuery", newQueryName);
        query.setName(newQueryName);
        query.setPropertyValue("QSNAME", newQueryName);
        query.setPropertyValue("RmOperationQuery", rmQuery.getId());
        RQPSubqueryList subqueryList = (RQPSubqueryList)nodeFactory.createNode(801022);
        query.addChild(subqueryList);
        String[] rmQueryParts = rmQuery.getNameParts();
        IXQEQueryNode rmQueryItemList = rmQuery.getFirstChildByType(801034);
        List<IXQEQueryNode> rmQueryItems = rmQueryItemList.getDescendantsOfTypeOrdered(801033, false);
        for (IXQEQueryNode i : rmQueryItems) {
            RMQueryItem queryItem = (RMQueryItem)i;
            String qiName = queryItem.getCaption();
            if (queryItem.getQueryItem() instanceof MoserQueryItem) {
                qiName = queryItem.getName();
            }
            RQPDataItem rqpDataItem = RQPDataItem.create(environment, qiName);
            query.addToProjectionList(environment, rqpDataItem);
            RMQueryItemRef rmQueryItemRef = (RMQueryItemRef)nodeFactory.createNode(801047);
            rqpDataItem.addChild(rmQueryItemRef);
            rmQueryItemRef.setQueryNameParts(rmQueryParts);
            rmQueryItemRef.setName(qiName);
        }
        return query;
    }
}

