/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMSqlAsView;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.QueryReuseManager;
import com.cognos.xqemoser.MoserDataSource;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserQuerySubject;
import java.util.ArrayList;
import java.util.HashSet;

public class EvaluateModuleLocalCache
extends RQPTransformation {
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public EvaluateModuleLocalCache() {
        this.mName = "EvaluateModuleLocalCache";
        this.mPassNumbers = new int[]{106};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean strictlyPackage;
        node.setPropertyValue("evaluateModuleLocalCache", TRUE);
        MoserMetadataConnection moserMetadataConnection = (MoserMetadataConnection)environment.getMetadataConnection();
        HashSet<String> packageLocalCache = new HashSet<String>();
        boolean foundMoserJdbc = false;
        boolean foundParquet = false;
        boolean foundPackage = false;
        ArrayList<String> packageAndDSExpiry = new ArrayList<String>();
        ArrayList<String> querySubjectExpiry = new ArrayList<String>();
        IXQEQueryNode[] sqlAsViewNodes = node.getDescendantsOfType(801028, false);
        if (sqlAsViewNodes.length == 0) {
            RQPQuery rqpQuery = (RQPQuery)node;
            RQPQuery rqpSubquery = this.getRQPSubquery(rqpQuery, environment);
            if (rqpSubquery != null) {
                node.getGovernors().setLocalCache(rqpSubquery.getGovernors().getLocalCache().toString());
            }
            return;
        }
        for (IXQEQueryNode sqlAsViewNode : sqlAsViewNodes) {
            String moduleDataCacheExpiry;
            RMSqlAsView sqlAsView = (RMSqlAsView)sqlAsViewNode;
            IQuerySubject qs = sqlAsView.getQuerySubject();
            boolean parquetDataSource = false;
            if (qs instanceof MoserQuerySubject) {
                MoserModule parentModule;
                MoserQuerySubject mqs = (MoserQuerySubject)qs;
                MoserDataSource mds = mqs.getParentDataSource();
                if (mds != null) {
                    String dataSourceInterface = mds.getInterface();
                    boolean bl = parquetDataSource = dataSourceInterface.equals("PARQUET") || dataSourceInterface.equals("FLINT");
                }
                if (parquetDataSource) {
                    foundParquet = true;
                } else {
                    foundMoserJdbc = true;
                }
                String querySubjectDataCacheExpiry = qs.getQuerySubjectDataCacheExpiry();
                if (querySubjectDataCacheExpiry != null && !querySubjectDataCacheExpiry.equalsIgnoreCase("automatic")) {
                    querySubjectExpiry.add(querySubjectDataCacheExpiry);
                }
                if ((moduleDataCacheExpiry = (parentModule = mqs.getParentModule()).getDataCacheExpiry()) == null) continue;
                packageAndDSExpiry.add(moduleDataCacheExpiry);
                continue;
            }
            foundPackage = true;
            MetadataConnection mc = qs.getConnection();
            moduleDataCacheExpiry = moserMetadataConnection.getPackageDataCacheExpiry(mc);
            if (moduleDataCacheExpiry == null) {
                IParameterMaps parameterMaps = mc.getParameterMapsModel();
                String localCache = parameterMaps.get("_governor", "localCache");
                if (localCache == null) {
                    packageLocalCache.add(TRUE);
                    continue;
                }
                packageLocalCache.add(localCache.toLowerCase());
                continue;
            }
            packageAndDSExpiry.add(moduleDataCacheExpiry);
        }
        Boolean dashboardContext = node.getGovernors().isDashboardContext();
        Boolean localCacheSpecifiedInQueryHint = node.getGovernors().isLocalCacheSpecifiedInQueryHint();
        boolean strictlyParquet = foundParquet && !foundMoserJdbc && !foundPackage;
        boolean bl = strictlyPackage = foundPackage && !foundMoserJdbc && !foundParquet;
        if (!packageAndDSExpiry.isEmpty()) {
            if (packageLocalCache.contains(FALSE)) {
                this.addQRMTraceLog(environment, XQEMessageKeys.RUS_ReuseDisabledModel, ((RQPQuery)node).getName(), "LocalCache is disabled in one of the FM packages included in the module. ");
                node.getGovernors().setLocalCache(FALSE);
            } else {
                node.getGovernors().setModuleExpiries(packageAndDSExpiry);
            }
        } else {
            String localCache = null;
            IMessageKey.Param1 messageKey = null;
            String reason = null;
            if (strictlyParquet) {
                localCache = FALSE;
                messageKey = XQEMessageKeys.RUS_ReuseDisabledLocal;
                reason = "LocalCache is disabled when consuming local data. ";
            } else {
                localCache = TRUE;
                messageKey = XQEMessageKeys.RUS_ReuseEnabled;
                if (!localCacheSpecifiedInQueryHint.booleanValue()) {
                    if (strictlyPackage) {
                        if (packageLocalCache.contains(FALSE)) {
                            localCache = FALSE;
                            messageKey = XQEMessageKeys.RUS_ReuseDisabledModel;
                            reason = "LocalCache is disabled in the model.";
                        }
                    } else if (dashboardContext.booleanValue()) {
                        localCache = FALSE;
                        messageKey = XQEMessageKeys.RUS_ReuseDisabledDashboard;
                        reason = "LocalCache is disabled when executing a dashboard.";
                    } else if (packageLocalCache.contains(FALSE)) {
                        localCache = FALSE;
                        messageKey = XQEMessageKeys.RUS_ReuseDisabledModel;
                        reason = "LocalCache is disabled in one of the FM packages included in the module.";
                    }
                }
            }
            String queryName = ((RQPQuery)node).getName();
            this.addQRMTraceLog(environment, messageKey, queryName, reason);
            node.getGovernors().setLocalCache(localCache);
        }
        if (!querySubjectExpiry.isEmpty()) {
            node.getGovernors().setQuerySubjectExpiries(querySubjectExpiry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        RQPQuery rqpQuery = (RQPQuery)node;
        if (rqpQuery.getRootRQPQuery() != rqpQuery) {
            return false;
        }
        if (rqpQuery.getPropertyValue("evaluateModuleLocalCache") != null) {
            return false;
        }
        if (node.getGovernors().isDataCacheExpiryEnabled()) {
            return false;
        }
        RQPQuery rqpSubquery = this.getRQPSubquery(rqpQuery, environment);
        if (rqpSubquery != null && rqpSubquery.getPropertyValue("evaluateModuleLocalCache") == null) {
            return false;
        }
        V5Query v5Query = rqpQuery.getRefV5Query();
        try (MetadataConnectionContext mcc = null;){
            MetadataConnection metadataConnection;
            if (environment.isMultiModelForQueryEnabled()) {
                mcc = environment.pushMetadataConnectionContext(v5Query);
            }
            if (!((metadataConnection = environment.getMetadataConnection()) instanceof MoserMetadataConnection)) {
                boolean bl = false;
                return bl;
            }
            if (rqpQuery.getGovernors().isLocalCacheSpecifiedInQueryHint().booleanValue() && !node.getGovernors().isLocalCacheEnabled(environment).booleanValue()) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private void addQRMTraceLog(PlanningEnvironment pEnvironment, IMessageKey.Param1 messageKey, String queryName, String disableReason) {
        QueryReuseManager queryReuseManager = (QueryReuseManager)((RequestEnvironment)pEnvironment.getRequestEnvironment()).getQueryReuseManager();
        if (disableReason != null && queryReuseManager.loggingEnabled()) {
            queryReuseManager.logToXQELog(LogLevel.TRACE, "REPORT=" + ((RequestEnvironment)pEnvironment.getRequestEnvironment()).getReportName() + " QUERY= " + queryName + " is not reused due to " + disableReason);
        }
        if (((RequestEnvironment)pEnvironment.getRequestEnvironment()).getMaxSeverityLevel() >= 2) {
            String nag = XQEMessages.getMessage(messageKey, XQEMessages.getCurrProductLocale(), queryName);
            ((ExecutionEnvironment)pEnvironment.getExecutionEnvironment()).addReuseNag(nag);
        }
    }

    private RQPQuery getRQPSubquery(RQPQuery rqpQuery, PlanningEnvironment environment) {
        V5Query refV5Query;
        String v5SubqueryName;
        IXQEQueryNode sqlAsViewNode = rqpQuery.getFirstDescendantOfTypeOrdered(801028, false);
        if (sqlAsViewNode == null && (v5SubqueryName = (refV5Query = rqpQuery.getRefV5Query()).getV5Source().getQueryRef()) != null) {
            return RQPUtilities.getRQPQueryForV5Query(v5SubqueryName, environment);
        }
        return null;
    }
}

