/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.ast.rqp.RMModelQueryAsView;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RMSqlCalcFilter;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.LoopDetectionChain;
import java.util.List;

public class ExpandEmbeddedCalcsFilters
extends RQPTransformation {
    public ExpandEmbeddedCalcsFilters() {
        this.mName = "Expand the embedded calculations or filters";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        LoopDetectionChain ldc = new LoopDetectionChain();
        IXQEQueryNode parentNode = node.getParent();
        int position = parentNode.getPositionOfChild(node);
        IQuerySubject originalQS = ((V5BoundModelIdentifier)node).getQuerySubject();
        this.applyImplementation(node, environment, ldc);
        IXQEQueryNode unwoundExpr = parentNode.getChild(position);
        if (originalQS != null && unwoundExpr.getAncestorOfType(801035) != null) {
            this.addFilterItemsInProjectionsOfUnderlyingQS(unwoundExpr, originalQS.getName());
        }
    }

    public void applyImplementation(IXQEQueryNode node, PlanningEnvironment environment, LoopDetectionChain ldc) {
        IXQEQueryNode[] allV5BoundNodes;
        V5BoundModelIdentifier v5Identifier = (V5BoundModelIdentifier)node;
        if (!ldc.push(v5Identifier.getIdentifier())) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, "Model Expression", ldc.serialize());
        }
        RMQueryItem queryItem = this.getRMQueryItem(v5Identifier);
        if (this.referencesSameQuerySubject(v5Identifier) && !this.shouldSelfRefCalcsBeExpanded(v5Identifier) && queryItem != null && queryItem.getCount() > 0) {
            V5BoundDataItemReference selfRef = (V5BoundDataItemReference)environment.getNodeFactory().createNode(201060);
            selfRef.setPropertyValue("nameParts", v5Identifier.getNameParts());
            selfRef.setPropertyValue("rmRefCalc", queryItem);
            node.exchange(selfRef);
            ldc.pop();
            return;
        }
        IXQEQueryNode replacementNode = environment.getNodeFactory().deepCopyNode(queryItem.getChildren()[0]);
        node.exchange(replacementNode);
        for (IXQEQueryNode v5Node : allV5BoundNodes = replacementNode.getDescendantsOfType(201116, true)) {
            IXQEQueryNode filter;
            if (!this.passesNodeCondition(v5Node, environment)) continue;
            RMQuery rmQuery = this.getRMQuery((V5BoundModelIdentifier)v5Node);
            if ((this.isReferenceOther((V5BoundModelIdentifier)v5Node) || rmQuery.getType() != 801027 || rmQuery.getPropertyValue("hasDeterminant") != null) && (filter = v5Node.getAncestorOfType(801035)) != null) break;
            this.applyImplementation(v5Node, environment, ldc);
        }
        ldc.pop();
    }

    private boolean shouldSelfRefCalcsBeExpanded(V5BoundModelIdentifier v5Identifier) {
        RMQuery rmQueryAncestorOfV5Identifier = this.getRMQueryOfV5IdentifierAncestor(v5Identifier);
        if (rmQueryAncestorOfV5Identifier == null) {
            return true;
        }
        if (v5Identifier.getAncestorOfType(801033) == null && v5Identifier.getAncestorOfType(801035) == null) {
            return true;
        }
        Boolean b = rmQueryAncestorOfV5Identifier.getBooleanPropertyValue("expandSefRefCalcs");
        if (b == null) {
            return true;
        }
        return b;
    }

    protected boolean referencesSameQuerySubject(V5BoundModelIdentifier v5Identifier) {
        RMQuery rmQuery;
        RMQuery rmQueryAncestorOfV5Identifier = this.getRMQueryOfV5IdentifierAncestor(v5Identifier);
        return rmQueryAncestorOfV5Identifier == (rmQuery = this.getRMQuery(v5Identifier));
    }

    protected RMQueryItem getRMQueryItem(V5BoundModelIdentifier v5Identifier) {
        RMQuery rmQuery = this.getRMQuery(v5Identifier);
        if (rmQuery == null) {
            return null;
        }
        RMQueryItem rmQueryItem = rmQuery.getRMQueryItem(v5Identifier);
        return rmQueryItem;
    }

    protected RMQuery getRMQuery(V5BoundModelIdentifier v5Identifier) {
        RQPQuery rqpQuery = (RQPQuery)v5Identifier.getAncestorOfType(801017);
        if (rqpQuery == null) {
            return null;
        }
        RMQueryList rmQueryList = RQPUtilities.getRMQueryList(v5Identifier);
        RMQuery rmQuery = rmQueryList.getRMQuery(v5Identifier);
        if (rmQuery == null) {
            return null;
        }
        return rmQuery;
    }

    protected RMQuery getRMQueryOfV5IdentifierAncestor(V5BoundModelIdentifier v5Identifier) {
        int[] types = new int[]{801027, 801029, 801028, 801031};
        RMQuery rmQuery = (RMQuery)v5Identifier.getAncestorOfTypes(types);
        if (rmQuery == null) {
            return null;
        }
        return rmQuery;
    }

    protected boolean isQueryItemHasExpression(V5BoundModelIdentifier v5Identifier) {
        IQueryItem qi;
        IMetadata metadata = v5Identifier.getMetadata();
        return metadata instanceof IQueryItem && (qi = (IQueryItem)metadata).getExpression() != null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        RMEmbeddedFilter embeddedFilter;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        V5BoundModelIdentifier v5Identifier = (V5BoundModelIdentifier)node;
        if (!this.isQueryItemHasExpression(v5Identifier)) {
            this.traceNodeCondition(false, "There is no expression to expand in embedded calculations or filters.", xqeTrace);
            return false;
        }
        RMQuery rmQueryOfV5IdentifierAncestor = this.getRMQueryOfV5IdentifierAncestor(v5Identifier);
        RMQuery rmQuery = this.getRMQuery(v5Identifier);
        if (rmQueryOfV5IdentifierAncestor == null || rmQuery == null) {
            this.traceNodeCondition(false, "The node is not in the context of an RMQuery", xqeTrace);
            return false;
        }
        IQuerySubject qs = (IQuerySubject)rmQueryOfV5IdentifierAncestor.getPropertyValue("sqsOwner");
        if (qs != null && (embeddedFilter = (RMEmbeddedFilter)v5Identifier.getAncestorOfType(801035)) != null && embeddedFilter.getPropertyValue("SQSFilterPAA") != null && rmQueryOfV5IdentifierAncestor == rmQuery) {
            return false;
        }
        if (rmQueryOfV5IdentifierAncestor.getType() != 801027 && rmQueryOfV5IdentifierAncestor != rmQuery) {
            if (null == v5Identifier.getAncestorOfType(801035)) {
                this.traceNodeCondition(false, "The node references other RMQuery, so do not expand it.", xqeTrace);
                return false;
            }
            RMQueryItem rmQueryItem = rmQuery.getRMQueryItem(v5Identifier);
            if (rmQueryItem.getCount() > 0) {
                return false;
            }
        }
        return true;
    }

    private boolean isReferenceOther(V5BoundModelIdentifier v5Id) {
        IXQEQueryNode[] allV5BoundNodes;
        RMQuery rmQuery = this.getRMQuery(v5Id);
        RMQueryItem rmQueryItem = rmQuery.getRMQueryItem(v5Id);
        IXQEQueryNode expr = rmQueryItem.getChild(0);
        for (IXQEQueryNode v5Node : allV5BoundNodes = expr.getDescendantsOfType(201116, true)) {
            if (rmQuery == this.getRMQuery((V5BoundModelIdentifier)v5Node)) continue;
            return true;
        }
        return false;
    }

    protected void addFilterItemsInProjectionsOfUnderlyingQS(IXQEQueryNode unwoundExpr, String originalQSName) {
        List<IXQEQueryNode> v5BoundIds = unwoundExpr.getDescendantsOfTypeOrdered(201116, true);
        RMQueryList rmQueryList = (RMQueryList)unwoundExpr.getAncestorOfType(801032);
        if (rmQueryList == null) {
            return;
        }
        for (IXQEQueryNode node : v5BoundIds) {
            V5BoundModelIdentifier v5BoundId = (V5BoundModelIdentifier)node;
            IQuerySubject qs = v5BoundId.getQuerySubject();
            if (qs.getName().equals(originalQSName)) continue;
            RMQuery referencedRmQuery = rmQueryList.getRMQuery(qs);
            this.addItemInRMQuery(v5BoundId, referencedRmQuery);
        }
    }

    protected void addItemInRMQuery(V5BoundModelIdentifier v5BoundId, RMQuery referencedRmQuery) {
        if (referencedRmQuery instanceof RMModelQueryAsView || referencedRmQuery instanceof RMSqlCalcFilter) {
            RMQueryItem rmItem = referencedRmQuery.getRMQueryItem(v5BoundId);
            rmItem.incrementCount();
        }
    }
}

