/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSubqueryList;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;

public class GenerateUniqueCorrelationNameForRMQuery
extends RQPTransformation {
    public GenerateUniqueCorrelationNameForRMQuery() {
        this.mName = "Generate Unique Correlation Name for RMQuery";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{801028, 801027, 801029, 801031, 801030};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RMQuery rmQuery = (RMQuery)node;
        RMQueryList rmqList = (RMQueryList)rmQuery.getParent();
        HashSet<String> allNames = new HashSet<String>();
        IXQEQueryNode[] rmQueries = rmqList.getChildren();
        for (int i = 0; i < rmQueries.length; ++i) {
            RMQuery query = (RMQuery)rmQueries[i];
            if (rmQuery == query) continue;
            String correlationName = query.getCorrelationName();
            if (correlationName != null) {
                allNames.add(correlationName);
                continue;
            }
            allNames.add(query.getNameFromNameParts());
        }
        RQPQuery rqpQuery = (RQPQuery)rmqList.getAncestorOfType(801017);
        RQPSubqueryList rqpSubList = (RQPSubqueryList)rqpQuery.getSubqueryList();
        IXQEQueryNode[] rqpSubQueries = rqpSubList.getChildren();
        for (int j = 0; j < rqpSubQueries.length; ++j) {
            RQPQuery subQuery = (RQPQuery)rqpSubQueries[j];
            allNames.add(subQuery.getName());
        }
        String rmQueryName = rmQuery.getNameFromNameParts();
        String newName = RQPNameGenerator.makeUniqueName(rmQueryName, allNames, 0);
        rmQuery.setCorrelationName(newName);
        if (rmQuery.getType() != 801029) {
            SQLRangeVar rangeVar = (SQLRangeVar)rmQuery.getFirstChildByType(301007);
            rangeVar.setName(newName);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        RMQuery rmQuery = (RMQuery)node;
        return rmQuery.getCorrelationName() == null;
    }
}

