/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryItemRef;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLFromClause;
import com.cognos.xqe.ast.sql.SQLOption;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.CreateRQPQueryFromRMQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class TransferRMQuerySQLASTToFromClause
extends RQPTransformation {
    public static final String JSON_ARRAY_QI_NAME_SUFFIX = "[]";

    public TransferRMQuerySQLASTToFromClause() {
        this.mName = "TransferRMQuerySQLASTToFromClause";
        this.mPassNumbers = new int[]{22};
        this.mTypes = new int[]{801017, 801025, 801024, 801012};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TreeSet<RQPNode> sources = new TreeSet<RQPNode>();
        this.getDataSourcesFromRQPQuery((RQPQuery)node, sources);
        this.removeAsviewMDQFromSource(sources);
        SQLFromClause fromClause = RQPUtilities.getFromClauseNode(node, environment.getNodeFactory());
        for (IXQEQueryNode iXQEQueryNode : sources) {
            IXQEQueryNode[] rqpQueryNodes;
            for (IXQEQueryNode rqpQuery : rqpQueryNodes = iXQEQueryNode.getDescendantsOfType(801017, false)) {
                IXQEQueryNode subQueryFromClause = rqpQuery.getFirstChildByType(301043);
                if (subQueryFromClause != null) continue;
                this.apply(rqpQuery, environment);
            }
            this.generateSQLForQuerySubject(environment.getNodeFactory(), fromClause, (RMQuery)iXQEQueryNode);
            this.transferEmbeddedFilterOfSetOperation(environment, fromClause, iXQEQueryNode);
        }
    }

    private void transferEmbeddedFilterOfSetOperation(PlanningEnvironment environment, IXQEQueryNode fromClause, IXQEQueryNode source) {
        if (source.getType() != 801031) {
            return;
        }
        RQPQuery rqpQuery = (RQPQuery)fromClause.getParent();
        IXQEQueryNode embeddedFilterList = source.getFirstChildByType(801036);
        if (embeddedFilterList == null) {
            return;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (IXQEQueryNode filter : embeddedFilterList.getChildren()) {
            V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            if (((RMEmbeddedFilter)filter).getFilterType() == "filterDefinition" && ((RMEmbeddedFilter)filter).getApply().equals("asNeeded")) {
                detailFilter.setPropertyValue("use", "optional");
            }
            detailFilter.addChild(nodeFactory.deepCopyNode(filter.getChild(0)));
            detailFilter.setPropertyValue("RMQueryOperationName", source.getPropertyValue("correlationName"));
            if (RQPUtilities.hasAggregateInExpression(detailFilter)) {
                rqpQuery.addToSummaryFilterList(environment, detailFilter);
                continue;
            }
            rqpQuery.addToDetailFilterList(environment, detailFilter);
        }
    }

    private void removeAsviewMDQFromSource(TreeSet<RQPNode> sources) {
        ArrayList<RQPNode> toRemove = new ArrayList<RQPNode>();
        for (RQPNode source : sources) {
            if (((RMQuery)source).getType() != 801029) continue;
            toRemove.add(source);
        }
        sources.removeAll(toRemove);
    }

    private void generateSQLForQuerySubject(IXQENodeFactory nodeFactory, IXQEQueryNode fromClause, RMQuery qs) {
        IXQEQueryNode sourceAST = qs.getSQLForQuerySubject(nodeFactory);
        if (null == sourceAST) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "BuildFromClause.generateSQLForQuerySubject requires sourceAST");
        }
        CreateRQPQueryFromRMQuery.setNocache(sourceAST, qs);
        fromClause.addChild(sourceAST);
        this.addUnnestTableFunctionForMultisetIdentifier(nodeFactory, fromClause, qs);
    }

    private void addUnnestTableFunctionForMultisetIdentifier(IXQENodeFactory nodeFactory, IXQEQueryNode sqlFromClause, RMQuery rmQuery) {
        IXQEQueryNode rmQIList = rmQuery.getFirstDescendantOfTypeOrdered(801034, false);
        for (IXQEQueryNode rmQI : rmQIList.getChildrenOfType(801033)) {
            RMQueryItem rmQueryItem = (RMQueryItem)rmQI;
            if (rmQueryItem.getCount() <= 0) continue;
            IMetadata queryItem = rmQueryItem.getQueryItem();
            List<IMetadata> multisetItems = RQPUtilities.getListOfMultisetItems(queryItem);
            LinkedList<SQLRangeVar> sqlRangeVars = new LinkedList<SQLRangeVar>();
            for (IMetadata multisetItem : multisetItems) {
                boolean foundExistingUnnest = false;
                for (IXQEQueryNode child : sqlFromClause.getChildren()) {
                    if (!((SQLRangeVar)child).getName().equals(multisetItem.getName())) continue;
                    sqlRangeVars.add((SQLRangeVar)child);
                    foundExistingUnnest = true;
                    break;
                }
                if (foundExistingUnnest) continue;
                IMetadata parentQS = multisetItem.getParentObject();
                ArrayList<String> identifierChain = new ArrayList<String>();
                identifierChain.add(multisetItem.getName());
                while (!(parentQS instanceof IQuerySubject) && !parentQS.getDataType().isMultiset()) {
                    identifierChain.add(parentQS.getName());
                    parentQS = parentQS.getParentObject();
                }
                SQLColumn column = (SQLColumn)nodeFactory.createNode(301005);
                column.setTableName(parentQS.getName());
                column.setName(multisetItem.getName());
                Collections.reverse(identifierChain);
                column.setIdentifierChain(identifierChain.toArray(new String[identifierChain.size()]));
                SQLTableFunction tableFunction = (SQLTableFunction)nodeFactory.createNode(301038);
                tableFunction.setSubType(SQLTableFunction.SubType.UNNEST);
                SQLOption sqlOption = (SQLOption)nodeFactory.createNode(301068);
                sqlOption.setValue("WITHOUT ORDINALITY");
                tableFunction.addChild(sqlOption);
                SQLRangeVar sqlRangeVar = (SQLRangeVar)nodeFactory.createNode(301007);
                sqlRangeVar.setName(multisetItem.getName());
                sqlRangeVar.setPropertyValue("fullQSName", multisetItem.getID());
                sqlRangeVar.addChild(tableFunction);
                tableFunction.addChild(column);
                this.associateLateralSQLRangeVars(sqlRangeVar, parentQS.getName(), sqlFromClause);
                sqlFromClause.addChild(sqlRangeVar);
                sqlRangeVars.add(sqlRangeVar);
            }
            SQLRangeVar directRangeVar = null;
            if (sqlRangeVars.isEmpty()) {
                directRangeVar = this.retrieveRangeVarAssociatedWithQS(sqlFromClause, rmQueryItem.getQuerySubject());
            } else {
                directRangeVar = (SQLRangeVar)sqlRangeVars.getLast();
                if (directRangeVar.getPropertyValue("fullQSName") == null) {
                    directRangeVar = null;
                }
            }
            if (directRangeVar == null) continue;
            directRangeVar.addToProjectionList(this.extractIdentifierChain(directRangeVar, queryItem));
        }
    }

    private SQLRangeVar retrieveRangeVarAssociatedWithQS(IXQEQueryNode sqlFromClause, IQuerySubject qs) {
        for (IXQEQueryNode child : sqlFromClause.getChildren()) {
            if (!(child instanceof SQLRangeVar)) continue;
            SQLRangeVar rangeVarChild = (SQLRangeVar)child;
            String qsName = null;
            if (child.getPropertyValue("fullQSName") == null || !(qsName = (String)rangeVarChild.getPropertyValue("fullQSName")).equals(qs.getID())) continue;
            return rangeVarChild;
        }
        return null;
    }

    private String extractIdentifierChain(SQLRangeVar rangeVar, IMetadata qi) {
        LinkedList<String> nameParts = new LinkedList<String>();
        String currentRangeVarName = null;
        if (rangeVar.getPropertyValue("fullQSName") != null) {
            currentRangeVarName = (String)rangeVar.getPropertyValue("fullQSName");
        }
        do {
            String id;
            String[] currentIdParts;
            String namePart;
            if ((namePart = (currentIdParts = UniqueNameParser.parseNoThrow(id = qi.getID()))[currentIdParts.length - 1]).endsWith(JSON_ARRAY_QI_NAME_SUFFIX)) {
                namePart = namePart.substring(0, namePart.length() - JSON_ARRAY_QI_NAME_SUFFIX.length());
            }
            nameParts.addFirst(namePart);
        } while ((qi = qi.getParentObject()) != null && !currentRangeVarName.equals(qi.getID()));
        return UniqueNameGenerator.createUniqueName(nameParts.toArray(new String[nameParts.size()]));
    }

    private void associateLateralSQLRangeVars(SQLRangeVar sqlRangeVar, String dependentName, IXQEQueryNode sqlFromClause) {
        IXQEQueryNode[] existingSQLRangeVarNodes = sqlFromClause.getChildrenOfTypesOrdered(new int[]{301007});
        for (int i = existingSQLRangeVarNodes.length - 1; i >= 0; --i) {
            SQLRangeVar current = (SQLRangeVar)existingSQLRangeVarNodes[i];
            if (!SQLBinderUtil.compareIdentifiers(dependentName, current.getName(), true)) continue;
            current.addLateralSQLRangeVars(sqlRangeVar.getName());
            sqlRangeVar.setLateral(true);
        }
    }

    private void getDataSourcesFromRQPQuery(RQPQuery query, TreeSet<RQPNode> sources) {
        this.getDataSourcesFromChildOfType(query, 801016, sources);
        this.getDataSourcesFromChildOfType(query, 801011, sources);
        this.getDataSourcesFromChildOfType(query, 801023, sources);
        this.getDataSourcesFromChildOfType(query, 801039, sources);
    }

    private void getDataSourcesFromChildOfType(RQPQuery query, int childtype, TreeSet<RQPNode> sources) {
        IXQEQueryNode childNode = query.getFirstChildByType(childtype);
        if (childNode == null) {
            return;
        }
        RMQueryList rmQueryList = RQPUtilities.getRMQueryList(query);
        List<IXQEQueryNode> modelIds = childNode.getDescendantsOfTypeOrdered(201116, 801017);
        for (IXQEQueryNode q : modelIds) {
            V5BoundModelIdentifier v5Id = (V5BoundModelIdentifier)q;
            RMQuery rmQuery = rmQueryList.getRMQuery(v5Id);
            if (rmQuery == null) continue;
            sources.add(rmQuery);
        }
        List<IXQEQueryNode> rmQueryItemRefs = childNode.getDescendantsOfTypeOrdered(801047, true);
        for (IXQEQueryNode q : rmQueryItemRefs) {
            RMQueryItemRef rmQueryItemRef = (RMQueryItemRef)q;
            RMQuery rmQuery = rmQueryList.getRMQuery(rmQueryItemRef);
            if (rmQuery == null) continue;
            sources.add(rmQuery);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        TreeSet<RQPNode> sources = new TreeSet<RQPNode>();
        this.getDataSourcesFromRQPQuery((RQPQuery)node, sources);
        this.removeAsviewMDQFromSource(sources);
        if (sources.isEmpty()) {
            this.traceNodeCondition(false, "This RQPQuery does not refer directly to dbQuerySubjects.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "This RQPQuery refers directly to dbQuerySubjects.", xqeTrace);
        return true;
    }
}

