/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSubqueryList;
import com.cognos.xqe.ast.sql.SQLFromClause;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;

public class TransferRQPSummaryQueryToFromClause
extends RQPTransformation {
    public TransferRQPSummaryQueryToFromClause() {
        this.mName = "TransferRQPSummaryQueryToFromClause";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{801017};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rootQuery;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode subQueryList = node.getFirstChildByType(801022);
        if (subQueryList.getNumberChildren() > 0) {
            this.setNumReferencesForSubqueries((RQPQuery)node);
            this.buildFromClause(node, nodeFactory);
        }
        if ((rootQuery = (RQPQuery)node).getFirstChildByType(801022) != null) {
            rootQuery.removeSubqueryList();
        }
    }

    private boolean buildFromClause(IXQEQueryNode node, IXQENodeFactory nodeFactory) {
        TreeSet<RQPNode> sources = new TreeSet<RQPNode>();
        this.getDataSourcesFromRQPQuery((RQPQuery)node, sources, nodeFactory);
        this.buildFromClauseFromDataSources(node, nodeFactory, sources);
        RQPQuery rootQuery = (RQPQuery)node;
        if (rootQuery.getType() == 801017 && rootQuery.getFirstChildByType(801022) != null) {
            rootQuery.removeSubqueryList();
        }
        return true;
    }

    private void setNumReferencesForSubqueries(RQPQuery query) {
        TreeSet<RQPNode> subqueries = new TreeSet<RQPNode>();
        this.getSubquerySourcesFromRQPQuery(query, subqueries);
        for (RQPQuery rQPQuery : subqueries) {
            if (rQPQuery == query) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_CircularReferenceInSubQueries, rQPQuery.getName());
            }
            rQPQuery.incrementNumReferences();
            this.setNumReferencesForSubqueries(rQPQuery);
        }
    }

    private void getSubquerySourcesFromRQPQuery(RQPQuery query, TreeSet<RQPNode> subqueries) {
        this.getSubquerySourcesFromChildOfType(query, 801016, subqueries);
        this.getSubquerySourcesFromChildOfType(query, 801011, subqueries);
        this.getSubquerySourcesFromChildOfType(query, 801023, subqueries);
        subqueries.addAll(this.getSubQueryWithSummaryFilter(query));
        subqueries.addAll(this.getBridgeSubqueries(query));
    }

    private List<RQPNode> getSubQueryWithSummaryFilter(RQPQuery query) {
        IXQEQueryNode[] subQueries;
        ArrayList<RQPNode> subqueries = new ArrayList<RQPNode>();
        IXQEQueryNode subQueryList = query.getSubqueryList();
        if (subQueryList == null) {
            return subqueries;
        }
        for (IXQEQueryNode subq : subQueries = subQueryList.getChildren()) {
            if (!((RQPQuery)subq).isSummarizedQuery() || subq.getDescendantsOfType(101011, false).length == 0) continue;
            subqueries.add((RQPNode)subq);
        }
        return subqueries;
    }

    private List<RQPNode> getBridgeSubqueries(RQPQuery query) {
        IXQEQueryNode[] subQueries;
        ArrayList<RQPNode> subqueries = new ArrayList<RQPNode>();
        IXQEQueryNode subQueryList = query.getSubqueryList();
        if (subQueryList == null) {
            return subqueries;
        }
        for (IXQEQueryNode s : subQueries = subQueryList.getChildren()) {
            RQPQuery subquery = (RQPQuery)s;
            if (!subquery.isBridgeQuery() && !subquery.isBridgeDataStream()) continue;
            subqueries.add((RQPNode)s);
        }
        return subqueries;
    }

    private void getSubquerySourcesFromChildOfType(RQPQuery query, int childType, TreeSet<RQPNode> subqueries) {
        IXQEQueryNode childNode = query.getFirstChildByType(childType);
        if (childNode == null) {
            return;
        }
        this.getSubquerySourcesFromDataItemRefs(query, childNode, subqueries);
    }

    private void buildFromClauseFromDataSources(IXQEQueryNode node, IXQENodeFactory nodeFactory, TreeSet<RQPNode> sources) {
        if (sources.isEmpty()) {
            node.setPropertyValue("leafSubQuery", true);
            return;
        }
        SQLFromClause rqpFromClause = RQPUtilities.getFromClauseNode(node, nodeFactory);
        for (IXQEQueryNode iXQEQueryNode : sources) {
            this.createSubquery(nodeFactory, rqpFromClause, (RQPQuery)iXQEQueryNode);
        }
    }

    private void createSubquery(IXQENodeFactory nodeFactory, IXQEQueryNode fromClause, RQPQuery query) {
        IXQEQueryNode rqpFromClause = query.getFirstChildByType(301043);
        if (rqpFromClause == null) {
            this.buildFromClause(query, nodeFactory);
        }
        SQLRangeVar subqueryAlias = (SQLRangeVar)nodeFactory.createNode(301007);
        subqueryAlias.setName(query.getName());
        if (query.isFactQuery() || query.isSummarizedQuery() && query.isLowestLevelSummaryQuery()) {
            subqueryAlias.setCandidateForQueryReuse(true);
        }
        if (query.getNumReferences() > 1) {
            subqueryAlias.addChild(nodeFactory.deepCopyNode(query));
        } else {
            query.move(subqueryAlias);
        }
        if (query.getPropertyValue("underSubQueryForSF") != null) {
            subqueryAlias.setPropertyValue("underSubQueryForSF", true);
        }
        if (query.isSubqueryForCalcsInQS()) {
            RQPQuery.setSubqueryForCalcsInQS(subqueryAlias, true);
        }
        fromClause.addChild(subqueryAlias);
    }

    private void getDataSourcesFromRQPQuery(RQPQuery query, TreeSet<RQPNode> sources, IXQENodeFactory factory) {
        this.getDataSourcesFromChildOfType(query, 801016, sources, factory);
        this.getDataSourcesFromChildOfType(query, 801011, sources, factory);
        this.getDataSourcesFromChildOfType(query, 801023, sources, factory);
        sources.addAll(this.getSubQueryWithSummaryFilter(query));
        sources.addAll(this.getBridgeSubqueries(query));
    }

    private void getDataSourcesFromChildOfType(RQPQuery query, int childtype, TreeSet<RQPNode> sources, IXQENodeFactory factory) {
        IXQEQueryNode childNode = query.getFirstChildByType(childtype);
        if (childNode == null) {
            return;
        }
        this.getSubquerySourcesFromDataItemRefs(query, childNode, sources);
    }

    private void getSubquerySourcesFromDataItemRefs(RQPQuery query, IXQEQueryNode childNode, TreeSet<RQPNode> sources) {
        List<IXQEQueryNode> dataItemRefs = childNode.getDescendantsOfTypeOrdered(801009, 801017);
        RQPQuery parentQuery = (RQPQuery)childNode.getAncestorOfType(801017);
        if (parentQuery == null) {
            return;
        }
        ListIterator<IXQEQueryNode> it = dataItemRefs.listIterator();
        while (it.hasNext()) {
            RQPDataItemRef rqpDataItemRef = (RQPDataItemRef)it.next();
            if (rqpDataItemRef.createdFromQS()) continue;
            String queryName = rqpDataItemRef.getQueryName();
            RQPQuery subquery = parentQuery.getSubquery(queryName);
            for (RQPQuery parentAncestor = (RQPQuery)parentQuery.getAncestorOfType(801017); subquery == null && parentAncestor != null; parentAncestor = (RQPQuery)parentAncestor.getAncestorOfType(801017)) {
                subquery = parentAncestor.getSubquery(queryName);
            }
            sources.add(subquery);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        RQPSubqueryList subqueryList = (RQPSubqueryList)node.getFirstChildByType(801022);
        if (subqueryList == null) {
            this.traceNodeCondition(false, "No subquery nodes to move/clean.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "This RQPQuery includes subqueries that will be moved under the sqlFrom clause.", xqeTrace);
        return true;
    }
}

