/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLFromClause;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundSQLQueryItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.List;

public class TransferV5SQLQueryToFromClause
extends RQPTransformation {
    public static final String PROP_BOOL_TYPEDINSQL_ROOTNODE = "typedInSQLRootNode";

    public TransferV5SQLQueryToFromClause() {
        this.mName = "TransferV5SQLQueryToFromClause";
        this.mPassNumbers = new int[]{22};
        this.mTypes = new int[]{801017, 801024, 801012, 801025};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ArrayList<IXQEQueryNode> sources = new ArrayList<IXQEQueryNode>();
        this.getDataSourcesFromRQPQuery((RQPQuery)node, sources);
        SQLFromClause rqpFromClause = RQPUtilities.getFromClauseNode(node, nodeFactory);
        for (IXQEQueryNode s : sources) {
            V5SqlQuery source = (V5SqlQuery)s;
            this.addSqlQueryBlockForV5SqlQuery(rqpFromClause, source, nodeFactory);
        }
    }

    private void addSqlQueryBlockForV5SqlQuery(IXQEQueryNode fromClause, V5SqlQuery v5SqlQuery, IXQENodeFactory nodeFactory) {
        IXQEQueryNode sqlQueryBlock = v5SqlQuery.getFirstChildByType(301004);
        if (sqlQueryBlock != null) {
            fromClause.addChild(nodeFactory.deepCopyNode(sqlQueryBlock));
            fromClause.getChild(0).setPropertyValue(PROP_BOOL_TYPEDINSQL_ROOTNODE, true);
        }
    }

    private void getDataSourcesFromRQPQuery(RQPQuery query, List<IXQEQueryNode> sources) {
        V5Query refV5Query = query.getRootRQPQuery().getRefV5Query();
        List<IXQEQueryNode> v5SqlQueries = refV5Query.getDescendantsOfTypeOrdered(101016, false);
        if (v5SqlQueries.isEmpty()) {
            return;
        }
        this.getDataSourcesFromChildOfType(query, v5SqlQueries, 801016, sources);
        this.getDataSourcesFromChildOfType(query, v5SqlQueries, 801011, sources);
        this.getDataSourcesFromChildOfType(query, v5SqlQueries, 801023, sources);
    }

    private void getDataSourcesFromChildOfType(RQPQuery query, List<IXQEQueryNode> v5SqlQueries, int childtype, List<IXQEQueryNode> sources) {
        IXQEQueryNode childNode = query.getFirstChildByType(childtype);
        if (childNode == null) {
            return;
        }
        List<IXQEQueryNode> sqlQueryItemRefs = childNode.getDescendantsOfTypeOrdered(201103, true);
        block0: for (IXQEQueryNode v : v5SqlQueries) {
            V5SqlQuery v5SqlQuery = (V5SqlQuery)v;
            for (IXQEQueryNode q : sqlQueryItemRefs) {
                V5BoundSQLQueryItemReference sqlQueryItemRef = (V5BoundSQLQueryItemReference)q;
                String[] nameParts = sqlQueryItemRef.getNameParts();
                String v5SqlQueryName = nameParts[0];
                if (!v5SqlQueryName.equals(v5SqlQuery.getName()) || sources.contains(v5SqlQuery)) continue;
                sources.add(v5SqlQuery);
                continue block0;
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        ArrayList<IXQEQueryNode> sources = new ArrayList<IXQEQueryNode>();
        this.getDataSourcesFromRQPQuery((RQPQuery)node, sources);
        if (sources.isEmpty()) {
            this.traceNodeCondition(false, "This RQPQuery does not refer directly to V5Sql queries.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "This RQPQuery refers to V5Sql queries.", xqeTrace);
        return true;
    }
}

