/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5JoinOperand;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5CoalesceFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.util.UniqueNameGenerator;

public class AdjustRQPQueryWithOuterJoins
extends RQPTransformation {
    public AdjustRQPQueryWithOuterJoins() {
        this.mName = "AdjustRQPQueryWithOuterJoins";
        this.mPassNumbers = new int[]{32};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPQuery leftRQPQuery = this.getRQPQueryUnderV5Source(environment, rqpQuery, 0);
        RQPQuery rightRQPQuery = this.getRQPQueryUnderV5Source(environment, rqpQuery, 1);
        SQLJoin.SubType joinType = this.getJoinType(environment, rqpQuery);
        RQPProjectionList projectionList = rqpQuery.getOrCreateProjectionList(environment);
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            if (!this.pushExpressionDown(projectionList.getChild(i))) continue;
            SQLAlias alias = (SQLAlias)projectionList.getChild(i);
            RQPDataItem dataItem = (RQPDataItem)alias.getChild(0);
            V5BoundDataItemReference leftDataItemRef = null;
            V5BoundDataItemReference rightDataItemRef = null;
            if (joinType == SQLJoin.SubType.LEFT_OUTER || joinType == SQLJoin.SubType.FULL_OUTER) {
                leftDataItemRef = this.pushConstantExpression(environment, leftRQPQuery, alias);
                if (joinType == SQLJoin.SubType.LEFT_OUTER) {
                    dataItem.getChild(0).detach();
                    dataItem.addChild(leftDataItemRef);
                }
            }
            if (joinType == SQLJoin.SubType.RIGHT_OUTER || joinType == SQLJoin.SubType.FULL_OUTER) {
                rightDataItemRef = this.pushConstantExpression(environment, rightRQPQuery, alias);
                if (joinType == SQLJoin.SubType.RIGHT_OUTER) {
                    dataItem.getChild(0).detach();
                    dataItem.addChild(rightDataItemRef);
                }
            }
            if (joinType != SQLJoin.SubType.FULL_OUTER) continue;
            V5CoalesceFunction sqlCoalesce = (V5CoalesceFunction)environment.getNodeFactory().createNode(201055);
            sqlCoalesce.addChild(leftDataItemRef);
            sqlCoalesce.addChild(rightDataItemRef);
            dataItem.getChild(0).detach();
            dataItem.addChild(sqlCoalesce);
        }
    }

    private RQPQuery getRQPQueryUnderV5Source(PlanningEnvironment environment, RQPQuery rqpQuery, int position) {
        V5Source v5Source = this.getV5Source(environment, rqpQuery);
        V5JoinOperation joinOperation = (V5JoinOperation)v5Source.getChild(0);
        String queryName = ((V5JoinOperand)joinOperation.getChild(position)).getQueryRef();
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(v5Source);
        V5Query v5Query = querySet.getV5Query(queryName);
        RQPQuery rqpQueryAtPosition = (RQPQuery)v5Query.getFirstChildByType(801017);
        return rqpQueryAtPosition;
    }

    private V5BoundDataItemReference pushConstantExpression(PlanningEnvironment environment, RQPQuery targetRQPQuery, SQLAlias alias) {
        String newName = RQPNameGenerator.generateUniqueRQPDataItemName(targetRQPQuery, alias.getName());
        SQLAlias newAlias = (SQLAlias)environment.getNodeFactory().deepCopyNode(alias);
        newAlias.setName(newName);
        targetRQPQuery.getProjectionList().addChild(newAlias);
        V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)environment.getNodeFactory().createNode(201060);
        dataItemRef.setIsQueryRefItem();
        dataItemRef.setIdentifier(UniqueNameGenerator.createUniqueName(targetRQPQuery.getName(), newName));
        return dataItemRef;
    }

    private V5Source getV5Source(PlanningEnvironment environment, RQPQuery rqpQuery) {
        V5Source v5Source = null;
        if (rqpQuery.getParent().getType() == 101006) {
            v5Source = ((V5Query)rqpQuery.getParent()).getV5Source();
        } else if (rqpQuery.getParent().getType() == 801041) {
            String queryName = rqpQuery.getName();
            IXQEQueryNode rootNode = environment.getRoot();
            if (rootNode.getType() == 101002) {
                V5QuerySet queryset = (V5QuerySet)rootNode;
                V5Query v5Query = queryset.getV5Query(queryName);
                v5Source = v5Query.getV5Source();
            }
        }
        return v5Source;
    }

    private SQLJoin.SubType getJoinType(PlanningEnvironment environment, RQPQuery rqpQuery) {
        V5Source v5Source = this.getV5Source(environment, rqpQuery);
        V5JoinOperation joinOperation = (V5JoinOperation)v5Source.getChild(0);
        return joinOperation.getJoinType();
    }

    public boolean pushExpressionDown(IXQEQueryNode expression) {
        if (expression.getDescendantsOfTypes(new int[]{201116, 201060, 801009, 101015}, false).length == 0) {
            return this.isFunctionToBePushed(expression);
        }
        return false;
    }

    public boolean isFunctionToBePushed(IXQEQueryNode expression) {
        switch (expression.getType()) {
            case 201040: 
            case 201041: 
            case 201042: {
                return true;
            }
        }
        if (expression.getNumberChildren() > 0) {
            for (IXQEQueryNode child : expression.getChildren()) {
                if (!this.isFunctionToBePushed(child)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Source v5Source = this.getV5Source(environment, (RQPQuery)node);
        if (v5Source == null) {
            return false;
        }
        if (v5Source.getNumberChildren() != 0 && v5Source.getChild(0).getType() == 101019) {
            RQPQuery leftRQPQuery = this.getRQPQueryUnderV5Source(environment, (RQPQuery)node, 0);
            RQPQuery rightRQPQuery = this.getRQPQueryUnderV5Source(environment, (RQPQuery)node, 1);
            if (leftRQPQuery == null || rightRQPQuery == null) {
                return false;
            }
            V5JoinOperation joinOperation = (V5JoinOperation)v5Source.getChild(0);
            SQLJoin.SubType joinType = joinOperation.getJoinType();
            if (joinType == SQLJoin.SubType.LEFT_OUTER || joinType == SQLJoin.SubType.RIGHT_OUTER || joinType == SQLJoin.SubType.FULL_OUTER) {
                IXQEQueryNode[] projections;
                RQPQuery rqpQuery = (RQPQuery)node;
                for (IXQEQueryNode projection : projections = rqpQuery.getProjectionList().getChildren()) {
                    if (!this.pushExpressionDown(projection)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

