/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPInnerJoinGroup;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.v5Exp.V5BoundSQLQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.relational.binding.BindSQLRelation;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindRelationNotFoundException;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ApplyJoinFilterOptimization;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Pair;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class BuildOuterJoins
extends RQPTransformation {
    public static final String BRACKET_INNER_JOIN = "bracketInnerJoin";

    public BuildOuterJoins() {
        this.mName = "Build outer joins";
        this.mPassNumbers = new int[]{31};
        this.mTypes = new int[]{801039};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getParent().getType() != 301043) {
            node.detach();
            return;
        }
        List<IMetadata> outer = ((RQPJoinPath)node).getOuterJoins();
        if (outer == null) {
            this.removeInnerJoinGroups(node);
            this.removeRQPJoinPathChild(node);
            node.extract();
            return;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ArrayList<IMetadata> outerJoins = new ArrayList<IMetadata>(outer);
        RQPInnerJoinGroup treeRoot = null;
        ArrayList<List<RQPInnerJoinGroup>> seenJoinedGroups = new ArrayList<List<RQPInnerJoinGroup>>();
        for (IMetadata join : outerJoins) {
            RQPInnerJoinGroup rightGroup;
            IRelationship relationShip = (IRelationship)join;
            RQPInnerJoinGroup leftGroup = this.findGroup(node, environment, relationShip.getLeftRefObject());
            if (this.haveTheseGroupsBeenJoined(leftGroup, rightGroup = this.findGroup(node, environment, relationShip.getRightRefObject()), seenJoinedGroups)) continue;
            if (leftGroup.getParentGroup() == null && rightGroup.getParentGroup() == null) {
                this.setParentAndChildForGroups(leftGroup, RQPInnerJoinGroup.Position.LEFT, rightGroup, RQPInnerJoinGroup.Position.RIGHT, relationShip);
            } else if (leftGroup.getParentGroup() != null && rightGroup.getParentGroup() != null) {
                this.reverseParentChildHierarchyInGroup(rightGroup);
                this.setParentAndChildForGroups(leftGroup, RQPInnerJoinGroup.Position.LEFT, rightGroup, RQPInnerJoinGroup.Position.RIGHT, relationShip);
            } else if (leftGroup.getParentGroup() != null) {
                this.setParentAndChildForGroups(leftGroup, RQPInnerJoinGroup.Position.LEFT, rightGroup, RQPInnerJoinGroup.Position.RIGHT, relationShip);
            } else {
                this.setParentAndChildForGroups(rightGroup, RQPInnerJoinGroup.Position.RIGHT, leftGroup, RQPInnerJoinGroup.Position.LEFT, relationShip);
            }
            if ((treeRoot = leftGroup.getRootParentGroup()) != null) continue;
            treeRoot = leftGroup;
        }
        RQPInnerJoinGroup start = this.computeJoinStartGroup(node, treeRoot);
        LinkedList<RQPInnerJoinGroup> stack = new LinkedList<RQPInnerJoinGroup>();
        this.buildOuterJoins(node, nodeFactory, start, environment, stack);
        this.bracketInnerJoinGroups(node);
        this.removeInnerJoinGroups(node);
        this.removeRQPJoinPathChild(node);
        node.extract();
    }

    private void removeInnerJoinGroups(IXQEQueryNode node) {
        IXQEQueryNode[] groups;
        for (IXQEQueryNode grp : groups = node.getDescendantsOfType(801040, false)) {
            grp.extract();
        }
    }

    private void bracketInnerJoinGroups(IXQEQueryNode node) {
        IXQEQueryNode[] groups;
        for (IXQEQueryNode grp : groups = node.getDescendantsOfType(801040, false)) {
            if (grp.getNumberChildren() <= 0) continue;
            grp.getChild(0).setPropertyValue(BRACKET_INNER_JOIN, Boolean.TRUE);
        }
    }

    private void removeRQPJoinPathChild(IXQEQueryNode node) {
        IXQEQueryNode child = node.getFirstChildByType(801039);
        if (child != null) {
            child.detach();
        }
    }

    private void setParentAndChildForGroups(RQPInnerJoinGroup parent, RQPInnerJoinGroup.Position parentPos, RQPInnerJoinGroup child, RQPInnerJoinGroup.Position childPos, IRelationship relationship) {
        parent.addChildGroup(child);
        parent.setPos(relationship, parentPos);
        child.setParentGroup(parent);
        child.setJoinToParent(relationship);
        child.setPos(relationship, childPos);
    }

    private void reverseParentChildHierarchyInGroup(RQPInnerJoinGroup child) {
        RQPInnerJoinGroup parent = child.getParentGroup();
        IRelationship joinToParent = child.getJoinToParent();
        RQPInnerJoinGroup.Position childPos = child.getPos(joinToParent);
        RQPInnerJoinGroup.Position parentPos = parent.getPos(joinToParent);
        if (null != parent.getParentGroup()) {
            this.reverseParentChildHierarchyInGroup(parent);
        }
        parent.removeChildGroup(child);
        parent.deletePos(joinToParent);
        child.deletePos(joinToParent);
        this.setParentAndChildForGroups(child, childPos, parent, parentPos, joinToParent);
    }

    private RQPInnerJoinGroup findGroup(IXQEQueryNode node, PlanningEnvironment environment, IMetadata ent) {
        boolean explicitShortcutProcessing;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (ent instanceof IShortcut && !RQPUtilities.isShortcutTreatedAsAlias(ent, explicitShortcutProcessing = RQPUtilities.getShortcutProcessing(environment))) {
            IShortcut sc = (IShortcut)ent;
            ent = sc.getTarget();
        }
        IXQEQueryNode[] groups = node.getChildrenOfType(801040);
        for (IXQEQueryNode group : groups) {
            if (!((RQPInnerJoinGroup)group).contains(ent, RQPUtilities.getShortcutProcessing(environment))) continue;
            return (RQPInnerJoinGroup)group;
        }
        RQPInnerJoinGroup newGroup = (RQPInnerJoinGroup)nodeFactory.createNode(801040);
        newGroup.getEntities().add(ent);
        RMQueryList rmQueryList = RQPUtilities.getRMQueryList(node);
        IXQEQueryNode sqlRel = RQPUtilities.getSQLRelationForJoin(node.getParent(), ent, rmQueryList);
        if (sqlRel == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "one side of a join has not been analyzed");
        }
        sqlRel.move(newGroup);
        node.addChild(newGroup);
        return newGroup;
    }

    private RQPInnerJoinGroup computeJoinStartGroup(IXQEQueryNode node, RQPInnerJoinGroup treeRoot) {
        treeRoot.setValue(0);
        ((RQPJoinPath)node).setStartGroup(treeRoot);
        this.markTree(treeRoot);
        RQPInnerJoinGroup start = (RQPInnerJoinGroup)((RQPJoinPath)node).getStartGroup();
        return start;
    }

    private void markTree(RQPInnerJoinGroup root) {
        List<RQPInnerJoinGroup> childrenGroup = root.getChildrenGroup();
        for (RQPInnerJoinGroup group : childrenGroup) {
            IRelationship join = group.getJoinToParent();
            SQLJoin.SubType joinType = this.getJoinType(join);
            int currentVal = root.getValue();
            if (joinType == SQLJoin.SubType.LEFT_OUTER) {
                if (root.getPos(join) == RQPInnerJoinGroup.Position.LEFT) {
                    group.setValue(--currentVal);
                } else {
                    group.setValue(++currentVal);
                }
            } else if (joinType == SQLJoin.SubType.RIGHT_OUTER) {
                if (root.getPos(join) == RQPInnerJoinGroup.Position.LEFT) {
                    group.setValue(++currentVal);
                } else {
                    group.setValue(--currentVal);
                }
            } else {
                group.setValue(currentVal);
            }
            this.trackStartGroup(group);
            this.markTree(group);
        }
    }

    private void trackStartGroup(RQPInnerJoinGroup group) {
        RQPJoinPath node = (RQPJoinPath)group.getAncestorOfType(801039);
        RQPInnerJoinGroup startGroup = (RQPInnerJoinGroup)node.getStartGroup();
        if (startGroup.getValue() < group.getValue()) {
            startGroup = group;
        } else if (startGroup.getValue() == group.getValue() && startGroup.getEntities().size() < group.getEntities().size()) {
            startGroup = group;
        }
        node.setStartGroup(startGroup);
    }

    private SQLJoin.SubType getJoinType(IRelationship join) {
        if (join.getLeftCardinality() == IRelationship.Cardinality.ZERO_MANY || join.getLeftCardinality() == IRelationship.Cardinality.ZERO_ONE) {
            if (join.getRightCardinality() == IRelationship.Cardinality.ZERO_MANY || join.getRightCardinality() == IRelationship.Cardinality.ZERO_ONE) {
                return SQLJoin.SubType.FULL_OUTER;
            }
            return SQLJoin.SubType.RIGHT_OUTER;
        }
        if (join.getRightCardinality() == IRelationship.Cardinality.ZERO_MANY || join.getRightCardinality() == IRelationship.Cardinality.ZERO_ONE) {
            return SQLJoin.SubType.LEFT_OUTER;
        }
        return SQLJoin.SubType.INNER;
    }

    private void buildOuterJoins(IXQEQueryNode node, IXQENodeFactory nodeFactory, RQPInnerJoinGroup startGrp, PlanningEnvironment environment, LinkedList<RQPInnerJoinGroup> stack) {
        stack.addLast(startGrp);
        ArrayList<RQPInnerJoinGroup> nextGroups = this.getGroups(startGrp, environment, stack);
        for (RQPInnerJoinGroup group : nextGroups) {
            if (group == null) continue;
            IRelationship join = null;
            join = group == startGrp.getParentGroup() ? startGrp.getJoinToParent() : group.getJoinToParent();
            SQLJoin topSQLJoin = (SQLJoin)node.getFirstChildByType(301011);
            if (topSQLJoin != null) {
                startGrp.setTopJoinNode(topSQLJoin);
            }
            IXQEQueryNode sqlJoin = this.buildOuterJoin(node, nodeFactory, join, startGrp, group, environment);
            node.addChild(sqlJoin);
            this.removeChild(startGrp, group, join);
            this.buildOuterJoins(node, nodeFactory, group, environment, stack);
        }
        stack.removeLast();
    }

    private void removeChild(RQPInnerJoinGroup start, RQPInnerJoinGroup next, IRelationship join) {
        if (start.getParentGroup() == next) {
            start.setParentGroup(null);
            start.setJoinToParent(null);
            next.getChildrenGroup().remove(start);
        } else {
            next.setParentGroup(null);
            next.setJoinToParent(null);
            start.getChildrenGroup().remove(next);
        }
    }

    private SQLJoin.SubType adjustJoinType(SQLJoin.SubType joinType, IRelationship join, RQPInnerJoinGroup start) {
        joinType = joinType == SQLJoin.SubType.RIGHT_OUTER && start.getPos(join) == RQPInnerJoinGroup.Position.LEFT ? SQLJoin.SubType.FULL_OUTER : (joinType == SQLJoin.SubType.LEFT_OUTER && start.getPos(join) == RQPInnerJoinGroup.Position.RIGHT ? SQLJoin.SubType.FULL_OUTER : (joinType == SQLJoin.SubType.FULL_OUTER ? SQLJoin.SubType.FULL_OUTER : SQLJoin.SubType.LEFT_OUTER));
        return joinType;
    }

    private IXQEQueryNode buildOuterJoin(IXQEQueryNode node, IXQENodeFactory nodeFactory, IRelationship join, RQPInnerJoinGroup start, RQPInnerJoinGroup next, PlanningEnvironment environment) {
        SQLJoin sqlJoin = (SQLJoin)nodeFactory.createNode(301011);
        SQLJoin.SubType joinType = this.getJoinType(join);
        joinType = this.adjustJoinType(joinType, join, start);
        ApplyJoinFilterOptimization.setJoinFilterProperties(environment, sqlJoin, join);
        sqlJoin.setJoinType(joinType);
        start.getTopJoinNode().move(sqlJoin);
        next.getTopJoinNode().move(sqlJoin);
        RQPJoinPath rqpJoinPath = (RQPJoinPath)node.getChild(0);
        IXQEQueryNode enode = rqpJoinPath.getParsedJoinExpression(join);
        if (join.isDummy()) {
            this.setStitchJoinHint(sqlJoin, environment);
            HashMap<String, IXQEQueryNode> joinPathToJoinExpression = rqpJoinPath.getJoinPathToJoinExpression();
            String key = join.getExpression();
            enode = joinPathToJoinExpression.get(key);
            if (enode == null) {
                enode = RQPUtilities.createV5ValueExpression(join, environment, (IXQEQueryNode)sqlJoin);
                List<IXQEQueryNode> multipartId = enode.getDescendantsOfTypeOrdered(201030, false);
                for (IXQEQueryNode currentNode : multipartId) {
                    V5BoundSQLQueryItemReference sqlQueryItemRef = (V5BoundSQLQueryItemReference)nodeFactory.createNode(201103);
                    sqlQueryItemRef.setIdentifier(((V5MultiPartIdentifier)currentNode).getIdentifier());
                    currentNode.exchange(sqlQueryItemRef);
                }
            }
            sqlJoin.addChild(enode);
        } else {
            enode.move(sqlJoin);
        }
        start.setTopJoinNode(sqlJoin);
        next.setTopJoinNode(sqlJoin);
        return sqlJoin;
    }

    private void setStitchJoinHint(SQLJoin sqlJoin, PlanningEnvironment environment) {
        if (environment.getMultiRequestContext().fetchBooleanConfiguration("queryPlanning.stitchJoinHintOnFullOuterJoin.[@enabled]", false)) {
            sqlJoin.setHint(SQLJoin.Hint.STITCH);
        }
    }

    private boolean haveTheseGroupsBeenJoined(RQPInnerJoinGroup leftGroup, RQPInnerJoinGroup rightGroup, List<List<RQPInnerJoinGroup>> seenJoinedGroups) {
        for (List<RQPInnerJoinGroup> pair : seenJoinedGroups) {
            if (!pair.contains(leftGroup) || !pair.contains(rightGroup)) continue;
            return true;
        }
        ArrayList<RQPInnerJoinGroup> joinedGroups = new ArrayList<RQPInnerJoinGroup>();
        joinedGroups.add(leftGroup);
        joinedGroups.add(rightGroup);
        seenJoinedGroups.add(joinedGroups);
        return false;
    }

    private ArrayList<RQPInnerJoinGroup> getNextGroups(RQPInnerJoinGroup startGrp, LinkedList<RQPInnerJoinGroup> stack) {
        ArrayList<RQPInnerJoinGroup> nextGroups = new ArrayList<RQPInnerJoinGroup>();
        RQPInnerJoinGroup a = startGrp.getParentGroup();
        if (a != null && !stack.contains(a)) {
            nextGroups.add(a);
        }
        for (RQPInnerJoinGroup c : startGrp.getChildrenGroup()) {
            if (c == null || stack.contains(c)) continue;
            nextGroups.add(c);
        }
        return nextGroups;
    }

    private ArrayList<RQPInnerJoinGroup> getGroups(RQPInnerJoinGroup startGrp, PlanningEnvironment environment, LinkedList<RQPInnerJoinGroup> stack) {
        ArrayList<RQPInnerJoinGroup> nextGroups = this.getNextGroups(startGrp, stack);
        HashSet<Object> startDSs = this.getDatasources(startGrp, environment);
        if (startDSs == null || startDSs.size() != 1 || startDSs.contains("storedProcedure")) {
            return nextGroups;
        }
        ArrayList<RQPInnerJoinGroup> groupsSameDS = new ArrayList<RQPInnerJoinGroup>();
        ArrayList<RQPInnerJoinGroup> groupsContainDS = new ArrayList<RQPInnerJoinGroup>();
        ArrayList<RQPInnerJoinGroup> groupsDiffDS = new ArrayList<RQPInnerJoinGroup>();
        for (RQPInnerJoinGroup grp : nextGroups) {
            if (grp == null) continue;
            HashSet<Object> grpDSs = new HashSet<Object>();
            if (!this.isLOJ(startGrp, grp, grpDSs, environment, stack) || grpDSs.isEmpty()) {
                return nextGroups;
            }
            if (startDSs.equals(grpDSs)) {
                groupsSameDS.add(grp);
                continue;
            }
            grpDSs.retainAll(startDSs);
            if (grpDSs.isEmpty()) {
                groupsDiffDS.add(grp);
                continue;
            }
            groupsContainDS.add(grp);
        }
        if (groupsSameDS.isEmpty() || groupsDiffDS.isEmpty()) {
            return nextGroups;
        }
        ArrayList<RQPInnerJoinGroup> rt = new ArrayList<RQPInnerJoinGroup>();
        rt.addAll(groupsSameDS);
        rt.addAll(groupsContainDS);
        rt.addAll(groupsDiffDS);
        return rt;
    }

    private boolean isLOJ(RQPInnerJoinGroup startGrp, RQPInnerJoinGroup grp, HashSet<Object> grpDSs, PlanningEnvironment environment, LinkedList<RQPInnerJoinGroup> stack) {
        IRelationship join = null;
        join = grp == startGrp.getParentGroup() ? startGrp.getJoinToParent() : grp.getJoinToParent();
        SQLJoin.SubType joinType = this.getJoinType(join);
        if ((joinType = this.adjustJoinType(joinType, join, startGrp)) != SQLJoin.SubType.LEFT_OUTER) {
            return false;
        }
        HashSet<Object> groupDSs = this.getDatasources(grp, environment);
        if (groupDSs == null || groupDSs.isEmpty()) {
            return false;
        }
        stack.addLast(grp);
        ArrayList<RQPInnerJoinGroup> nextGroups = this.getNextGroups(grp, stack);
        for (RQPInnerJoinGroup childgrp : nextGroups) {
            if (childgrp == null || this.isLOJ(grp, childgrp, grpDSs, environment, stack)) continue;
            stack.removeLast();
            return false;
        }
        stack.removeLast();
        grpDSs.addAll(groupDSs);
        return true;
    }

    private HashSet<Object> getDatasources(RQPInnerJoinGroup grp, PlanningEnvironment environment) {
        IXQEQueryNode[] nodes;
        HashSet<Object> rt = new HashSet<Object>();
        int[] types = new int[]{301016, 301012, 301061};
        for (IXQEQueryNode n : nodes = grp.getDescendantsOfTypes(types, false)) {
            if (n.getType() == 301061) {
                rt.add("storedProcedure");
                continue;
            }
            SQLRelation rel = (SQLRelation)n;
            if (rel instanceof SQLRelation && (rel.getModelDatasourceName() == null || rel.getModelDatasourceName().isEmpty())) continue;
            Pair p = null;
            try {
                p = BindSQLRelation.getDataSource(rel, environment, null);
            }
            catch (BindRelationNotFoundException e) {
                return null;
            }
            IDataSource ds = (IDataSource)p.getFirst();
            if (ds == null) {
                return null;
            }
            if ("PARQUET".equals(ds.getType())) {
                rt.add("PARQUET");
                continue;
            }
            rt.add(ds);
        }
        return rt;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getParent().getType() == 801039) {
            return false;
        }
        return node.getAncestorOfType(801032) == null;
    }
}

