/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSortItem;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5StringFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.ClobType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.List;

public class CastBlobToVarchar
extends RQPTransformation {
    private static final int VARCHAR_LENGTH = 1024;
    private static boolean alwaysCastWhenUseAsFunctionArgument = false;
    public static final String PROP_NEED_TO_ADJUST_VARCHARSIZE = "needToAdjustToVarcharSize";

    public CastBlobToVarchar() {
        this.mName = "CastBlobToVarchar ";
        this.mPassNumbers = new int[]{36};
        this.mTypes = new int[]{801017};
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (configuration != null) {
            alwaysCastWhenUseAsFunctionArgument = configuration.getBooleanProperty("queryPlanning.alwaysCastWhenUseAsFunctionArgument[@enabled]", false);
        }
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] childNodes;
        for (IXQEQueryNode childNode : childNodes = node.getDescendantsOfTypes(new int[]{201116, 201042, 801009}, false)) {
            if (!this.needCast(childNode, environment)) continue;
            this.castNode(childNode, environment);
        }
    }

    private void castNode(IXQEQueryNode node, PlanningEnvironment environment) {
        V5StringFunction function;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode child = node;
        IXQEQueryNode parent = node.getParent();
        int size = 1024;
        boolean needToAdjustVarcharSize = true;
        if (parent.getType() == 201041 && (function = (V5StringFunction)node.getParent()).getSubType() == 2) {
            if (function.getNumberChildren() == 2) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_SubstringForClob3rdArgMissing, function.getName());
            }
            V5LiteralValue to = (V5LiteralValue)function.getChild(2);
            Value toValue = to.getValue();
            size = toValue.getInteger();
            needToAdjustVarcharSize = false;
            if (size > 65535) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_SubstringForClob3rdArgLimit, function.getName());
            }
            child = function;
            parent = function.getParent();
        }
        SQLCast castExpr = (SQLCast)nodeFactory.createNode(301047);
        if (needToAdjustVarcharSize) {
            castExpr.setPropertyValue(PROP_NEED_TO_ADJUST_VARCHARSIZE, "true");
        }
        parent.addChild(castExpr, parent.getPositionOfChild(node));
        child.detach();
        SQLDataType dType = (SQLDataType)nodeFactory.createNode(301037);
        dType.setDataType(DataTypeFactory.getVarcharType(size));
        castExpr.addChild(child);
        castExpr.addChild(dType);
    }

    private boolean needCast(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        IXQEQueryNode expr = node;
        V5BoundModelIdentifier bmi = null;
        switch (node.getType()) {
            case 201042: {
                if (((V5GenericFunction)node).getDataType() == ClobType.CLOBTYPE) {
                    this.traceNodeCondition(true, "CastBlobToVarchar: function returning clob", xqeTrace);
                    return true;
                }
                this.traceNodeCondition(false, "CastBlobToVarchar, function does not return clob", xqeTrace);
                return false;
            }
            case 801009: {
                RQPDataItem dataItem = ((RQPDataItemRef)node).getReferencedItem();
                if (dataItem == null) {
                    this.traceNodeCondition(false, "RQP Data Item reference has no matching RQPDataItem.", xqeTrace);
                    return false;
                }
                expr = dataItem.getExpression();
                if (expr.getType() != 201116) {
                    this.traceNodeCondition(false, "The expression isn't a bound model identifier.", xqeTrace);
                    return false;
                }
                if (this.needCast(expr, environment)) {
                    this.traceNodeCondition(false, "The referenced item will be cast'ed.", xqeTrace);
                    return false;
                }
            }
            case 201116: {
                IXQEQueryNode sortList;
                XQEQueryNode function;
                bmi = (V5BoundModelIdentifier)expr;
                if (bmi.getDataType() != ClobType.CLOBTYPE) {
                    return false;
                }
                if (node.getParent().getType() == 301047 || node.getParent().getType() == 201051) {
                    this.traceNodeCondition(false, "CastBlobToVarchar: already cast'ed", xqeTrace);
                    return false;
                }
                if (node.getParent().getType() == 301033 && ((SQLFunction)(function = (SQLFunction)node.getParent())).getSubType() == SQLFunction.SubType.SUBSTRING) {
                    this.traceNodeCondition(false, "CastBlobToVarchar: already wrapped with substring 1", xqeTrace);
                    return false;
                }
                if (node.getParent().getType() == 201041 && ((V5SimpleNode)(function = (V5StringFunction)node.getParent())).getSubType() == 2 && (function.getParent().getType() == 301047 || function.getParent().getType() == 201051)) {
                    this.traceNodeCondition(false, "CastBlobToVarchar: already wrapped with cast(substring)", xqeTrace);
                    return false;
                }
                RQPDataItem dataItem = (RQPDataItem)node.getAncestorOfType(801008);
                if (dataItem == null) {
                    this.traceNodeCondition(false, "CastBlobToVarchar, not a projection", xqeTrace);
                    return false;
                }
                this.mTypes = new int[]{801017, 801025, 801024, 801012};
                RQPQuery parentRQPQuery = (RQPQuery)node.getAncestorOfTypes(this.mTypes);
                if (parentRQPQuery == null) {
                    this.traceNodeCondition(false, "CastBlobToVarchar: not under an RQPQuery", xqeTrace);
                    return false;
                }
                if (!alwaysCastWhenUseAsFunctionArgument && node.getParent().getType() == 201042) {
                    List<IDataType> funcDTs = V5GenericFunction.getPossibleDataTypesForArgument((V5GenericFunction)node.getParent(), node);
                    boolean completeLogic = false;
                    if (funcDTs.size() == 1 && (funcDTs.get(0).getSubType() == DataSubType.TEXTTYPE || funcDTs.get(0).getSubType() == DataSubType.STRINGTYPE)) {
                        completeLogic = true;
                    }
                    if (!completeLogic) {
                        this.traceNodeCondition(false, "CastBlobToVarchar: no cast when used within a generic function", xqeTrace);
                        return false;
                    }
                }
                String projectionName = dataItem.getName();
                IXQEQueryNode groupByList = parentRQPQuery.getFirstChildByType(801013);
                if (groupByList != null) {
                    for (int j = 0; j < groupByList.getNumberChildren(); ++j) {
                        RQPDataItemSelfRef groupingItem = (RQPDataItemSelfRef)groupByList.getChild(j);
                        if (!groupingItem.getName().equals(projectionName)) continue;
                        this.traceNodeCondition(true, "CastBlobToVarchar: groupBy on item", xqeTrace);
                        return true;
                    }
                }
                if ((sortList = parentRQPQuery.getFirstChildByType(801020)) != null) {
                    for (int j = 0; j < sortList.getNumberChildren(); ++j) {
                        RQPSortItem sortItem = (RQPSortItem)sortList.getChild(j);
                        SQLColumn column = (SQLColumn)sortItem.getChild(0);
                        if (!column.getName().equals(projectionName)) continue;
                        this.traceNodeCondition(true, "CastBlobToVarchar: sort on item", xqeTrace);
                        return true;
                    }
                }
                if (RQPUtilities.isIdentifierInAggregateFunction(node)) {
                    this.traceNodeCondition(true, "CastBlobToVarchar: under aggregate", xqeTrace);
                    return true;
                }
                if (!(node instanceof V5BoundModelIdentifier) || parentRQPQuery.getAncestorOfType(301043) == null) break;
                String identifier = ((V5BoundModelIdentifier)node).getIdentifier();
                IXQEQueryNode[] boundModelIdentifiers = parentRQPQuery.getDescendantsOfType(201116, false);
                for (int i = 0; i < boundModelIdentifiers.length; ++i) {
                    V5BoundModelIdentifier boundModelIdentifier = (V5BoundModelIdentifier)boundModelIdentifiers[i];
                    if (!boundModelIdentifier.getIdentifier().equals(identifier) || !RQPUtilities.isIdentifierInAggregateFunction(boundModelIdentifiers[i])) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (node != ((RQPQuery)node).getRootRQPQuery()) {
            return false;
        }
        RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = requestEnvironment.getRequestParameters();
        if (parameters.hasUnresolvedParameters()) {
            this.traceNodeCondition(false, "Need to resolve parameters", xqeTrace);
            return false;
        }
        IXQEQueryNode[] childNodes = node.getDescendantsOfTypes(new int[]{201116, 201042, 801009}, false);
        boolean hasBlobColumn = false;
        for (IXQEQueryNode childNode : childNodes) {
            IDataType dataType = null;
            if (childNode.getNodeType() == 201116) {
                dataType = ((V5BoundModelIdentifier)childNode).getDataType();
            } else if (childNode.getNodeType() == 201042) {
                dataType = ((V5GenericFunction)childNode).getDataType();
            }
            if (dataType != ClobType.CLOBTYPE) continue;
            hasBlobColumn = true;
            break;
        }
        if (!hasBlobColumn) {
            return false;
        }
        for (IXQEQueryNode childNode : childNodes) {
            if (!this.needCast(childNode, environment)) continue;
            return true;
        }
        this.traceNodeCondition(false, "CastBlobToVarchar, no need to cast", xqeTrace);
        return false;
    }
}

