/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLColumnStar;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.HashMap;

public class CollapseSimpleCommonTable
extends RQPTransformation {
    public CollapseSimpleCommonTable() {
        this.mName = "Collapse Simple Common Table";
        this.mPassNumbers = new int[]{65};
        this.mTypes = new int[]{301022};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ArrayList<IXQEQueryNode> nodeToRemoved = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode child = children[i];
            if (!CollapseSimpleCommonTable.isSimpleCommonTable(child)) continue;
            nodeToRemoved.add(child);
            for (int j = i + 1; j < children.length; ++j) {
                this.replaceSQLRelationAndSQLColumn(nodeFactory, child, children[j]);
            }
        }
        for (IXQEQueryNode del : nodeToRemoved) {
            del.detach();
        }
        if (node.getNumberChildren() == 1) {
            node.extract();
        }
    }

    protected void replaceSQLRelationAndSQLColumn(XQENodeFactory nodeFactory, IXQEQueryNode sqlRangeVar, IXQEQueryNode node) {
        IXQEQueryNode[] targetRelations;
        IXQEQueryNode[] srcRelations = sqlRangeVar.getDescendantsOfType(301016, false);
        SQLRelation srcSQLRelation = (SQLRelation)srcRelations[0];
        IXQEQueryNode[] alias = sqlRangeVar.getDescendantsOfType(301028, false);
        String sqlVarName = ((SQLRangeVar)sqlRangeVar).getName();
        boolean bReplaced = false;
        ArrayList<SQLColumnStar> columnStars = new ArrayList<SQLColumnStar>();
        for (IXQEQueryNode r : targetRelations = node.getDescendantsOfType(301016, false)) {
            SQLRelation targetRelation = (SQLRelation)r;
            if (targetRelation.isDatabaseTable() || !sqlVarName.equals(targetRelation.getName())) continue;
            bReplaced = true;
            SQLColumnStar sqlColumnStar = this.getSQLColumnStar(targetRelation);
            if (sqlColumnStar != null) {
                columnStars.add(sqlColumnStar);
            }
            srcSQLRelation.copyPropertiesTo(targetRelation);
            IXQEQueryNode newTabAlias = nodeFactory.copyNode(sqlRangeVar);
            targetRelation.insertParent(newTabAlias);
        }
        if (!bReplaced) {
            return;
        }
        HashMap<String, SQLColumn> lookUpMap = new HashMap<String, SQLColumn>();
        for (IXQEQueryNode a : alias) {
            SQLAlias sqlAlias = (SQLAlias)a;
            lookUpMap.put(sqlAlias.getName(), (SQLColumn)sqlAlias.getChild(0));
        }
        IXQEQueryNode[] targetColumns = node.getDescendantsOfType(301005, false);
        for (IXQEQueryNode c : targetColumns) {
            SQLColumn targetColumn = (SQLColumn)c;
            if (!sqlVarName.equals(targetColumn.getTableName())) continue;
            String colName = targetColumn.getName();
            SQLColumn srcCol = (SQLColumn)lookUpMap.get(colName);
            srcCol.copyPropertiesTo(targetColumn);
            targetColumn.setTableName(sqlVarName);
        }
        for (SQLColumnStar cStar : columnStars) {
            IXQEQueryNode parent = cStar.getParent();
            cStar.detach();
            for (IXQEQueryNode a : alias) {
                SQLAlias sqlAlias = (SQLAlias)a;
                IXQEQueryNode newSQLAlias = nodeFactory.deepCopyNode(sqlAlias);
                parent.addChild(newSQLAlias);
                SQLColumn targetColumn = (SQLColumn)newSQLAlias.getChild(0);
                targetColumn.setTableName(sqlVarName);
            }
        }
    }

    protected SQLColumnStar getSQLColumnStar(SQLRelation relation) {
        IXQEQueryNode[] vlist = relation.getParent().getChildrenOfType(301030);
        if (vlist.length != 1) {
            return null;
        }
        IXQEQueryNode[] children = vlist[0].getChildren();
        if (children.length != 1 || children[0].getType() != 301006) {
            return null;
        }
        return (SQLColumnStar)children[0];
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode child;
        IXQEQueryNode[] children;
        boolean bHasSimpleCommonTable = false;
        IXQEQueryNode[] iXQEQueryNodeArray = children = node.getChildren();
        int n = iXQEQueryNodeArray.length;
        for (int i = 0; i < n && !(bHasSimpleCommonTable = CollapseSimpleCommonTable.isSimpleCommonTable(child = iXQEQueryNodeArray[i])); ++i) {
        }
        XQETrace trace = environment.getTrace();
        if (bHasSimpleCommonTable) {
            this.traceQueryCondition(true, "At least one Simple Common Table in WITH clause.", trace);
        } else {
            this.traceQueryCondition(false, "No Simple Common Table in WITH clause.", trace);
        }
        return bHasSimpleCommonTable;
    }

    protected static boolean isSimpleCommonTable(IXQEQueryNode node) {
        IXQEQueryNode[] alias;
        int type = node.getType();
        if (type != 301007 || ((SQLRangeVar)node).getReusableQuery() != null) {
            return false;
        }
        IXQEQueryNode[] children = node.getChildren();
        if (children.length != 1 || children[0].getType() != 301015) {
            return false;
        }
        IXQEQueryNode proj = children[0];
        IXQEQueryNode[] var = proj.getChildrenOfType(301007);
        if (var.length != 1) {
            return false;
        }
        IXQEQueryNode[] relation = var[0].getChildren();
        if (relation.length != 1 || relation[0].getType() != 301016) {
            return false;
        }
        if (!((SQLRelation)relation[0]).isDatabaseTable()) {
            return false;
        }
        IXQEQueryNode[] vList = proj.getChildrenOfType(301030);
        if (vList.length != 1) {
            return false;
        }
        for (IXQEQueryNode a : alias = vList[0].getChildren()) {
            if (a.getType() != 301028) {
                return false;
            }
            IXQEQueryNode[] col = a.getChildren();
            if (col.length == 1 && col[0].getType() == 301005) continue;
            return false;
        }
        return true;
    }
}

