/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Set;

public class ConnectToRelationalDatabase
extends RQPTransformation {
    public ConnectToRelationalDatabase(int[] passNumbers) {
        this.mName = "ConnectToRelationalDatabase";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{101002};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet rootQuerySet = (V5QuerySet)node;
        Set<IDataSource> dataSources = rootQuerySet.getDataSources();
        if (dataSources != null) {
            RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
            ExecutionEnvironment executionEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
            if (executionEnv.getMetadataConnection() == null) {
                executionEnv.setMetdataConnection(environment.getMetadataConnection());
            }
            boolean throwUnresolvedParameterException = false;
            for (IDataSource dataSource : dataSources) {
                if (dataSource.getType() == null) continue;
                try {
                    if (!DataSourceTypeEnum.isJDBC(dataSource.getType())) continue;
                    IDataSourceCapabilities capabilities = null;
                    if (!requestEnv.isGetParametersRequest()) {
                        capabilities = ProviderCapabilites.getInstance().getOrAddDatasourceCapabilities(dataSource);
                        if (capabilities == null) {
                            capabilities = ConnectionUtil.getCapabilitiesFromJDBCConnection(executionEnv, dataSource);
                        }
                    } else {
                        IPooledConnection pooledConnection = null;
                        try {
                            pooledConnection = ConnectionUtil.getPooledConnection(executionEnv, dataSource);
                            JDBCConnection jdbcConnection = (JDBCConnection)pooledConnection.getConnection();
                            capabilities = jdbcConnection.getCapabilities();
                        }
                        finally {
                            if (pooledConnection != null) {
                                pooledConnection.returnConnection();
                            }
                        }
                    }
                    int maxColumnNameLength = 0;
                    int maxTableNameLength = 0;
                    if (capabilities != null) {
                        maxColumnNameLength = capabilities.getIntegerValue("limits.maxColumnNameLength");
                        maxTableNameLength = capabilities.getIntegerValue("limits.maxTableNameLength");
                    }
                    if (maxColumnNameLength != 0) {
                        rootQuerySet.setMaxColumnNameLength(maxColumnNameLength);
                    } else {
                        rootQuerySet.setMaxColumnNameLength(18);
                    }
                    if (maxTableNameLength != 0) {
                        rootQuerySet.setMaxTableNameLength(maxTableNameLength);
                        continue;
                    }
                    rootQuerySet.setMaxTableNameLength(18);
                }
                finally {
                    if (throwUnresolvedParameterException || !requestEnv.isGetParametersRequest()) continue;
                    IXQEQueryNode rootNode = environment.getRoot();
                    boolean dmrQueryExploredThroughThePrePlan = false;
                    if (rootNode.getType() == 101002) {
                        IXQEQueryNode[] v5Queries;
                        for (IXQEQueryNode q : v5Queries = rootNode.getChildrenOfType(101006)) {
                            V5Query v5Query = (V5Query)q;
                            if (!v5Query.isDMR()) continue;
                            dmrQueryExploredThroughThePrePlan = true;
                        }
                    }
                    if (dmrQueryExploredThroughThePrePlan) continue;
                    throwUnresolvedParameterException = true;
                }
            }
            if (throwUnresolvedParameterException) {
                throw new UnresolvedParameterException(requestEnv, null, requestEnv.getRequestParameters().getUnresolvedParameters());
            }
        }
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        V5QuerySet rootQuerySet = (V5QuerySet)node;
        Set<IDataSource> dataSources = rootQuerySet.getDataSources();
        if (dataSources != null) {
            this.traceNodeCondition(true, "dataSources to connect.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "No dataSources to connect.", xqeTrace);
        return false;
    }
}

