/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPInnerJoinGroup;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.sql.SQLFromClause;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ApplyJoinFilterOptimization;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.itemNormalization.ItemNormalization;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ConvertJoinPathToSQL
extends RQPTransformation {
    public ConvertJoinPathToSQL() {
        this.mName = "Convert Join Path to SQL AST.";
        this.mPassNumbers = new int[]{30};
        this.mTypes = new int[]{801040};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IMetadata> joinPath = ((RQPInnerJoinGroup)node).getJoinPath();
        RMQueryList rmQueryList = RQPUtilities.getRMQueryList(node);
        Map<IMetadata, IMetadata> joinedEntity2Target = this.getJoinedEntityToTarget(environment, joinPath);
        HashSet<IMetadata> querySubjects = new HashSet<IMetadata>();
        IXQEQueryNode joinPredicate = null;
        while (!joinPath.isEmpty()) {
            IRelationship joinRelationshipToAdd = this.getNextJoin(joinPath, joinedEntity2Target, querySubjects);
            IXQEQueryNode joinToBeAdded = this.buildOneSQLJoin(joinedEntity2Target, node.getParent(), joinRelationshipToAdd, SQLJoin.SubType.INNER, rmQueryList, joinPredicate, environment);
            querySubjects.add(joinedEntity2Target.get(joinRelationshipToAdd.getLeftRefObject()));
            querySubjects.add(joinedEntity2Target.get(joinRelationshipToAdd.getRightRefObject()));
            joinPath.remove(joinRelationshipToAdd);
            this.mergeTwoSQLJoins(joinToBeAdded, joinPredicate);
            joinPredicate = joinToBeAdded;
        }
        node.addChild(joinPredicate);
    }

    private IRelationship getNextJoin(List<IMetadata> joinPath, Map<IMetadata, IMetadata> joinedEntity2Target, HashSet<IMetadata> querySubjects) {
        for (IMetadata join : joinPath) {
            IRelationship relationship = (IRelationship)join;
            IMetadata leftQS = joinedEntity2Target.get(relationship.getLeftRefObject());
            IMetadata rightQS = joinedEntity2Target.get(relationship.getRightRefObject());
            if (!querySubjects.isEmpty() && !querySubjects.contains(leftQS) && !querySubjects.contains(rightQS)) continue;
            return relationship;
        }
        return null;
    }

    private IXQEQueryNode buildOneSQLJoin(Map<IMetadata, IMetadata> joinedEntity2Target, IXQEQueryNode rqpJoinPathNode, IRelationship relationship, SQLJoin.SubType joinType, RMQueryList rmQueryList, IXQEQueryNode childSQLJoin, PlanningEnvironment environment) {
        IXQEQueryNode joinExpr;
        RMQuery rmQuery;
        IXQEQueryNode tempRelation;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RQPJoinPath rqpJoinPath = (RQPJoinPath)rqpJoinPathNode;
        SQLFromClause fromClause = (SQLFromClause)rqpJoinPath.getParent();
        SQLJoin join = (SQLJoin)nodeFactory.createNode(301011);
        join.setJoinType(joinType);
        IMetadata leftQuerySubject = ItemNormalization.getSourceQuerySubject(relationship.getLeftRefObject(), joinedEntity2Target);
        IMetadata rightQuerySubject = ItemNormalization.getSourceQuerySubject(relationship.getRightRefObject(), joinedEntity2Target);
        IXQEQueryNode leftRelation = RQPUtilities.getSQLRelationForJoin(fromClause, leftQuerySubject, rmQueryList);
        IXQEQueryNode rightRelation = RQPUtilities.getSQLRelationForJoin(fromClause, rightQuerySubject, rmQueryList);
        ApplyJoinFilterOptimization.setJoinFilterProperties(environment, join, relationship);
        if (leftRelation == null) {
            tempRelation = null;
            if (childSQLJoin != null) {
                tempRelation = RQPUtilities.getSQLRelationForJoin(childSQLJoin, leftQuerySubject, rmQueryList);
            }
            if (tempRelation == null && leftQuerySubject instanceof IShortcut) {
                rmQuery = rmQueryList.getRMQuery(leftQuerySubject);
                tempRelation = rmQuery.getFirstChildByType(301007);
            }
            if (tempRelation != null) {
                leftRelation = nodeFactory.deepCopyNode(tempRelation);
            }
        }
        if (rightRelation == null) {
            tempRelation = null;
            if (childSQLJoin != null) {
                tempRelation = RQPUtilities.getSQLRelationForJoin(childSQLJoin, rightQuerySubject, rmQueryList);
            }
            if (tempRelation == null && rightQuerySubject instanceof IShortcut) {
                rmQuery = rmQueryList.getRMQuery(rightQuerySubject);
                tempRelation = rmQuery.getFirstChildByType(301007);
            }
            if (tempRelation != null) {
                rightRelation = nodeFactory.deepCopyNode(tempRelation);
            }
        }
        if ((joinExpr = ((RQPJoinPath)rqpJoinPath.getChild(0)).getParsedJoinExpression(relationship)) != null) {
            String modelQueryStr = "modelQuery";
            if (leftRelation == null && ((IQuerySubject)leftQuerySubject).getDefinitionType().equals("modelQuery")) {
                leftQuerySubject = ((V5BoundModelIdentifier)joinExpr.getChild(0)).getQuerySubject();
                leftRelation = RQPUtilities.getSQLRelationForJoin(fromClause, leftQuerySubject, rmQueryList);
            }
            if (rightRelation == null && ((IQuerySubject)rightQuerySubject).getDefinitionType().equals("modelQuery")) {
                rightQuerySubject = ((V5BoundModelIdentifier)joinExpr.getChild(1)).getQuerySubject();
                rightRelation = RQPUtilities.getSQLRelationForJoin(fromClause, rightQuerySubject, rmQueryList);
            }
        }
        this.createOneJoinPart(join, leftQuerySubject, leftRelation, rmQueryList, nodeFactory);
        this.createOneJoinPart(join, rightQuerySubject, rightRelation, rmQueryList, nodeFactory);
        if (joinExpr != null) {
            joinExpr.move(join);
        }
        join.setLeftCardinality(relationship.getLeftCardinality());
        join.setRightCardinality(relationship.getRightCardinality());
        return join;
    }

    protected void createOneJoinPart(SQLJoin join, IMetadata aQuerySubject, IXQEQueryNode aRelation, RMQueryList rmQueryList, IXQENodeFactory nodeFactory) {
        if (aRelation != null) {
            if (aRelation.getParent() != null) {
                aRelation.move(join);
            } else {
                join.addChild(aRelation);
            }
        } else {
            RMQuery rmQuery = rmQueryList.getRMQuery(aQuerySubject);
            if (rmQuery != null) {
                IXQEQueryNode sourceAST = rmQuery.getSQLForQuerySubject(nodeFactory);
                join.addChild(sourceAST);
            }
        }
    }

    private void mergeTwoSQLJoins(IXQEQueryNode joinToBeAdded, IXQEQueryNode joinPredicate) {
        String sqlRangevarName;
        IXQEQueryNode p;
        SQLRangeVar s;
        if (joinPredicate == null) {
            return;
        }
        String parentLeftRangevarName = (String)joinToBeAdded.getChild(0).getPropertyValue("name");
        String parentRightRangevarName = (String)joinToBeAdded.getChild(1).getPropertyValue("name");
        List<IXQEQueryNode> childSQLRangevars = joinPredicate.getDescendantsOfTypeOrdered(301007, false);
        Boolean qualifiedSQLRangevar = true;
        for (IXQEQueryNode childSQLRangevar : childSQLRangevars) {
            s = (SQLRangeVar)childSQLRangevar;
            for (p = s.getParent(); p != null; p = p.getParent()) {
                if (p.getType() != 301011) {
                    qualifiedSQLRangevar = false;
                    break;
                }
                qualifiedSQLRangevar = true;
            }
            if (!qualifiedSQLRangevar.booleanValue() || !(sqlRangevarName = (String)s.getPropertyValue("name")).equals(parentLeftRangevarName)) continue;
            joinToBeAdded.getChild(0).exchange(joinPredicate);
            return;
        }
        for (IXQEQueryNode childSQLRangevar : childSQLRangevars) {
            s = (SQLRangeVar)childSQLRangevar;
            for (p = s.getParent(); p != null; p = p.getParent()) {
                if (p.getType() != 301011) {
                    qualifiedSQLRangevar = false;
                    break;
                }
                qualifiedSQLRangevar = true;
            }
            if (!qualifiedSQLRangevar.booleanValue() || !(sqlRangevarName = (String)s.getPropertyValue("name")).equals(parentRightRangevarName)) continue;
            joinToBeAdded.getChild(1).exchange(joinPredicate);
            joinPredicate.move(joinToBeAdded, 0);
            return;
        }
    }

    private Map<IMetadata, IMetadata> getJoinedEntityToTarget(PlanningEnvironment environment, List<IMetadata> joinPath) {
        boolean explicitShortcutProcessing = RQPUtilities.getShortcutProcessing(environment);
        HashMap<IMetadata, IMetadata> ent2Target = new HashMap<IMetadata, IMetadata>();
        for (IMetadata jn : joinPath) {
            IShortcut sc;
            IRelationship join = (IRelationship)jn;
            IMetadata leftRefObj = join.getLeftRefObject();
            IMetadata rightRefObj = join.getRightRefObject();
            if (leftRefObj instanceof IShortcut) {
                if (RQPUtilities.isShortcutTreatedAsAlias(leftRefObj, explicitShortcutProcessing)) {
                    ent2Target.put(leftRefObj, leftRefObj);
                } else {
                    sc = (IShortcut)leftRefObj;
                    ent2Target.put(leftRefObj, sc.getTarget());
                }
            } else {
                ent2Target.put(leftRefObj, leftRefObj);
            }
            if (rightRefObj instanceof IShortcut) {
                if (RQPUtilities.isShortcutTreatedAsAlias(rightRefObj, explicitShortcutProcessing)) {
                    ent2Target.put(rightRefObj, rightRefObj);
                    continue;
                }
                sc = (IShortcut)rightRefObj;
                ent2Target.put(rightRefObj, sc.getTarget());
                continue;
            }
            ent2Target.put(rightRefObj, rightRefObj);
        }
        return ent2Target;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IMetadata> joinPath = ((RQPInnerJoinGroup)node).getJoinPath();
        if (joinPath == null || joinPath.isEmpty()) {
            XQETrace xqeTrace = environment.getTrace();
            this.traceNodeCondition(false, "There is no JoinPath to process in RQPInnerJoinGroup.", xqeTrace);
            return false;
        }
        return node.getAncestorOfType(801032) == null;
    }
}

