/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.GenerateCTEInWithClauseForRQPSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CreateUniqueValidSqlIdentifierForSqlRangeVar
extends RQPTransformation {
    private static final String TRANSFORMATION_HAS_BEEN_DONE = "CreateUniqeValidSqlIdentifierForSqlRangeVarDone";

    public CreateUniqueValidSqlIdentifierForSqlRangeVar() {
        this.mName = "Create valid SQL identifier for SqlRangeVar.";
        this.mPassNumbers = new int[]{61};
        this.mTypes = new int[]{801041};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String oldName;
        int j;
        IXQEQueryNode rangeVar;
        int govMaxLength;
        List<IXQEQueryNode> allRangeVars = node.getDescendantsOfTypesOrdered(new int[]{301007, 301004}, false);
        ArrayList<IXQEQueryNode> rangeVars = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode rv : allRangeVars) {
            IXQEQueryNode child;
            if (rv.getType() == 301004 && (rv.getPropertyValue("typedInSQLRootNode") == null || rv.getPropertyValue("name") == null || (child = rv.getChild(0)).getType() == 301012 && ((SQLNativeSql)child).isPassThrough())) continue;
            rangeVars.add(rv);
        }
        int maxLength = RQPUtilities.getMaxTableNameLength(environment);
        if (maxLength > 0 && (govMaxLength = node.getGovernors().getMaxTableNameLength()) != 0) {
            maxLength = govMaxLength;
        }
        HashSet<String> validNames = new HashSet<String>();
        HashSet<String> duplicatedRangeVars = new HashSet<String>();
        for (int i = 0; i < rangeVars.size(); ++i) {
            rangeVar = (IXQEQueryNode)rangeVars.get(i);
            String rangeVarName = (String)rangeVar.getPropertyValue("name");
            if (!RQPNameGenerator.isValidSqlIdentifier(rangeVarName, maxLength)) continue;
            if (validNames.contains(rangeVarName)) {
                duplicatedRangeVars.add(rangeVarName);
            }
            validNames.add(rangeVarName);
        }
        for (j = rangeVars.size() - 1; j >= 0; --j) {
            rangeVar = (IXQEQueryNode)rangeVars.get(j);
            oldName = (String)rangeVar.getPropertyValue("name");
            if (validNames.contains(oldName)) continue;
            this.modifyCorrelationName(maxLength, validNames, j, rangeVar, oldName);
        }
        for (j = rangeVars.size() - 1; j >= 0; --j) {
            rangeVar = (IXQEQueryNode)rangeVars.get(j);
            oldName = (String)rangeVar.getPropertyValue("name");
            IXQEQueryNode parent = rangeVar.getParent();
            if (parent == null || parent.getType() != 301022 || parent.getPropertyValue("createdForCognosSQL") == null || !this.existSameTableNameInFromClauseOf(rangeVar) && !duplicatedRangeVars.contains(oldName)) continue;
            this.modifyCorrelationName(maxLength, validNames, j, rangeVar, oldName);
        }
        ((RQPSql)node).setMaxTableNameLength(maxLength);
        node.setPropertyValue(TRANSFORMATION_HAS_BEEN_DONE, "");
    }

    private void modifyCorrelationName(int maxLength, HashSet<String> validNames, int index, IXQEQueryNode rangeVar, String oldName) {
        String newName = RQPNameGenerator.getUniqueColumnOrTableName(validNames, oldName, index, maxLength, true);
        if (rangeVar.getType() == 301004) {
            SQLQueryItemList bindItems = ((SQLQueryBlock)rangeVar).getQueryItemList();
            for (SQLQueryItem item : bindItems) {
                item.setTableName(newName);
            }
        }
        this.updateCorrelationName(rangeVar, newName);
        rangeVar.setPropertyValue("name", newName);
        rangeVar.setPropertyValue("originalName", oldName);
    }

    public static IDataSource getDataSource(IXQEQueryNode node, PlanningEnvironment planningEnv) {
        SQLRangeVar sqlRangeVar;
        IDataSource dataSource = null;
        String databaseName = null;
        SQLIdentifier identifierNode = null;
        int[] types = new int[]{301016, 301061};
        IXQEQueryNode[] sqlIdNodes = node.getDescendantsOfTypes(types, true);
        if (sqlIdNodes.length > 0) {
            identifierNode = (SQLIdentifier)sqlIdNodes[0];
        }
        if (identifierNode == null && (sqlRangeVar = (SQLRangeVar)node.getFirstDescendantOfTypeOrdered(301007, true)) != null && sqlRangeVar.getChild(0) != null && sqlRangeVar.getChild(0) instanceof SQLIdentifier) {
            return sqlRangeVar.getDataSource();
        }
        if (identifierNode != null && (dataSource = (databaseName = identifierNode.getDatabaseName()) == null ? identifierNode.getDataSource() : SQLBinderUtil.findOrCreateDataSource(planningEnv, identifierNode)) == null) {
            SQLQueryBlock qblockNode = (SQLQueryBlock)node.getFirstDescendantOfTypeOrdered(301004, false);
            if (qblockNode != null) {
                dataSource = qblockNode.getDataSource();
            }
            if (dataSource == null) {
                IXQEQueryNode r;
                IXQEQueryNode[] relations;
                IXQEQueryNode[] iXQEQueryNodeArray = relations = node.getDescendantsOfType(301016, false);
                int n = iXQEQueryNodeArray.length;
                for (int i = 0; i < n && (dataSource = (databaseName = (identifierNode = (SQLRelation)(r = iXQEQueryNodeArray[i])).getDatabaseName()) == null ? identifierNode.getDataSource() : SQLBinderUtil.findOrCreateDataSource(planningEnv, identifierNode)) == null; ++i) {
                }
            }
        }
        return dataSource;
    }

    private boolean existSameTableNameInFromClauseOf(IXQEQueryNode inputRangeVar) {
        IXQEQueryNode[] children;
        String lowerCaseName = ((String)inputRangeVar.getPropertyValue("name")).toLowerCase();
        if (inputRangeVar.getChild(0).getType() == 301012 && !((SQLNativeSql)inputRangeVar.getChild(0)).isPassThrough()) {
            String sqlText = ((SQLNativeSql)inputRangeVar.getChild(0)).getSqlString();
            String upperCaseName = lowerCaseName.toUpperCase();
            return sqlText.indexOf(lowerCaseName) != -1 || sqlText.indexOf(upperCaseName) != -1;
        }
        for (IXQEQueryNode child : children = inputRangeVar.getDescendantsOfTypes(new int[]{301016, 301007}, false)) {
            if (!(child.getType() == 301016 ? ((SQLRelation)child).getName().toLowerCase().equals(lowerCaseName) : ((SQLRangeVar)child).getName().toLowerCase().equals(lowerCaseName))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object done = node.getPropertyValue(TRANSFORMATION_HAS_BEEN_DONE);
        return done == null;
    }

    private void updateCorrelationName(IXQEQueryNode rangeVar, String newTableName) {
        String oldName = (String)rangeVar.getPropertyValue("name");
        IXQEQueryNode parent = rangeVar.getParent();
        if (parent == null) {
            return;
        }
        if (parent.getType() == 301022) {
            Object sqlRelation = rangeVar.getPropertyValue("sqlRelationReference");
            if (sqlRelation != null) {
                this.updateSQLColumnsWithinParentQuery((SQLRelation)sqlRelation, newTableName);
                ((SQLRelation)sqlRelation).setName(newTableName);
                rangeVar.removeProperty("sqlRelationReference");
            }
            int childrenOfSqlWith = parent.getNumberChildren();
            int ctePositionInWithClause = GenerateCTEInWithClauseForRQPSubQuery.getCtePositionInWithClause(rangeVar);
            for (int i = ctePositionInWithClause + 1; i < childrenOfSqlWith; ++i) {
                IXQEQueryNode cteToUpdate = parent.getChild(i);
                List<IXQEQueryNode> allRelations = cteToUpdate.getDescendantsOfTypeOrdered(301016, false);
                List<Object> relations = new ArrayList();
                if (cteToUpdate instanceof SQLRangeVar) {
                    SQLRangeVar aRangeVar = (SQLRangeVar)cteToUpdate;
                    for (IXQEQueryNode relation : allRelations) {
                        SQLRelation aRelation = (SQLRelation)relation;
                        if (aRelation.getDatabaseName() != null) continue;
                        relations.add(relation);
                    }
                } else {
                    relations = allRelations;
                }
                for (IXQEQueryNode iXQEQueryNode : relations) {
                    IXQEQueryNode relation;
                    relation = (SQLRelation)iXQEQueryNode;
                    if (!((SQLIdentifier)relation).getName().equals(oldName) || ((SQLRelation)relation).isDatabaseTable() || !((SQLRelation)relation).isEligibleForRenaming(rangeVar)) continue;
                    SQLRangeVar sqlRangeVar = (SQLRangeVar)((XQEBaseQueryNode)relation).getAncestorOfType(301007);
                    if (sqlRangeVar != null && sqlRangeVar.getSubQueryType() != null && sqlRangeVar.getSubQueryType().equals((Object)SQLRangeVar.PropertySubqueryTypeEnum.SIMPLE_DBQUERY) && !sqlRangeVar.hasChildOfType(301018)) {
                        oldName = (String)sqlRangeVar.getPropertyValue("name");
                        sqlRangeVar.setPropertyValue("name", newTableName);
                    } else {
                        ((SQLIdentifier)relation).setName(newTableName);
                    }
                    List<IXQEQueryNode> columns = cteToUpdate.getDescendantsOfTypeOrdered(301005, false);
                    this.updateTableNameInSqlColumns(oldName, newTableName, columns);
                }
            }
            return;
        }
        this.updateSQLColumnsWithinParentQuery(rangeVar, newTableName);
    }

    private void updateSQLColumnsWithinParentQuery(IXQEQueryNode rangeVar, String newTableName) {
        SQLRangeVar sqlRangeVar;
        ArrayList<String> lateralRangeVarNames;
        int[] types = new int[]{301007, 301018, 301026, 301076, 801017, 801041};
        IXQEQueryNode ancestor = rangeVar;
        IXQEQueryNode parent = rangeVar.getParent();
        while (!parent.isOfTypes(types)) {
            ancestor = parent;
            parent = parent.getParent();
        }
        List<IXQEQueryNode> columns = ancestor.getDescendantsOfTypeOrdered(301005, false, 301007);
        if (rangeVar.getType() == 301007 && (lateralRangeVarNames = (sqlRangeVar = (SQLRangeVar)rangeVar).getLateralSQLRangeVars()) != null) {
            ArrayList<String> updatedLateralRVNames = new ArrayList<String>();
            IXQEQueryNode parentOfRangeVar = rangeVar.getParent();
            IXQEQueryNode[] rangeVarSiblings = parentOfRangeVar.getChildrenOfTypeOrdered(301007);
            for (int i = rangeVarSiblings.length - 1; i >= 0; --i) {
                SQLRangeVar current = (SQLRangeVar)rangeVarSiblings[i];
                if (!lateralRangeVarNames.contains(current.getName()) && !lateralRangeVarNames.contains(current.getOriginalName())) continue;
                List<IXQEQueryNode> moreColumns = current.getDescendantsOfTypeOrdered(301005, false, 301007);
                columns.addAll(moreColumns);
                updatedLateralRVNames.add(current.getName());
            }
            sqlRangeVar.setLateralSQLRangeVars(updatedLateralRVNames);
        }
        this.updateTableNameInSqlColumns((String)rangeVar.getPropertyValue("name"), newTableName, columns);
    }

    private void updateTableNameInSqlColumns(String oldTableName, String newTableName, List<IXQEQueryNode> columns) {
        block0: for (IXQEQueryNode c : columns) {
            SQLColumn column = (SQLColumn)c;
            String tableName = column.getTableName();
            if (tableName != null) {
                if (!tableName.equals(oldTableName)) continue;
                column.setTableName(newTableName);
                continue;
            }
            String[] idChains = column.getIdentifierChain();
            for (int j = idChains.length - 2; j >= 0; --j) {
                if (!idChains[j].equals(oldTableName)) continue;
                column.setTableName(newTableName);
                continue block0;
            }
        }
    }
}

