/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.HashSet;
import java.util.Set;

public class DisableQueryReuseForUDF
extends RQPTransformation {
    public static final String PROP_UDF_NAMES = "UDFNames";

    public DisableQueryReuseForUDF() {
        this.mName = "Disable Query Reuse For User-Defined Functions";
        this.mPassNumbers = new int[]{49};
        this.mTypes = new int[]{301033};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        DisableQueryReuseForUDF.disableQueryReuseForUDF(node);
        environment.setTreeHasBeenModified();
    }

    public static void disableQueryReuseForUDF(IXQEQueryNode node) {
        IXQEQueryNode rqpSql = node.getAncestorOfType(801041);
        String functionName = null;
        if (node.getType() == 301033) {
            functionName = ((SQLFunction)node).getFunctionName();
        }
        if (node.getType() == 301034) {
            functionName = ((SQLAggregate)node).getFunctionName();
        }
        if (rqpSql != null) {
            ((RQPSql)rqpSql).setQueryReusable(false);
            DisableQueryReuseForUDF.addUdfName(rqpSql, functionName);
        } else {
            IXQEQueryNode rqpQuery = node.getAncestorOfType(801017);
            if (rqpQuery != null) {
                DisableQueryReuseForUDF.addUdfName(rqpQuery, functionName);
            }
        }
    }

    public static void addUdfName(IXQEQueryNode node, String udfName) {
        HashSet<String> udfNames = (HashSet<String>)node.getPropertyValue(PROP_UDF_NAMES);
        if (udfNames == null) {
            udfNames = new HashSet<String>();
            node.setPropertyValue(PROP_UDF_NAMES, udfNames);
        }
        udfNames.add(udfName);
    }

    public static void addUdfName(IXQEQueryNode node, Set<String> anotherUdfNameSet) {
        HashSet<String> udfSet = (HashSet<String>)node.getPropertyValue(PROP_UDF_NAMES);
        if (udfSet == null) {
            udfSet = new HashSet<String>();
            node.setPropertyValue(PROP_UDF_NAMES, udfSet);
        }
        udfSet.addAll(anotherUdfNameSet);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = super.passesNodeCondition(node, environment) && ((SQLFunction)node).getSubType() == SQLFunction.SubType.UDF;
        if (status) {
            this.traceQueryCondition(status, "Disable query reuse for the userd-defined function.", trace);
        } else {
            this.traceQueryCondition(status, "The function is not a user-defined function.", trace);
        }
        return status;
    }
}

