/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPQueryRef;
import com.cognos.xqe.ast.rqp.RQPTNode;
import com.cognos.xqe.ast.sql.SQLColumnStar;
import com.cognos.xqe.ast.sql.SQLFromClause;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5JoinOperand;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryItem;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5.query.V5QueryRef;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ApplyJoinFilterOptimization;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ConvertJoinExpressionToFilter;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class GenerateCTEInWithClauseForV5Query
extends Transformation {
    public static final String PROP_BOOL_DEPENDANTS_RETRIEVED = "dependantsRetrieved";
    private static final String CROSS_JOIN_ERR_FRMT = "%1$s, %2$s";
    private static final String PROP_BOOL_FROM_CLAUSE_ADDED = "fromClauseAdded";

    public GenerateCTEInWithClauseForV5Query() {
        this.mName = "GenerateCTEInWithClauseForV5Query";
        this.mPassNumbers = new int[]{39};
        this.mTypes = new int[]{801017, 801049};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLWith sqlWith = (SQLWith)node.getAncestorOfType(301022);
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(sqlWith);
        List<String> nameList = sqlWith.getNameList();
        V5Query referencingQuery = null;
        referencingQuery = node.getType() == 801017 ? ((RQPQuery)node).getRefV5Query() : ((RQPQueryRef)node).getReferenceOf();
        TreeSet<String> dependentQueries = this.getDependentQueries(environment, referencingQuery, sqlWith);
        if (dependentQueries != null && dependentQueries.size() > 0) {
            this.buildFromClauseStructureInReferencingQuery(environment, referencingQuery, node, dependentQueries);
            for (String dependentQueryName : dependentQueries) {
                int index = nameList.indexOf(dependentQueryName);
                if (index != -1) continue;
                RQPQueryRef queryRef = (RQPQueryRef)environment.getNodeFactory().createNode(801049);
                V5Query v5Query = rootQuerySet.getV5Query(dependentQueryName);
                queryRef.setReferenceOf(v5Query);
                sqlWith.addChild(queryRef, 0);
                nameList.add(0, dependentQueryName);
            }
        }
        node.setPropertyValue(PROP_BOOL_DEPENDANTS_RETRIEVED, true);
    }

    private TreeSet<String> getDependentQueries(PlanningEnvironment environment, V5Query referencingQuery, SQLWith sqlWith) {
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(sqlWith);
        TreeMap queryDependencyMap = (TreeMap)rootQuerySet.getPropertyValue("queryDependencyMap");
        if (queryDependencyMap == null || queryDependencyMap.size() == 0) {
            return null;
        }
        TreeSet dependentQueryNames = (TreeSet)queryDependencyMap.get(referencingQuery.getV5QueryName());
        if (dependentQueryNames == null || dependentQueryNames.size() == 0) {
            return null;
        }
        return dependentQueryNames;
    }

    private void buildFromClauseStructureInReferencingQuery(PlanningEnvironment environment, V5Query referencingQuery, IXQEQueryNode node, Set<String> dependentQueryNames) {
        IXQEQueryNode queryPlan = null;
        if (node.getType() == 801049 && (queryPlan = referencingQuery.getQueryPlan()).getType() == 801017 && queryPlan.getPropertyValue(PROP_BOOL_FROM_CLAUSE_ADDED) != null) {
            return;
        }
        V5Source source = referencingQuery.getV5Source();
        List<IXQEQueryNode> referencingLeafSubQueries = this.getLeafSubQueries(node);
        if (source.getNumberChildren() == 0) {
            this.addSQLRelationsInReferencingQuery(environment, dependentQueryNames, referencingLeafSubQueries);
        } else {
            IXQEQueryNode childOfSource = source.getChild(0);
            if (childOfSource != null) {
                switch (childOfSource.getType()) {
                    case 101019: {
                        V5JoinOperation joinOperation = (V5JoinOperation)childOfSource;
                        if (joinOperation.getNumberChildren() == 2) {
                            this.buildFromClause(environment, joinOperation);
                            break;
                        }
                        this.addSQLJoinStructureInReferencingQuery(environment, joinOperation, dependentQueryNames, referencingLeafSubQueries);
                        break;
                    }
                    case 101018: {
                        V5QueryOperation queryOperation = (V5QueryOperation)childOfSource;
                        this.addSQLSetOperatorStructureInReferencingQuery(environment, queryOperation, dependentQueryNames, referencingLeafSubQueries);
                        break;
                    }
                    case 101016: {
                        V5QuerySet querySet = (V5QuerySet)referencingQuery.getAncestorOfType(101002);
                        if (!this.isReferencedQueryInFilter(querySet, source.getReferencedQueries())) break;
                        this.addSQLRelationsInReferencingQuery(environment, source.getReferencedQueries(), referencingLeafSubQueries);
                        break;
                    }
                }
            }
        }
        if (queryPlan != null && queryPlan.getType() == 801017) {
            queryPlan.setPropertyValue(PROP_BOOL_FROM_CLAUSE_ADDED, true);
        }
    }

    private boolean isReferencedQueryInFilter(V5QuerySet querySet, Set<String> dependentQueryNames) {
        if (dependentQueryNames == null) {
            return false;
        }
        for (String qname : dependentQueryNames) {
            V5Query query = querySet.getV5Query(qname);
            if (query.getPropertyValue("queryReferencedFromFilter") != null && query.getPropertyValue("refByInPredicate") == null) continue;
            return false;
        }
        return true;
    }

    private void buildFromClause(PlanningEnvironment environment, V5JoinOperation joinOp) {
        XQENodeFactory factory = environment.getNodeFactory();
        RQPQuery rqpQuery = (RQPQuery)ConvertJoinExpressionToFilter.getRQPQueryOfJoinOperation(joinOp);
        SQLFromClause fromClause = RQPUtilities.getFromClauseNode(rqpQuery, factory);
        for (String jopName : joinOp.getJoinOperandNames()) {
            SQLRelation relation = (SQLRelation)factory.createNode(301016);
            relation.setName(jopName);
            fromClause.addChild(relation);
        }
    }

    private void addSQLRelationsInReferencingQuery(PlanningEnvironment environment, Set<String> referencedQueries, List<IXQEQueryNode> referencingLeafSubQueries) {
        XQENodeFactory factory = environment.getNodeFactory();
        boolean hasSubQueryForInExpr = this.hasSubQueryForInExpr(referencingLeafSubQueries);
        for (String referencedQueryName : referencedQueries) {
            for (IXQEQueryNode subQuery : referencingLeafSubQueries) {
                if (hasSubQueryForInExpr) {
                    V5QuerySet v5QuerySet = V5QuerySet.getRootQuerySet(environment, subQuery);
                    V5Query v5Query = v5QuerySet.getV5Query(referencedQueryName);
                    v5Query.setPropertyValue("refByInPredicate", true);
                    if (!this.subQueryHasReferenceTo(subQuery, referencedQueryName)) continue;
                }
                if (subQuery.getFirstChildByType(301043) != null && !this.subQueryHasReferenceToSimplifiedVerification(subQuery, referencedQueryName)) continue;
                ArrayList<String> refNames = new ArrayList<String>();
                refNames.add(referencedQueryName);
                SQLFromClause fromClause = this.getFromClauseAndVerifyCrossJoin(subQuery, environment, refNames);
                SQLRelation relation = (SQLRelation)factory.createNode(301016);
                relation.setName(referencedQueryName);
                fromClause.addChild(relation);
            }
        }
    }

    private void addSQLRelationsInFilterSubquery(PlanningEnvironment environment, Set<String> referencedQueries, List<IXQEQueryNode> referencingFilterSubqueries) {
        XQENodeFactory factory = environment.getNodeFactory();
        for (String referencedQueryName : referencedQueries) {
            for (IXQEQueryNode subQuery : referencingFilterSubqueries) {
                V5QuerySet v5QuerySet = V5QuerySet.getRootQuerySet(environment, subQuery);
                V5Query v5Query = v5QuerySet.getV5Query(referencedQueryName);
                v5Query.setPropertyValue("refByInPredicate", true);
                if (!this.subQueryHasReferenceTo(subQuery, referencedQueryName) || subQuery.getFirstChildByType(301043) != null) continue;
                ArrayList<String> refNames = new ArrayList<String>();
                refNames.add(referencedQueryName);
                SQLFromClause fromClause = this.getFromClauseAndVerifyCrossJoin(subQuery, environment, refNames);
                SQLRelation relation = (SQLRelation)factory.createNode(301016);
                relation.setName(referencedQueryName);
                fromClause.addChild(relation);
            }
        }
    }

    private boolean subQueryHasReferenceTo(IXQEQueryNode referencingSubQuery, String referencedQueryName) {
        if (referencingSubQuery.getPropertyValue("forINExpression") != null) {
            String queryRefInInExpr = ((RQPQuery)referencingSubQuery).getQueryRefInINExpression();
            return queryRefInInExpr != null && queryRefInInExpr.equals(referencedQueryName);
        }
        List<IXQEQueryNode> dataItemRefs = referencingSubQuery.getDescendantsOfTypeOrdered(201060, 301007);
        for (IXQEQueryNode diRef : dataItemRefs) {
            String[] parts;
            V5BoundDataItemReference boundDiRef = (V5BoundDataItemReference)diRef;
            if (!boundDiRef.isQueryRefItem() || !(parts = boundDiRef.getNameParts())[0].equals(referencedQueryName) || boundDiRef.getAncestorOfType(301059) != null) continue;
            return true;
        }
        return false;
    }

    private boolean subQueryHasReferenceToSimplifiedVerification(IXQEQueryNode referencingSubQuery, String referencedQueryName) {
        List<IXQEQueryNode> dataItemRefs = referencingSubQuery.getDescendantsOfTypeOrdered(201060, 301007);
        for (IXQEQueryNode diRef : dataItemRefs) {
            String[] parts;
            V5BoundDataItemReference boundDiRef = (V5BoundDataItemReference)diRef;
            if (!boundDiRef.isQueryRefItem() || !(parts = boundDiRef.getNameParts())[0].equals(referencedQueryName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSubQueryForInExpr(List<IXQEQueryNode> subQueries) {
        for (IXQEQueryNode query : subQueries) {
            if (!((RQPQuery)query).isSubQueryForInExpression()) continue;
            return true;
        }
        return false;
    }

    private SQLFromClause getFromClauseAndVerifyCrossJoin(IXQEQueryNode rqpQuery, PlanningEnvironment environment, List<String> referencedQueryNames) {
        IXQEQueryNode fromClause = rqpQuery.getFirstChildByType(301043);
        if (fromClause == null) {
            fromClause = environment.getNodeFactory().createNode(301043);
            rqpQuery.addChild(fromClause);
        } else {
            IXQEQueryNode rangeVar;
            if (referencedQueryNames.size() > 1 && (rangeVar = fromClause.getChild(0)).getType() == 301007) {
                referencedQueryNames.add(((SQLRangeVar)rangeVar).getName());
            }
            this.handleCrossJoin(environment, rqpQuery, referencedQueryNames);
        }
        return (SQLFromClause)fromClause;
    }

    private void addSQLSetOperatorStructureInReferencingQuery(PlanningEnvironment environment, V5QueryOperation queryOperation, Set<String> dependentQueryNames, List<IXQEQueryNode> referencingLeafSubQueries) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5Query[] queryOperands = queryOperation.getReferencedV5Queries(environment);
        ArrayList<String> queryOperandNames = new ArrayList<String>();
        for (V5Query query : queryOperands) {
            queryOperandNames.add(query.getV5QueryName());
        }
        SQLRangeVar rangeVar = this.buildSQLSetOperatorStructure(environment, queryOperation, queryOperandNames);
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(queryOperation);
        for (String queryName : queryOperandNames) {
            V5Query queryRef = rootQuerySet.getV5Query(queryName);
            IXQEQueryNode queryPlan = queryRef.getQueryPlan();
            if (queryPlan.getType() == 801017) {
                queryPlan.setPropertyValue("isCandidateForQueryReuse", true);
                this.processReferencedQueries(queryRef);
                continue;
            }
            if (queryPlan.getType() != 401005) continue;
            ((RSAPIDataset)queryPlan).setNoMetadataMode();
            rangeVar.setPropertyValue("containsNonRelationalReference", Boolean.TRUE);
        }
        ArrayList<IXQEQueryNode> filterSubqueries = new ArrayList<IXQEQueryNode>();
        int nbSubQueries = referencingLeafSubQueries.size();
        for (int i = 0; i < nbSubQueries; ++i) {
            IXQEQueryNode subQ = referencingLeafSubQueries.get(i);
            if (subQ.getPropertyValue("forINExpression") != null) {
                filterSubqueries.add(subQ);
                continue;
            }
            SQLFromClause fromClause = this.getFromClauseAndVerifyCrossJoin(subQ, environment, queryOperandNames);
            fromClause.addChild(factory.deepCopyNode(rangeVar));
        }
        HashSet<String> queryRefs = new HashSet<String>(dependentQueryNames);
        HashSet<String> nameSet = new HashSet<String>();
        for (String queryName : queryOperandNames) {
            nameSet.add(queryName);
        }
        queryRefs.removeAll(nameSet);
        if (queryRefs.size() > 0) {
            this.addSQLRelationsInReferencingQuery(environment, queryRefs, referencingLeafSubQueries);
        }
        if (filterSubqueries.size() > 0) {
            this.addSQLRelationsInFilterSubquery(environment, dependentQueryNames, filterSubqueries);
        }
    }

    void processReferencedQueries(V5Query query) {
        Set<String> queryNames = query.getV5Source().getReferencedQueries();
        if (queryNames == null) {
            return;
        }
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(query);
        for (String queryName : queryNames) {
            V5Query queryRef = rootQuerySet.getV5Query(queryName);
            IXQEQueryNode queryPlan = queryRef.getQueryPlan();
            if (queryPlan.getType() != 401005) continue;
            ((RSAPIDataset)queryPlan).setNoMetadataMode();
        }
    }

    private SQLRangeVar buildSQLSetOperatorStructure(PlanningEnvironment environment, V5QueryOperation queryOperation, List<String> queryOperandNames) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLRangeVar rangeVar = (SQLRangeVar)factory.createNode(301007);
        List<String> derivedColumnList = this.createSQLSetOperatorNameList(queryOperation, V5QuerySet.getRootQuerySet(queryOperation));
        rangeVar.setDerivedColumnList(derivedColumnList);
        String queryOperationName = queryOperation.getName();
        rangeVar.setName(queryOperationName);
        SQLSetOperator sqlSetOperation = (SQLSetOperator)factory.createNode(301018);
        sqlSetOperation.setSubType(queryOperation.getSQLSubType());
        sqlSetOperation.setAll(queryOperation.isDuplicatesPreserve());
        rangeVar.addChild(sqlSetOperation);
        for (String queryOperandName : queryOperandNames) {
            sqlSetOperation.addChild(this.buildSQLASTOfLegQuery(factory, queryOperandName));
        }
        return rangeVar;
    }

    private void addSQLJoinStructureInReferencingQuery(PlanningEnvironment environment, V5JoinOperation joinOperation, Set<String> dependentQueryNames, List<IXQEQueryNode> referencingLeafSubQueries) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLJoin sqlJoin = (SQLJoin)factory.createNode(301011);
        sqlJoin.setJoinType(joinOperation.getJoinType());
        ApplyJoinFilterOptimization.setJoinFilterProperties(environment, sqlJoin, joinOperation.getJoinFilterType(), joinOperation.getFJOAdvancedProperty());
        IRelationship.JoinFilterType joinFilterType = joinOperation.getJoinFilterType();
        if (joinFilterType != IRelationship.JoinFilterType.FILTER_TYPE_NONE) {
            sqlJoin.setPropertyValue("joinFilterType", (Object)joinFilterType);
        }
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(joinOperation);
        SQLRelation oneSideRelation = null;
        boolean leftCardinalitySet = false;
        List<IXQEQueryNode> joinOps = joinOperation.getDescendantsOfTypeOrdered(101021, false);
        ArrayList<String> joinOpNames = new ArrayList<String>();
        for (IXQEQueryNode jop : joinOps) {
            String card;
            V5JoinOperand joinOperand = (V5JoinOperand)jop;
            String joinOperandName = joinOperand.getQueryRef();
            joinOpNames.add(joinOperandName);
            V5Query joinOperandQuery = rootQuerySet.getV5Query(joinOperandName);
            IXQEQueryNode queryPlan = joinOperandQuery.getQueryPlan();
            if (queryPlan.getType() == 801017) {
                queryPlan.setPropertyValue("isCandidateForQueryReuse", true);
            } else if (queryPlan.getType() == 401005) {
                ((RSAPIDataset)queryPlan).setNoMetadataMode();
                sqlJoin.setPropertyValue("involvesMdxQuery", true);
            }
            SQLRelation relation = (SQLRelation)factory.createNode(301016);
            relation.setName(joinOperandName);
            sqlJoin.addChild(relation);
            if (!leftCardinalitySet) {
                sqlJoin.setLeftCardinality(IRelationship.Cardinality.toCardinality(joinOperand.getCardinality()));
                leftCardinalitySet = true;
            } else {
                sqlJoin.setRightCardinality(IRelationship.Cardinality.toCardinality(joinOperand.getCardinality()));
            }
            if (joinFilterType == IRelationship.JoinFilterType.FILTER_TYPE_NONE || !"0:1".equals(card = joinOperand.getCardinality()) && !"1:1".equals(card) || oneSideRelation != null) continue;
            oneSideRelation = relation;
        }
        if (joinFilterType != IRelationship.JoinFilterType.FILTER_TYPE_NONE) {
            sqlJoin.setPropertyValue("createdForJoinOperation", Boolean.TRUE);
            RQPTNode oneSideTNode = (RQPTNode)factory.createNode(801043);
            RQPTNode manySideTNode = (RQPTNode)factory.createNode(801043);
            oneSideTNode.setPropertyValue("oneSideJoinKey", true);
            manySideTNode.setPropertyValue("manySideJoinKey", true);
            IXQEQueryNode[] relations = sqlJoin.getChildrenOfType(301016);
            if (oneSideRelation == null) {
                relations[0].insertParent(oneSideTNode);
                relations[1].insertParent(manySideTNode);
            } else if (oneSideRelation == relations[0]) {
                relations[0].insertParent(oneSideTNode);
                relations[1].insertParent(manySideTNode);
            } else {
                relations[0].insertParent(manySideTNode);
                relations[1].insertParent(oneSideTNode);
            }
        }
        IXQEQueryNode joinFilter = joinOperation.getJoinFilterExpressionNode();
        int nbSubQueries = referencingLeafSubQueries.size();
        ArrayList<IXQEQueryNode> filterSubqueries = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < nbSubQueries; ++i) {
            IXQEQueryNode subQ = referencingLeafSubQueries.get(i);
            if (subQ.getPropertyValue("forINExpression") != null) {
                filterSubqueries.add(subQ);
                continue;
            }
            SQLFromClause fromClause = this.getFromClauseAndVerifyCrossJoin(subQ, environment, joinOpNames);
            SQLJoin clonedJoin = (SQLJoin)factory.deepCopyNode(sqlJoin);
            fromClause.addChild(clonedJoin);
            clonedJoin.addChild(factory.deepCopyNode(joinFilter));
        }
        HashSet<String> queryRefs = new HashSet<String>(dependentQueryNames);
        queryRefs.removeAll(joinOperation.getJoinOperandNames());
        if (queryRefs.size() > 0) {
            this.addSQLRelationsInReferencingQuery(environment, queryRefs, referencingLeafSubQueries);
        }
        if (filterSubqueries.size() > 0) {
            this.addSQLRelationsInFilterSubquery(environment, dependentQueryNames, filterSubqueries);
        }
    }

    private IXQEQueryNode buildSQLASTOfLegQuery(IXQENodeFactory factory, String queryName) {
        SQLProject project = (SQLProject)factory.createNode(301015);
        SQLValueList sqlValueList = (SQLValueList)factory.createNode(301030);
        SQLColumnStar columnStar = (SQLColumnStar)factory.createNode(301006);
        sqlValueList.addChild(columnStar);
        SQLRelation relation = (SQLRelation)factory.createNode(301016);
        relation.setName(queryName);
        project.addChild(relation);
        project.addChild(sqlValueList);
        return project;
    }

    private void handleCrossJoin(PlanningEnvironment environment, IXQEQueryNode referencingQuery, List<String> queryRefNames) {
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(referencingQuery);
        if (rootQuerySet.getPropertyValue(V5Query.QueryHint.CROSS_PRODUCT_ALLOWED.getPropertyName()) != null) {
            return;
        }
        Governors governors = referencingQuery.getGovernors();
        RQPQuery rootRqpQuery = ((RQPQuery)referencingQuery).getRootRQPQuery();
        if (governors.getCrossProdAllowed() == Governors.GovernorPermission.DENY) {
            int i;
            if (queryRefNames.size() == 1) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_CrossJoinsNotPermitted, String.format(CROSS_JOIN_ERR_FRMT, rootRqpQuery.getName(), queryRefNames.get(0)));
            }
            StringBuilder queryNames = new StringBuilder("");
            for (i = 0; i < queryRefNames.size() - 1; ++i) {
                if (i != 0) {
                    queryNames.append(", ");
                }
                queryNames.append(queryRefNames.get(i));
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_CrossJoinsNotPermitted, String.format(CROSS_JOIN_ERR_FRMT, queryNames, queryRefNames.get(i)));
        }
        if (governors.getCrossProdAllowed() == Governors.GovernorPermission.WARN) {
            ExecutionEnvironment ee = (ExecutionEnvironment)environment.getExecutionEnvironment();
            String nagMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_CrossJoinsDetected, XQEMessages.getCurrProductLocale());
            ee.addNag(nagMsg);
        }
    }

    private List<IXQEQueryNode> getLeafSubQueries(IXQEQueryNode node) {
        IXQEQueryNode referencingQueryPlan = node;
        if (node.getType() == 801049) {
            V5Query refV5Query = ((RQPQueryRef)node).getReferenceOf();
            referencingQueryPlan = refV5Query.getQueryPlan();
        }
        ArrayList<IXQEQueryNode> leafSubQueries = new ArrayList<IXQEQueryNode>();
        int[] rqpQueryTypes = new int[]{801017, 801025, 801024, 801012};
        List<IXQEQueryNode> subQueries = referencingQueryPlan.getDescendantsOfTypesOrdered(rqpQueryTypes, true);
        if (subQueries.size() == 1) {
            return subQueries;
        }
        for (int i = 0; i < subQueries.size(); ++i) {
            RQPQuery subQuery = (RQPQuery)subQueries.get(i);
            if (subQuery.isAsViewModelQuery()) continue;
            if (subQuery.getPropertyValue("leafSubQuery") != null) {
                leafSubQueries.add(subQuery);
                continue;
            }
            IXQEQueryNode fromClause = subQuery.getFirstChildByType(301043);
            if (fromClause == null) {
                leafSubQueries.add(subQuery);
                continue;
            }
            if (subQuery.isSubQueryForInExpression()) {
                leafSubQueries.add(subQuery);
                continue;
            }
            List<IXQEQueryNode> nestedQueries = fromClause.getDescendantsOfTypesOrdered(rqpQueryTypes, false);
            if (nestedQueries.size() == 0) {
                if (!this.hasQueryRefItem(subQuery)) continue;
                leafSubQueries.add(subQuery);
                continue;
            }
            if (nestedQueries.size() == 1 && ((RQPQuery)nestedQueries.get(0)).isSubQueryForInExpression()) {
                leafSubQueries.add(subQuery);
                continue;
            }
            boolean isLeafSubQuery = true;
            for (int j = 0; j < nestedQueries.size() && isLeafSubQuery; ++j) {
                RQPQuery nestedQuery = (RQPQuery)nestedQueries.get(j);
                if (nestedQuery.getType() != 801017) {
                    isLeafSubQuery = false;
                    break;
                }
                if (nestedQuery.isSubqueryForSelfRefCalcs()) {
                    isLeafSubQuery = false;
                    break;
                }
                if (!nestedQuery.isFactQuery() && !nestedQuery.isSubqueryForSummaryFilters() && !nestedQuery.isSubqueryToAvoidDoubleCounting()) continue;
                isLeafSubQuery = false;
                break;
            }
            if (!isLeafSubQuery) continue;
            leafSubQueries.add(subQuery);
        }
        return leafSubQueries;
    }

    private boolean hasQueryRefItem(RQPQuery subQuery) {
        int[] rqpNodeTypes;
        int[] types = new int[]{201060, 201097};
        for (int rqpNodeType : rqpNodeTypes = new int[]{801016, 801011, 801023}) {
            IXQEQueryNode rqpNode = subQuery.getFirstChildByType(rqpNodeType);
            if (rqpNode == null || !this.hasQueryRefItemAsDescendant(rqpNode, types)) continue;
            return true;
        }
        return false;
    }

    private boolean hasQueryRefItemAsDescendant(IXQEQueryNode node, int[] types) {
        List<IXQEQueryNode> itemRefs = node.getDescendantsOfTypesOrdered(types, false);
        for (IXQEQueryNode itemRef : itemRefs) {
            if (itemRef.getType() == types[0]) {
                if (!((V5BoundDataItemReference)itemRef).isQueryRefItem()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private List<String> createSQLSetOperatorNameList(IXQEQueryNode v5QueryOperation, V5QuerySet rootQuerySet) {
        IXQEQueryNode projectionList = v5QueryOperation.getChildrenOfType(101020)[0];
        IXQEQueryNode[] queryItems = projectionList.getChildrenOfTypeOrdered(101022);
        IXQEQueryNode[] v5QueryRefs = v5QueryOperation.getChildrenOfType(101023);
        String firstQueryRefName = ((V5QueryRef)v5QueryRefs[0]).getRefQuery();
        V5Query v5Query = rootQuerySet.getV5Query(firstQueryRefName);
        if (v5Query == null) {
            v5QueryOperation.throwInternalError("Unable to find the V5 query of the first leg of the V5 Query Operation, can't set the name list");
        }
        return this.getLongestDataItemList(v5Query.getV5Selection(), queryItems);
    }

    private List<String> getLongestDataItemList(V5Selection selection, IXQEQueryNode[] queryItems) {
        IXQEQueryNode[] v5DataItems = selection.getChildrenOfType(101003);
        V5Query v5Query = (V5Query)selection.getParent();
        if (queryItems.length >= v5DataItems.length) {
            ArrayList<String> nameList = new ArrayList<String>(queryItems.length);
            for (int i = 0; i < queryItems.length; ++i) {
                V5QueryItem queryItem = (V5QueryItem)queryItems[i];
                if (v5Query.isDMR() && V5SubQueryBuilder.containsAggregateWithinDetail(v5DataItems[i])) continue;
                nameList.add(queryItem.getName());
            }
            return nameList;
        }
        ArrayList<String> nameList = new ArrayList<String>(v5DataItems.length);
        for (IXQEQueryNode v5DataItem : v5DataItems) {
            V5DataItem item = (V5DataItem)v5DataItem;
            if (v5Query.isDMR() && V5SubQueryBuilder.containsAggregateWithinDetail(item) || !item.isOriginal()) continue;
            nameList.add(item.getNameProperty());
        }
        return nameList;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_BOOL_DEPENDANTS_RETRIEVED) != null) {
            this.traceQueryCondition(false, "The dependencies of this sub-query are already inserted in the WITH clause.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent == null || parent.getType() != 301022) {
            this.traceQueryCondition(false, "The sub-query is not inserted yet in the WITH clause.", trace);
            return false;
        }
        if (node.getType() == 801017 && node.getPropertyValue("forINExpression") != null) {
            return false;
        }
        if (node.getType() == 801017 && ((RQPQuery)node).isSubqueryForCalcsInQS()) {
            return false;
        }
        this.traceQueryCondition(true, "The dependencies of this sub-query need to be inserted in the WITH clause.", trace);
        return true;
    }
}

