/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public final class GenerateCastOverDateTimeForInPredicate
extends RQPTransformation {
    public GenerateCastOverDateTimeForInPredicate() {
        this.mName = "Generate cast over DateTime for IN predicate.";
        this.mPassNumbers = new int[]{56};
        this.mTypes = new int[]{301076};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] vList;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IDataType lhsDataType = ((SQLColumn)node.getChild(0)).getDataType();
        for (IXQEQueryNode v : vList = node.getChild(1).getChildren()) {
            IDataType vDataType = null;
            if (v instanceof SQLExpression) {
                vDataType = ((SQLExpression)v).getDataType();
            }
            if (lhsDataType.exactlyEquivalent(vDataType)) continue;
            SQLCast castNode = (SQLCast)nodeFactory.createNode(301047);
            SQLDataType castType = (SQLDataType)nodeFactory.createNode(301037);
            castType.setDataType(lhsDataType);
            IXQEQueryNode parent = v.getParent();
            parent.exchangeChildNode(v, castNode, false);
            castNode.addChild(v);
            castNode.addChild(castType);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] vList;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode rqpQueryNode = node.getAncestorOfType(801041);
        if (null == rqpQueryNode) {
            this.traceQueryCondition(false, "Not a relational query.", trace);
            return false;
        }
        RQPSql rqpSql = (RQPSql)rqpQueryNode;
        Object isQueryReusable = rqpSql.isQueryReusable();
        if (null == isQueryReusable || !((Boolean)isQueryReusable).booleanValue()) {
            this.traceQueryCondition(false, "Not a reusable query.", trace);
            return false;
        }
        IDataType lhsDataType = null;
        if (node.getChild(0).getType() == 301005) {
            lhsDataType = ((SQLColumn)node.getChild(0)).getDataType();
        }
        if (null == lhsDataType || !lhsDataType.isDate() && !lhsDataType.isTimestamp()) {
            this.traceQueryCondition(false, "LHS of IN predicate is neither date nor timestamp.", trace);
            return false;
        }
        if (node.getChild(1).getType() == 301059) {
            this.traceQueryCondition(false, "IN predicate contains a sub-query.", trace);
            return false;
        }
        for (IXQEQueryNode v : vList = node.getChild(1).getChildren()) {
            IDataType vDataType = null;
            if (v instanceof SQLExpression) {
                vDataType = ((SQLExpression)v).getDataType();
            }
            if (lhsDataType.exactlyEquivalent(vDataType)) continue;
            this.traceQueryCondition(true, "At least one expression needs to be cast.", trace);
            return true;
        }
        return false;
    }
}

