/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.util.SQLPrettyPrintQueryFormatter;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.relational.SQLCapabilities;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.NagCollector;
import com.cognos.xqe.query.engine.NagExceptionWithCognosSQL;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.ParameterInSQL;
import com.cognos.xqe.query.parameters.ParameterInfo;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.CollectXQELogs;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.runtree.relational.GenerateXSql;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.CreateUniqueValidSqlIdentifierForSqlRangeVar;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.MDOLogger;
import com.cognos.xqe.util.FileHandler;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class GenerateRQPSQL
extends RQPTransformation {
    private static final String HEADER = "Planning SQL:\r\n\r\n";
    private static final String HEADER1 = "\r\n\r\n\r\n\r\nPlanning SQL:\r\n\r\n";
    private static final String NEWLINE = "\r\n";

    public GenerateRQPSQL() {
        this.mName = "Log/Trace RQP SQL";
        this.mPassNumbers = new int[]{67};
        this.mTypes = new int[]{801041};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPSql rSql = (RQPSql)node;
        IXQEQueryNode child = node.getChild(0);
        if (child.getType() == 301060) {
            child = child.getChild(0);
        }
        if (child.getType() == 301019) {
            child = child.getChild(0);
        }
        if (child.getType() == 301022 && child.getNumberChildren() == 1) {
            child.extract();
        }
        RSAPIDataset dataSet = (RSAPIDataset)node.getAncestorOfType(401005);
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        boolean isTracingOn = this.isQueryPlanTraceOn(environment);
        boolean isSQLFilePathSet = GenerateRQPSQL.isSQLFilePathSet(reqEnv);
        boolean cognosSQLFeedbackRequested = dataSet.queryFeedbackIsRequested("CognosCommandText");
        NagCollector nagCollector = ((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getNagCollector();
        List<Nag> nagExceptions = nagCollector.getNagOfType(Nag.NagType.EXCEPTION_COGNOS_SQL);
        if (isTracingOn || isSQLFilePathSet || cognosSQLFeedbackRequested || dataSet.getSqlToMessageFolder() || nagExceptions.size() > 0 || CollectXQELogs.isLoggingEnabled(reqEnv)) {
            SQLQueryNode qNode = (SQLQueryNode)node.getChild(0);
            Properties props = new Properties();
            props.setProperty("printDbName", "true");
            SQLPrettyPrintQueryFormatter formatter = new SQLPrettyPrintQueryFormatter(props);
            formatter.setWithClauseGovernor(node.getGovernors().getSqlWithClause());
            formatter.setForPlanning(true);
            formatter.setReportAsDatasource(node.getGovernors().getReportAsDatasource());
            SQLCapabilities capabilities = SQLCapabilities.getInstance();
            qNode.accept(formatter, capabilities);
            String formattedSql = formatter.toString();
            if (isTracingOn) {
                rSql.setSqlText(formattedSql);
            }
            if (isSQLFilePathSet) {
                String path = reqEnv.getSqlFilePath();
                Governors.UseSQLParameters sqlParam = node.getGovernors().getUseSQLParameters();
                if (sqlParam == Governors.UseSQLParameters.LITERAL) {
                    this.logToSqlFile(path, this.substituteParameterValuesInSqlText(rSql, formattedSql, environment));
                } else {
                    this.logToSqlFile(path, formattedSql);
                }
                String cursorText = rSql.getPlannedSQLCursors().getFormattedString();
                if (cursorText != null && !"".equals(cursorText)) {
                    FileHandler.appendToFile(path, NEWLINE);
                    FileHandler.appendToFile(path, NEWLINE);
                    FileHandler.appendToFile(path, cursorText);
                }
            }
            if (cognosSQLFeedbackRequested || dataSet.getSqlToMessageFolder()) {
                String cogSQL = null;
                String cursorText = rSql.getPlannedSQLCursors().getFormattedString();
                if (cursorText != null && !"".equals(cursorText)) {
                    StringBuilder temp = new StringBuilder();
                    temp.append(formattedSql);
                    temp.append(NEWLINE);
                    temp.append(NEWLINE);
                    temp.append(rSql.getPlannedSQLCursors().getFormattedString());
                    cogSQL = temp.toString();
                } else {
                    cogSQL = formattedSql;
                }
                Governors.UseSQLParameters sqlParam = node.getGovernors().getUseSQLParameters();
                if (sqlParam == Governors.UseSQLParameters.LITERAL) {
                    cogSQL = this.substituteParameterValuesInSqlText(rSql, cogSQL, environment);
                }
                dataSet.setCognosSQL(cogSQL);
                if (dataSet.getSqlToMessageFolder()) {
                    MDOLogger.logMDOCognosSQL(environment, dataSet, cogSQL);
                }
            }
            if (nagExceptions.size() > 0) {
                NagExceptionWithCognosSQL firstNagException = (NagExceptionWithCognosSQL)nagExceptions.get(0);
                XQERuntimeException exception = firstNagException.getException();
                exception.getXQEMessage().setPostMessage(formattedSql);
                throw exception;
            }
            CollectXQELogs xqeLogs = new CollectXQELogs(reqEnv.getOrCreateReportLogsDir());
            xqeLogs.logSQL(dataSet.getRefQueryName(), formattedSql);
        }
        rSql.setPropertyValue("dumped", true);
    }

    protected String substituteParameterValuesInSqlText(RQPSql rSql, String cogSQL, PlanningEnvironment environment) {
        List<ParameterInSQL> arrayParamInSQL;
        int charAt;
        String escapingChar;
        ArrayList<String> pnames = new ArrayList<String>();
        MultiRequestContext multiRequestContext = environment.getMultiRequestContext();
        Parameters parameters = multiRequestContext.getRequestParameters().getParameters();
        pnames.addAll(parameters.keySet());
        IDataSource dataSource = CreateUniqueValidSqlIdentifierForSqlRangeVar.getDataSource(rSql, environment);
        if (dataSource == null) {
            return cogSQL;
        }
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        char literalQuoteEscapeChar = ' ';
        if (null != capabilities && null != (escapingChar = capabilities.getStringValue("delimiters.literalQuoteEscape", null)) && (charAt = escapingChar.length() - 2) >= 0) {
            literalQuoteEscapeChar = escapingChar.charAt(charAt);
        }
        if ((arrayParamInSQL = XSql.parseSqlForParameters(cogSQL, pnames, literalQuoteEscapeChar)).isEmpty()) {
            return cogSQL;
        }
        String substitute = "SUBSTITUTE_PARAMETERS_WITH_SQLLITERAL";
        capabilities.setStringValue(substitute, "true");
        List<ParameterInfo> parameterInfo = GenerateXSql.buildParameterInfo(rSql);
        String substSql = XSql.substituteParameterValuesInSqlText(cogSQL, parameters, dataSource, parameterInfo, arrayParamInSQL, false);
        capabilities.setStringValue(substitute, "");
        return substSql;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        Boolean alreadyDumped = (Boolean)node.getPropertyValue("dumped");
        if (alreadyDumped.booleanValue()) {
            this.traceQueryCondition(false, "Logging RQP SQL has already been processed.", trace);
            return false;
        }
        if (node.getDescendantsOfType(401005, false).length > 0) {
            this.traceQueryCondition(false, "RQP SQL will not be logged. The query contains mixed MDX and relational objects.", trace);
            return false;
        }
        return true;
    }

    public static boolean isSQLFilePathSet(RequestEnvironment environment) {
        String path = environment.getSqlFilePath();
        return path != null && !path.equals("");
    }

    private boolean isQueryPlanTraceOn(PlanningEnvironment environment) {
        return environment.getMultiRequestContext().fetchBooleanConfiguration("queryPlanning[@traceEnabled]", false);
    }

    private void logToSqlFile(String path, String sqlText) {
        if (FileHandler.isEmptyFile(path)) {
            FileHandler.appendToFile(path, HEADER);
        } else {
            FileHandler.appendToFile(path, HEADER1);
        }
        FileHandler.appendToFile(path, sqlText);
    }
}

