/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPInnerJoinGroup;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class GroupInnerJoins
extends RQPTransformation {
    public GroupInnerJoins() {
        this.mName = "Split the join path into inner join groups";
        this.mPassNumbers = new int[]{29};
        this.mTypes = new int[]{801039};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ArrayList<IMetadata> joinPath = new ArrayList<IMetadata>(((RQPJoinPath)node).getJoinPath());
        ArrayList<IMetadata> allInnerJoins = this.getAllInnerJoins(joinPath);
        if (joinPath.size() > allInnerJoins.size()) {
            joinPath.removeAll(allInnerJoins);
            ((RQPJoinPath)node).setOuterJoins(joinPath);
        }
        boolean explicitSCProcessing = RQPUtilities.getShortcutProcessing(environment);
        while (!allInnerJoins.isEmpty()) {
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            RQPInnerJoinGroup joinGroup = (RQPInnerJoinGroup)nodeFactory.createNode(801040);
            this.populateJoinGroup(allInnerJoins, joinGroup, explicitSCProcessing);
            node.addChild(joinGroup);
        }
    }

    private ArrayList<IMetadata> getAllInnerJoins(ArrayList<IMetadata> joinPath) {
        ArrayList<IMetadata> innerJoins = new ArrayList<IMetadata>();
        for (IMetadata join : joinPath) {
            IRelationship relationShip = (IRelationship)join;
            if (relationShip.getLeftCardinality() == IRelationship.Cardinality.ZERO_ONE || relationShip.getLeftCardinality() == IRelationship.Cardinality.ZERO_MANY || relationShip.getRightCardinality() == IRelationship.Cardinality.ZERO_ONE || relationShip.getRightCardinality() == IRelationship.Cardinality.ZERO_MANY) continue;
            innerJoins.add(join);
        }
        return innerJoins;
    }

    private void populateJoinGroup(List<IMetadata> joinPath, RQPInnerJoinGroup joinGroup, boolean explicitSCProcessing) {
        int numInnerJoins;
        do {
            numInnerJoins = joinGroup.getJoinPath().size();
            for (IMetadata join : joinPath) {
                joinGroup.addJoinAndEntities(join, explicitSCProcessing);
            }
            joinPath.removeAll(joinGroup.getJoinPath());
            if (!joinPath.isEmpty()) continue;
            return;
        } while (numInnerJoins < joinGroup.getJoinPath().size());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getParent().getType() != 301043) {
            return false;
        }
        List<IMetadata> outerJoins = ((RQPJoinPath)node).getOuterJoins();
        if (outerJoins != null) {
            return false;
        }
        return node.getChildren().length == 1;
    }
}

