/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.util.SQLAbstractFormattedQueryFormatter;
import com.cognos.xqe.ast.sql.util.SQLPrettyPrintQueryFormatter;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.providers.relational.SQLCapabilities;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.FileHandler;
import com.cognos.xqe.util.xml.XMLUtils;
import java.util.List;
import java.util.Properties;
import org.dom4j.Node;

public class HarvestPlanningSQL
extends RQPTransformation {
    private static final String COMMAND = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<command>\r\n";
    private static final String CONNECTION = "\t<connection>\r\n\t\t<QFProviderType value=\"OlapQueryProvider\"/>\r\n\t\t<productLocale value=\"en\"/>\r\n\t\t<runLocale value=\"en-us\"/>\r\n\t\t<serviceID value=\"RSVP\"/>\r\n\t\t<sessionID value=\"010:0121d2f0-129c-11dc-9a4f-fc7410014a90:1259391544\"/>\r\n\t\t<contentManagerURI value=\"http://127.0.0.1:9300/p2pd/servlet\"/>\r\n\t\t<requestID value=\"hCCGhhqysC4Cd8d4dj8j92qdvdsj4G9vjdjCC9l4\"/>\r\n\t\t<subRequestID value=\"hCCGhhqysC4Cd8d4dj8j92qdvdsj4G9vjdjCC9l4\"/>\r\n\t</connection>\r\n";
    private static final String EXECUTE = "\t<execute>\r\n\t\t<querySet expressionLocale=\"en-us\">\r\n\t\t\t<modelPath>MODEL_PATH</modelPath>\r\n\t\t\t<queries>\r\n\t\t\t\t<query name=\"Query1\">\r\n\t\t\t\t\t<source>\r\n\t\t\t\t\t\t<sqlQuery name=\"SQL1\" type=\"cogSQL\">\r\n\t\t\t\t\t\t\t<sqlText>\r\n";
    private static final String PROJECTEDITEMS = "\r\n\t\t\t\t\t\t\t</sqlText>\r\n\t\t\t\t\t\t\t<mdProjectedItems>\r\n";
    private static final String PROJECTEDITEM = "\t\t\t\t\t\t\t\t<mdProjectedItem name=\"";
    private static final String SELECTION = "\t\t\t\t\t\t\t</mdProjectedItems>\r\n\t\t\t\t\t\t</sqlQuery>\r\n\t\t\t\t\t</source>\r\n\t\t\t\t\t<selection autoSummary=\"false\">\r\n";
    private static final String DATAITEM = "\t\t\t\t\t\t<dataItem aggregate=\"none\" rollupAggregate=\"none\" name=\"";
    private static final String EXPRESSION = "\t\t\t\t\t\t\t<expression rID=\"1\">[SQL1].[";
    private static final String DATAITEM_END = "\t\t\t\t\t\t</dataItem>\r\n";
    private static final String QRD_BEGIN = "\t\t\t\t\t</selection>\r\n\t\t\t\t</query>\r\n\t\t\t</queries>\r\n\t\t\t<queryResultDefinitions>\r\n\t\t\t\t<queryResultDefinition name=\"Query1.0\" refQuery=\"Query1\">\r\n\t\t\t\t\t<edges>\r\n\t\t\t\t\t\t<edge name=\"1\">\r\n\t\t\t\t\t\t\t<edgeGroups>\r\n\t\t\t\t\t\t\t\t<edgeGroup>\r\n\t\t\t\t\t\t\t\t\t<valueSets>\r\n\t\t\t\t\t\t\t\t\t\t<valueSet name=\"1\">\r\n\t\t\t\t\t\t\t\t\t\t\t<groupBody name=\"1_groupBody\">\r\n";
    private static final String DATAITEMREF = "\t\t\t\t\t\t\t\t\t\t\t\t<dataItemRef refDataItem=\"";
    private static final String QRD_END = "\t\t\t\t\t\t\t\t\t\t\t</groupBody>\r\n\t\t\t\t\t\t\t\t\t\t</valueSet>\r\n\t\t\t\t\t\t\t\t\t</valueSets>\r\n\t\t\t\t\t\t\t\t</edgeGroup>\r\n\t\t\t\t\t\t\t</edgeGroups>\r\n\t\t\t\t\t\t</edge>\r\n\t\t\t\t\t</edges>\r\n\t\t\t\t</queryResultDefinition>\r\n\t\t\t</queryResultDefinitions>\r\n\t\t</querySet>\r\n\t</execute>\r\n</command>\r\n";
    private static final String END_TAG = "\"/>\r\n";

    public HarvestPlanningSQL() {
        this.mName = "Harvest planning SQL.";
        this.mPassNumbers = new int[]{68};
        this.mTypes = new int[]{801041};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        SQLCapabilities capabilities = SQLCapabilities.getInstance();
        Properties props = new Properties();
        props.setProperty("printDbName", "true");
        props.setProperty("XMLEscapeCharacter", "true");
        SQLPrettyPrintQueryFormatter formatter = new SQLPrettyPrintQueryFormatter(props);
        String path = reqEnv.getSqlFilePath();
        path = path.replace(".sql", ".xml");
        path = path.replace("/output/", "/input/relational/harvestSQL/");
        FileHandler.deleteFile(path);
        FileHandler.createOutputFolders(path);
        FileHandler.appendToFile(path, COMMAND);
        String connection = null;
        try {
            connection = XMLUtils.toString((Node)((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getConnectionElement());
            connection = connection + "\r\n";
        }
        catch (Exception e1) {
            connection = CONNECTION;
        }
        FileHandler.appendToFile(path, connection);
        String modelPath = reqEnv.getModelPath();
        String execute = EXECUTE;
        execute = execute.replace("MODEL_PATH", modelPath);
        FileHandler.appendToFile(path, execute);
        IXQEQueryNode child = node.getChild(0);
        ((SQLQueryNode)child).accept(formatter, capabilities);
        String formattedSql = ((SQLAbstractFormattedQueryFormatter)formatter).toString();
        FileHandler.appendToFile(path, formattedSql);
        while (child.getType() == 301019 || child.getType() == 301008 || child.getType() == 301022) {
            if (child.getType() == 301022) {
                child = child.getChild(child.getNumberChildren() - 1);
                continue;
            }
            child = child.getChild(0);
        }
        SQLProject projectNode = (SQLProject)child;
        List<String> columnNames = ((SQLQueryNode)projectNode).getColumnNames();
        FileHandler.appendToFile(path, PROJECTEDITEMS);
        for (String columnName : columnNames) {
            FileHandler.appendToFile(path, PROJECTEDITEM + columnName + END_TAG);
        }
        FileHandler.appendToFile(path, SELECTION);
        for (String columnName : columnNames) {
            FileHandler.appendToFile(path, DATAITEM + columnName + "\">\r\n");
            FileHandler.appendToFile(path, EXPRESSION + columnName + "]</expression>\r\n" + DATAITEM_END);
        }
        FileHandler.appendToFile(path, QRD_BEGIN);
        for (String columnName : columnNames) {
            FileHandler.appendToFile(path, DATAITEMREF + columnName + END_TAG);
        }
        FileHandler.appendToFile(path, QRD_END);
        node.setPropertyValue("harvested", true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        boolean status = false;
        boolean bl = status = HarvestPlanningSQL.isSQLFilePathSet(environment) && node.getPropertyValue("harvested") == null && node.getDescendantsOfType(401005, false).length == 0 && reqEnv.getModelPath() != null;
        if (status) {
            super.traceQueryCondition(status, "Planning SQL needs to be harvested.", trace);
        } else {
            super.traceQueryCondition(status, "Planning SQL does not need to be harvested.", trace);
        }
        return status;
    }

    public static boolean isSQLFilePathSet(PlanningEnvironment environment) {
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        boolean status = false;
        String path = reqEnv.getSqlFilePath();
        if (path == null || path.equals("")) {
            return false;
        }
        status = path.contains("/output/rqp/");
        return status;
    }
}

