/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ProcessNativeSQLInCTEGovernor
extends RQPTransformation {
    public ProcessNativeSQLInCTEGovernor() {
        this.mName = "Process NativeSQLInCTE governor";
        this.mPassNumbers = new int[]{64};
        this.mTypes = new int[]{801041};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Governors governors = node.getGovernors();
        if (governors.getNativeSQLInCTE() == Governors.NativeSQLInCTE.AUTOMATIC) {
            IXQEQueryNode n;
            governors.setSqlWithClause(Boolean.FALSE.toString());
            IXQEQueryNode[] natives = node.getDescendantsOfType(301012, false);
            SQLNativeSql nativeSQL = null;
            IXQEQueryNode[] iXQEQueryNodeArray = natives;
            int n2 = iXQEQueryNodeArray.length;
            for (int i = 0; i < n2 && ((nativeSQL = (SQLNativeSql)(n = iXQEQueryNodeArray[i])).isPassThrough() || !nativeSQL.hasWithClause()); ++i) {
            }
            String nagMsg = XQEMessages.getMessage(XQEMessageKeys.WRN_WithClauseDetectedInNativeSQL, XQEMessages.getCurrProductLocale(), nativeSQL.getSqlString());
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nagMsg);
        } else if (governors.getNativeSQLInCTE() == Governors.NativeSQLInCTE.DT) {
            governors.setSqlWithClause(Boolean.FALSE.toString());
        } else if (governors.getNativeSQLInCTE() == Governors.NativeSQLInCTE.PT) {
            IXQEQueryNode[] natives;
            for (IXQEQueryNode n : natives = node.getDescendantsOfType(301012, false)) {
                ((SQLNativeSql)n).setIsPassThrough(true);
            }
        }
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] natives;
        Governors governors = node.getGovernors();
        if (governors == null || !governors.getSqlWithClause().booleanValue()) {
            return false;
        }
        if (governors.getNativeSQLInCTE() == Governors.NativeSQLInCTE.KEEP) {
            return false;
        }
        for (IXQEQueryNode n : natives = node.getDescendantsOfType(301012, false)) {
            SQLNativeSql nativeSQL = (SQLNativeSql)n;
            if (nativeSQL.isPassThrough() || !nativeSQL.hasWithClause()) continue;
            return true;
        }
        return false;
    }
}

