/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.GenerateCTEInWithClauseForRQPSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.aggregateAwareness.IAggregateAwareness;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class ReplaceAggregateWithSummaryTable
extends RQPTransformation {
    private static final String MSG = "it has distinct";
    private static final String MSG1 = "aggregate query subject substitution fails.";
    private static final int[] SRC_TYPES = new int[]{301007, 301011, 301014};
    private static final String AGGR_AVG = "Avg";
    private static final String AGGR_SUM = "Sum";
    private static final String AGGR_COUNT = "Count";
    private static final String TEMP_MARK = "awTempMark";
    private static final String TEMP_MARK_1 = "awTempMark_1";

    public ReplaceAggregateWithSummaryTable() {
        this.mName = "ReplaceAggregateWithSummaryTable";
        this.mPassNumbers = new int[]{57};
        this.mTypes = new int[]{301034};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Param pm = new Param();
        SQLRangeVar sqlRangeVar = this.getAggregatesForRewrite(node, environment, pm);
        for (IXQEQueryNode s : pm.skipAlias) {
            s.detach();
        }
        this.convertSQLAggregate(environment.getNodeFactory(), pm);
        this.substituteBaseFactTableWithAggregateTable(environment, sqlRangeVar, pm);
    }

    private void convertSQLAggregate(IXQENodeFactory nodeFactory, Param pm) {
        if (!pm.bUseTQ) {
            this.convertAvgToSumDivCountNormal(nodeFactory, pm);
        } else {
            this.convertAvgToSumDivCountTQ(nodeFactory, pm);
            HashMap<Integer, TreeSet<String>> realduplicates = this.getCloneInfo(pm);
            this.cloneSQLAliasInTQ(nodeFactory, pm, realduplicates);
        }
        for (Pair p : pm.sqlAggregates) {
            SQLAggregate aggr = (SQLAggregate)p.getFirst();
            if (aggr.getSubType() != SQLAggregate.SubType.COUNT) continue;
            aggr.setSubType(SQLAggregate.SubType.SUM);
        }
    }

    private void convertAvgToSumDivCountTQ(IXQENodeFactory nodeFactory, Param pm) {
        ArrayList<Pair> newCounts = new ArrayList<Pair>();
        for (Pair p : pm.sqlAggregates) {
            IXQEQueryNode[] sqlCols;
            SQLAggregate aggr = (SQLAggregate)p.getFirst();
            if (aggr.getSubType() != SQLAggregate.SubType.AVG) continue;
            List cols = (List)p.getSecond();
            for (int i = 0; i < cols.size(); ++i) {
                ((IXQEQueryNode)((List)cols.get(i)).get(0)).setPropertyValue(TEMP_MARK, i);
            }
            aggr.setSubType(SQLAggregate.SubType.SUM);
            SQLAggregate count = (SQLAggregate)nodeFactory.deepCopyNode(aggr);
            count.setSubType(SQLAggregate.SubType.COUNT);
            SQLValueExpression vExprNode = (SQLValueExpression)nodeFactory.createNode(301025);
            vExprNode.setSubType(SQLValueExpression.SubType.DIVIDE);
            aggr.getParent().exchangeChildNode(aggr, vExprNode);
            vExprNode.addChild(aggr);
            vExprNode.addChild(count);
            ArrayList newcols = new ArrayList();
            for (IXQEQueryNode cloned : sqlCols = count.getDescendantsOfType(301005, false)) {
                Integer mk = (Integer)cloned.getPropertyValue(TEMP_MARK);
                if (mk == null) continue;
                cloned.removeProperty(TEMP_MARK);
                ArrayList<IXQEQueryNode> newList = new ArrayList<IXQEQueryNode>((Collection)cols.get(mk));
                newList.set(0, cloned);
                newcols.add(newList);
            }
            Pair newAggr = new Pair(count, newcols);
            newCounts.add(newAggr);
            for (List lst : cols) {
                ((IXQEQueryNode)lst.get(0)).removeProperty(TEMP_MARK);
            }
        }
        pm.sqlAggregates.addAll(newCounts);
    }

    private HashMap<Integer, TreeSet<String>> getCloneInfo(Param pm) {
        HashSet sqlColSet = new HashSet();
        for (Object p : pm.sqlAggregates) {
            List cols = (List)((Pair)p).getSecond();
            for (List list : cols) {
                sqlColSet.add(list.get(1));
            }
        }
        int i = 0;
        for (Object aSQLCol : sqlColSet) {
            aSQLCol.setPropertyValue(TEMP_MARK, i);
            ++i;
        }
        HashMap<Integer, TreeSet<String>> duplicates = new HashMap<Integer, TreeSet<String>>();
        for (Map.Entry entry : pm.aggregates.entrySet()) {
            HashMap hashMap = (HashMap)entry.getValue();
            for (Map.Entry e1 : hashMap.entrySet()) {
                Pair pp = (Pair)e1.getKey();
                String aggrFunc = (String)pp.getSecond();
                ArrayList lst = (ArrayList)e1.getValue();
                for (IXQEQueryNode cc : lst) {
                    Integer mk = (Integer)cc.getPropertyValue(TEMP_MARK);
                    if (mk == null) continue;
                    TreeSet<String> aggrs = (TreeSet<String>)duplicates.get(mk);
                    if (aggrs == null) {
                        aggrs = new TreeSet<String>();
                        duplicates.put(mk, aggrs);
                    }
                    aggrs.add(aggrFunc);
                }
            }
        }
        HashMap<Integer, TreeSet<String>> realduplicates = new HashMap<Integer, TreeSet<String>>();
        for (Map.Entry entry : duplicates.entrySet()) {
            if (((TreeSet)entry.getValue()).size() > 1) {
                TreeSet cloned = new TreeSet((SortedSet)entry.getValue());
                cloned.remove(cloned.last());
                realduplicates.put((Integer)entry.getKey(), cloned);
                continue;
            }
            for (IXQEQueryNode sc : sqlColSet) {
                Integer mk = (Integer)sc.getPropertyValue(TEMP_MARK);
                if (!((Integer)entry.getKey()).equals(mk)) continue;
                sc.removeProperty(TEMP_MARK);
            }
        }
        return realduplicates;
    }

    /*
     * Could not resolve type clashes
     */
    private void cloneSQLAliasInTQ(IXQENodeFactory nodeFactory, Param pm, HashMap<Integer, TreeSet<String>> realduplicates) {
        for (Pair p : pm.sqlAggregates) {
            SQLAggregate aggr = (SQLAggregate)p.getFirst();
            String aggrname = aggr.getFunctionName();
            List cols = (List)p.getSecond();
            for (List lst : cols) {
                TreeSet<String> st;
                SQLColumn sqlCol = (SQLColumn)lst.get(1);
                Integer mk = (Integer)sqlCol.getPropertyValue(TEMP_MARK);
                if (mk == null || (st = realduplicates.get(mk)) == null || !st.contains(aggrname)) continue;
                SQLAlias aliasTQ = (SQLAlias)lst.get(2);
                for (Map.Entry eg : pm.groupingItems.entrySet()) {
                    for (SQLColumn gc : (ArrayList)eg.getValue()) {
                        gc.setPropertyValue(TEMP_MARK_1, eg.getKey());
                    }
                }
                SQLAlias aliasCloned = (SQLAlias)nodeFactory.deepCopyNode(aliasTQ);
                IXQEQueryNode[] clonedSQLCols = aliasCloned.getDescendantsOfType(301005, false);
                for (IXQEQueryNode aSQLCol : clonedSQLCols) {
                    String mark = (String)aSQLCol.getPropertyValue(TEMP_MARK_1);
                    if (mark == null) continue;
                    ((ArrayList)pm.groupingItems.get(mark)).add((SQLColumn)aSQLCol);
                }
                for (Map.Entry eg1 : pm.groupingItems.entrySet()) {
                    for (SQLColumn gc : (ArrayList)eg1.getValue()) {
                        gc.removeProperty(TEMP_MARK_1);
                    }
                }
                aliasTQ.getParent().addChild(aliasCloned);
                SQLColumn clonedSQLCol = null;
                for (IXQEQueryNode aCol : clonedSQLCols) {
                    Integer mark = (Integer)aCol.getPropertyValue(TEMP_MARK);
                    if (!mk.equals(mark)) continue;
                    aCol.removeProperty(TEMP_MARK);
                    clonedSQLCol = (SQLColumn)aCol;
                    break;
                }
                aliasCloned.setName(aliasCloned.getName() + aggrname);
                ((SQLColumn)lst.get(0)).setName(aliasCloned.getName());
                for (Map.Entry e : pm.aggregates.entrySet()) {
                    HashMap mp = (HashMap)e.getValue();
                    block9: for (Map.Entry e1 : mp.entrySet()) {
                        Pair pp = (Pair)e1.getKey();
                        if (!aggrname.equals(pp.getSecond())) continue;
                        ArrayList aggrColLst = (ArrayList)e1.getValue();
                        for (int j = 0; j < aggrColLst.size(); ++j) {
                            Integer orgMk = (Integer)((IXQEQueryNode)aggrColLst.get(j)).getPropertyValue(TEMP_MARK);
                            if (!mk.equals(orgMk)) continue;
                            aggrColLst.set(j, clonedSQLCol);
                            continue block9;
                        }
                    }
                }
            }
        }
        for (Pair p1 : pm.sqlAggregates) {
            List cols = (List)p1.getSecond();
            for (List lst : cols) {
                IXQEQueryNode sCol = (IXQEQueryNode)lst.get(1);
                sCol.removeProperty(TEMP_MARK);
            }
        }
    }

    private void convertAvgToSumDivCountNormal(IXQENodeFactory nodeFactory, Param pm) {
        for (Pair p : pm.sqlAggregates) {
            SQLAggregate aggr = (SQLAggregate)p.getFirst();
            if (aggr.getSubType() != SQLAggregate.SubType.AVG) continue;
            aggr.setSubType(SQLAggregate.SubType.SUM);
            List cols = (List)p.getSecond();
            ArrayList all = new ArrayList();
            for (List l : cols) {
                all.addAll(l);
            }
            for (int i = 0; i < all.size(); ++i) {
                ((IXQEQueryNode)all.get(i)).setPropertyValue(TEMP_MARK, i);
            }
            SQLAggregate count = (SQLAggregate)nodeFactory.deepCopyNode(aggr);
            count.setSubType(SQLAggregate.SubType.SUM);
            SQLValueExpression vExprNode = (SQLValueExpression)nodeFactory.createNode(301025);
            vExprNode.setSubType(SQLValueExpression.SubType.DIVIDE);
            aggr.getParent().exchangeChildNode(aggr, vExprNode);
            vExprNode.addChild(aggr);
            vExprNode.addChild(count);
            IXQEQueryNode[] sqlCols = count.getDescendantsOfType(301005, false);
            for (IXQEQueryNode cloned : sqlCols) {
                Integer mk = (Integer)cloned.getPropertyValue(TEMP_MARK);
                if (mk == null) continue;
                cloned.removeProperty(TEMP_MARK);
                for (Map.Entry e : pm.aggregates.entrySet()) {
                    HashMap mp = (HashMap)e.getValue();
                    block5: for (Map.Entry e1 : mp.entrySet()) {
                        Pair pp = (Pair)e1.getKey();
                        if (!AGGR_COUNT.equals(pp.getSecond())) continue;
                        ArrayList lst = (ArrayList)e1.getValue();
                        for (int j = 0; j < lst.size(); ++j) {
                            Integer orgMk = (Integer)((IXQEQueryNode)lst.get(j)).getPropertyValue(TEMP_MARK);
                            if (!mk.equals(orgMk)) continue;
                            lst.set(j, cloned);
                            continue block5;
                        }
                    }
                }
            }
            for (IXQEQueryNode c : all) {
                c.removeProperty(TEMP_MARK);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean b;
        Param pm = new Param();
        SQLRangeVar sqlRangeVar = this.getAggregatesForRewrite(node, environment, pm);
        boolean bl = b = sqlRangeVar != null && pm.aggregates.size() == 1;
        if (!b) {
            int aSeverity;
            if (pm.msg[0].length() > 0) {
                aSeverity = 1;
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_AggregateRewriteFail, pm.msg[0].toString(), pm.msg[1].toString()));
            }
            if (sqlRangeVar != null && pm.aggregates.size() > 1) {
                node.writeFormattedText(pm.msg[0]);
                pm.msg[1].append("requies multiple aggregate query subjects.");
                aSeverity = 1;
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_AggregateRewriteFail, pm.msg[0].toString(), pm.msg[1].toString()));
            }
        }
        return b;
    }

    private ArrayList<SQLColumn> getSQLColumnsForTabName(IXQEQueryNode node, String tabName) {
        IXQEQueryNode[] cols;
        ArrayList<SQLColumn> rt = new ArrayList<SQLColumn>();
        for (IXQEQueryNode c : cols = node.getDescendantsOfType(301005, true)) {
            SQLColumn col = (SQLColumn)c;
            if (!tabName.equals(col.getTableName())) continue;
            rt.add(col);
        }
        return rt;
    }

    private SQLRangeVar getAggregatesForRewrite(IXQEQueryNode node, PlanningEnvironment environment, Param pm) {
        IAggregateAwareness aw = environment.getMetadataConnection().getAggregateAwareness();
        if (aw == null) {
            return null;
        }
        RQPQuery rqpQuery = (RQPQuery)node.getAncestorOfCategory(801017);
        if (rqpQuery == null) {
            return null;
        }
        if (this.useTQ(rqpQuery)) {
            pm.bUseTQ = true;
            return this.getAggregatesForRewriteOverTQ(node, environment, rqpQuery, pm);
        }
        return this.getAggregatesForRewriteNormal(node, environment, rqpQuery, pm);
    }

    private boolean useTQ(RQPQuery rqpQuery) {
        ArrayList<IXQEQueryNode> sqlRangeVars = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeSkipSubQuery(rqpQuery, 301007, sqlRangeVars, null, true);
        if (sqlRangeVars.size() != 1) {
            return false;
        }
        IXQEQueryNode[] children = sqlRangeVars.get(0).getChildren();
        return children.length == 1 && children[0].getType() == 801025;
    }

    private boolean supported(SQLAggregate sqlAggr) {
        IXQEQueryNode first = sqlAggr.getChild(0);
        SQLAggregate.SubType aggrType = sqlAggr.getSubType();
        if (aggrType == SQLAggregate.SubType.COUNT && first.getType() != 301005) {
            return false;
        }
        return !sqlAggr.isDistinct() && this.canRollUp(sqlAggr);
    }

    private SQLRangeVar getAggregatesForRewriteOverTQ(IXQEQueryNode node, PlanningEnvironment environment, RQPQuery rqpQuery, Param pm) {
        TreeMap<String, HashMap<Pair, ArrayList<SQLColumn>>> aggrColumns = new TreeMap<String, HashMap<Pair, ArrayList<SQLColumn>>>();
        SQLAggregate sqlAggr = (SQLAggregate)node;
        if (sqlAggr.getNumberParameters() < 1) {
            return null;
        }
        if (!this.supported(sqlAggr)) {
            return null;
        }
        String aggrFunc = sqlAggr.getFunctionName();
        HashMap<Pair, ArrayList<SQLColumn>> tabColNames = new HashMap<Pair, ArrayList<SQLColumn>>();
        if (!this.checkCalculationAndgetSQLColumns(sqlAggr.getChild(0), tabColNames)) {
            return null;
        }
        IAggregateAwareness aw = environment.getMetadataConnection().getAggregateAwareness();
        ArrayList<IXQEQueryNode> sqlRangeVars = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeSkipSubQuery(rqpQuery, 301007, sqlRangeVars, null, true);
        IXQEQueryNode[] children = sqlRangeVars.get(0).getChildren();
        RQPQuery tqRQPQuery = (RQPQuery)children[0];
        ArrayList<IXQEQueryNode> skip = new ArrayList<IXQEQueryNode>();
        TreeSet<String> allTopColNames = new TreeSet<String>();
        for (Pair pair : tabColNames.keySet()) {
            allTopColNames.add((String)pair.getSecond());
        }
        HashMap<Pair, ArrayList<SQLColumn>> tabColNamesInTQ = new HashMap<Pair, ArrayList<SQLColumn>>();
        aggrColumns.put(aggrFunc, tabColNamesInTQ);
        for (String tc : allTopColNames) {
            Object tqFirst = null;
            Pair aP = this.getFirstInTQ(pm.skipAlias, tqRQPQuery, tc, skip);
            if (aP != null) {
                tqFirst = (IXQEQueryNode)aP.getFirst();
            }
            if (!this.checkCalculationAndgetSQLColumns((IXQEQueryNode)tqFirst, tabColNamesInTQ)) {
                return null;
            }
            skip.add((IXQEQueryNode)tqFirst);
        }
        SQLRangeVar sQLRangeVar = this.findBaseTableSQLRangeVar(aw, tqRQPQuery, tabColNamesInTQ, pm.baseTableNames);
        if (sQLRangeVar == null) {
            return null;
        }
        this.updateChain4SQLAggregtae(sqlAggr, tabColNames, pm, tqRQPQuery, skip);
        ArrayList<IXQEQueryNode> sqlAggregates = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeSkipSubQuery(rqpQuery, 301034, sqlAggregates, null, true);
        for (IXQEQueryNode s : sqlAggregates) {
            SQLAggregate otherSqlAggr;
            if (s == node || (otherSqlAggr = (SQLAggregate)s).getNumberParameters() < 1) continue;
            ArrayList<IXQEQueryNode> otherSQLColsTop = new ArrayList<IXQEQueryNode>();
            this.getDescendantsOfTypeSkipSubQuery(otherSqlAggr.getChild(0), 301005, otherSQLColsTop, null, false);
            TreeSet<String> otherColNamesTop = new TreeSet<String>();
            for (IXQEQueryNode iXQEQueryNode : otherSQLColsTop) {
                otherColNamesTop.add(((SQLColumn)iXQEQueryNode).getName());
            }
            boolean bUseBaseTable = false;
            for (String ocName : otherColNamesTop) {
                IXQEQueryNode tqFirst = null;
                Pair aP = this.getFirstInTQ(pm.skipAlias, tqRQPQuery, ocName, skip);
                if (aP != null) {
                    tqFirst = (IXQEQueryNode)aP.getFirst();
                }
                skip.add(tqFirst);
                if (!this.useBaseTable(tqFirst, pm.baseTableNames[0])) continue;
                bUseBaseTable = true;
                break;
            }
            if (!bUseBaseTable) continue;
            if (!this.supported(otherSqlAggr)) {
                return null;
            }
            HashMap<Pair, ArrayList<SQLColumn>> hashMap = new HashMap<Pair, ArrayList<SQLColumn>>();
            if (!this.checkCalculationAndgetSQLColumns(otherSqlAggr.getChild(0), hashMap)) {
                return null;
            }
            String otherAggrFunc = otherSqlAggr.getFunctionName();
            for (String ocName : otherColNamesTop) {
                HashMap<Pair, ArrayList<SQLColumn>> otherTabColNamesTQ;
                IXQEQueryNode tqFirst = null;
                Pair aP = this.getFirstInTQ(pm.skipAlias, tqRQPQuery, ocName, skip);
                if (aP != null) {
                    tqFirst = (IXQEQueryNode)aP.getFirst();
                }
                if ((otherTabColNamesTQ = (HashMap<Pair, ArrayList<SQLColumn>>)aggrColumns.get(otherAggrFunc)) == null) {
                    otherTabColNamesTQ = new HashMap<Pair, ArrayList<SQLColumn>>();
                    aggrColumns.put(otherAggrFunc, otherTabColNamesTQ);
                }
                if (this.checkCalculationAndgetSQLColumns(tqFirst, otherTabColNamesTQ)) continue;
                return null;
            }
            this.updateChain4SQLAggregtae(otherSqlAggr, hashMap, pm, tqRQPQuery, skip);
        }
        TreeMap<String, String> baseTabColNameToOrigianlName = this.getColNameMap(sQLRangeVar);
        if (!this.getAllGroupingItems(aw, tqRQPQuery, baseTabColNameToOrigianlName, skip, pm)) {
            node.writeFormattedText(pm.msg[0]);
            return null;
        }
        TreeSet<String> allGroupingUNames = new TreeSet<String>(pm.groupingItems.keySet());
        this.addExtraGroupingItemsFromFJO(sQLRangeVar, pm.baseTableNames, allGroupingUNames, baseTabColNameToOrigianlName);
        for (Map.Entry e : aggrColumns.entrySet()) {
            String aggrType = (String)e.getKey();
            ArrayList<SQLColumn> cols = this.getTQSQLColumnsForTabName((HashMap)e.getValue(), pm.baseTableNames[0]);
            if (this.getMatchingAggregateQuerySubject(cols, aw, pm.baseTableNames[1], allGroupingUNames, aggrType, baseTabColNameToOrigianlName, pm.aggregates)) continue;
            return null;
        }
        return sQLRangeVar;
    }

    private void updateChain4SQLAggregtae(SQLAggregate sqlAggr, HashMap<Pair, ArrayList<SQLColumn>> tabColNames, Param pm, RQPQuery tqRQPQuery, ArrayList<IXQEQueryNode> skip) {
        ArrayList list = new ArrayList();
        pm.sqlAggregates.add(new Pair(sqlAggr, list));
        for (Map.Entry<Pair, ArrayList<SQLColumn>> e : tabColNames.entrySet()) {
            Pair p = e.getKey();
            String cName = (String)p.getSecond();
            for (SQLColumn c : e.getValue()) {
                Pair aP = this.getFirstInTQ(pm.skipAlias, tqRQPQuery, cName, skip);
                if (aP == null) continue;
                ArrayList<IXQEQueryNode> l = new ArrayList<IXQEQueryNode>();
                l.add(c);
                l.add((IXQEQueryNode)aP.getFirst());
                l.add((IXQEQueryNode)aP.getSecond());
                list.add(l);
            }
        }
    }

    private ArrayList<SQLColumn> getTQSQLColumnsForTabName(HashMap<Pair, ArrayList<SQLColumn>> mp, String tabName) {
        ArrayList<SQLColumn> rt = new ArrayList<SQLColumn>();
        for (Map.Entry<Pair, ArrayList<SQLColumn>> e : mp.entrySet()) {
            String tname = (String)e.getKey().getFirst();
            if (!tabName.equals(tname)) continue;
            rt.addAll((Collection<SQLColumn>)e.getValue());
        }
        return rt;
    }

    private Pair getFirstInTQ(HashSet<IXQEQueryNode> skipAlias, RQPQuery tqRQPQuery, String colName, ArrayList<IXQEQueryNode> skip) {
        ArrayList<IXQEQueryNode> sqlAlias = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeSkipSubQuery(tqRQPQuery, 301028, sqlAlias, null, true);
        for (IXQEQueryNode a : sqlAlias) {
            int sz;
            SQLAlias alias;
            SQLAlias orgAlias = alias = (SQLAlias)a;
            if (!colName.equals(alias.getName())) continue;
            String orgName = GenerateCTEInWithClauseForRQPSubQuery.getOriginalColumnName(alias);
            IXQEQueryNode first = alias.getChild(0);
            if (first.getType() == 301074 && (sz = this.checkNameforDET(orgName)) > 0) {
                first = first.getChild(0).getChild(0).getChild(1);
                String skipName = orgName.substring(0, orgName.length() - sz);
                for (IXQEQueryNode aa : sqlAlias) {
                    alias = (SQLAlias)aa;
                    orgName = GenerateCTEInWithClauseForRQPSubQuery.getOriginalColumnName(alias);
                    if (!orgName.equals(skipName)) continue;
                    skip.add(alias);
                    skipAlias.add(alias);
                    break;
                }
            }
            if (first != null) {
                return new Pair(first, orgAlias);
            }
            return null;
        }
        return null;
    }

    private int checkNameforDET(String orgName) {
        int idx = orgName.lastIndexOf("_u");
        if (idx == -1) {
            return 0;
        }
        String s = orgName.substring(idx + 2);
        if (s.isEmpty()) {
            return 2;
        }
        if (!s.matches("^[0-9]+$")) {
            return 0;
        }
        return 2 + s.length();
    }

    private SQLRangeVar getAggregatesForRewriteNormal(IXQEQueryNode node, PlanningEnvironment environment, RQPQuery rqpQuery, Param pm) {
        IAggregateAwareness aw = environment.getMetadataConnection().getAggregateAwareness();
        SQLRangeVar baseTableRangeVar = this.getBaseTableSQLRangeVar(rqpQuery, (SQLAggregate)node, aw, pm.baseTableNames);
        if (baseTableRangeVar == null) {
            return null;
        }
        if (((SQLAggregate)node).isDistinct()) {
            node.writeFormattedText(pm.msg[0]);
            pm.msg[1].append(MSG);
            return null;
        }
        ArrayList<IXQEQueryNode> others = new ArrayList<IXQEQueryNode>();
        if (!this.getOtherAggregates(rqpQuery, node, pm.baseTableNames[0], others, pm.msg, baseTableRangeVar, aw)) {
            return null;
        }
        others.add(node);
        TreeMap<String, String> baseTabColNameToOrigianlName = this.getColNameMap(baseTableRangeVar);
        ArrayList<IXQEQueryNode> skip = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode aggr : others) {
            skip.add(aggr.getChild(0));
        }
        if (!this.getAllGroupingItems(aw, rqpQuery, baseTabColNameToOrigianlName, skip, pm)) {
            node.writeFormattedText(pm.msg[0]);
            return null;
        }
        TreeSet<String> allGroupingUNames = new TreeSet<String>(pm.groupingItems.keySet());
        this.addExtraGroupingItemsFromFJO(baseTableRangeVar, pm.baseTableNames, allGroupingUNames, baseTabColNameToOrigianlName);
        for (IXQEQueryNode aggr : others) {
            String aggrType = ((SQLAggregate)aggr).getFunctionName();
            if (!this.canRollUp(aggr)) {
                aggr.writeFormattedText(pm.msg[0]);
                pm.msg[1].append("The aggregate function '");
                pm.msg[1].append(aggrType);
                pm.msg[1].append("' prevents aggregate query subject substitution.");
                return null;
            }
            ArrayList<SQLColumn> cols = this.getSQLColumnsForTabName(aggr.getChild(0), pm.baseTableNames[0]);
            if (!this.getMatchingAggregateQuerySubject(cols, aw, pm.baseTableNames[1], allGroupingUNames, aggrType, baseTabColNameToOrigianlName, pm.aggregates)) {
                aggr.writeFormattedText(pm.msg[0]);
                pm.msg[1].append("no aggregate query subject matching the aggregate function or grouping items: ");
                pm.msg[1].append(allGroupingUNames.toString());
                return null;
            }
            ArrayList scols = new ArrayList();
            for (SQLColumn c : cols) {
                ArrayList<SQLColumn> l = new ArrayList<SQLColumn>();
                l.add(c);
                scols.add(l);
            }
            pm.sqlAggregates.add(new Pair(aggr, scols));
        }
        return baseTableRangeVar;
    }

    private boolean getMatchingAggregateQuerySubject(ArrayList<SQLColumn> cols, IAggregateAwareness aw, String baseQS, TreeSet<String> allGroupingUNames, String aggrType, TreeMap<String, String> baseTabColNameToOrgName, TreeMap<String, HashMap<Pair, ArrayList<IXQEQueryNode>>> aggregates) {
        for (SQLColumn c : cols) {
            HashMap<Pair, ArrayList<IXQEQueryNode>> aggCols;
            List<String> sumInfo = this.getSummaryTable(aw, baseQS, aggrType, c.getName(), allGroupingUNames, baseTabColNameToOrgName);
            if (sumInfo == null) {
                return false;
            }
            String summaryTable = sumInfo.get(0);
            String summaryCol = sumInfo.get(1);
            String summaryColCount = null;
            if (sumInfo.size() > 2) {
                summaryColCount = sumInfo.get(2);
            }
            if ((aggCols = aggregates.get(summaryTable)) == null) {
                aggCols = new HashMap();
                aggregates.put(summaryTable, aggCols);
            }
            Pair p1 = null;
            p1 = aggrType.equals(AGGR_AVG) ? new Pair(summaryCol, AGGR_SUM) : new Pair(summaryCol, aggrType);
            ArrayList<IXQEQueryNode> aggrNodes = aggCols.get(p1);
            if (aggrNodes == null) {
                aggrNodes = new ArrayList();
                aggCols.put(p1, aggrNodes);
            }
            aggrNodes.add(c);
            if (summaryColCount == null) continue;
            Pair p2 = new Pair(summaryColCount, AGGR_COUNT);
            aggrNodes = aggCols.get(p2);
            if (aggrNodes == null) {
                aggrNodes = new ArrayList();
                aggCols.put(p2, aggrNodes);
            }
            aggrNodes.add(c);
        }
        return true;
    }

    private ArrayList<IXQEQueryNode> getAllFJOSQLColumns(IXQEQueryNode node) {
        IXQEQueryNode[] sqlCols;
        ArrayList<IXQEQueryNode> rt = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode c : sqlCols = node.getDescendantsOfType(301005, true)) {
            if (Boolean.TRUE != c.getPropertyValue("manySideRQPQuery")) continue;
            rt.add(c);
        }
        return rt;
    }

    private void addExtraGroupingItemsFromFJO(SQLRangeVar baseTableRangeVar, String[] baseTableNames, TreeSet<String> allGroupingUNames, TreeMap<String, String> baseTabColNameToOrigianlName) {
        IXQEQueryNode child = baseTableRangeVar.getChild(0);
        if (!child.isOfCategory(801017)) {
            return;
        }
        ArrayList<IXQEQueryNode> sqlColsFJO = this.getAllFJOSQLColumns(child);
        if (sqlColsFJO.isEmpty()) {
            return;
        }
        for (IXQEQueryNode c : sqlColsFJO) {
            SQLColumn sqlC = (SQLColumn)c;
            String name = this.getTopMostOrigName(baseTableRangeVar, sqlC);
            if (name == null) continue;
            String uniName = UniqueNameGenerator.join(baseTableNames[1], UniqueNameGenerator.createSingleNamePart(name));
            allGroupingUNames.add(uniName);
        }
    }

    private String getTopMostOrigName(SQLRangeVar topMost, SQLColumn sqlC) {
        SQLAlias alias = this.getTopMostSQLAlias(topMost, sqlC, sqlC.getTableName(), sqlC.getName());
        if (alias != null) {
            return GenerateCTEInWithClauseForRQPSubQuery.getOriginalColumnName(alias);
        }
        return null;
    }

    private SQLAlias getTopMostSQLAlias(SQLRangeVar topMost, IXQEQueryNode node, String tab, String col) {
        SQLRangeVar sqlV = (SQLRangeVar)node.getAncestorOfType(301007);
        if (sqlV == null) {
            return null;
        }
        IXQEQueryNode rqpQ = sqlV.getChild(0);
        if (!rqpQ.isOfCategory(801017)) {
            return null;
        }
        ArrayList<IXQEQueryNode> sqlAlias = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeSkipSubQuery(rqpQ, 301028, sqlAlias, null, true);
        SQLAlias found = null;
        for (IXQEQueryNode a : sqlAlias) {
            SQLColumn sqlC;
            SQLAlias as = (SQLAlias)a;
            IXQEQueryNode c = as.getChild(0);
            if (c.getType() != 301005 || !tab.equals((sqlC = (SQLColumn)c).getTableName()) || !col.equals(sqlC.getName())) continue;
            found = as;
            break;
        }
        if (found == null || sqlV == topMost) {
            return found;
        }
        return this.getTopMostSQLAlias(topMost, sqlV, sqlV.getName(), found.getName());
    }

    private boolean canRollUp(IXQEQueryNode aggr) {
        SQLAggregate.SubType tp = ((SQLAggregate)aggr).getSubType();
        return tp == SQLAggregate.SubType.MAX || tp == SQLAggregate.SubType.MIN || tp == SQLAggregate.SubType.SUM || tp == SQLAggregate.SubType.COUNT || tp == SQLAggregate.SubType.AVG;
    }

    private TreeMap<String, String> getColNameMap(SQLRangeVar baseTable) {
        TreeMap<String, String> rt = new TreeMap<String, String>();
        IXQEQueryNode rqpQ = baseTable.getChild(0);
        if (rqpQ.isOfCategory(801017) || rqpQ.getType() == 301015 || rqpQ.getType() == 301010) {
            ArrayList<IXQEQueryNode> sqlAlias = new ArrayList<IXQEQueryNode>();
            this.getDescendantsOfTypeSkipSubQuery(rqpQ, 301028, sqlAlias, null, true);
            for (IXQEQueryNode a : sqlAlias) {
                SQLAlias as = (SQLAlias)a;
                String org = GenerateCTEInWithClauseForRQPSubQuery.getOriginalColumnName(as);
                rt.put(as.getName(), org);
            }
        }
        return rt;
    }

    private boolean checkCalculationAndgetSQLColumns(IXQEQueryNode node, HashMap<Pair, ArrayList<SQLColumn>> sqlColumns) {
        IXQEQueryNode[] children;
        SQLValueExpression vExp;
        int type = node.getType();
        if (type == 301005) {
            SQLColumn col = (SQLColumn)node;
            String tabName = col.getTableName();
            if (tabName == null) {
                return false;
            }
            Pair p = new Pair(tabName, col.getName());
            ArrayList<SQLColumn> sqlCols = sqlColumns.get(p);
            if (sqlCols == null) {
                sqlCols = new ArrayList();
                sqlColumns.put(p, sqlCols);
            }
            sqlCols.add(col);
            return true;
        }
        if (type == 301031 || type == 301037) {
            return true;
        }
        if (type != 301025 && type != 301071 && type != 301047) {
            return false;
        }
        if (type == 301025 && (vExp = (SQLValueExpression)node).getSubType() != SQLValueExpression.SubType.MULTIPLY && vExp.getSubType() != SQLValueExpression.SubType.DIVIDE) {
            return false;
        }
        for (IXQEQueryNode c : children = node.getChildren()) {
            if (this.checkCalculationAndgetSQLColumns(c, sqlColumns)) continue;
            return false;
        }
        return true;
    }

    private SQLRangeVar getBaseTableSQLRangeVar(RQPQuery rqpQuery, SQLAggregate node, IAggregateAwareness aw, String[] tab) {
        if (node.getNumberParameters() < 1) {
            return null;
        }
        IXQEQueryNode first = node.getChild(0);
        HashMap<Pair, ArrayList<SQLColumn>> tabColNames = new HashMap<Pair, ArrayList<SQLColumn>>();
        SQLAggregate.SubType aggrType = node.getSubType();
        if (aggrType == SQLAggregate.SubType.COUNT && first.getType() != 301005) {
            return null;
        }
        if (!this.checkCalculationAndgetSQLColumns(first, tabColNames)) {
            return null;
        }
        return this.findBaseTableSQLRangeVar(aw, rqpQuery, tabColNames, tab);
    }

    private SQLRangeVar findBaseTableSQLRangeVar(IAggregateAwareness aw, RQPQuery rqpQuery, HashMap<Pair, ArrayList<SQLColumn>> tabColNames, String[] tab) {
        ArrayList<IXQEQueryNode> sqlRangeVars = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeSkipSubQuery(rqpQuery, 301007, sqlRangeVars, null, true);
        block0: for (Map.Entry<Pair, ArrayList<SQLColumn>> e : tabColNames.entrySet()) {
            String tabName = (String)e.getKey().getFirst();
            for (IXQEQueryNode v : sqlRangeVars) {
                if (!tabName.equals(((SQLRangeVar)v).getName())) continue;
                String qsName = (String)v.getPropertyValue("fullQSName");
                if (qsName == null || !aw.isBaseFactQuerySubject(qsName)) continue block0;
                tab[0] = tabName;
                tab[1] = qsName;
                return (SQLRangeVar)v;
            }
        }
        return null;
    }

    private boolean useBaseTable(IXQEQueryNode node, String tabName) {
        IXQEQueryNode[] cols;
        for (IXQEQueryNode c : cols = node.getDescendantsOfType(301005, true)) {
            SQLColumn col = (SQLColumn)c;
            if (!tabName.equals(col.getTableName())) continue;
            return true;
        }
        return false;
    }

    private boolean getOtherAggregates(RQPQuery rqpQuery, IXQEQueryNode node, String tabName, ArrayList<IXQEQueryNode> others, StringBuilder[] msg, SQLRangeVar baseTableRangeVar, IAggregateAwareness aw) {
        ArrayList<IXQEQueryNode> sqlAggrs = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeSkipSubQuery(rqpQuery, 301034, sqlAggrs, null, true);
        for (IXQEQueryNode aggr : sqlAggrs) {
            SQLAggregate sAggr;
            if (aggr == node || (sAggr = (SQLAggregate)aggr).getNumberParameters() < 1 || !this.useBaseTable(sAggr.getChild(0), tabName)) continue;
            String[] tab = new String[]{null, null};
            SQLRangeVar sv = this.getBaseTableSQLRangeVar(rqpQuery, sAggr, aw, tab);
            if (sv == null || sv != baseTableRangeVar || sAggr.isDistinct()) {
                aggr.writeFormattedText(msg[0]);
                msg[1].append("has conflict with ");
                node.writeFormattedText(msg[1]);
                msg[1].append(" or ");
                msg[1].append(MSG);
                return false;
            }
            others.add(aggr);
        }
        return true;
    }

    private boolean getAllGroupingItems(IAggregateAwareness aw, RQPQuery rqpQuery, TreeMap<String, String> baseTabColNameToOrigianlName, ArrayList<IXQEQueryNode> skips, Param pm) {
        ArrayList<IXQEQueryNode> sqlCols = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeSkipSubQuery(rqpQuery, 301005, sqlCols, skips, true);
        for (IXQEQueryNode c : sqlCols) {
            SQLColumn aSQLCol = (SQLColumn)c;
            String tab = aSQLCol.getTableName();
            if (!pm.baseTableNames[0].equals(tab)) continue;
            String name = aSQLCol.getName();
            String orgName = baseTabColNameToOrigianlName.get(name);
            if (orgName != null) {
                name = orgName;
            }
            String uniName = UniqueNameGenerator.join(pm.baseTableNames[1], UniqueNameGenerator.createSingleNamePart(name));
            if (!aw.isGroupingItem(pm.baseTableNames[1], uniName)) {
                pm.msg[1].append(uniName);
                pm.msg[1].append(" is not a grouping item in the base fact query subject.");
                return false;
            }
            ArrayList<SQLColumn> cols = (ArrayList<SQLColumn>)pm.groupingItems.get(uniName);
            if (cols == null) {
                cols = new ArrayList<SQLColumn>();
                pm.groupingItems.put(uniName, cols);
            }
            cols.add(aSQLCol);
        }
        return true;
    }

    private List<String> getSummaryTable(IAggregateAwareness aw, String baseTableName, String aggrType, String colName, TreeSet<String> commonGroupingItems, TreeMap<String, String> baseTabColNameToOrigianlName) {
        String org = baseTabColNameToOrigianlName.get(colName);
        if (org != null) {
            colName = org;
        }
        String uniName = UniqueNameGenerator.join(baseTableName, UniqueNameGenerator.createSingleNamePart(colName));
        if (aggrType.equals(AGGR_AVG)) {
            Pair p1 = aw.getAggregateQsAndFactItemUNames(baseTableName, uniName, AGGR_SUM, commonGroupingItems);
            if (p1 == null) {
                return null;
            }
            Pair p2 = aw.getAggregateQsAndFactItemUNames(baseTableName, uniName, AGGR_COUNT, commonGroupingItems);
            if (p2 == null) {
                return null;
            }
            ArrayList<String> rt = new ArrayList<String>();
            rt.add((String)p1.getFirst());
            rt.add((String)p1.getSecond());
            rt.add((String)p2.getSecond());
            return rt;
        }
        Pair p = aw.getAggregateQsAndFactItemUNames(baseTableName, uniName, aggrType, commonGroupingItems);
        if (p == null) {
            return null;
        }
        ArrayList<String> rt = new ArrayList<String>();
        rt.add((String)p.getFirst());
        rt.add((String)p.getSecond());
        return rt;
    }

    private void getDescendantsOfTypeSkipSubQuery(IXQEQueryNode node, int type, ArrayList<IXQEQueryNode> rt, ArrayList<IXQEQueryNode> skipNodes, boolean skip) {
        IXQEQueryNode[] children;
        if (!skip) {
            if (skipNodes != null && skipNodes.contains(node)) {
                return;
            }
            if (node.getType() == type) {
                rt.add(node);
                return;
            }
            if (node.isOfCategory(801017) || node.getType() == 301007) {
                return;
            }
        }
        for (IXQEQueryNode c : children = node.getChildren()) {
            this.getDescendantsOfTypeSkipSubQuery(c, type, rt, skipNodes, false);
        }
    }

    private TreeMap<String, String> getColNameMapFromQuerySubject(PlanningEnvironment environment, String summaryTableName) {
        TreeMap<String, String> rt = new TreeMap<String, String>();
        V5NameBinding nameBinding = new V5NameBinding(environment);
        IMetadata metadata = nameBinding.bindModelIdentifier(summaryTableName, true);
        if (metadata != null && metadata instanceof IQuerySubject) {
            for (IMetadata qi : ((IQuerySubject)metadata).getQueryItemsAndMeasures()) {
                IQueryItem queryItem = (IQueryItem)qi;
                String name = queryItem.getName();
                String uName = queryItem.getUniqueName();
                rt.put(uName, name);
            }
        }
        return rt;
    }

    private void substituteBaseFactTableWithAggregateTable(PlanningEnvironment environment, SQLRangeVar sqlRangeVar, Param pm) {
        IAggregateAwareness aw = environment.getMetadataConnection().getAggregateAwareness();
        for (Map.Entry e : pm.aggregates.entrySet()) {
            String summaryColName;
            String summaryColUName;
            String summaryTableName = (String)e.getKey();
            SQLRangeVar summarySQLRangeVar = aw.cloneAggregateQsSQLRangeVar(environment, pm.baseTableNames[1], summaryTableName);
            if (summarySQLRangeVar == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, MSG1);
            }
            TreeMap<String, String> aggregateColsMap = null;
            aggregateColsMap = summarySQLRangeVar.getNumberChildren() == 1 && summarySQLRangeVar.getChild(0).getType() == 301016 ? this.getColNameMapFromQuerySubject(environment, summaryTableName) : this.getColNameMap(summarySQLRangeVar);
            TreeSet<String> requredSQLAlias = new TreeSet<String>();
            for (Map.Entry e1 : pm.groupingItems.entrySet()) {
                String baseColUName = (String)e1.getKey();
                summaryColUName = aw.getGroupingItemUNameAggregateQs(pm.baseTableNames[1], baseColUName, summaryTableName);
                summaryColName = this.getColumnNameFromUName(summaryColUName, aggregateColsMap);
                requredSQLAlias.add(summaryColName);
                for (SQLColumn sqlC : (ArrayList)e1.getValue()) {
                    sqlC.setTableName(summarySQLRangeVar.getName());
                    sqlC.removeProperty("orginalTableName");
                    sqlC.setName(summaryColName);
                }
            }
            HashMap aggrs = (HashMap)e.getValue();
            for (Map.Entry e3 : aggrs.entrySet()) {
                summaryColUName = (String)((Pair)e3.getKey()).getFirst();
                summaryColName = this.getColumnNameFromUName(summaryColUName, aggregateColsMap);
                requredSQLAlias.add(summaryColName);
                ArrayList aggrNodes = (ArrayList)e3.getValue();
                for (IXQEQueryNode aggr : aggrNodes) {
                    SQLColumn sqlC = (SQLColumn)aggr;
                    sqlC.setTableName(summarySQLRangeVar.getName());
                    sqlC.removeProperty("orginalTableName");
                    sqlC.setName(summaryColName);
                }
            }
            this.replaceSQLRangeVar(environment, sqlRangeVar, summarySQLRangeVar, aggregateColsMap, requredSQLAlias, aw);
        }
    }

    private String getColumnNameFromUName(String colUName, TreeMap<String, String> colsMap) {
        String[] nameParst = UniqueNameParser.parseNoThrow(colUName);
        String colName = nameParst[nameParst.length - 1];
        for (Map.Entry<String, String> e2 : colsMap.entrySet()) {
            if (!e2.getValue().equals(colName)) continue;
            return e2.getKey();
        }
        return colName;
    }

    private void replaceSQLRangeVar(PlanningEnvironment environment, SQLRangeVar sqlRangeVar, SQLRangeVar summarySQLRangeVar, TreeMap<String, String> aggregateColsMap, TreeSet<String> requredSQLAlias, IAggregateAwareness aw) {
        IXQEQueryNode firtsParamofAggrgate;
        this.transferFJOtoAggregateSQLRangeVar(environment, sqlRangeVar, summarySQLRangeVar, aggregateColsMap, requredSQLAlias, aw);
        if (!aggregateColsMap.isEmpty() && (firtsParamofAggrgate = summarySQLRangeVar.getChild(0)).isOfCategory(801017)) {
            ArrayList<IXQEQueryNode> sqlAlias = new ArrayList<IXQEQueryNode>();
            this.getDescendantsOfTypeSkipSubQuery(firtsParamofAggrgate, 301028, sqlAlias, null, true);
            for (IXQEQueryNode a : sqlAlias) {
                SQLAlias as = (SQLAlias)a;
                String name = as.getName();
                if (requredSQLAlias.contains(name)) continue;
                as.detach();
            }
        }
        sqlRangeVar.exchange(summarySQLRangeVar);
    }

    private HashMap<String, Pair> getSQLAliasToColumnMap(SQLRangeVar sqlRangeVar) {
        HashMap<String, Pair> rt = new HashMap<String, Pair>();
        IXQEQueryNode rqpQ = sqlRangeVar.getChild(0);
        if (rqpQ.isOfCategory(801017)) {
            ArrayList<IXQEQueryNode> sqlAlias = new ArrayList<IXQEQueryNode>();
            this.getDescendantsOfTypeSkipSubQuery(rqpQ, 301028, sqlAlias, null, true);
            for (IXQEQueryNode a : sqlAlias) {
                SQLAlias as = (SQLAlias)a;
                IXQEQueryNode c = as.getChild(0);
                if (c.getType() != 301005) continue;
                SQLColumn sqlC = (SQLColumn)c;
                String aliasName = as.getName();
                String tab = sqlC.getTableName();
                String col = sqlC.getName();
                Pair p = new Pair(tab, col);
                rt.put(aliasName, p);
            }
        }
        return rt;
    }

    private void transferFJOtoAggregateSQLRangeVar(PlanningEnvironment environment, SQLRangeVar sqlRangeVar, SQLRangeVar summarySQLRangeVar, TreeMap<String, String> aggregateColsMap, TreeSet<String> requredSQLAlias, IAggregateAwareness aw) {
        IXQEQueryNode firtsParamofAggrgate = summarySQLRangeVar.getChild(0);
        if (!firtsParamofAggrgate.isOfCategory(801017)) {
            return;
        }
        IXQEQueryNode firstProject = firtsParamofAggrgate.getChild(0);
        if (firstProject.getType() != 301015 && firstProject.getType() != 301010) {
            return;
        }
        HashSet<IXQEQueryNode> fjoFilters = new HashSet<IXQEQueryNode>();
        IXQEQueryNode firstParamofBase = sqlRangeVar.getChild(0);
        if (firstParamofBase.isOfCategory(801017)) {
            ArrayList<IXQEQueryNode> allSQLColsinFJO = this.getAllFJOSQLColumns(firstParamofBase);
            for (IXQEQueryNode c : allSQLColsinFJO) {
                fjoFilters.add(c.getParent());
            }
        }
        if (fjoFilters.isEmpty()) {
            return;
        }
        HashMap<String, Pair> aliasToCols = this.getSQLAliasToColumnMap(summarySQLRangeVar);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode current = null;
        String baseTableName = (String)sqlRangeVar.getPropertyValue("fullQSName");
        String summaryTableName = (String)summarySQLRangeVar.getPropertyValue("fullQSName");
        for (IXQEQueryNode fjo : fjoFilters) {
            ArrayList<IXQEQueryNode> sqlCols = new ArrayList<IXQEQueryNode>();
            this.getDescendantsOfTypeSkipSubQuery(fjo, 301005, sqlCols, null, false);
            for (IXQEQueryNode c : sqlCols) {
                SQLColumn sqlC = (SQLColumn)c;
                String name = this.getTopMostOrigName(sqlRangeVar, sqlC);
                if (name == null) {
                    return;
                }
                String uName = UniqueNameGenerator.join(baseTableName, UniqueNameGenerator.createSingleNamePart(name));
                String summaryColUName = aw.getGroupingItemUNameAggregateQs(baseTableName, uName, summaryTableName);
                String summaryColName = this.getColumnNameFromUName(summaryColUName, aggregateColsMap);
                Pair pp = aliasToCols.get(summaryColName);
                if (pp == null) {
                    return;
                }
                sqlC.setTableName((String)pp.getFirst());
                sqlC.removeProperty("orginalTableName");
                sqlC.setName((String)pp.getSecond());
            }
            fjo.detach();
            IXQEQueryNode filter = firstProject.getFirstChildByType(301009);
            if (filter == null) {
                IXQEQueryNode sqlRangeV = this.getFirstChildByTypes(firstProject, SRC_TYPES);
                if (sqlRangeV == null) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, MSG1);
                }
                filter = (SQLFilter)nodeFactory.createNode(301009);
                sqlRangeV.insertParent(filter);
                filter.addChild(fjo);
                current = fjo;
                continue;
            }
            if (current == null) {
                IXQEQueryNode[] children;
                for (IXQEQueryNode cnode : children = filter.getChildren()) {
                    if (cnode.getType() == 301007) continue;
                    current = cnode;
                    break;
                }
            }
            SQLLogical logicalAND = (SQLLogical)nodeFactory.createNode(301027);
            logicalAND.setSubType(SQLLogical.SubType.AND);
            current.insertParent(logicalAND);
            logicalAND.addChild(fjo);
            current = logicalAND;
        }
    }

    private IXQEQueryNode getFirstChildByTypes(IXQEQueryNode node, int[] types) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode c : children = node.getChildren()) {
            int type = c.getType();
            for (int t : types) {
                if (t != type) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IAggregateAwareness aw = environment.getMetadataConnection().getAggregateAwareness();
        return aw != null && aw.hasBaseFactTableDefinition();
    }

    private final class Param {
        private TreeMap<String, HashMap<Pair, ArrayList<IXQEQueryNode>>> aggregates = new TreeMap();
        private TreeMap<String, ArrayList<SQLColumn>> groupingItems = new TreeMap();
        private String[] baseTableNames = new String[]{null, null};
        private HashSet<IXQEQueryNode> skipAlias = new HashSet();
        private StringBuilder[] msg = new StringBuilder[2];
        private ArrayList<Pair> sqlAggregates = new ArrayList();
        private boolean bUseTQ = false;

        private Param() {
            this.msg[0] = new StringBuilder();
            this.msg[1] = new StringBuilder();
        }
    }
}

