/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StructType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemFolder;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqemoser.MoserQueryItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReplaceV5BoundModelIdenitifierWithSQLColumn
extends RQPTransformation {
    public ReplaceV5BoundModelIdenitifierWithSQLColumn() {
        this.mPassNumbers = new int[]{44};
        this.mTypes = new int[]{201116};
        this.mName = "Replace V5BoundModelIdentifier with SQLColumn";
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode sqlRangeVar;
        SQLRangeVar parentRangeVar;
        V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)node;
        RMQueryList rmList = RQPUtilities.getRMQueryList(identifier);
        List<String> chain = null;
        String correlationName = null;
        RMQuery rmQuery = null;
        String columnName = null;
        IMetadata metadata = identifier.getMetadata();
        if (metadata instanceof IQueryItem) {
            IQueryItem qi = (IQueryItem)identifier.getMetadata();
            IQuerySubject qs = qi.getQuerySubject();
            if (qs == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "No query subject associated with query item. Probably DMR.");
            }
            rmQuery = rmList.getRMQuery(qs);
            if (qs != null) {
                IQuerySubject.QuerySubjectTypeEnum qsType = qs.getQuerySubjectType();
                if (qsType == IQuerySubject.QuerySubjectTypeEnum.QUERYOPERATION) {
                    columnName = qi.getCaption();
                    if (qi instanceof MoserQueryItem) {
                        columnName = qi.getName();
                    }
                }
                if (qsType == IQuerySubject.QuerySubjectTypeEnum.DBQSASVIEW) {
                    chain = this.getIdentifierChain(qi);
                }
            }
        } else {
            rmQuery = rmList.getRMQuery(identifier);
        }
        String[] nameparts = identifier.getNameParts();
        List<IMetadata> multisetItems = RQPUtilities.getListOfMultisetItems(metadata);
        if (multisetItems.size() > 0) {
            correlationName = multisetItems.get(multisetItems.size() - 1).getName();
        }
        if (rmQuery != null && correlationName == null) {
            correlationName = rmQuery.getCorrelationName();
        }
        String subQueryName = null;
        subQueryName = correlationName == null ? nameparts[1] : correlationName;
        if ((columnName = columnName == null ? RQPUtilities.findProjectionAlias(subQueryName, identifier.getColumnName(), identifier) : RQPUtilities.findProjectionAlias(subQueryName, columnName, identifier)) == null) {
            columnName = identifier.getColumnName();
        }
        if ((parentRangeVar = (SQLRangeVar)node.getAncestorOfType(301007)) != null && !this.existsRangeVarWithCorrelationName(correlationName, parentRangeVar)) {
            correlationName = nameparts[1];
        }
        SQLColumn sqlColumn = RQPUtilities.createSQLColumn(environment.getNodeFactory(), correlationName, columnName);
        sqlColumn.setDataType(identifier.getDataType());
        if (chain != null) {
            chain.add(columnName);
            sqlColumn.setIdentifierChain(chain);
        }
        if (node.getPropertyValue("manySideRQPQuery") != null) {
            sqlColumn.setPropertyValue("manySideRQPQuery", Boolean.TRUE);
        }
        if (rmQuery != null && (rmQuery.getType() == 801027 || rmQuery.getType() == 801028) && (sqlRangeVar = rmQuery.getFirstChildByType(301007)) != null) {
            IXQEQueryNode tableSample;
            IXQEQueryNode sqlRelation = sqlRangeVar.getFirstChildByType(301016);
            if (sqlRelation == null && (tableSample = sqlRangeVar.getFirstChildByType(301092)) != null) {
                sqlRelation = tableSample.getChild(0);
            }
            if (sqlRelation != null) {
                sqlColumn.setPropertyValue("orginalTableName", ((SQLRelation)sqlRelation).getPropertyValue("name"));
            }
        }
        node.exchange(sqlColumn);
    }

    private List<String> getIdentifierChain(IQueryItem qi) {
        IDataType dt;
        ArrayList<String> chain = null;
        for (IMetadata parent = qi.getParentObject(); parent != null && parent instanceof IQueryItemFolder && StructType.STRUCTTYPE.equals(dt = parent.getDataType()); parent = parent.getParentObject()) {
            String id;
            if (chain == null) {
                chain = new ArrayList<String>();
            }
            if ((id = parent.getID()) == null) {
                return null;
            }
            String name = UniqueNameParser.parseLastIdentifier(id);
            chain.add(name);
        }
        if (chain != null) {
            Collections.reverse(chain);
        }
        return chain;
    }

    private boolean existsRangeVarWithCorrelationName(String correlationName, IXQEQueryNode parent) {
        IXQEQueryNode[] rangeVars;
        for (IXQEQueryNode rv : rangeVars = parent.getDescendantsOfType(301007, false)) {
            if (!((SQLRangeVar)rv).getName().equals(correlationName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        return node.getParent().getNodeType() != 801033;
    }
}

