/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.v5Exp.V5OrderedValueExpression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ReplaceV5OrderedValueExpression
extends RQPTransformation {
    public ReplaceV5OrderedValueExpression() {
        this.mName = "Replace V5OrderedValueExpression node with SQLLiteral or SQLWindow node.";
        this.mPassNumbers = new int[]{46};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[]{201114};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (node.getNumberChildren() == 0) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_MissingArgumentForAggFunc);
        }
        SQLAggregate aggregate = (SQLAggregate)node.getParent();
        IXQEQueryNode childNode = node.getChild(0);
        if (childNode.getType() == 301031 && aggregate.getSubType() == SQLAggregate.SubType.NTILE && aggregate.getFirstChildByType(301041) != null) {
            node.extract();
        } else {
            aggregate.createOrGetWindow(nodeFactory);
            if (aggregate.getSubType() == SQLAggregate.SubType.RATIO_TO_REPORT) {
                node.extract();
                return;
            }
            boolean sortOrder = false;
            SQLSortKey.NullOrdering nullOrdering = SQLSortKey.NullOrdering.UNSPECIFIED;
            if (aggregate.getSubType() == SQLAggregate.SubType.CUME_DIST) {
                sortOrder = true;
            } else if (aggregate.getSubType() == SQLAggregate.SubType.TERTILE) {
                if (((V5OrderedValueExpression)node).getSubType() == 1) {
                    sortOrder = true;
                }
            } else if (aggregate.getSubType() == SQLAggregate.SubType.RANK || aggregate.getSubType() == SQLAggregate.SubType.DENSE_RANK) {
                if (((V5OrderedValueExpression)node).getSubType() == 1) {
                    sortOrder = true;
                }
                nullOrdering = ((V5OrderedValueExpression)node).getNullOrdering() == 1 ? SQLSortKey.NullOrdering.NULLS_FIRST : SQLSortKey.NullOrdering.NULLS_LAST;
            } else if ((aggregate.getSubType() == SQLAggregate.SubType.FIRST_VALUE || aggregate.getSubType() == SQLAggregate.SubType.LAST_VALUE) && ((V5OrderedValueExpression)node).getSubType() == 1) {
                sortOrder = true;
            }
            aggregate.addSortKey(nodeFactory.deepCopyNode(childNode), sortOrder, nullOrdering, nodeFactory);
            node.detach();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        IXQEQueryNode parent = node.getAncestorOfType(301034);
        if (parent == null) {
            this.traceNodeCondition(false, "The V5OrderedValueExpression is not a child of SQLAggregate.", xqeTrace);
            return false;
        }
        return true;
    }
}

