/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSortItem;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunctionSubtype;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MovingAndRunningSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueAnalyticFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.FloatType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.DisableQueryReuseForUDF;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.PutForClauseItemsInMinOrGroupByForAnalyticFunctions;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Pair;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public final class ReplaceV5SummaryFunction
extends RQPTransformation {
    private static final String MEDIAN_PERCENTILE = "0.5";
    private static final String DISTINCT = "DISTINCT";

    public ReplaceV5SummaryFunction() {
        this.mName = "Replace V5ValueSummaryFunction node with a SQLAggregate node.";
        this.mPassNumbers = new int[]{15};
        this.mTypes = new int[]{201031, 201033, 201035};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        int v5AggregateFunctionSubtype = ReplaceV5SummaryFunction.getV5AggregateFunctionSubType(node);
        SQLAggregate sqlNode = ReplaceV5SummaryFunction.createSqlAggregateNode(environment, node, v5AggregateFunctionSubtype);
        node.exchange(sqlNode, true);
        if (v5AggregateFunctionSubtype == 43) {
            DisableQueryReuseForUDF.disableQueryReuseForUDF(sqlNode);
        }
        if (sqlNode.getSubType() == SQLAggregate.SubType.PERCENTILE_CONT) {
            ReplaceV5SummaryFunction.convertToPercentileCont(nodeFactory, sqlNode);
            return;
        }
        if (node.getType() == 201035) {
            if (node.getPropertyValue("orderBy") != null) {
                sqlNode.setPropertyValue("orderBy", node.getPropertyValue("orderBy"));
            }
            this.buildMovingAndRunningWindow((V5MovingAndRunningSummaryFunction)node, sqlNode, environment);
            return;
        }
        if (node.getType() == 201033 && v5AggregateFunctionSubtype == 18) {
            this.buildLiteralForQuartile(sqlNode, nodeFactory);
            ((V5ValueAnalyticFunction)node).setSubType(17);
        }
        ReplaceV5SummaryFunction.generatePartitionByClause(sqlNode, nodeFactory);
        if (v5AggregateFunctionSubtype == 12 || v5AggregateFunctionSubtype == 13) {
            SQLWindow window = sqlNode.createOrGetWindow(nodeFactory);
            this.setWindowProperties(window, false);
            window.setWindowFrameUpperBound(Integer.MAX_VALUE);
        }
    }

    public static SQLAggregate createSqlAggregateNode(PlanningEnvironment environment, IXQEQueryNode v5Aggregate, int v5AggregateFunctionSubtype) {
        boolean isDistinct = ((V5AggregateFunction)v5Aggregate).getDistinct();
        SQLAggregate.SubType sqlAggregateSubtype = ReplaceV5SummaryFunction.convertV5AggregateFunctionSubTypeToSqlAggregateSubtype(v5AggregateFunctionSubtype, isDistinct);
        if (sqlAggregateSubtype == SQLAggregate.SubType.COUNT) {
            if (0 == v5Aggregate.getNumberChildren()) {
                sqlAggregateSubtype = SQLAggregate.SubType.COUNT_STAR;
            } else {
                IXQEQueryNode child = v5Aggregate.getChild(0);
                if (201025 == child.getType()) {
                    sqlAggregateSubtype = SQLAggregate.SubType.COUNT_STAR;
                    child.extract();
                }
            }
        }
        if (sqlAggregateSubtype == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidV5SummaryFunctionSubType, Integer.toString(v5AggregateFunctionSubtype));
        }
        SQLAggregate sqlNode = (SQLAggregate)environment.getNodeFactory().createNode(301034);
        sqlNode.setSubType(sqlAggregateSubtype);
        if (sqlAggregateSubtype == SQLAggregate.SubType.UDF) {
            String udfName = ((V5AggregateFunction)v5Aggregate).getNativeName();
            sqlNode.setFunctionName(udfName);
        }
        ExecutionEnvironment ee = (ExecutionEnvironment)environment.getExecutionEnvironment();
        if (isDistinct) {
            switch (v5AggregateFunctionSubtype) {
                case 1: 
                case 2: 
                case 9: {
                    sqlNode.setDistinct(true);
                    break;
                }
                case 4: 
                case 6: 
                case 14: {
                    break;
                }
                case 23: {
                    String msg = XQEMessages.getMessage(XQEMessageKeys.PLN_ConsiderRankDistinctForRunningCountDistinct, XQEMessages.getCurrProductLocale(), DISTINCT, ((V5AggregateFunction)v5Aggregate).getNativeName(), V5AggregateFunctionSubtype.getName(14), DISTINCT);
                    ee.addNag(msg);
                    break;
                }
                default: {
                    String nagMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_UnsupportedDistinct, XQEMessages.getCurrProductLocale(), ((V5AggregateFunction)v5Aggregate).getNativeName());
                    ee.addNag(nagMsg);
                }
            }
        }
        return sqlNode;
    }

    private void buildLiteralForQuartile(IXQEQueryNode aggregateNode, IXQENodeFactory nodeFactory) {
        SQLLiteral literal = (SQLLiteral)nodeFactory.createNode(301031);
        literal.setDataType(DataTypeFactory.getSmallintType());
        literal.setValue("4");
        aggregateNode.addChild(literal);
    }

    private SQLLiteral buildLiteralForOrderBy(IXQENodeFactory nodeFactory) {
        SQLLiteral literal = (SQLLiteral)nodeFactory.createNode(301031);
        literal.setDataType(DataTypeFactory.getSmallintType());
        literal.setValue("100");
        return literal;
    }

    private void buildMovingAndRunningWindow(V5MovingAndRunningSummaryFunction v5Function, SQLAggregate aggregate, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLWindow window = aggregate.createOrGetWindow(factory);
        this.setWindowProperties(window, v5Function.isMovingFunction());
        ReplaceV5SummaryFunction.generatePartitionByClause(aggregate, factory);
        Object obj = v5Function.getPropertyValue("determinantKeyProjections");
        if (obj != null) {
            aggregate.setPropertyValue("determinantKeyProjections", obj);
        }
        this.generateOrderByAndATClause(aggregate, environment, obj != null);
        this.putWindowItemsInMinFunction(environment.getNodeFactory(), aggregate, window);
    }

    private void putWindowItemsInMinFunction(XQENodeFactory factory, SQLAggregate aggregate, SQLWindow window) {
        IXQEQueryNode[] children;
        boolean olapAggInGroupingColumn;
        if (RQPNode.isUnderRMQuery(aggregate)) {
            return;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(aggregate);
        if (rqpQuery.getType() == 801025) {
            return;
        }
        IXQEQueryNode[] groupingItems = rqpQuery.getGroupingItems();
        if (groupingItems == null || groupingItems.length == 0) {
            return;
        }
        RQPDataItem rqpDI = (RQPDataItem)aggregate.getAncestorOfType(801008);
        boolean bl = olapAggInGroupingColumn = rqpDI != null && rqpDI.isGroupingItem();
        if (olapAggInGroupingColumn) {
            return;
        }
        for (IXQEQueryNode child : children = window.getChildren()) {
            if (child.getType() != 301021) continue;
            this.putOrderByItemInMinFunction(factory, rqpQuery, aggregate, child);
        }
    }

    private void putOrderByItemInMinFunction(XQENodeFactory factory, RQPQuery rqpQuery, SQLAggregate aggregate, IXQEQueryNode sortKeyList) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = sortKeyList.getChildren()) {
            IXQEQueryNode item = child.getChild(0);
            if (RQPUtilities.hasAggregateInExpression(item) || PutForClauseItemsInMinOrGroupByForAnalyticFunctions.forClauseItemfoundInGroupBy(rqpQuery, item)) continue;
            SQLAggregate minFunction = (SQLAggregate)factory.createNode(301034);
            minFunction.setSubType(SQLAggregate.SubType.MIN);
            item.insertParent(minFunction);
        }
    }

    private static void generatePartitionByClause(SQLAggregate aggregate, IXQENodeFactory nodeFactory) {
        IXQEQueryNode forClause = ReplaceV5SummaryFunction.getV5AggregateBreakClause(aggregate);
        if (forClause == null) {
            return;
        }
        IXQEQueryNode[] forClauseItems = null;
        forClauseItems = forClause.getChildren();
        SQLWindow window = aggregate.createOrGetWindow(nodeFactory);
        if (forClauseItems != null && forClauseItems.length > 0) {
            SQLPartition partition = window.createOrGetPartition(nodeFactory);
            for (int i = 0; i < forClauseItems.length; ++i) {
                partition.addChild(nodeFactory.deepCopyNode(forClauseItems[i]));
            }
        }
        forClause.detach();
    }

    private void generateOrderByAndATClause(SQLAggregate aggregate, PlanningEnvironment environment, boolean isDistinct) {
        SQLSortKeyList sortKeyList;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode overallSort = this.getOverallSort(aggregate, environment, isDistinct);
        IXQEQueryNode[] partitionByItems = this.getPartitionByItems(aggregate, nodeFactory);
        IXQEQueryNode[] selectedItems = this.getMax(partitionByItems, this.getAtClauseItems(aggregate));
        boolean ascending = true;
        if (selectedItems != null) {
            for (int i = 0; i < selectedItems.length; ++i) {
                if (this.alreadyInSort(selectedItems[i], overallSort)) continue;
                IXQEQueryNode cloneOfOrderByItem = nodeFactory.deepCopyNode(selectedItems[i]);
                aggregate.addSortKey(cloneOfOrderByItem, ascending, nodeFactory);
            }
        }
        if ((sortKeyList = aggregate.getSortKeyList(nodeFactory)).getNumberChildren() == 0) {
            aggregate.addSortKey(this.buildLiteralForOrderBy(nodeFactory), ascending, nodeFactory);
            return;
        }
    }

    private IXQEQueryNode[] getMax(IXQEQueryNode[] forClauseItems, IXQEQueryNode[] atClauseItems) {
        IXQEQueryNode[] selectedItems = null;
        if (forClauseItems != null && forClauseItems.length != 0) {
            selectedItems = atClauseItems == null ? forClauseItems : (forClauseItems.length >= atClauseItems.length ? forClauseItems : atClauseItems);
        } else if (atClauseItems != null) {
            selectedItems = forClauseItems;
        }
        return selectedItems;
    }

    private boolean alreadyInSort(IXQEQueryNode node, IXQEQueryNode sortNode) {
        if (sortNode.getNumberChildren() == 0) {
            return false;
        }
        for (IXQEQueryNode child : sortNode.getChildren()) {
            if (!child.getChild(0).isSameExpression(node, false)) continue;
            return true;
        }
        return false;
    }

    private IXQEQueryNode[] getAtClauseItems(SQLAggregate aggregate) {
        IXQEQueryNode atClause = this.getV5AggregateATClause(aggregate);
        if (atClause == null) {
            return null;
        }
        return atClause.getChildren();
    }

    private IXQEQueryNode[] getPartitionByItems(SQLAggregate aggregate, IXQENodeFactory nodeFactory) {
        SQLWindow window = aggregate.createOrGetWindow(nodeFactory);
        IXQEQueryNode partition = window.getFirstChildByType(301042);
        if (partition == null) {
            return null;
        }
        return partition.getChildren();
    }

    public static void convertToPercentileCont(IXQENodeFactory nodeFactory, SQLAggregate sqlNode) {
        IXQEQueryNode[] children = sqlNode.getChildren();
        SQLLiteral sqlLiteral = (SQLLiteral)nodeFactory.createNode(301031);
        sqlLiteral.setDataType(FloatType.FLOATTYPE);
        sqlLiteral.setValue(MEDIAN_PERCENTILE);
        sqlNode.addChild(sqlLiteral, 0);
        SQLSortKeyList sqlSortKeyList = (SQLSortKeyList)nodeFactory.createNode(301021);
        ReplaceV5SummaryFunction.populateSortKeyList(nodeFactory, sqlSortKeyList, children);
        sqlNode.addChild(sqlSortKeyList, 1);
        ReplaceV5SummaryFunction.generatePartitionByClause(sqlNode, nodeFactory);
    }

    private static void populateSortKeyList(IXQENodeFactory nodeFactory, SQLSortKeyList sqlSortKeyList, IXQEQueryNode[] sortKeyItems) {
        SQLSortKey sqlSortKey = (SQLSortKey)nodeFactory.createNode(301020);
        sqlSortKey.setAscending(false);
        sortKeyItems[0].move(sqlSortKey, 0);
        sqlSortKeyList.addChild(sqlSortKey);
    }

    public static SQLAggregate.SubType convertV5AggregateFunctionSubTypeToSqlAggregateSubtype(int v5AggregateFunctionSubtype, boolean isDistinct) {
        switch (v5AggregateFunctionSubtype) {
            case 9: {
                return SQLAggregate.SubType.SUM;
            }
            case 2: {
                return SQLAggregate.SubType.COUNT;
            }
            case 1: {
                return SQLAggregate.SubType.AVG;
            }
            case 6: {
                return SQLAggregate.SubType.MIN;
            }
            case 4: {
                return SQLAggregate.SubType.MAX;
            }
            case 8: {
                return SQLAggregate.SubType.STDDEV_POP;
            }
            case 41: {
                return SQLAggregate.SubType.STDDEV_SAMP;
            }
            case 7: {
                return SQLAggregate.SubType.STDDEV_SAMP;
            }
            case 11: {
                return SQLAggregate.SubType.VAR_POP;
            }
            case 42: {
                return SQLAggregate.SubType.VAR_SAMP;
            }
            case 10: {
                return SQLAggregate.SubType.VAR_SAMP;
            }
            case 5: {
                return SQLAggregate.SubType.PERCENTILE_CONT;
            }
            case 21: 
            case 27: {
                return SQLAggregate.SubType.SUM;
            }
            case 20: 
            case 22: {
                return SQLAggregate.SubType.AVG;
            }
            case 23: {
                return SQLAggregate.SubType.COUNT;
            }
            case 25: {
                return SQLAggregate.SubType.MAX;
            }
            case 26: {
                return SQLAggregate.SubType.MIN;
            }
            case 24: {
                return SQLAggregate.SubType.DIFFERENCE;
            }
            case 15: {
                return SQLAggregate.SubType.RATIO_TO_REPORT;
            }
            case 16: {
                return SQLAggregate.SubType.CUME_DIST;
            }
            case 17: {
                return SQLAggregate.SubType.NTILE;
            }
            case 18: {
                return SQLAggregate.SubType.NTILE;
            }
            case 14: {
                if (isDistinct) {
                    return SQLAggregate.SubType.DENSE_RANK;
                }
                return SQLAggregate.SubType.RANK;
            }
            case 19: {
                return SQLAggregate.SubType.TERTILE;
            }
            case 43: {
                return SQLAggregate.SubType.UDF;
            }
            case 29: {
                return SQLAggregate.SubType.CORR;
            }
            case 30: {
                return SQLAggregate.SubType.COVAR_POP;
            }
            case 31: {
                return SQLAggregate.SubType.COVAR_SAMP;
            }
            case 32: {
                return SQLAggregate.SubType.REGR_AVGX;
            }
            case 33: {
                return SQLAggregate.SubType.REGR_AVGY;
            }
            case 34: {
                return SQLAggregate.SubType.REGR_COUNT;
            }
            case 35: {
                return SQLAggregate.SubType.REGR_INTERCEPT;
            }
            case 36: {
                return SQLAggregate.SubType.REGR_R2;
            }
            case 37: {
                return SQLAggregate.SubType.REGR_SLOPE;
            }
            case 38: {
                return SQLAggregate.SubType.REGR_SXX;
            }
            case 39: {
                return SQLAggregate.SubType.REGR_SXY;
            }
            case 40: {
                return SQLAggregate.SubType.REGR_SYY;
            }
            case 12: {
                return SQLAggregate.SubType.FIRST_VALUE;
            }
            case 13: {
                return SQLAggregate.SubType.LAST_VALUE;
            }
            case 44: {
                return SQLAggregate.SubType.APPROX_COUNT_DISTINCT;
            }
        }
        return null;
    }

    public static int getV5AggregateFunctionSubType(IXQEQueryNode node) {
        switch (node.getType()) {
            case 201031: {
                return ((V5ValueSummaryFunction)node).getSubType();
            }
            case 201035: {
                return ((V5MovingAndRunningSummaryFunction)node).getSubType();
            }
            case 201033: {
                return ((V5ValueAnalyticFunction)node).getSubType();
            }
        }
        return -1;
    }

    private static IXQEQueryNode getV5AggregateBreakClause(IXQEQueryNode aggregate) {
        return aggregate.getFirstChildByType(201037);
    }

    private IXQEQueryNode getV5AggregateATClause(IXQEQueryNode aggregate) {
        return aggregate.getFirstChildByType(201036);
    }

    private IXQEQueryNode getOverallSort(SQLAggregate aggregate, PlanningEnvironment env, boolean isDistinct) {
        IXQEQueryNode rqpSortList;
        XQENodeFactory factory = env.getNodeFactory();
        SQLWindow window = aggregate.createOrGetWindow(factory);
        SQLSortKeyList sqlSortList = window.createOrGetSortKeyList(factory);
        if (RQPNode.isUnderRMQuery(aggregate)) {
            return sqlSortList;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(aggregate);
        RQPQuery rootQuery = rqpQuery.getRootRQPQuery();
        if (rootQuery.getPropertyValue("rootDSQSQuery") != null) {
            if (this.generateOrderByFromUserSpecification(factory, aggregate, rqpQuery, sqlSortList)) {
                return sqlSortList;
            }
            this.addOverallSortInDSQSRMAggregate(env, aggregate, rqpQuery, rootQuery, sqlSortList);
        }
        if ((rqpSortList = rootQuery.getFirstChildByType(801020)) == null || rqpSortList.getChildren().length == 0) {
            this.addProjsWithExplicitSortInOrderBy(factory, aggregate, sqlSortList, rqpQuery);
            this.addSortingItemsInOrderBy(factory, aggregate, sqlSortList, rqpQuery);
            this.addGroupingColumnsInOrderBy(factory, aggregate, sqlSortList, rqpQuery, null);
            if (0 == sqlSortList.getChildren().length && ReplaceV5SummaryFunction.isRunningAggregateUsedInFilterOfReferencingQuery(aggregate)) {
                ReplaceV5SummaryFunction.addProjectionsToSortList(aggregate, sqlSortList, factory);
                return sqlSortList;
            }
            if (0 == sqlSortList.getChildren().length && null != (rqpSortList = this.getSortListOfOutermostQuery(env)) && rqpSortList.getChildren().length > 0) {
                for (IXQEQueryNode sortKey : rqpSortList.getChildren()) {
                    IXQEQueryNode aggregateInMatchingProj;
                    RQPDataItemSelfRef projRef = (RQPDataItemSelfRef)sortKey.getChild(0);
                    RQPDataItem matchingProj = rqpQuery.findProjection(projRef.getName());
                    if (null == matchingProj || null != (aggregateInMatchingProj = matchingProj.getFirstDescendantOfTypeOrdered(301034, false))) continue;
                    this.addProjectionItemToSortList(factory, matchingProj, sortKey, sqlSortList);
                }
            }
            if (isDistinct) {
                String string = rootQuery.getDefaultTabularQuery().getName();
                this.addCaseRowNumberExprInOrderByClause(env, aggregate, sqlSortList, string);
            }
            return sqlSortList;
        }
        for (IXQEQueryNode sortKey : rqpSortList.getChildren()) {
            RQPDataItemSelfRef projRef = (RQPDataItemSelfRef)sortKey.getChild(0);
            IXQEQueryNode sortItemExpr = projRef.getExpression();
            RQPDataItem projInSubquery = rqpQuery.getProjectionWithSameExprAsTheGroupingExpression(sortItemExpr);
            if (projInSubquery == null) continue;
            this.addProjectionItemToSortList(factory, projInSubquery, sortKey, sqlSortList);
        }
        if (isDistinct) {
            String string = rootQuery.getDefaultTabularQuery().getName();
            this.addCaseRowNumberExprInOrderByClause(env, aggregate, sqlSortList, string);
        }
        return sqlSortList;
    }

    private IXQEQueryNode getSortListOfOutermostQuery(PlanningEnvironment env) {
        V5QuerySet querySet = (V5QuerySet)env.getRoot();
        IXQEQueryNode dataset = querySet.getFirstChildByType(401005);
        return dataset.getFirstDescendantOfTypeOrdered(801020, false);
    }

    private void addProjectionItemToSortList(IXQENodeFactory factory, RQPDataItem projection, IXQEQueryNode sortKey, IXQEQueryNode sqlSortList) {
        IXQEQueryNode newSortKey = factory.deepCopyNode(sortKey);
        newSortKey.getChild(0).exchange(factory.deepCopyNode(projection.getExpression()));
        sqlSortList.addChild(newSortKey);
    }

    private void addGroupingColumnsInOrderBy(IXQENodeFactory factory, SQLAggregate aggregate, IXQEQueryNode sqlSortList, RQPQuery rqpQuery, String sortDirection) {
        IXQEQueryNode[] children;
        RQPDataItem parentItem = (RQPDataItem)aggregate.getAncestorOfType(801008);
        for (IXQEQueryNode child : children = rqpQuery.getProjectionList().getChildren()) {
            RQPDataItem dataItem = (RQPDataItem)child;
            if (dataItem == parentItem || !dataItem.isGroupingItem() || ReplaceV5SummaryFunction.hasMovingRunningInExpression(dataItem.getExpression()) || this.alreadyInSort(dataItem.getExpression(), sqlSortList)) continue;
            SQLSortKey sortKey = (SQLSortKey)factory.createNode(301020);
            if (sortDirection != null) {
                if (sortDirection.equals("ASC")) {
                    sortKey.setAscending(true);
                } else {
                    sortKey.setAscending(false);
                }
            } else {
                sortKey.setAscending(dataItem.isAscending());
            }
            sortKey.addChild(factory.deepCopyNode(dataItem.getExpression()));
            sqlSortList.addChild(sortKey);
        }
    }

    private void addSortingItemsInOrderBy(IXQENodeFactory factory, SQLAggregate aggregate, IXQEQueryNode sqlSortList, RQPQuery rqpQuery) {
        IXQEQueryNode[] children;
        RQPDataItem parentItem = (RQPDataItem)aggregate.getAncestorOfType(801008);
        for (IXQEQueryNode child : children = rqpQuery.getProjectionList().getChildren()) {
            String sort;
            RQPDataItem dataItem = (RQPDataItem)child;
            if (dataItem == parentItem || dataItem.isGroupingItem() || rqpQuery.getRefV5Query() == null || ReplaceV5SummaryFunction.hasMovingRunningInExpression(dataItem.getExpression()) || this.alreadyInSort(dataItem.getExpression(), sqlSortList) || (sort = this.getV5DISort(dataItem)) == null) continue;
            SQLSortKey sortKey = (SQLSortKey)factory.createNode(301020);
            sortKey.setAscending(sort.equals("ascending"));
            sortKey.addChild(factory.deepCopyNode(dataItem.getExpression()));
            sqlSortList.addChild(sortKey);
        }
    }

    private void addProjsWithExplicitSortInOrderBy(IXQENodeFactory factory, SQLAggregate aggregate, IXQEQueryNode sqlSortList, RQPQuery rqpQuery) {
        IXQEQueryNode[] children;
        RQPDataItem parentItem = (RQPDataItem)aggregate.getAncestorOfType(801008);
        for (IXQEQueryNode child : children = rqpQuery.getProjectionList().getChildren()) {
            RQPDataItem dataItem = (RQPDataItem)child;
            if (dataItem.isAscending() || dataItem == parentItem || this.alreadyInSort(dataItem.getExpression(), sqlSortList)) continue;
            SQLSortKey sortKey = (SQLSortKey)factory.createNode(301020);
            sortKey.setAscending(false);
            sortKey.addChild(factory.deepCopyNode(dataItem.getExpression()));
            sqlSortList.addChild(sortKey);
        }
    }

    private String getV5DISort(RQPDataItem proj) {
        V5DataItem di = RQPUtilities.getV5DataItemInSelection(proj, proj.getOriginalName());
        if (di == null) {
            return null;
        }
        return (String)di.getPropertyValue("sort");
    }

    private boolean generateOrderByFromUserSpecification(IXQENodeFactory factory, SQLAggregate aggregate, RQPQuery aggregateRQPQuery, IXQEQueryNode sqlSortList) {
        List obItemList = (List)aggregate.getPropertyValue("orderBy");
        if (obItemList == null) {
            return false;
        }
        for (Pair p : obItemList) {
            String qiName = (String)p.getFirst();
            String sortOrder = (String)p.getSecond();
            if (qiName.equals("AUTO ")) {
                this.addGroupingColumnsInOrderBy(factory, aggregate, sqlSortList, aggregateRQPQuery, sortOrder);
                continue;
            }
            RQPDataItem rqpDi = aggregateRQPQuery.getRQPDataItemByName(qiName);
            IXQEQueryNode operand = null;
            if (rqpDi == null || this.alreadyInSort(operand = rqpDi.getExpression(), sqlSortList)) continue;
            this.addSortKey(sqlSortList, operand, factory, 0, sortOrder.equals("ASC"));
        }
        return true;
    }

    private void addOverallSortInDSQSRMAggregate(PlanningEnvironment env, SQLAggregate aggregate, RQPQuery aggregateRQPQuery, RQPQuery rootQuery, IXQEQueryNode sqlSortList) {
        RQPQuery rqpQueryReferencedByLayout = this.findRQPQueryReferencedByLayout(env, rootQuery);
        IXQEQueryNode rqpSortList = rqpQueryReferencedByLayout.getFirstChildByType(801020);
        XQENodeFactory factory = env.getNodeFactory();
        if (rqpSortList != null) {
            for (IXQEQueryNode sortKey : rqpSortList.getChildren()) {
                IXQEQueryNode expr;
                RQPDataItem rqpDi;
                V5BoundDataItemReference ref;
                RQPSortItem sortItem = (RQPSortItem)sortKey;
                String sortOrder = sortItem.getSortOrder();
                boolean isAscending = sortOrder == null || sortOrder.equals("ascending");
                RQPDataItemSelfRef projRef = (RQPDataItemSelfRef)sortKey.getChild(0);
                IXQEQueryNode sortItemExpr = projRef.getExpression();
                IXQEQueryNode[] refs = sortItemExpr.getDescendantsOfType(201060, true);
                if (refs.length <= 0 || !(ref = (V5BoundDataItemReference)refs[0]).isQueryRefItem() || (rqpDi = this.findProjectionMatchingSortItem(env, ref, aggregateRQPQuery, rootQuery)) == null || this.alreadyInSort(expr = rqpDi.getExpression(), sqlSortList) || ReplaceV5SummaryFunction.hasMovingRunningInExpression(expr)) continue;
                this.addSortKey(sqlSortList, rqpDi.getExpression(), factory, -1, isAscending);
            }
        }
    }

    public RQPDataItem findProjectionMatchingSortItem(PlanningEnvironment env, V5BoundDataItemReference sortItemExpr, RQPQuery aggregateRQPQuery, RQPQuery rootQuery) {
        IXQEQueryNode expr = sortItemExpr;
        V5QuerySet querySet = (V5QuerySet)env.getRoot();
        V5Query rootV5Query = rootQuery.getRefV5Query();
        boolean unwindSortItemExpr = true;
        while (unwindSortItemExpr && expr.getType() == 201060) {
            RQPDataItem rqpDi;
            V5BoundDataItemReference ref = expr;
            String queryName = ref.getNameParts()[0];
            V5Query query = querySet.getV5Query(queryName);
            if (query == rootV5Query) {
                RQPQuery rqpQuery = (RQPQuery)rootV5Query.getFirstChildByType(801017);
                rqpDi = rqpQuery.getRQPDataItemByName(ref.getNameParts()[1]);
                if (rqpQuery == aggregateRQPQuery) {
                    return rqpDi;
                }
                IXQEQueryNode diExpr = rqpDi.getExpression();
                while (diExpr.getType() == 801009) {
                    RQPDataItem rqpDi1 = ((RQPDataItemRef)diExpr).getNextReferencedItem();
                    RQPQuery rqpQuery2 = (RQPQuery)rqpDi1.getAncestorOfTypes(new int[]{801017, 801024});
                    if (rqpQuery2 == aggregateRQPQuery) {
                        return rqpDi1;
                    }
                    diExpr = rqpDi1.getExpression();
                }
                unwindSortItemExpr = false;
                continue;
            }
            if (query.getDynamicSQS() != null) continue;
            RQPQuery rqpQuery1 = (RQPQuery)query.getFirstChildByType(801017);
            rqpDi = rqpQuery1.getRQPDataItemByName(sortItemExpr.getNameParts()[1]);
            expr = rqpDi.getExpression();
        }
        return null;
    }

    private RQPQuery findRQPQueryReferencedByLayout(PlanningEnvironment env, RQPQuery aDsqsRQPQuery) {
        V5Query query;
        V5Query rootDSQS = (V5Query)aDsqsRQPQuery.getPropertyValue("rootDSQSQuery");
        RQPQuery rootDSQSQuery = this.findRQPQueryByV5Query(env, rootDSQS);
        if (rootDSQSQuery.getPropertyValue("isReferencedByQRD") != null) {
            return rootDSQSQuery;
        }
        String rootQueryName = rootDSQS.getRootQueryName();
        V5QuerySet querySet = (V5QuerySet)env.getRoot();
        if (rootQueryName != null && (query = querySet.getV5Query(rootQueryName)) != null) {
            return this.findRQPQueryByV5Query(env, query);
        }
        return null;
    }

    private RQPQuery findRQPQueryByV5Query(PlanningEnvironment env, V5Query rootDSQS) {
        IXQEQueryNode[] rqpQueries;
        V5QuerySet querySet = (V5QuerySet)env.getRoot();
        for (IXQEQueryNode rqpQuery : rqpQueries = querySet.getDescendantsOfType(801017, false)) {
            V5Query query = ((RQPQuery)rqpQuery).getRefV5Query();
            if (query != rootDSQS) continue;
            return (RQPQuery)rqpQuery;
        }
        return null;
    }

    private void addCaseRowNumberExprInOrderByClause(PlanningEnvironment env, SQLAggregate aggregate, IXQEQueryNode sqlSortList, String tabQueryName) {
        RQPDataItemRef detAttr;
        String detAttProjName;
        int pos;
        XQENodeFactory factory = env.getNodeFactory();
        List detKeyProjs = (List)aggregate.getPropertyValue("determinantKeyProjections");
        RQPQuery aggrQuery = RQPNode.getRQPQuery(aggregate);
        for (IXQEQueryNode proj : detKeyProjs) {
            String projName = ((RQPDataItem)proj).getName();
            if (this.findSortItemInSortList(projName, sqlSortList) != -1) continue;
            if (aggrQuery.getType() == 801025) {
                RQPDataItem di = aggrQuery.getRQPDataItemByName(projName);
                this.addSortKey(sqlSortList, di.getExpression(), factory, sqlSortList.getNumberChildren(), true);
                continue;
            }
            RQPDataItemRef diRef = RQPDataItemRef.create(env, tabQueryName, projName);
            this.addSortKey(sqlSortList, diRef, factory, sqlSortList.getNumberChildren(), true);
        }
        List<IXQEQueryNode> refs = aggregate.getDescendantsOfTypeOrdered(801009, false, 301041);
        if (refs.size() > 0 && (pos = this.findSortItemInSortList(detAttProjName = (detAttr = (RQPDataItemRef)refs.get(0)).getName().substring(0, detAttr.getName().length() - 2), sqlSortList)) != -1) {
            SQLSortKey sortKey = this.addSortKey(sqlSortList, detAttr, factory, ++pos, true);
            sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
        }
    }

    private SQLSortKey addSortKey(IXQEQueryNode sqlSortList, IXQEQueryNode sortItemExpr, IXQENodeFactory factory, int pos, boolean isAscending) {
        SQLSortKey sortKey = (SQLSortKey)factory.createNode(301020);
        sortKey.setAscending(isAscending);
        sortKey.addChild(factory.deepCopyNode(sortItemExpr));
        if (pos != -1) {
            sqlSortList.addChild(sortKey, pos);
        } else {
            sqlSortList.addChild(sortKey);
        }
        return sortKey;
    }

    private int findSortItemInSortList(String sortItemName, IXQEQueryNode sqlSortList) {
        int n = sqlSortList.getNumberChildren();
        String sortName = null;
        for (int i = 0; i < n; ++i) {
            IXQEQueryNode sortItemExpr = sqlSortList.getChild(i).getChild(0);
            if (sortItemExpr.getType() == 801009) {
                sortName = ((RQPDataItemRef)sortItemExpr).getName();
            } else if (sortItemExpr.getType() == 801008) {
                sortName = ((RQPDataItem)sortItemExpr).getName();
            } else if (sortItemExpr.getType() == 201116) {
                sortName = ((V5BoundModelIdentifier)sortItemExpr).getColumnName();
            }
            if (!sortItemName.equals(sortName)) continue;
            return i;
        }
        return -1;
    }

    private void setWindowProperties(SQLWindow window, boolean isMovingFunction) {
        window.setWindowFrameUnits("ROWS");
        window.setWindowFrameUpperBound(0);
        if (isMovingFunction) {
            V5LiteralValue valueNode = this.getMovingFunctionLowerBoundValue(window);
            int lowerBoundPreceding = valueNode.getValue().getInteger();
            lowerBoundPreceding = -(lowerBoundPreceding - 1);
            window.setWindowFrameLowerBound(lowerBoundPreceding);
            valueNode.detach();
        } else {
            window.setWindowFrameLowerBound(Integer.MIN_VALUE);
        }
    }

    private V5LiteralValue getMovingFunctionLowerBoundValue(SQLWindow window) {
        SQLAggregate aggregate = (SQLAggregate)window.getParent();
        IXQEQueryNode[] literals = aggregate.getChildrenOfType(201026);
        if (literals.length > 0) {
            return (V5LiteralValue)literals[0];
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_MissingArgumentForMovingFunc);
    }

    public static boolean hasMovingRunningInExpression(IXQEQueryNode expressionNode) {
        return expressionNode.hasDescendantOfType(201035, true) || expressionNode.hasDescendantOfType(301041, true);
    }

    private static boolean isRunningAggregateUsedInFilterOfReferencingQuery(IXQEQueryNode aggregate) {
        if (aggregate.getParent().getType() != 801008 || aggregate.getParent().getParent().getType() != 801016) {
            return false;
        }
        IXQEQueryNode aggrItem = aggregate.getParent();
        IXQEQueryNode parentQuery = aggrItem.getParent().getParent();
        RQPQuery referencingQuery = (RQPQuery)parentQuery.getAncestorOfType(801017);
        if (referencingQuery != null && referencingQuery.getDetailFilterList() != null) {
            IXQEQueryNode[] itemRefList;
            RQPDetailFilterList filterList = referencingQuery.getDetailFilterList();
            for (IXQEQueryNode itemRef : itemRefList = filterList.getDescendantsOfType(801009, false)) {
                if (((RQPDataItemRef)itemRef).getReferencedItem() != aggrItem) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void addProjectionsToSortList(IXQEQueryNode aggregate, IXQEQueryNode sqlSortList, IXQENodeFactory factory) {
        SQLSortKey sortKey;
        RQPDataItem dataItem;
        void var12_15;
        IXQEQueryNode aggrItem = aggregate.getAncestorOfType(801008);
        IXQEQueryNode parentQuery = aggrItem.getAncestorOfType(801016).getParent();
        RQPQuery referencingQuery = (RQPQuery)parentQuery.getAncestorOfType(801017);
        IXQEQueryNode[] projsInOuterQuery = referencingQuery.getProjectionList().getChildren();
        IXQEQueryNode[] projsInInnerQuery = aggrItem.getAncestorOfType(801016).getChildren();
        ArrayList<RQPDataItem> outDataItems = new ArrayList<RQPDataItem>();
        ArrayList<IXQEQueryNode> inExpressions = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode[] iXQEQueryNodeArray = projsInOuterQuery;
        int n = iXQEQueryNodeArray.length;
        boolean bl = false;
        while (var12_15 < n) {
            IXQEQueryNode projInOuterQuery = iXQEQueryNodeArray[var12_15];
            RQPDataItem outerProj = (RQPDataItem)projInOuterQuery;
            for (IXQEQueryNode projInInnerQuery : projsInInnerQuery) {
                IXQEQueryNode firstAggrInProj;
                RQPDataItem innerProj = (RQPDataItem)projInInnerQuery;
                if (!outerProj.getName().equals(innerProj.getName()) || (firstAggrInProj = innerProj.getFirstDescendantOfTypeOrdered(301034, false)) != null || RQPUtilities.isConstantGroupingItem(projInInnerQuery)) continue;
                outDataItems.add(outerProj);
                inExpressions.add(innerProj.getExpression());
            }
            ++var12_15;
        }
        int index = 0;
        for (IXQEQueryNode iXQEQueryNode : outDataItems) {
            dataItem = (RQPDataItem)iXQEQueryNode;
            if (dataItem.hasExplicitSort()) {
                sortKey = (SQLSortKey)factory.createNode(301020);
                sqlSortList.addChild(sortKey);
                sortKey.addChild(factory.deepCopyNode((IXQEQueryNode)inExpressions.get(index)));
                sortKey.setAscending(dataItem.isAscending());
            }
            ++index;
        }
        index = 0;
        for (IXQEQueryNode iXQEQueryNode : outDataItems) {
            dataItem = (RQPDataItem)iXQEQueryNode;
            if (!dataItem.hasExplicitSort()) {
                sortKey = (SQLSortKey)factory.createNode(301020);
                sqlSortList.addChild(sortKey);
                sortKey.addChild(factory.deepCopyNode((IXQEQueryNode)inExpressions.get(index)));
                sortKey.setAscending(dataItem.isAscending());
            }
            ++index;
        }
    }
}

