/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.CollapseSimpleCommonTable;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.HashSet;

public class TrimUnprojectedColumn
extends RQPTransformation {
    public TrimUnprojectedColumn() {
        this.mName = "Trim Unprojected Column";
        this.mPassNumbers = new int[]{65};
        this.mTypes = new int[]{301007};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.removeProperty("selectControl");
        IXQEQueryNode rootRQPSQL = node.getAncestorOfType(801041);
        if (rootRQPSQL == null) {
            return;
        }
        SQLRangeVar rangeVar = (SQLRangeVar)node;
        String tableName = rangeVar.getName();
        HashSet<String> usedAlias = new HashSet<String>();
        this.getUsedSQLAliasNamesOfTable(usedAlias, rootRQPSQL, node, tableName);
        if (usedAlias.isEmpty()) {
            return;
        }
        IXQEQueryNode proj = rangeVar.getChildren()[0];
        IXQEQueryNode[] vList = proj.getChildrenOfType(301030);
        if (vList.length != 1) {
            return;
        }
        IXQEQueryNode[] alias = vList[0].getChildren();
        ArrayList<IXQEQueryNode> nodeToRemoved = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode a : alias) {
            SQLAlias sqlAlias = (SQLAlias)a;
            if (usedAlias.contains(sqlAlias.getName())) continue;
            nodeToRemoved.add(a);
        }
        for (IXQEQueryNode del : nodeToRemoved) {
            del.detach();
        }
    }

    protected void getUsedSQLAliasNamesOfTable(HashSet<String> usedAlias, IXQEQueryNode node, IXQEQueryNode nodeSkip, String tableName) {
        IXQEQueryNode[] children;
        String[] idChain;
        SQLColumn sqlColumn;
        String tName;
        if (node.equals(nodeSkip)) {
            return;
        }
        if (node.getType() == 301005 && tableName.equals(tName = (sqlColumn = (SQLColumn)node).getTableName()) && (idChain = sqlColumn.getIdentifierChain()).length == 1) {
            usedAlias.add(idChain[0]);
        }
        for (IXQEQueryNode c : children = node.getChildren()) {
            this.getUsedSQLAliasNamesOfTable(usedAlias, c, nodeSkip, tableName);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IQuerySubject.SelectListControl aProp = (IQuerySubject.SelectListControl)((Object)node.getPropertyValue("selectControl"));
        return IQuerySubject.SelectListControl.USEDQUERYITEMS == aProp && this.preCheckCanApply((SQLRangeVar)node);
    }

    protected boolean preCheckCanApply(SQLRangeVar rangeVar) {
        if (rangeVar.getReusableQuery() != null) {
            return false;
        }
        IXQEQueryNode[] children = rangeVar.getChildren();
        if (children.length != 1 || children[0].getType() != 301015) {
            return false;
        }
        return !CollapseSimpleCommonTable.isSimpleCommonTable(rangeVar);
    }
}

