/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class ValidateNumberOfProjectionsOfSetOperator
extends RQPTransformation {
    private static final String PROP_CHECK_NUMBER_OF_PROJECTED_ITEMS = "CheckNoOfProjItems";

    public ValidateNumberOfProjectionsOfSetOperator() {
        this.mName = "Validate the number of projection items in set operator";
        this.mPassNumbers = new int[]{45};
        this.mTypes = new int[]{301018};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLSetOperator setOperator = (SQLSetOperator)node;
        SQLRangeVar rangeVar = (SQLRangeVar)setOperator.getAncestorOfType(301007);
        String nm = rangeVar.getName();
        if (nm == null) {
            nm = "";
        }
        List<String> derivedColumnList = rangeVar.getDerivedColumnList();
        RQPQuery query = (RQPQuery)node.getFirstChildByType(801017);
        RQPProjectionList projList = query.getProjectionList();
        IXQEQueryNode[] children = projList.getChildren();
        if (derivedColumnList.size() != children.length) {
            if (derivedColumnList.size() > children.length) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidQueryOperationProjections, nm);
            }
            ExecutionEnvironment ee = (ExecutionEnvironment)environment.getExecutionEnvironment();
            String nagMsg = XQEMessages.getMessage(XQEMessageKeys.WRN_TooFewProjectionItems, XQEMessages.getCurrProductLocale(), ((SQLRangeVar)setOperator.getParent()).getName());
            ee.addNag(nagMsg);
        }
        IXQEQueryNode[] setOpQueries = setOperator.getChildren();
        for (int i = 1; i < setOpQueries.length; ++i) {
            RQPProjectionList projs1 = ((RQPQuery)setOpQueries[i]).getProjectionList();
            if (projs1 != null && projs1.getNumberChildren() == projList.getNumberChildren()) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidQueryOperationQueries, nm);
        }
        node.setPropertyValue(PROP_CHECK_NUMBER_OF_PROJECTED_ITEMS, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object property = node.getPropertyValue(PROP_CHECK_NUMBER_OF_PROJECTED_ITEMS);
        if (property != null && (Boolean)property == Boolean.TRUE) {
            return false;
        }
        return node.hasChildOfType(801017);
    }
}

