/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5QueryRef;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class AddNonProjectedGroupingColumnForAutoSummaryFalse
extends RQPTransformation {
    public AddNonProjectedGroupingColumnForAutoSummaryFalse() {
        this.mName = "Add non-projected grouping columns to get detail records.";
        this.mPassNumbers = new int[]{69};
        this.mTypes = new int[]{801010};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rootQuery = RQPQuery.getRQPQuery(node).getParentRQPQuery();
        RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)node;
        RQPDataItem rqpDataItem = selfRef.getRefProjection();
        RQPDataItem newRQPDataItem = rootQuery.createRQPDataItem(environment, rqpDataItem.getName());
        IXQEQueryNode expr = environment.getNodeFactory().deepCopyNode(rqpDataItem.getExpression());
        newRQPDataItem.addChild(expr);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        if (node.getParent().getType() != 801013) {
            this.traceNodeCondition(false, "self ref not in context of a group-by list.", xqeTrace);
            return false;
        }
        RQPQuery rootQuery = RQPQuery.getRQPQuery(node).getRootRQPQuery();
        if (rootQuery.isAutoSummaryTRUE()) {
            this.traceNodeCondition(false, "Not a autoSummary=false query so detail rows need not be returned.", xqeTrace);
            return false;
        }
        RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)node;
        if (selfRef.isColumnForGroupedReport()) {
            this.traceNodeCondition(false, "Grouping column is in context of grouped query.", xqeTrace);
            return false;
        }
        if (rootQuery.getRQPDataItemWithSameExpression(selfRef.getRefProjection().getExpression()) != null) {
            this.traceNodeCondition(false, "Grouping column is already in the root query projection list .", xqeTrace);
            return false;
        }
        V5QuerySet v5QuerySet = (V5QuerySet)rootQuery.getAncestorOfType(101002);
        for (IXQEQueryNode child : v5QuerySet.getChildrenOfType(101006)) {
            for (IXQEQueryNode source : child.getChildrenOfType(101007)) {
                for (IXQEQueryNode queryOperation : source.getChildrenOfType(101018)) {
                    for (IXQEQueryNode refQuery : queryOperation.getChildrenOfType(101023)) {
                        V5QueryRef queryRef = (V5QueryRef)refQuery;
                        String queryName = queryRef.getRefQuery();
                        if (!queryName.equals(rootQuery.getName())) continue;
                        this.traceNodeCondition(false, "QueryOperation cannot be altered:left/right side queries, crafted by report writer, must match.", xqeTrace);
                        return false;
                    }
                }
            }
        }
        this.traceNodeCondition(true, "Grouping column is not projected and will be added to the projection list to get detail rows.", xqeTrace);
        return true;
    }
}

