/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class AddNonProjectedMUNDataItemForDistinct
extends RQPTransformation {
    public AddNonProjectedMUNDataItemForDistinct() {
        this.mName = "Add non projected MUN data item for distinct";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{801017};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] dataItems;
        RQPQuery rqpQuery = (RQPQuery)node;
        V5Query query = rqpQuery.getRefV5Query();
        for (IXQEQueryNode current : dataItems = query.getV5Selection().getChildrenOfType(101003)) {
            V5DataItem di = (V5DataItem)current;
            String name = di.getOriginalDistinctItem();
            if (name == null) continue;
            rqpQuery.createRQPDataItemFromV5DataItem(environment, di);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] dataItems;
        XQETrace trace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        V5Query query = rqpQuery.getRefV5Query();
        for (IXQEQueryNode current : dataItems = query.getV5Selection().getChildrenOfType(101003)) {
            if (((V5DataItem)current).getOriginalDistinctItem() == null) continue;
            this.traceQueryCondition(true, "There is at least one data item that requires MUNs", trace);
            return true;
        }
        this.traceQueryCondition(false, "There is data items that require MUNs", trace);
        return false;
    }
}

