/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSortItem;
import com.cognos.xqe.ast.rqp.RQPSortList;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class AdjustRQPSortBasedOnV5GroupSort
extends RQPTransformation {
    public static final String STR_NULL_FIRST = "first";
    public static final String STR_NULL_LAST = "last";

    public AdjustRQPSortBasedOnV5GroupSort() {
        this.mName = "Adjusts the RQPSort based on the V5 <groupSort>";
        this.mPassNumbers = new int[]{19};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[]{101049};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IXQEQueryNode> v5SortItems = node.getDescendantsOfTypeOrdered(101056, false);
        List<IXQEQueryNode> v5ValueSets = node.getDescendantsOfTypeOrdered(101057, false);
        RQPQuery rootRqpQuery = RQPQuery.getRQPQuery(node).getParentRQPQuery();
        RQPSortList sortListFromGroupSort = this.buildRQPSortList(environment, rootRqpQuery, v5SortItems);
        RQPSortList sortListFromAutoSort = rootRqpQuery.getOrCreateRQPSortList(environment);
        RQPSortList combinedSortList = RQPSortList.create(environment);
        for (int iVS = 0; iVS < v5ValueSets.size(); ++iVS) {
            V5ValueSet valueSet = (V5ValueSet)v5ValueSets.get(iVS);
            String currentValueSetName = valueSet.getNameProperty();
            IXQEQueryNode[] sortItemsFromGroupSort = sortListFromGroupSort.getChildren();
            if (sortItemsFromGroupSort.length > 0) {
                RQPSortItem siFromGroupSort;
                for (int i = 0; i < sortItemsFromGroupSort.length && currentValueSetName.equals((siFromGroupSort = (RQPSortItem)sortItemsFromGroupSort[i]).getValueSetNameProperty()); ++i) {
                    this.addItemToSortList(siFromGroupSort, combinedSortList);
                }
                this.moveSortItemsToNewList(currentValueSetName, sortListFromAutoSort, combinedSortList);
                continue;
            }
            this.moveSortItemsToNewList(currentValueSetName, sortListFromAutoSort, combinedSortList);
        }
        sortListFromAutoSort.exchange(combinedSortList);
        if (combinedSortList.getChildren().length == 0) {
            combinedSortList.extract();
        }
    }

    private void moveSortItemsToNewList(String currentValueSetName, RQPSortList fromSortList, RQPSortList toSortList) {
        IXQEQueryNode[] sortItems = fromSortList.getChildren();
        if (sortItems.length > 0) {
            for (int iItem = 0; iItem < sortItems.length; ++iItem) {
                RQPSortItem sortItem = (RQPSortItem)sortItems[iItem];
                if (!currentValueSetName.equals(sortItem.getValueSetNameProperty())) continue;
                this.addItemToSortList(sortItem, toSortList);
            }
        }
    }

    private void addItemToSortList(RQPSortItem sortItem, RQPSortList sortList) {
        RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)sortItem.getChild(0);
        RQPNode rqpNode = sortList.findDataItemSelfRef(selfRef.getName());
        if (rqpNode == null) {
            sortItem.move(sortList);
        }
    }

    private RQPSortList buildRQPSortList(PlanningEnvironment environment, RQPQuery rootRqpQuery, List<IXQEQueryNode> v5SortItems) {
        RQPSortList rqpSortList = RQPSortList.create(environment);
        for (int i = 0; i < v5SortItems.size(); ++i) {
            String refDataItem;
            V5DataItem dataItem;
            V5SortItem v5SortItem = (V5SortItem)v5SortItems.get(i);
            String rqpSortOrder = "ascending";
            if (!"ascending".equals(v5SortItem.getSortOrder())) {
                rqpSortOrder = v5SortItem.getSortOrder();
            }
            if (RQPUtilities.hasMovingRunningInExpression(dataItem = RQPUtilities.getV5DataItemInSelection(v5SortItem, refDataItem = v5SortItem.getRefDataItem()))) {
                String nagMsg = XQEMessages.getMessage(XQEMessageKeys.WRN_NoSortForRunningMovingAggregates, XQEMessages.getCurrProductLocale());
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nagMsg);
                continue;
            }
            RQPDataItem rqpDataItemToSortOn = this.findRQPDataItemToSortOn(rootRqpQuery, v5SortItem);
            RQPSortItem sortItem = RQPSortItem.create(environment, rqpDataItemToSortOn.getName(), rqpSortOrder);
            SQLSortKey.NullOrdering nullOdering = this.convertNullPlaceToNullOrdering(v5SortItem.getNullPlace());
            if (nullOdering != null) {
                sortItem.setPropertyValue("nullOrdering", (Object)nullOdering);
            }
            V5ValueSet valueSet = (V5ValueSet)v5SortItem.getAncestorOfType(101057);
            sortItem.setValueSetNameProperty(valueSet.getNameProperty());
            rqpSortList.addChild(sortItem);
        }
        return rqpSortList;
    }

    private SQLSortKey.NullOrdering convertNullPlaceToNullOrdering(String nullPlace) {
        if (nullPlace == null) {
            return null;
        }
        if (STR_NULL_FIRST.equals(nullPlace)) {
            return SQLSortKey.NullOrdering.NULLS_FIRST;
        }
        if (STR_NULL_LAST.equals(nullPlace)) {
            return SQLSortKey.NullOrdering.NULLS_LAST;
        }
        return null;
    }

    private RQPDataItem findRQPDataItemToSortOn(RQPQuery rootRqpQuery, V5SortItem sortItem) {
        int m;
        String refDataItem;
        V5ValueSet groupValueSet;
        IXQEQueryNode[] valueSets;
        V5Edge edge;
        RQPDataItem rqpDataItem;
        V5ValueSet valueSetOfSortItem = (V5ValueSet)sortItem.getAncestorOfType(101057);
        V5ValueSet nestedValueSet = RQPUtilities.getNestedValueSet(rootRqpQuery, valueSetOfSortItem);
        String sortItemRefName = sortItem.getRefDataItem();
        RQPProjectionList projList = rootRqpQuery.getProjectionList();
        for (int i = 0; i < projList.getNumberChildren(); ++i) {
            rqpDataItem = (RQPDataItem)projList.getChild(i);
            if (!rqpDataItem.getOriginalName().equals(sortItemRefName)) continue;
            if (rqpDataItem.getValueSet() == valueSetOfSortItem && rqpDataItem.isValueSetRefDataItem()) {
                return rqpDataItem;
            }
            if (rqpDataItem.getValueSet() == nestedValueSet && rqpDataItem.isFooterHeaderItem()) {
                return rqpDataItem;
            }
            if (nestedValueSet == null && !rqpDataItem.isFooterHeaderItem() && rqpDataItem.getValueSet() == valueSetOfSortItem) {
                return rqpDataItem;
            }
            edge = (V5Edge)sortItem.getAncestorOfType(101049);
            for (IXQEQueryNode current : valueSets = edge.getDescendantsOfType(101057, false)) {
                groupValueSet = (V5ValueSet)current;
                refDataItem = groupValueSet.getRefDataItemProperty();
                if (refDataItem == null || !sortItemRefName.equals(refDataItem) || rqpDataItem.getValueSet() != groupValueSet || !rqpDataItem.isValueSetRefDataItem() || rqpDataItem.getValueSet() != valueSetOfSortItem) continue;
                return rqpDataItem;
            }
        }
        for (m = 0; m < projList.getNumberChildren(); ++m) {
            rqpDataItem = (RQPDataItem)projList.getChild(m);
            if (!rqpDataItem.getOriginalName().equals(sortItemRefName) || !rqpDataItem.getPropertyValue("valueSet").equals(sortItem.getParent())) continue;
            edge = (V5Edge)sortItem.getAncestorOfType(101049);
            for (IXQEQueryNode current : valueSets = edge.getDescendantsOfType(101057, false)) {
                IXQEQueryNode[] refDataItems;
                groupValueSet = (V5ValueSet)current;
                IXQEQueryNode groupBody = groupValueSet.getFirstChildByType(101051);
                if (groupBody == null) continue;
                for (IXQEQueryNode refDI : refDataItems = groupBody.getChildrenOfCategory(101015)) {
                    String refDIName = ((V5DataItemRef)refDI).getDataItemRefProperty();
                    if (refDIName == null || !sortItemRefName.equals(refDIName)) continue;
                    return rqpDataItem;
                }
            }
        }
        for (m = 0; m < projList.getNumberChildren(); ++m) {
            rqpDataItem = (RQPDataItem)projList.getChild(m);
            if (!rqpDataItem.getOriginalName().equals(sortItemRefName)) continue;
            edge = (V5Edge)sortItem.getAncestorOfType(101049);
            for (IXQEQueryNode current : valueSets = edge.getDescendantsOfType(101057, false)) {
                groupValueSet = (V5ValueSet)current;
                refDataItem = groupValueSet.getRefDataItemProperty();
                if (refDataItem == null || !sortItemRefName.equals(refDataItem)) continue;
                return rqpDataItem;
            }
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        List<IXQEQueryNode> v5SortItems = node.getDescendantsOfTypeOrdered(101056, false);
        XQETrace xqeTrace = environment.getTrace();
        if (v5SortItems.size() == 0) {
            this.traceNodeCondition(false, "No groupSort elements.", xqeTrace);
            return false;
        }
        if (node.getAncestorOfType(401005) == null) {
            this.traceQueryCondition(false, "No rsapiDataset node is found.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The groupSort items will override any existing sort, and/or add a sort.", xqeTrace);
        return true;
    }
}

