/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5AggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5CaseExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueAnalyticFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;

public class AggregateExpressionBuilder {
    private PlanningEnvironment environment;

    public AggregateExpressionBuilder(PlanningEnvironment inputEnvironment) {
        this.environment = inputEnvironment;
    }

    public IXQEQueryNode generateAggregateExpression(String aggregateName, IXQEQueryNode originalExpr) {
        int v5AggregateEnumCode = V5AggregateEnum.getAggregate(aggregateName);
        if (!this.isAggregateSupported(v5AggregateEnumCode)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedAggregateAttribute, aggregateName, ((V5DataItem)originalExpr.getParent()).getNameProperty());
        }
        if (v5AggregateEnumCode == 3 && (v5AggregateEnumCode = this.resolveAutomaticAggregate(originalExpr)) == 8) {
            aggregateName = "minimum";
        }
        IXQEQueryNode aggregateExpr = null;
        switch (v5AggregateEnumCode) {
            case 2: {
                aggregateExpr = this.generateCalculatedAggregate(originalExpr);
                break;
            }
            case 1: {
                aggregateExpr = this.generateSummarizeAggregate(originalExpr);
                break;
            }
            default: {
                aggregateExpr = this.generateSummaryAggregate(aggregateName, originalExpr);
            }
        }
        return aggregateExpr;
    }

    private IXQEQueryNode generateSummaryAggregate(String aggregateName, IXQEQueryNode originalExpr) {
        V5ValueSummaryFunction summaryFunction = (V5ValueSummaryFunction)this.environment.getNodeFactory().createNode(201031);
        int v5AggregateFunctionSubtypeCode = RQPUtilities.convertAggregateNameToV5AggregateFunctionSubtype(aggregateName);
        summaryFunction.setSubType(v5AggregateFunctionSubtypeCode);
        if (v5AggregateFunctionSubtypeCode == 43) {
            summaryFunction.setNativeName(aggregateName);
        }
        if (aggregateName.equals("countDistinct")) {
            summaryFunction.setDistinct(true);
        }
        if (originalExpr.getType() == 101015 && originalExpr.getParent() == null) {
            summaryFunction.addChild(originalExpr);
        } else {
            summaryFunction.addChild(this.environment.getNodeFactory().deepCopyNode(originalExpr));
        }
        return summaryFunction;
    }

    private IXQEQueryNode generateCalculatedAggregate(IXQEQueryNode originalExpr) {
        V5ValueAnalyticFunction af;
        XQENodeFactory nodeFactory = this.environment.getNodeFactory();
        IXQEQueryNode aggregateExpr = nodeFactory.deepCopyNode(originalExpr);
        if (originalExpr.getType() == 201033 && ((af = (V5ValueAnalyticFunction)originalExpr).getSubType() == 12 || af.getSubType() == 13)) {
            return aggregateExpr;
        }
        IXQEQueryNode[] boundItems = aggregateExpr.getDescendantsOfTypes(new int[]{201116, 201060, 201097}, true);
        for (int i = 0; i < boundItems.length; ++i) {
            V5BoundDataItemReference dataItemReference;
            IXQEQueryNode boundItem = boundItems[i];
            if (boundItem.getAncestorOfType(201031) != null || boundItem.getAncestorOfType(201037) != null || boundItem.getAncestorOfType(201036) != null) continue;
            IXQEQueryNode summaryFunction = null;
            if (boundItem.getType() == 201116) {
                String regularAggregateName;
                IDataType dataType;
                String regularAggregateName2;
                V5BoundModelIdentifier modelIdentifier = (V5BoundModelIdentifier)boundItem;
                if (modelIdentifier.isFactQueryItemWithStandardRegularAggregate()) {
                    regularAggregateName2 = modelIdentifier.convertRegularAggregateSumToTotal();
                    summaryFunction = this.generateSummaryAggregate(regularAggregateName2, boundItem);
                } else if (modelIdentifier.isFactQueryItemUsingAggregateUDF(this.environment)) {
                    summaryFunction = this.environment.getNodeFactory().deepCopyNode(modelIdentifier.getV5ValueExpression(this.environment));
                } else if (modelIdentifier.isFactQueryItemWithAutomaticOrCalculatedRegularAggregate()) {
                    dataType = ((V5SimpleNode)originalExpr).getDataType();
                    regularAggregateName = RQPUtilities.getDefaultAggregateNameBasedOnDataType(dataType);
                    summaryFunction = this.generateSummaryAggregate(regularAggregateName, boundItem);
                } else if (modelIdentifier.isMeasureWithStandardRegularAggregate()) {
                    regularAggregateName2 = modelIdentifier.convertRegularAggregateSumToTotal();
                    summaryFunction = this.generateSummaryAggregate(regularAggregateName2, boundItem);
                } else if (modelIdentifier.isMeasureAutomaticOrCalculatedRegularAggregate()) {
                    dataType = ((V5SimpleNode)originalExpr).getDataType();
                    regularAggregateName = RQPUtilities.getDefaultAggregateNameBasedOnDataType(dataType);
                    summaryFunction = this.generateSummaryAggregate(regularAggregateName, boundItem);
                }
            } else if (boundItem.getType() == 201060 && (dataItemReference = (V5BoundDataItemReference)boundItem).isQueryRefItem()) {
                V5DataItem di = dataItemReference.getRefDataItem();
                String aggregateProperty = di.getAggregateProperty();
                String aggregateToApply = null;
                if (aggregateProperty != null && !aggregateProperty.isEmpty() && (V5AggregateEnum.isStandardAggregate(aggregateProperty) || aggregateProperty.equals("none"))) {
                    aggregateToApply = aggregateProperty;
                } else {
                    IDataType dataType = di.getDataType();
                    AggregateTypeEnum aggregate = AggregateTypeEnum.valueOfV5String(aggregateProperty);
                    dataType = aggregate.getPostAggregationDataType(dataType);
                    if (dataType.getSubType() == DataSubType.VARIANTTYPE || dataType.getSubType() == DataSubType.UNKNOWN) {
                        dataType = this.getDataTypeFromContext(dataItemReference);
                    }
                    aggregateToApply = RQPUtilities.getDefaultAggregateNameBasedOnDataType(dataType);
                }
                summaryFunction = this.generateSummaryAggregate(aggregateToApply, boundItem);
            }
            if (summaryFunction == null) {
                summaryFunction = this.generateSummaryAggregate("minimum", boundItem);
            }
            if (boundItem.getParent() != null) {
                boundItem.exchange(summaryFunction);
                continue;
            }
            aggregateExpr = summaryFunction;
        }
        return aggregateExpr;
    }

    private IXQEQueryNode generateSummarizeAggregate(IXQEQueryNode originalExpr) {
        IDataType dataType;
        if (originalExpr.getType() == 201060) {
            dataType = ((V5BoundDataItemReference)originalExpr).getRefDataItem().getDataType();
        } else if (originalExpr.getType() == 201116) {
            if (((V5BoundModelIdentifier)originalExpr).isFactQueryItemWithStandardRegularAggregate()) {
                String aggregateName = ((V5BoundModelIdentifier)originalExpr).convertRegularAggregateSumToTotal();
                return this.generateSummaryAggregate(aggregateName, originalExpr);
            }
            if (((V5BoundModelIdentifier)originalExpr).isMeasureWithStandardRegularAggregate()) {
                String aggregateName = ((V5BoundModelIdentifier)originalExpr).convertRegularAggregateSumToTotal();
                return this.generateSummaryAggregate(aggregateName, originalExpr);
            }
            dataType = ((V5BoundModelIdentifier)originalExpr).getDataType();
        } else {
            dataType = originalExpr.getType() == 201097 ? ((V5BoundQueryItemReference)originalExpr).getDataType() : ((V5SimpleNode)originalExpr).getDataType();
        }
        return this.generateSummaryAggregate(RQPUtilities.getDefaultAggregateNameBasedOnDataType(dataType), originalExpr);
    }

    private int resolveAutomaticAggregate(IXQEQueryNode originalExpr) {
        if (AggregateExpressionBuilder.hasAggregateInExpression(originalExpr)) {
            return 2;
        }
        if (AggregateExpressionBuilder.hasFactInIfClauseOfIfThenElse(originalExpr)) {
            return 2;
        }
        if (this.hasQueryItemOrCalculationWithDefinedRegularAggregate(originalExpr)) {
            return 1;
        }
        if (this.hasFactWithStandardRegularAggregate(originalExpr)) {
            return 1;
        }
        if (this.isMeasure(originalExpr)) {
            return 1;
        }
        return 8;
    }

    public static boolean hasAggregateInExpression(IXQEQueryNode expressionNode) {
        int[] descendantTypes = new int[]{201031, 201033, 201035};
        return expressionNode.getDescendantsOfTypes(descendantTypes, true).length > 0;
    }

    public static boolean hasFactInIfClauseOfIfThenElse(IXQEQueryNode expressionNode) {
        int[] conditionalNodeTypes = new int[]{201017, 201018, 201020};
        IXQEQueryNode[] expr = expressionNode.getDescendantsOfTypes(conditionalNodeTypes, false);
        boolean hasFact = false;
        for (int i = 0; i < expr.length; ++i) {
            if (!AggregateExpressionBuilder.hasFactInConditionClauses(expr[i])) continue;
            hasFact = true;
            break;
        }
        return hasFact;
    }

    private static IXQEQueryNode[] getConditionClauses(IXQEQueryNode expressionNode) {
        ArrayList<IXQEQueryNode> conditionClauses = new ArrayList<IXQEQueryNode>();
        if (expressionNode.getType() == 201017) {
            conditionClauses.add(expressionNode.getChild(0));
        } else if (expressionNode.getType() == 201018) {
            if (((V5CaseExpression)expressionNode).getSubType() == 0) {
                conditionClauses.add(expressionNode.getChild(0));
            } else {
                IXQEQueryNode[] caseWhenClauses = expressionNode.getChildrenOfType(201019);
                for (int i = 0; i < caseWhenClauses.length; ++i) {
                    conditionClauses.add(caseWhenClauses[i].getChild(0));
                }
            }
        } else if (expressionNode.getType() == 201020) {
            conditionClauses.add(expressionNode.getChild(0));
        }
        IXQEQueryNode[] nodes = new IXQEQueryNode[conditionClauses.size()];
        return conditionClauses.toArray(nodes);
    }

    private static boolean hasFactInConditionClauses(IXQEQueryNode expressionNode) {
        IXQEQueryNode[] conditionClauses = AggregateExpressionBuilder.getConditionClauses(expressionNode);
        for (int i = 0; i < conditionClauses.length; ++i) {
            IXQEQueryNode[] modelReferences = conditionClauses[i].getDescendantsOfType(201116, false);
            for (int j = 0; j < modelReferences.length; ++j) {
                if (!((V5BoundModelIdentifier)modelReferences[j]).isFactQueryItem() && !((V5BoundModelIdentifier)modelReferences[j]).isCalculationWithDefinedRegularAggregate()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasQueryItemOrCalculationWithDefinedRegularAggregate(IXQEQueryNode expressionNode) {
        IXQEQueryNode[] modelReferences = expressionNode.getDescendantsOfType(201116, true);
        for (int i = 0; i < modelReferences.length; ++i) {
            V5BoundModelIdentifier modelReference = (V5BoundModelIdentifier)modelReferences[i];
            if (!modelReference.isCalculationWithDefinedRegularAggregate() && (!modelReference.isFactQueryItem() || !modelReference.isQueryItemWithDefinedRegularAggregate())) continue;
            return true;
        }
        return false;
    }

    private boolean hasFactWithStandardRegularAggregate(IXQEQueryNode expressionNode) {
        IXQEQueryNode[] itemReferences = expressionNode.getDescendantsOfType(201116, false);
        for (int i = 0; i < itemReferences.length; ++i) {
            V5BoundModelIdentifier itemReference = (V5BoundModelIdentifier)itemReferences[i];
            if (!itemReference.isFactQueryItem() || !V5AggregateEnum.isStandardAggregate(itemReference.convertRegularAggregateSumToTotal())) continue;
            return true;
        }
        return false;
    }

    public boolean isAggregateSupported(int v5AggregateEnumCode) {
        return v5AggregateEnumCode != -1 && v5AggregateEnumCode != 14 && v5AggregateEnumCode != 15;
    }

    private boolean isMeasure(IXQEQueryNode originalExpr) {
        if (originalExpr.getChildren().length > 0) {
            return false;
        }
        return originalExpr instanceof V5BoundModelIdentifier && ((V5BoundModelIdentifier)originalExpr).isMeasure();
    }

    private IDataType getDataTypeFromContext(V5BoundDataItemReference dataItem) {
        IDataType result = DataTypeFactory.getVariantType();
        IXQEQueryNode parent = dataItem.getParent();
        IXQEQueryNode[] children = parent.getChildren();
        switch (parent.getType()) {
            case 201008: {
                if (children[1] instanceof V5SimpleNode && ((V5SimpleNode)children[1]).getDataType().getSubType() != DataSubType.VARIANTTYPE && ((V5SimpleNode)children[1]).getDataType().getSubType() != DataSubType.UNKNOWN) {
                    result = ((V5SimpleNode)children[1]).getDataType();
                    break;
                }
                if (!(children[2] instanceof V5SimpleNode) || ((V5SimpleNode)children[2]).getDataType().getSubType() == DataSubType.VARIANTTYPE || ((V5SimpleNode)children[2]).getDataType().getSubType() == DataSubType.UNKNOWN) break;
                result = ((V5SimpleNode)children[2]).getDataType();
                break;
            }
            case 201013: {
                IXQEQueryNode other = null;
                other = dataItem == children[0] ? children[1] : children[0];
                if (!(other instanceof V5SimpleNode) || ((V5SimpleNode)other).getDataType().getSubType() == DataSubType.VARIANTTYPE || ((V5SimpleNode)other).getDataType().getSubType() == DataSubType.UNKNOWN) break;
                result = ((V5SimpleNode)other).getDataType();
                break;
            }
        }
        if (result.isVariant()) {
            String warnMsg = "Unknown data type (possibly due to use of a UDF) remains unresolved in a ";
            warnMsg = warnMsg.concat(parent.getNodeTypeName());
            warnMsg = warnMsg.concat(" node.\nDefault aggregation type ");
            warnMsg = warnMsg.concat(RQPUtilities.getDefaultAggregateNameBasedOnDataType(result));
            warnMsg = warnMsg.concat(" will be applied to data item ");
            warnMsg = warnMsg.concat(dataItem.getDataItemName());
            warnMsg = warnMsg.concat(".");
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "AggregateAwareness", LogLevel.WARN);
            logger.log(LogLevel.WARN, warnMsg);
        }
        return result;
    }
}

