/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5AggregateEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.AggregateExpressionBuilder;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ResolveDataItemReferenceAutomaticAggregate;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashMap;

public class ApplyAggregateAttributeOnDataItem
extends Transformation {
    public ApplyAggregateAttributeOnDataItem() {
        this.mName = "Apply aggregate attribute on V5DataItem.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{101003};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent;
        V5DataItem dataItem = (V5DataItem)node;
        String aggregateName = dataItem.getAggregateProperty();
        if (aggregateName == null) {
            aggregateName = "automatic";
        }
        if (aggregateName.equals("notApplicable")) {
            IXQEQueryNode aggregate = environment.getNodeFactory().deepCopyNode(dataItem.getChild(0));
            dataItem.setAggregateExpression(aggregate);
            return;
        }
        IXQEQueryNode aggregateExpr = null;
        if (aggregateName.equals("none") && (parent = node.getParent()) != null && (parent.getType() == 201037 || parent.getType() == 201036)) {
            aggregateExpr = environment.getNodeFactory().deepCopyNode(dataItem.getChild(0));
            dataItem.setAggregateExpression(aggregateExpr);
            return;
        }
        AggregateExpressionBuilder aggregateExprBuilder = new AggregateExpressionBuilder(environment);
        int v5AggregateEnumCode = V5AggregateEnum.getAggregate(aggregateName);
        if (!aggregateExprBuilder.isAggregateSupported(v5AggregateEnumCode)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedAggregateAttribute, aggregateName, dataItem.getNameProperty());
        }
        switch (v5AggregateEnumCode) {
            case 2: {
                aggregateExpr = aggregateExprBuilder.generateAggregateExpression(aggregateName, dataItem.getChild(0));
                break;
            }
            case 1: {
                aggregateExpr = aggregateExprBuilder.generateAggregateExpression(aggregateName, dataItem.getChild(0));
                break;
            }
            default: {
                IXQEQueryNode dataItemRef = environment.getNodeFactory().createNode(101015);
                dataItemRef.setPropertyValue("refDataItem", dataItem.getNameProperty());
                aggregateExpr = aggregateExprBuilder.generateAggregateExpression(aggregateName, dataItemRef);
            }
        }
        dataItem.setAggregateExpression(aggregateExpr);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        V5DataItem dataItem = (V5DataItem)node;
        if (null != dataItem.getAggregateExpression()) {
            this.traceNodeCondition(false, "The aggregate expression of V5DataItem node is already set", xqeTrace);
            return false;
        }
        String aggr = dataItem.getAggregateProperty();
        if (aggr == null || aggr.equals("automatic")) {
            return false;
        }
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (querySet == null) {
            return false;
        }
        if (!querySet.hasDescendantOfType(801017, false)) {
            this.traceNodeCondition(false, "The query is not a relational query.", xqeTrace);
            return false;
        }
        if (0 < node.getDescendantsOfType(101003, false).length) {
            return false;
        }
        LoopDetectionChain ldc = new LoopDetectionChain();
        HashMap<String, Boolean> nodeToResult = new HashMap<String, Boolean>();
        if (!ResolveDataItemReferenceAutomaticAggregate.allQueryItemReferencesAreNotAggregateAutomatic((V5DataItem)node, ldc, nodeToResult)) {
            return false;
        }
        this.traceNodeCondition(true, "The aggregate expression of V5DataItem node is not set", xqeTrace);
        return true;
    }
}

