/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupHeader;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.AggregateExpressionBuilder;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class ApplyRollupAggregate
extends RQPTransformation {
    public static final String EXP_CONST = "dummy";

    public ApplyRollupAggregate() {
        this.mName = "Apply rollup aggregate.";
        this.mPassNumbers = new int[]{17};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[]{801008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String rollupAggregate;
        RQPDataItem rqpDataItem = (RQPDataItem)node;
        RQPQuery rootQuery = rqpDataItem.getParentRQPQuery();
        V5DataItemRef dataItemRef = null;
        V5DataItem v5DataItem = null;
        if (rqpDataItem.isNonProjectedSortItem()) {
            if (rqpDataItem.getChild(0).getType() == 101003) {
                v5DataItem = (V5DataItem)rqpDataItem.getExpression();
            }
        } else {
            dataItemRef = (V5DataItemRef)rqpDataItem.getExpression();
            v5DataItem = rootQuery.getRefV5Query().getV5Selection().getDataItemByRefName(dataItemRef.getDataItemRefProperty());
        }
        if (this.rollupNeedsToBeAppliedOnDetailValues(rollupAggregate = v5DataItem.getRollupAggregateProperty()) && this.rollupOperandContainsDMRQueryRefItem(v5DataItem)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedUseOfRollupAggregate, v5DataItem.getNameProperty(), rollupAggregate);
        }
        IXQEQueryNode rollupAggrExpr = null;
        rollupAggrExpr = v5DataItem.isErrorCell() ? ApplyRollupAggregate.generateConstantExpression(environment) : ApplyRollupAggregate.generateRollupAggrExpr(environment, rootQuery, v5DataItem, rollupAggregate, rqpDataItem);
        if (rqpDataItem.isNonProjectedSortItem()) {
            v5DataItem.exchange(rollupAggrExpr);
        } else {
            dataItemRef.exchange(rollupAggrExpr);
            IXQEQueryNode summaryFilterList = rootQuery.getFirstChildByType(801023);
            if (summaryFilterList != null && this.preserveDetailContextForAutoForClause(environment, v5DataItem, rqpDataItem)) {
                summaryFilterList.setPropertyValue("detailContext", Boolean.TRUE);
            }
        }
        v5DataItem.setRollupExpression(rollupAggrExpr);
    }

    protected boolean preserveDetailContextForAutoForClause(PlanningEnvironment environment, V5DataItem v5DataItem, RQPDataItem rqpDataItem) {
        if (!v5DataItem.isGroupingItem()) {
            return false;
        }
        IXQEQueryNode parentPorjList = rqpDataItem.getParent();
        for (int i = 0; i < parentPorjList.getNumberChildren(); ++i) {
            Object o;
            RQPDataItem aRQPDataItem;
            IXQEQueryNode child = parentPorjList.getChild(i);
            if (child == rqpDataItem || child.getType() != 801008 || !((aRQPDataItem = (RQPDataItem)child).isGroupingItem() ? aRQPDataItem.getOriginalName().equals(rqpDataItem.getOriginalName()) : (o = aRQPDataItem.getPropertyValue("detailContext")) != null && aRQPDataItem.getOriginalName().equals(rqpDataItem.getOriginalName()))) continue;
            return false;
        }
        rqpDataItem.setPropertyValue("detailContext", v5DataItem);
        return true;
    }

    private boolean rollupOperandContainsDMRQueryRefItem(V5DataItem v5DataItem) {
        List<IXQEQueryNode> dataItemRefs = v5DataItem.getDescendantsOfTypeOrdered(201060, false);
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(v5DataItem);
        for (IXQEQueryNode diRef : dataItemRefs) {
            String[] parts;
            V5Query v5Query;
            V5BoundDataItemReference boundDiRef = (V5BoundDataItemReference)diRef;
            if (!boundDiRef.isQueryRefItem() || (v5Query = querySet.getV5Query((parts = boundDiRef.getNameParts())[0])) == null || !v5Query.isDMR()) continue;
            return true;
        }
        return false;
    }

    private boolean rollupNeedsToBeAppliedOnDetailValues(String aggregateName) {
        return "countDistinct".equals(aggregateName) || "average".equals(aggregateName) || "median".equals(aggregateName) || "standardDeviation".equals(aggregateName) || "variance".equals(aggregateName);
    }

    public static IXQEQueryNode generateConstantExpression(PlanningEnvironment environment) {
        V5LiteralValue literalValue = (V5LiteralValue)environment.getNodeFactory().createNode(201026);
        literalValue.setDataType(StringType.DEFAULTSTRINGTYPE);
        literalValue.setValue(EXP_CONST);
        return literalValue;
    }

    public static IXQEQueryNode generateRollupAggrExpr(PlanningEnvironment environment, RQPQuery rootQuery, V5DataItem v5DataItem, String rollupAggregate, RQPDataItem rqpDataItem) {
        String aggregateAttribute = v5DataItem.getAggregateProperty();
        IXQEQueryNode aggrExpr = v5DataItem.getAggregateExpression(environment);
        IXQEQueryNode rollupAggrExpr = null;
        IXQEQueryNode rollupAggrOperand = null;
        if (aggregateAttribute.equals("notApplicable")) {
            if (rollupAggregate.equals("summarize")) {
                return ApplyRollupAggregate.generateRollupAggrExprForNotApplicableDataItem(environment, aggrExpr);
            }
            if (V5AggregateEnum.isStandardAggregate(rollupAggregate)) {
                AggregateExpressionBuilder aggregateExprBuilder = new AggregateExpressionBuilder(environment);
                IXQEQueryNode rollupAggr = aggregateExprBuilder.generateAggregateExpression(rollupAggregate, v5DataItem.getChild(0));
                ApplyRollupAggregate.markRollupAggr(rollupAggr, true);
                return rollupAggr;
            }
        }
        if (aggregateAttribute.equals("none")) {
            rollupAggrOperand = rootQuery.isAutoSummaryTRUE() && V5AggregateEnum.isStandardAggregate(rollupAggregate) ? environment.getNodeFactory().deepCopyNode(aggrExpr) : v5DataItem.getDetailContext(environment);
        } else if (rootQuery.isAutoSummaryTRUE()) {
            rollupAggrOperand = environment.getNodeFactory().deepCopyNode(aggrExpr);
        } else {
            if (rollupAggregate.equals("automatic")) {
                rollupAggregate = aggregateAttribute;
            }
            rollupAggrOperand = rollupAggregate.equals("calculated") ? environment.getNodeFactory().deepCopyNode(aggrExpr) : v5DataItem.getDetailContext(environment);
        }
        if (V5AggregateEnum.isStandardAggregate(rollupAggregate) || rollupAggregate.equals("summarize")) {
            AggregateExpressionBuilder aggregateExprBuilder = new AggregateExpressionBuilder(environment);
            rollupAggrExpr = aggregateExprBuilder.generateAggregateExpression(rollupAggregate, rollupAggrOperand);
            ApplyRollupAggregate.markRollupAggr(rollupAggrExpr, true);
        } else if (rootQuery.isAutoSummaryTRUE() && !RQPUtilities.hasAggregateInExpression(rollupAggrOperand)) {
            V5ValueSummaryFunction minFunction = ExpressionAnalyzer.createV5SummaryFunctionMin(environment);
            minFunction.setRollupAggregateNode(true);
            minFunction.addChild(rollupAggrOperand);
            rollupAggrExpr = minFunction;
            ApplyRollupAggregate.markRollupAggr(rollupAggrExpr, true);
        } else {
            rollupAggrExpr = rollupAggrOperand;
            if (aggregateAttribute.equals("none")) {
                if (rollupAggregate.equals("calculated")) {
                    ApplyRollupAggregate.markRollupAggr(rollupAggrExpr, false);
                }
            } else if (rollupAggregate.equals("none")) {
                if (rqpDataItem != null && rqpDataItem.isHeaderItem()) {
                    ApplyRollupAggregate.flagRelatedRowsetAsReturningFirstValue(rqpDataItem);
                }
            } else {
                ApplyRollupAggregate.markRollupAggr(rollupAggrExpr, aggregateAttribute.equals("notApplicable"));
            }
        }
        if (rollupAggregate.equals("calculated") || rollupAggregate.equals("automatic")) {
            IXQEQueryNode exp;
            V5BoundModelIdentifier v5Id;
            if (rollupAggrOperand.getType() == 201116 && (v5Id = (V5BoundModelIdentifier)rollupAggrOperand).isFactQueryItemUsingAggregateUDF(environment) && (exp = v5Id.getV5ValueExpression(environment)) != null && exp.getType() == 201031) {
                ((V5ValueSummaryFunction)exp).setRollupAggregateNode(true);
                return exp;
            }
            return ApplyRollupAggregate.generateMinAroundStandardAggWithExplicitForClause(rollupAggrExpr, environment, true, null);
        }
        return rollupAggrExpr;
    }

    private static void flagRelatedRowsetAsReturningFirstValue(RQPDataItem rqpDataItem) {
        if (rqpDataItem == null) {
            return;
        }
        V5ValueSet valueset = rqpDataItem.getValueSet();
        if (valueset == null) {
            return;
        }
        V5GroupHeader groupHeader = (V5GroupHeader)valueset.getFirstChildByType(101053);
        if (groupHeader == null) {
            return;
        }
        RSAPIEdgeRowset rowset = groupHeader.getRSAPIEdgeRowset();
        if (rowset == null) {
            return;
        }
        rowset.setContainsHeaderReturningFirstValue(true);
    }

    public static IXQEQueryNode generateRollupAggrExprForNotApplicableDataItem(PlanningEnvironment environment, IXQEQueryNode aggr) {
        IXQEQueryNode[] aggregates;
        IXQEQueryNode rollupAggr = environment.getNodeFactory().deepCopyNode(aggr);
        for (IXQEQueryNode aggregate : aggregates = rollupAggr.getDescendantsOfType(201031, true)) {
            if (null == aggregate.getPropertyValue("dataItemRef")) continue;
            AggregateExpressionBuilder aggregateExprBuilder = new AggregateExpressionBuilder(environment);
            IXQEQueryNode rollupAggrExpr = aggregateExprBuilder.generateAggregateExpression("summarize", aggregate);
            ApplyRollupAggregate.markRollupAggr(rollupAggrExpr, true);
            aggregate.exchange(rollupAggrExpr);
        }
        return rollupAggr;
    }

    private static void markRollupAggr(IXQEQueryNode rollupAggrExpr, boolean onOutermostAggregate) {
        if (onOutermostAggregate && ExpressionAnalyzer.isStandardOrAnalyticAggregateWithAutoForClause(rollupAggrExpr)) {
            ((V5AggregateFunction)rollupAggrExpr).setRollupAggregateNode(true);
            return;
        }
        IXQEQueryNode[] aggregates = ExpressionAnalyzer.getAggregateNodes(rollupAggrExpr);
        for (int i = 0; i < aggregates.length; ++i) {
            if (!ExpressionAnalyzer.isStandardOrAnalyticAggregateWithAutoForClause(aggregates[i])) continue;
            ((V5AggregateFunction)aggregates[i]).setRollupAggregateNode(true);
        }
    }

    public static IXQEQueryNode generateMinAroundStandardAggWithExplicitForClause(IXQEQueryNode rollupAggrExpr, PlanningEnvironment environment, boolean forFooter, V5AggregateBreakClause forClause) {
        IXQEQueryNode newRollupAggrExpr = rollupAggrExpr;
        IXQEQueryNode[] forClauses = rollupAggrExpr.getDescendantsOfType(201037, false);
        for (int i = 0; i < forClauses.length; ++i) {
            IXQEQueryNode parentOfAggregate;
            IXQEQueryNode aggregateNode = forClauses[i].getParent();
            if (!ExpressionAnalyzer.isStandardAggregate(aggregateNode)) continue;
            V5ValueSummaryFunction minFunction = ExpressionAnalyzer.createV5SummaryFunctionMin(environment);
            if (forFooter) {
                minFunction.setRollupAggregateNode(true);
            }
            if ((parentOfAggregate = aggregateNode.getParent()) == null) {
                minFunction.addChild(aggregateNode);
                newRollupAggrExpr = minFunction;
            } else if (aggregateNode.getAncestorOfType(201031) == null && !ExpressionAnalyzer.isStandardAggregate(parentOfAggregate)) {
                aggregateNode.insertParent(minFunction);
            }
            if (forClause == null) continue;
            minFunction.addChild(forClause);
        }
        return newRollupAggrExpr;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPDataItem rqpDataItem = (RQPDataItem)node;
        if (!rqpDataItem.isFooterHeaderItem() && !rqpDataItem.isGroupBodyItemOfNonLastValueSet()) {
            this.traceNodeCondition(false, "RQPDataItem is not a footer item.", xqeTrace);
            return false;
        }
        RQPQuery rootQuery = (RQPQuery)node.getAncestorOfType(801017);
        if ((node.getNumberChildren() != 1 || node.getChild(0).getType() != 101015) && rqpDataItem.isNonProjectedSortItem() && !rootQuery.isAutoSummaryTRUE()) {
            this.traceNodeCondition(false, "Rollup aggregate expression has already been applied on this RQPDataItem.", xqeTrace);
            return false;
        }
        return true;
    }
}

