/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.Bridge;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPBridgeTabularQuery;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSubqueryList;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class ApplyAggregatesAcrossBridge
extends RQPTransformation {
    public static final String PROP_IS_EXPLICIT_AGGREGATE = "isExplicitAggregate";
    public static final String BRIDGE_PREFIX = "BRIDGE";

    public ApplyAggregatesAcrossBridge() {
        this.mName = "Apply Aggregates Across Bridge";
        this.mPassNumbers = new int[]{40};
        this.mTypes = new int[]{801017};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPDataItem dataItem;
        RQPQuery query = (RQPQuery)node;
        RQPBridgeTabularQuery bridgeTabularQuery = query.getDefaultBridgeTabularQuery();
        List<RQPDataItemRef> detailScope = this.getGroupingItems(environment, bridgeTabularQuery);
        RQPProjectionList projectionList = query.getProjectionList();
        for (IXQEQueryNode projection : projectionList.getChildren()) {
            dataItem = (RQPDataItem)projection;
            if (!ApplyAggregatesAcrossBridge.expressionUsesShoresAndBridge(bridgeTabularQuery, dataItem)) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedBridgeExpression, query.getName(), dataItem.getName());
        }
        for (IXQEQueryNode projection : projectionList.getChildren()) {
            dataItem = (RQPDataItem)projection;
            if (ApplyAggregatesAcrossBridge.expressionUsesMultipleShores(bridgeTabularQuery, dataItem, false)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedBridgeMultiShoreExpression, query.getName(), dataItem.getName());
            }
            List<RQPDataItemRef> bridgeKeys = this.getExpressionBridgeKeys(environment, dataItem);
            this.processDataItem(environment, dataItem, detailScope, bridgeKeys, dataItem.isGroupingItem());
        }
        this.cleanGroupByLists(query);
    }

    private List<RQPDataItemRef> getGroupingItems(PlanningEnvironment environment, RQPQuery query) {
        XQENodeFactory factory = environment.getNodeFactory();
        ArrayList<RQPDataItemRef> groupingItems = new ArrayList<RQPDataItemRef>();
        for (IXQEQueryNode projection : query.getProjectionList().getChildren()) {
            IXQEQueryNode expr;
            RQPDataItem dataItem = (RQPDataItem)projection;
            if (!dataItem.isGroupingItem() || this.isInScope(groupingItems, (RQPDataItemRef)(expr = dataItem.getExpression()))) continue;
            groupingItems.add((RQPDataItemRef)factory.deepCopyNode(expr));
        }
        return groupingItems;
    }

    public static boolean expressionUsesMultipleShores(RQPQuery query, IXQEQueryNode exp, boolean considerTheBridge) {
        IXQEQueryNode[] refs = exp.getDescendantsOfType(801009, false);
        if (refs.length <= 1) {
            return false;
        }
        String shore = null;
        for (IXQEQueryNode ref : refs) {
            RQPDataItem referencedItem;
            String otherShore;
            if (ref.getParent().getType() == 201037 || (otherShore = (referencedItem = query.getRQPDataItemByName(((RQPDataItemRef)ref).getName())).getBridgeStream()) == null || !considerTheBridge && otherShore.startsWith(BRIDGE_PREFIX)) continue;
            if (shore == null) {
                shore = otherShore;
                continue;
            }
            if (shore.equals(otherShore)) continue;
            return true;
        }
        return false;
    }

    private static boolean expressionUsesShoresAndBridge(RQPQuery query, IXQEQueryNode exp) {
        IXQEQueryNode[] refs = exp.getDescendantsOfType(801009, false);
        if (refs.length <= 1) {
            return false;
        }
        String shore = null;
        for (IXQEQueryNode ref : refs) {
            RQPDataItem referencedItem;
            String otherShore;
            if (ref.getParent().getType() == 201037 || (otherShore = (referencedItem = query.getRQPDataItemByName(((RQPDataItemRef)ref).getName())).getBridgeStream()) == null) continue;
            if (shore == null) {
                shore = otherShore;
                continue;
            }
            if (shore.equals(otherShore) || !otherShore.startsWith(BRIDGE_PREFIX) && !shore.startsWith(BRIDGE_PREFIX)) continue;
            return true;
        }
        return false;
    }

    private boolean isInScope(List<RQPDataItemRef> scope, RQPDataItemRef itemRef) {
        for (RQPDataItemRef scopeRef : scope) {
            if (!scopeRef.getQueryName().equals(itemRef.getQueryName()) || !scopeRef.getName().equals(itemRef.getName())) continue;
            return true;
        }
        return false;
    }

    private void processDataItem(PlanningEnvironment environment, IXQEQueryNode node, List<RQPDataItemRef> currentScope, List<RQPDataItemRef> bridgeKeys, boolean groupingItem) {
        IXQEQueryNode[] breakClauses;
        Boolean value;
        if (node.getType() == 801009) {
            RQPDataItemRef dataItemRef = (RQPDataItemRef)node;
            RQPDataItem referencedItem = dataItemRef.getNextReferencedItem();
            if (referencedItem.isGroupingItem() || node.getParent().getType() == 201037) {
                this.processGroupingItemRef(environment, dataItemRef, groupingItem);
            } else {
                this.processNonGroupingItemRef(environment, dataItemRef, this.mergeScopeWithBridgeKeys(currentScope, bridgeKeys));
            }
            return;
        }
        List<RQPDataItemRef> newScope = currentScope;
        boolean isExplicitAggr = false;
        if (node.getType() == 201031 && (value = node.getBooleanPropertyValue(PROP_IS_EXPLICIT_AGGREGATE)) != null) {
            isExplicitAggr = value;
        }
        if (!isExplicitAggr && (breakClauses = node.getChildrenOfTypeOrdered(201037)).length > 0) {
            newScope = new ArrayList<RQPDataItemRef>();
            IXQEQueryNode[] iXQEQueryNodeArray = breakClauses;
            int n = iXQEQueryNodeArray.length;
            for (int i = 0; i < n; ++i) {
                IXQEQueryNode breakClause = iXQEQueryNodeArray[i];
                for (IXQEQueryNode itemRef : breakClause.getDescendantsOfTypeOrdered(801009, false)) {
                    RQPDataItem referencedItem = ((RQPDataItemRef)itemRef).getNextReferencedItem();
                    RQPDataItemRef referencedItemRef = (RQPDataItemRef)referencedItem.getExpression();
                    if (this.isInScope(newScope, referencedItemRef)) continue;
                    newScope.add((RQPDataItemRef)environment.getNodeFactory().deepCopyNode(referencedItemRef));
                }
            }
        }
        for (IXQEQueryNode child : node.getChildren()) {
            this.processDataItem(environment, child, newScope, bridgeKeys, groupingItem);
        }
    }

    private List<RQPDataItemRef> mergeScopeWithBridgeKeys(List<RQPDataItemRef> scope, List<RQPDataItemRef> bridgeKeys) {
        ArrayList<RQPDataItemRef> newScope = new ArrayList<RQPDataItemRef>(scope);
        for (RQPDataItemRef key : bridgeKeys) {
            if (this.isInScope(newScope, key)) continue;
            newScope.add(key);
        }
        return newScope;
    }

    private List<RQPDataItemRef> getExpressionBridgeKeys(PlanningEnvironment environment, IXQEQueryNode node) {
        ArrayList<RQPDataItemRef> scopeWithKeys = new ArrayList<RQPDataItemRef>();
        for (IXQEQueryNode ref : node.getDescendantsOfTypeOrdered(801009, false)) {
            if (ref.getParent().getType() == 201037) continue;
            RQPDataItem bridgeQueryDataItem = ((RQPDataItemRef)ref).getNextReferencedItem();
            RQPDataItem streamQueryDataItem = ((RQPDataItemRef)bridgeQueryDataItem.getExpression()).getNextReferencedItem();
            RQPProjectionList streamProjectionList = (RQPProjectionList)streamQueryDataItem.getParent();
            boolean checkStream = RQPNode.getRQPQuery(streamQueryDataItem).isBridgeSummaryFilterQuery();
            for (IXQEQueryNode item : streamProjectionList.getChildren()) {
                RQPDataItemRef keyRef;
                RQPDataItem streamDataItem = (RQPDataItem)item;
                if (!streamDataItem.isBridgeKey() || checkStream && !streamDataItem.getBridgeStream().equals(bridgeQueryDataItem.getBridgeStream()) || this.isInScope(scopeWithKeys, keyRef = RQPDataItemRef.create(environment, streamDataItem))) continue;
                scopeWithKeys.add(keyRef);
            }
        }
        return scopeWithKeys;
    }

    private void processGroupingItemRef(PlanningEnvironment environment, RQPDataItemRef dataItemRef, boolean groupingItem) {
        RQPDataItem referencedItem = dataItemRef.getNextReferencedItem();
        RQPSummaryQuery summaryQuery = RQPNode.getRQPQuery(dataItemRef).getDefaultSummaryQuery();
        RQPDataItem dataItem = summaryQuery.getRQPDataItem(environment, (IXQEQueryNode)dataItemRef, referencedItem);
        if (groupingItem) {
            RQPDataItemSelfRef dataItemSelfRef = RQPDataItemSelfRef.create(environment, dataItem.getName());
            if (dataItem.isValueSetRefDataItem()) {
                dataItemSelfRef.setColumnIsForGroupedReport();
            }
            summaryQuery.addToGroupByList(environment, dataItemSelfRef);
        }
        dataItemRef.setName(dataItem.getName());
        dataItemRef.setQueryName(summaryQuery.getName());
    }

    private void processNonGroupingItemRef(PlanningEnvironment environment, RQPDataItemRef dataItemRef, List<RQPDataItemRef> scope) {
        RQPDataItem referencedItem = dataItemRef.getNextReferencedItem();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5ValueSummaryFunction aggr = (V5ValueSummaryFunction)nodeFactory.createNode(201031);
        aggr.setSubType(ApplyAggregatesAcrossBridge.getDataItemAggregateSubtype(referencedItem));
        RQPQuery parentQuery = RQPNode.getRQPQuery(dataItemRef);
        RQPBridgeTabularQuery bridgeTabularQuery = parentQuery.getDefaultBridgeTabularQuery();
        List<IXQEQueryNode> rowNumberScope = this.getRowNumberScope(environment, bridgeTabularQuery, scope, referencedItem);
        RQPDataItem tabularItem = bridgeTabularQuery.generateRowNumber(environment, referencedItem, rowNumberScope, true);
        RQPDataItemRef tabularItemRef = RQPDataItemRef.create(environment, bridgeTabularQuery.getName(), tabularItem.getName());
        aggr.addChild(tabularItemRef);
        RQPSummaryQuery summaryQuery = parentQuery.getDefaultSummaryQuery();
        RQPDataItem summaryItem = summaryQuery.getRQPDataItem(environment, (IXQEQueryNode)aggr, referencedItem);
        dataItemRef.setQueryName(summaryQuery.getName());
        dataItemRef.setName(summaryItem.getName());
    }

    public static int getDataItemAggregateSubtype(RQPDataItem dataItem) {
        int subType = 6;
        RQPDataItem referencedItem = dataItem;
        IXQEQueryNode expr = referencedItem.getExpression();
        while (expr.getType() == 801009) {
            referencedItem = ((RQPDataItemRef)expr).getReferencedItem();
            expr = referencedItem.getExpression();
        }
        if (expr.getType() == 201031) {
            subType = ((V5ValueSummaryFunction)expr).getSubType();
        }
        if (subType == 2) {
            subType = 9;
        }
        return subType;
    }

    private List<IXQEQueryNode> getRowNumberScope(PlanningEnvironment environment, RQPQuery query, List<RQPDataItemRef> scope, RQPDataItem item) {
        XQENodeFactory factory = environment.getNodeFactory();
        ArrayList<IXQEQueryNode> result = new ArrayList<IXQEQueryNode>();
        for (RQPDataItemRef ref : scope) {
            RQPDataItem dataItem = RQPDataItem.create(environment, ref.getName());
            dataItem.addChild(factory.deepCopyNode(ref));
            result.add(dataItem);
        }
        return result;
    }

    private void cleanGroupByLists(RQPQuery query) {
        this.cleanRQPQueryGroupByList(query);
        RQPSubqueryList subqueryList = (RQPSubqueryList)query.getSubqueryList();
        if (subqueryList != null) {
            for (IXQEQueryNode subquery : subqueryList.getChildren()) {
                this.cleanGroupByLists((RQPQuery)subquery);
            }
        }
    }

    private void cleanRQPQueryGroupByList(RQPQuery query) {
        RQPGroupByList groupBy = query.getGroupByList();
        if (groupBy == null) {
            return;
        }
        boolean foundNonGroupingItem = false;
        RQPProjectionList projection = query.getProjectionList();
        for (IXQEQueryNode item : projection.getChildren()) {
            RQPDataItem dataItem = (RQPDataItem)item;
            if (dataItem.isGroupingItem()) continue;
            foundNonGroupingItem = true;
            break;
        }
        if (!foundNonGroupingItem) {
            groupBy.detach();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        if (!rqpQuery.isBridgeWrapperQuery()) {
            this.traceNodeCondition(false, "This RQPQuery is not a Bridge wrapper.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This RQPQuery is a Bridge wrapper, apply aggregates across the bridge.", trace);
        return true;
    }
}

