/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.Bridge;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPBridgeQuery;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.dynamic.DMQuerySubject;
import com.cognos.xqe.metadata.dynamic.DMRelationship;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class InitializeBridgeQueries
extends RQPTransformation {
    public InitializeBridgeQueries() {
        this.mName = "InitializeBridgeQueries";
        this.mPassNumbers = new int[]{37};
        this.mTypes = new int[]{801050};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPBridgeQuery bridgeQuery = (RQPBridgeQuery)node;
        RQPQuery parentQuery = bridgeQuery.getParentRQPQuery();
        RQPFactManager factManager = parentQuery.getFactManager();
        List<IMetadata> joinsForBridge = bridgeQuery.getJoinsForBridge();
        RQPQuery rqpQuery = (RQPQuery)environment.getNodeFactory().createNode(801017);
        rqpQuery.setName(bridgeQuery.getName());
        rqpQuery.setIsBridgeQuery();
        rqpQuery.setJoinsForBridge(joinsForBridge);
        bridgeQuery.exchange(rqpQuery, true);
        List<IMetadata> updatedJoinPath = null;
        RQPJoinPath updatedRqpJoinPath = (RQPJoinPath)parentQuery.getFirstChildByType(801039);
        if (updatedRqpJoinPath == null) {
            updatedJoinPath = new ArrayList<IMetadata>();
            updatedRqpJoinPath = (RQPJoinPath)environment.getNodeFactory().createNode(801039);
            updatedRqpJoinPath.setJoinPath(updatedJoinPath);
            parentQuery.addChild(updatedRqpJoinPath);
            parentQuery.setComputedJoinPlan(true);
        } else {
            updatedJoinPath = updatedRqpJoinPath.getJoinPath();
        }
        for (IMetadata q : joinsForBridge) {
            IRelationship relationship = (IRelationship)q;
            IXQEQueryNode v5JoinExpression = RQPUtilities.getV5BoundRelationshipExpression(relationship, environment);
            IXQEQueryNode[] modelIds = v5JoinExpression.getDescendantsOfType(201116, true);
            String leftQuery = null;
            String rightQuery = null;
            RQPQuery leftSubquery = null;
            RQPQuery rightSubquery = null;
            for (IXQEQueryNode modelId : modelIds) {
                RQPDataItemRef queryItemRef;
                RQPDataItem dataItem;
                String streamName = factManager.getSupportingStream(modelId);
                if (streamName == null) {
                    throw new XQERuntimeException();
                }
                if (leftQuery == null || leftQuery.equals(streamName)) {
                    leftQuery = streamName;
                    leftSubquery = parentQuery.getSubquery(streamName);
                    dataItem = leftSubquery.getRQPDataItem(environment, modelId, RQPUtilities.getExpressionName(modelId));
                    dataItem.setGroupingItem(true);
                    dataItem.setIsBridgeKey(true);
                    queryItemRef = RQPDataItemRef.create(environment, dataItem);
                    modelId.exchange(queryItemRef);
                    continue;
                }
                if (rightQuery == null || rightQuery.equals(streamName)) {
                    rightQuery = streamName;
                    rightSubquery = parentQuery.getSubquery(streamName);
                    dataItem = rightSubquery.getRQPDataItem(environment, modelId, RQPUtilities.getExpressionName(modelId));
                    dataItem.setGroupingItem(true);
                    dataItem.setIsBridgeKey(true);
                    queryItemRef = RQPDataItemRef.create(environment, dataItem);
                    modelId.exchange(queryItemRef);
                    continue;
                }
                throw new XQERuntimeException();
            }
            DMQuerySubject leftSide = new DMQuerySubject(leftQuery);
            DMQuerySubject rightSide = new DMQuerySubject(rightQuery);
            DMRelationship join = new DMRelationship(leftQuery + "<--->" + rightQuery, leftSide, rightSide, "one", "one", "one", "one");
            updatedJoinPath.add(join);
            updatedRqpJoinPath.addChild(v5JoinExpression);
            v5JoinExpression.setPropertyValue("parsedJoinExpression", join);
        }
    }
}

