/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.MDOLogger;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.List;

public class CanReuseMasterDetailFilter
extends RQPTransformation {
    public CanReuseMasterDetailFilter() {
        this.mName = "Can detail query from a master-detail query be optimize?";
        this.mPassNumbers = new int[]{15};
        this.mTypes = new int[]{801011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPDetailFilterList filterList = (RQPDetailFilterList)node;
        List<IXQEQueryNode> masterDetailFilters = this.getMasterDetailFilters(filterList);
        for (IXQEQueryNode filter : masterDetailFilters) {
            IXQEQueryNode comparisonNode = filter.getFirstChildByType(201013);
            comparisonNode.setPropertyValue("useQueryReuse", Boolean.TRUE);
        }
        MDOLogger.logMDOWillBeApplied(environment, masterDetailFilters);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if (!requestEnv.getQueryReuseManager().isQueryReuseEnabled()) {
            this.traceQueryCondition(false, "Query reuse config switches are disabled.", trace);
            MDOLogger.logMDODisabledQueryReuseSwitchFalse(environment);
            return false;
        }
        RQPDetailFilterList filterList = (RQPDetailFilterList)node;
        RQPQuery query = RQPNode.getRQPQuery(filterList);
        IXQEQueryNode parent = query.getParent();
        if (parent == null || parent.getType() != 801041) {
            this.traceQueryCondition(false, "Applicable to only query referenced by QRD.", trace);
            return false;
        }
        RQPSql rqpSQL = (RQPSql)parent;
        if (rqpSQL.getPropertyValue("relationalSubquery") != null) {
            this.traceQueryCondition(false, "Applicable to only relational queries.", trace);
            return false;
        }
        if (!rqpSQL.getGovernors().isLocalCacheEnabled(environment).booleanValue()) {
            this.traceQueryCondition(false, "Applicable when localCache is ON.", trace);
            MDOLogger.logMDODisabledLocalCacheNo(environment, rqpSQL);
            return false;
        }
        if (rqpSQL.getGovernors().getMasterDetailOptimization().equals((Object)Governors.MasterDetailOptimization.DISABLED)) {
            this.traceQueryCondition(false, "masterDetailOptimization is DISABLED.", trace);
            return false;
        }
        List<IXQEQueryNode> masterDetailFilters = this.getMasterDetailFilters(filterList);
        if (masterDetailFilters.size() == 0) {
            this.traceQueryCondition(false, "No master-detail filters to processed.", trace);
            MDOLogger.logMDODisabledNoDataItemToDataItemLink(environment, filterList);
            return false;
        }
        RQPProjectionList projectionList = query.getProjectionList();
        ArrayList<IXQEQueryNode> projectedMasterDetailFilters = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode filter : masterDetailFilters) {
            if (!this.isMasterDetailFilterProjected(environment, projectionList, filter)) continue;
            projectedMasterDetailFilters.add(filter);
        }
        if (masterDetailFilters.size() > projectedMasterDetailFilters.size()) {
            this.traceQueryCondition(false, "All master-detail filters must be projected.", trace);
            MDOLogger.logMDODisabledAllDataItemMustBeProjected(environment, masterDetailFilters);
            return false;
        }
        return true;
    }

    private List<IXQEQueryNode> getMasterDetailFilters(RQPDetailFilterList rqpDetailFilterList) {
        ArrayList<IXQEQueryNode> filters = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode filter : rqpDetailFilterList.getChildren()) {
            if (filter.getPropertyValue("masterDetailDFilter") != Boolean.TRUE) continue;
            filters.add(filter);
        }
        return filters;
    }

    private boolean isMasterDetailFilterProjected(PlanningEnvironment environment, RQPProjectionList projectionList, IXQEQueryNode filter) {
        IXQEQueryNode comparisonNode = filter.getFirstChildByType(201013);
        IXQEQueryNode boundParameter = comparisonNode.getFirstChildByType(201127);
        int filterProjectedItemIndex = 0;
        int boundParameterIndex = comparisonNode.getPositionOfChild(boundParameter);
        if (boundParameterIndex == 0) {
            filterProjectedItemIndex = 1;
        }
        IXQEQueryNode filterProjectedItem = comparisonNode.getChild(filterProjectedItemIndex);
        for (IXQEQueryNode projectionItem : projectionList.getChildren()) {
            IXQEQueryNode expression = projectionItem.getChild(0);
            if (!expression.isSameExpression(filterProjectedItem, false)) continue;
            return true;
        }
        MDOLogger.logDetailDataItemNotProjected(environment, comparisonNode);
        return false;
    }
}

