/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5Exp.V5AggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class CopyV5FiltersToRQPQuery
extends RQPTransformation {
    public CopyV5FiltersToRQPQuery() {
        this.mName = "Copy V5 filters to RQPQuery.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{801017};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rootQuery = (RQPQuery)node;
        V5Query v5Query = rootQuery.getRefV5Query();
        XQENodeFactory factory = environment.getNodeFactory();
        boolean isQueryRef = false;
        RQPSql rqpSql = (RQPSql)node.getAncestorOfType(801041);
        if (rqpSql == null) {
            isQueryRef = true;
        }
        IXQEQueryNode[] detailFilters = v5Query.getV5DetailFilters();
        for (int i = 0; i < detailFilters.length; ++i) {
            String filterUsage;
            boolean isMasterDetailFilter;
            V5DetailFilter detailFilter = (V5DetailFilter)detailFilters[i];
            boolean bl = isMasterDetailFilter = detailFilter.getPropertyValue("masterDetailDFilter") == Boolean.TRUE;
            if (isMasterDetailFilter && isQueryRef || (filterUsage = detailFilter.getUseProperty()).compareTo("prohibited") == 0) continue;
            IXQEQueryNode filterExpression = factory.deepCopyNode(detailFilters[i]);
            if (!this.shouldBeConvertedToSummaryFilter(detailFilters[i], v5Query, environment)) {
                IXQEQueryNode[] v5DataItems;
                for (IXQEQueryNode v5DataItem : v5DataItems = filterExpression.getDescendantsOfType(101003, false)) {
                    v5DataItem.exchange(((V5DataItem)v5DataItem).getDetailContext(environment));
                }
                rootQuery.addToDetailFilterList(environment, filterExpression);
                IXQEQueryNode orgfilterExpression = factory.deepCopyNode(detailFilters[i].getChild(0));
                filterExpression.setPropertyValue("orgFltExpr", orgfilterExpression);
                continue;
            }
            CopyV5FiltersToRQPQuery.convertToSummaryFilter(environment, rootQuery, (V5DetailFilter)detailFilters[i], true);
        }
        IXQEQueryNode[] summaryFilters = v5Query.getV5SummaryFilters();
        for (int i = 0; i < summaryFilters.length; ++i) {
            String filterUsage = ((V5SummaryFilter)summaryFilters[i]).getUseProperty();
            if (filterUsage.compareTo("prohibited") == 0) continue;
            IXQEQueryNode filterExpression = this.expandFilterExpression(factory.deepCopyNode(summaryFilters[i]), environment);
            if (!RQPUtilities.hasAggregateInExpression(filterExpression.getChild(0))) {
                IXQEQueryNode[] v5DataItems;
                boolean isGroupingItem = false;
                boolean isRollupAsStandardAggregate = false;
                for (IXQEQueryNode v5DataItem : v5DataItems = summaryFilters[i].getDescendantsOfType(101003, false)) {
                    String dataItemName = ((V5DataItem)v5DataItem).getNameProperty();
                    RQPDataItem projection = rootQuery.findProjection(dataItemName);
                    if (projection != null && projection.isGroupingItem()) {
                        isGroupingItem = true;
                    }
                    if (!V5AggregateEnum.isStandardAggregate(((V5DataItem)v5DataItem).getRollupAggregateProperty())) continue;
                    isRollupAsStandardAggregate = true;
                }
                if (isGroupingItem || !isRollupAsStandardAggregate) {
                    V5DetailFilter v5DetailFilter = (V5DetailFilter)factory.createNode(101008);
                    v5DetailFilter.addChild(factory.deepCopyNode(filterExpression.getChild(0)));
                    v5DetailFilter.setOriginalExpression(((V5SummaryFilter)summaryFilters[i]).getOriginalExpression());
                    v5DetailFilter.setPropertyValue("convertedFromSummary", Boolean.TRUE);
                    rootQuery.addToDetailFilterList(environment, v5DetailFilter);
                    if (summaryFilters[i].getPropertyValue("splitFilterAtAND") != null) {
                        StringBuilder sb = new StringBuilder();
                        v5DetailFilter.getChild(0).writeFormattedText(sb);
                        ResponseMessage respMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_ConvertedPartOfSummaryFilterToDetailFilter, v5DetailFilter.getOriginalExpression(), rootQuery.getName(), sb.toString());
                        ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(respMsg, null, environment.getRoot());
                        continue;
                    }
                    ResponseMessage respMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_ConvertedSummaryFilterToDetailFilter, rootQuery.getName(), v5DetailFilter.getOriginalExpression());
                    ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(respMsg, summaryFilters[i], environment.getRoot());
                    continue;
                }
            }
            rootQuery.addToSummaryFilterList(environment, environment.getNodeFactory().deepCopyNode(summaryFilters[i]));
        }
    }

    public static void convertToSummaryFilter(PlanningEnvironment environment, RQPQuery rootQuery, V5DetailFilter v5DetailFilter, boolean duplicateFilterExpr) {
        V5SummaryFilter summaryFilter = (V5SummaryFilter)environment.getNodeFactory().createNode(101011);
        summaryFilter.setPropertyValue("convertedFromDetail", Boolean.TRUE);
        summaryFilter.setOriginalExpression(v5DetailFilter.getOriginalExpression());
        summaryFilter.setPostAutoAggregation(v5DetailFilter.getPostAutoAggregation());
        IXQEQueryNode filterExpression = v5DetailFilter;
        if (duplicateFilterExpr) {
            filterExpression = environment.getNodeFactory().deepCopyNode(v5DetailFilter);
        }
        summaryFilter.addChild(filterExpression.getChild(0).detach());
        rootQuery.addToSummaryFilterList(environment, summaryFilter);
    }

    private IXQEQueryNode expandFilterExpression(IXQEQueryNode filterExpression, PlanningEnvironment environment) {
        IXQEQueryNode[] v5DataItems;
        for (IXQEQueryNode v5DataItem : v5DataItems = filterExpression.getDescendantsOfType(101003, false)) {
            if (v5DataItem.getParent().getType() == 201037) {
                v5DataItem.exchange(((V5DataItem)v5DataItem).getDetailContext(environment));
                continue;
            }
            if (!((V5DataItem)v5DataItem).isAggregate()) {
                IXQEQueryNode detailExp = ((V5DataItem)v5DataItem).getDetailContext(environment);
                v5DataItem.exchange(detailExp);
                continue;
            }
            IXQEQueryNode aggrExp = ((V5DataItem)v5DataItem).getAggregateExpression(environment);
            v5DataItem.exchange(aggrExp);
        }
        return filterExpression;
    }

    private boolean shouldBeConvertedToSummaryFilter(IXQEQueryNode filter, V5Query v5Query, PlanningEnvironment environment) {
        if (filter.getAncestorOfType(101072) != null) {
            return false;
        }
        if (RQPUtilities.hasAggregateInExpression(filter)) {
            return true;
        }
        Boolean postAutoAggregation = ((V5DetailFilter)filter).getPostAutoAggregation();
        if (postAutoAggregation == null || postAutoAggregation == Boolean.FALSE) {
            return false;
        }
        IXQEQueryNode[] detailExprNodes = RQPUtilities.getDetailExprNodes(filter);
        int detailExprNodesCount = detailExprNodes.length;
        if (detailExprNodesCount == 0) {
            return postAutoAggregation != null && postAutoAggregation == Boolean.TRUE;
        }
        for (IXQEQueryNode v5DIRef : detailExprNodes) {
            if (v5DIRef.getType() == 201103 || v5DIRef.getType() == 201097) {
                if (!CopyV5FiltersToRQPQuery.isOriginallyDataItemRef(v5DIRef) && !CopyV5FiltersToRQPQuery.isPartOfExpressionOfDataItemRef(v5DIRef)) continue;
                return true;
            }
            if (v5DIRef.getType() == 201060) {
                V5BoundDataItemReference v5BoundDataItemRef = (V5BoundDataItemReference)v5DIRef;
                if (!v5BoundDataItemRef.isQueryRefItem() || !CopyV5FiltersToRQPQuery.isOriginallyDataItemRef(v5BoundDataItemRef) && !CopyV5FiltersToRQPQuery.isPartOfExpressionOfDataItemRef(v5BoundDataItemRef)) continue;
                return true;
            }
            return true;
        }
        if (filter.getPropertyValue("splitFilterAtAND") == null) {
            ResponseMessage respMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_ConvertDetailFilterPAATrueToFalse, v5Query.getRootQueryName(), ((V5DetailFilter)filter).getOriginalExpression());
            ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(respMsg, filter, environment.getRoot());
        } else {
            StringBuilder sb = new StringBuilder();
            filter.writeFormattedText(sb);
            ResponseMessage respMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_ConvertPartOfDetailFilterPAATrueToFalse, ((V5DetailFilter)filter).getOriginalExpression(), v5Query.getRootQueryName(), sb.toString());
            ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(respMsg, null, environment.getRoot());
        }
        return false;
    }

    public static boolean isOriginallyDataItemRef(IXQEQueryNode identifier) {
        IXQEQueryNode v5DI = identifier.getParent();
        return v5DI.getType() == 101003 && ((V5DataItem)v5DI).getOriginalV5DataItem() != null;
    }

    public static boolean isPartOfExpressionOfDataItemRef(IXQEQueryNode identifier) {
        IXQEQueryNode expr = identifier.getParent();
        IXQEQueryNode v5DI = expr.getParent();
        if (201014 == expr.getType() && 101003 == v5DI.getType() && null != ((V5DataItem)v5DI).getOriginalV5DataItem()) {
            return true;
        }
        IXQEQueryNode parent = identifier.getParent();
        while (parent.getType() != 101003 && parent.getType() != 101008) {
            if ((parent = parent.getParent()).getType() != 101003 || ((V5DataItem)parent).getOriginalV5DataItem() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        int i;
        XQETrace xqeTrace = environment.getTrace();
        if (node.getFirstChildByType(801011) != null || node.getFirstChildByType(801023) != null) {
            this.traceNodeCondition(false, "The V5 filters are already copied in RQPQuery.", xqeTrace);
            return false;
        }
        V5Query v5Query = ((RQPQuery)node).getRefV5Query();
        IXQEQueryNode[] detailFilters = v5Query.getV5DetailFilters();
        IXQEQueryNode[] summaryFilters = v5Query.getV5SummaryFilters();
        if (detailFilters.length == 0 && summaryFilters.length == 0) {
            this.traceNodeCondition(false, "The V5 query does not have detail/summary filters.", xqeTrace);
            return false;
        }
        boolean isQueryRef = false;
        RQPSql rqpSql = (RQPSql)node.getAncestorOfType(801041);
        if (rqpSql == null) {
            isQueryRef = true;
        }
        for (i = 0; i < detailFilters.length; ++i) {
            String filterUsage;
            boolean isMasterDetailFilter;
            V5DetailFilter detailFilter = (V5DetailFilter)detailFilters[i];
            boolean bl = isMasterDetailFilter = detailFilter.getPropertyValue("masterDetailDFilter") == Boolean.TRUE;
            if (isMasterDetailFilter && isQueryRef || (filterUsage = detailFilter.getUseProperty()).compareTo("prohibited") == 0) continue;
            this.traceNodeCondition(true, "There is at least one detail filter needs to be copied into RQPQuery.", xqeTrace);
            return true;
        }
        for (i = 0; i < summaryFilters.length; ++i) {
            String filterUsage = ((V5SummaryFilter)summaryFilters[i]).getUseProperty();
            if (filterUsage.compareTo("prohibited") == 0) continue;
            this.traceNodeCondition(true, "There is at least one summary filter needs to be copied into RQPQuery.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "There are no filters need to be copied into RQPQuery.", xqeTrace);
        return false;
    }
}

