/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPBridgeQuery;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DetectMultiFactOperationsInvolvingDetailItems
extends RQPTransformation {
    public static final String MULTIFACT_OPERATION_CANNOT_BE_APPLIED = "MultiFactOperationCannotBeApplied";

    public DetectMultiFactOperationsInvolvingDetailItems() {
        this.mName = "Detect Multifact Operations on Detail Items";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean allowMultiFactOperationsOnDetailItems = config.getBooleanProperty("general.allowMultiFactOperationsOnDetailItems[@enabled]", false);
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        V5Selection v5Selection = rqpQuery.getRefV5Query().getV5Selection();
        for (IXQEQueryNode proj : projectionList.getChildren()) {
            RQPDataItem projection = (RQPDataItem)proj;
            if (projection.getBooleanPropertyValue(MULTIFACT_OPERATION_CANNOT_BE_APPLIED) == null) continue;
            String itemName = projection.getName();
            V5DataItem v5DataItem = v5Selection.getDataItemByRefName(itemName);
            IXQEQueryNode v5Expression = v5DataItem.getDetailExpression();
            if (v5Expression.getType() == 201116) {
                V5BoundModelIdentifier bmi = (V5BoundModelIdentifier)v5Expression;
                if (allowMultiFactOperationsOnDetailItems) {
                    String nag = XQEMessages.getMessage(XQEMessageKeys.PLN_MultiFactOperationInvolvesDetailItems, XQEMessages.getCurrProductLocale(), bmi.getNativeName());
                    ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nag);
                    continue;
                }
                throw new XQERuntimeException(XQEMessageKeys.PLN_MultiFactOperationInvolvesDetailItems, bmi.getNativeName());
            }
            if (allowMultiFactOperationsOnDetailItems) {
                String nag = XQEMessages.getMessage(XQEMessageKeys.PLN_MultiFactOperationInvolvesDetailItems2, XQEMessages.getCurrProductLocale(), v5DataItem.getFullName());
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nag);
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_MultiFactOperationInvolvesDetailItems2, v5DataItem.getFullName());
        }
    }

    private boolean exprContainsMoreThanOneFactStream(RQPQuery rqpQuery, IXQEQueryNode expr, RQPFactManager factManager) {
        ArrayList<IXQEQueryNode> bmiList = new ArrayList<IXQEQueryNode>();
        ExpressionAnalyzer.getAllReferencedModelID(expr, bmiList);
        HashSet<String> factStreamNames = new HashSet<String>();
        for (IXQEQueryNode node : bmiList) {
            RQPQuery subQuery;
            List<String> supportingFactStreams = factManager.getSupportingStreams(node, null);
            if (supportingFactStreams.size() > 1 || (subQuery = rqpQuery.getSubquery(supportingFactStreams.get(0))).isBridgeQuery() || subQuery instanceof RQPBridgeQuery) continue;
            factStreamNames.add(supportingFactStreams.get(0));
        }
        return factStreamNames.size() > 1;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (node.getAncestorOfType(101072) != null) {
            this.traceNodeCondition(false, "The transformation is not applicable for a DMR prePlan query.", trace);
            return false;
        }
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPQuery rootQuery = rqpQuery.getRootRQPQuery();
        if (!rootQuery.isMultiFactQuery()) {
            this.traceNodeCondition(false, "The query is not a multi-fact query", trace);
            return false;
        }
        if (!rootQuery.isAutoSummaryTRUE()) {
            this.traceNodeCondition(false, "The request has autoSummary set to false", trace);
            return false;
        }
        if (rootQuery != rqpQuery) {
            return false;
        }
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        V5Selection v5Selection = rootQuery.getRefV5Query().getV5Selection();
        RQPFactManager factManager = rootQuery.getFactManager();
        for (IXQEQueryNode proj : projectionList.getChildren()) {
            IXQEQueryNode[] operationNodes;
            RQPDataItem projection = (RQPDataItem)proj;
            String itemName = projection.getName();
            V5DataItem v5DataItem = v5Selection.getDataItemByRefName(itemName);
            if (v5DataItem == null) continue;
            for (IXQEQueryNode operationNode : operationNodes = projection.getDescendantsOfType(201014, true)) {
                if (!this.exprContainsMoreThanOneFactStream(rqpQuery, operationNode, factManager) || ExpressionAnalyzer.eachTermInExprIsAggregated(operationNode)) continue;
                projection.setPropertyValue(MULTIFACT_OPERATION_CANNOT_BE_APPLIED, true);
                this.traceNodeCondition(true, "The request has an operation that can not be applied in the multifact query", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "There is no operation that can not be applied in the multifact query ", trace);
        return false;
    }
}

