/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeAggregatesInAppropriateSubQueries;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ProcessDataItemRefInValueSet;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.List;

public class DetectNoOpAggregates
extends RQPTransformation {
    public static final String PROP_NOOP = "noop";

    public DetectNoOpAggregates() {
        this.mName = "DetectNoOpAggregates";
        this.mPassNumbers = new int[]{53};
        this.mTypes = new int[]{801008, 101011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ArrayList<IXQEQueryNode> aggregates = new ArrayList<IXQEQueryNode>();
        this.getTopAggregates(node, aggregates);
        for (IXQEQueryNode aggregate : aggregates) {
            List<IXQEQueryNode> nestedAggregates = aggregate.getDescendantsOfTypesOrdered(new int[]{201031, 201033}, true);
            for (int i = nestedAggregates.size() - 2; i >= 0; --i) {
                IXQEQueryNode innerAggregate = null;
                innerAggregate = DetectNoOpAggregates.getInnerStandardAggregate(nestedAggregates.get(i), environment);
                if (innerAggregate == null || !this.nestedAggregateAtHigherOrSameScope((V5AggregateFunction)nestedAggregates.get(i), (V5AggregateFunction)innerAggregate, environment)) continue;
                nestedAggregates.get(i).setPropertyValue(PROP_NOOP, "true");
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (0 != node.getDescendantsOfType(201035, false).length) {
            return false;
        }
        ArrayList<IXQEQueryNode> aggregates = new ArrayList<IXQEQueryNode>();
        this.getTopAggregates(node, aggregates);
        if (0 == aggregates.size()) {
            return false;
        }
        boolean status = false;
        for (IXQEQueryNode aggregate : aggregates) {
            List<IXQEQueryNode> nestedAggregates = aggregate.getDescendantsOfTypesOrdered(new int[]{201031, 201033}, true);
            if (nestedAggregates.size() < 2) continue;
            for (int i = nestedAggregates.size() - 2; i >= 0; --i) {
                V5AggregateFunction aggr = (V5AggregateFunction)nestedAggregates.get(i);
                IXQEQueryNode innerAggr = null;
                innerAggr = DetectNoOpAggregates.getInnerStandardAggregate(aggr, environment);
                if (innerAggr == null || !this.nestedAggregateAtHigherOrSameScope(aggr, (V5AggregateFunction)innerAggr, environment)) continue;
                status = true;
            }
        }
        return status;
    }

    public static IXQEQueryNode getInnerStandardAggregate(IXQEQueryNode aggr, PlanningEnvironment environment) {
        ArrayList<IXQEQueryNode> aggregates = new ArrayList<IXQEQueryNode>();
        DetectNoOpAggregates.getTopAggregatesOfType(aggr.getChildren(), 201031, aggregates);
        IXQEQueryNode innerAggr = null;
        int scopeSize = -1;
        for (IXQEQueryNode agg : aggregates) {
            IXQEQueryNode[] scope = DetectNoOpAggregates.getScope((V5AggregateFunction)agg, environment);
            if (scope == null || scope.length == 0) {
                if (scopeSize != -1) continue;
                scopeSize = 0;
                innerAggr = agg;
                continue;
            }
            if (scopeSize >= scope.length) continue;
            scopeSize = scope.length;
            innerAggr = agg;
        }
        return innerAggr;
    }

    public static void getTopAggregatesOfType(IXQEQueryNode[] nodes, int nodetype, List<IXQEQueryNode> aggregates) {
        for (IXQEQueryNode node : nodes) {
            IXQEQueryNode parent = node.getParent();
            if (parent.getType() == 201014) {
                int subType = ((V5ValueExpression)parent).getSubType();
                if (subType == 3 && 1 == parent.getPositionOfChild(node)) continue;
                if (subType == 0 || subType == 2 || subType == 1 || subType == 4 || subType == 3) {
                    IXQEQueryNode otherNode;
                    int otherPos = 1;
                    if (parent.getPositionOfChild(node) > 0) {
                        otherPos = 0;
                    }
                    if ((otherNode = parent.getChild(otherPos)).getType() != 201031 && DetectNoOpAggregates.containsDetailExpression(otherNode)) continue;
                }
            }
            IXQEQueryNode ifOrCaseAncestor = node.getAncestorOfType(201017);
            IXQEQueryNode parentAggr = node.getAncestorOfType(nodetype);
            if (ifOrCaseAncestor != null && node.isAncestor(ifOrCaseAncestor.getChild(0)) && ifOrCaseAncestor.isAncestor(parentAggr)) continue;
            ifOrCaseAncestor = node.getAncestorOfType(201018);
            if (ifOrCaseAncestor != null) {
                IXQEQueryNode[] whens = ifOrCaseAncestor.getChildrenOfType(201019);
                boolean isCondition = false;
                for (IXQEQueryNode when : whens) {
                    if (!node.isAncestor(when.getChild(0))) continue;
                    isCondition = true;
                    break;
                }
                if (201019 != ifOrCaseAncestor.getChild(0).getType()) {
                    isCondition = node.isAncestor(ifOrCaseAncestor.getChild(0));
                }
                if (isCondition && ifOrCaseAncestor.isAncestor(parentAggr)) continue;
            }
            if (node.getType() != nodetype || node.getPropertyValue(PROP_NOOP) != null) {
                if (node.getType() == 801009) {
                    RQPDataItemRef ref = (RQPDataItemRef)node;
                    DetectNoOpAggregates.getTopAggregatesOfType(ref.getNextReferencedItem().getChildren(), nodetype, aggregates);
                    continue;
                }
                DetectNoOpAggregates.getTopAggregatesOfType(node.getChildren(), nodetype, aggregates);
                continue;
            }
            aggregates.add(node);
        }
    }

    private void getTopAggregates(IXQEQueryNode node, List<IXQEQueryNode> aggregates) {
        if (node.getType() == 201033 || node.getType() == 201031) {
            aggregates.add(node);
            return;
        }
        for (IXQEQueryNode child : node.getChildren()) {
            this.getTopAggregates(child, aggregates);
        }
    }

    private boolean nestedAggregateAtHigherOrSameScope(V5AggregateFunction outerAggregate, V5AggregateFunction nestedAggregate, PlanningEnvironment environment) {
        IXQEQueryNode[] outerScope = DetectNoOpAggregates.getScope(outerAggregate, environment);
        IXQEQueryNode[] innerScope = DetectNoOpAggregates.getScope(nestedAggregate, environment);
        if (innerScope == null || innerScope.length == 0) {
            return true;
        }
        if (outerScope == null || outerScope.length == 0) {
            return false;
        }
        return RQPSummaryQuery.groupingItemsAreSubsetOf(innerScope, outerScope);
    }

    public static IXQEQueryNode[] getScope(V5AggregateFunction aggr, PlanningEnvironment environment) {
        IXQEQueryNode summaryFilter = aggr.getAncestorOfType(101011);
        if (null != summaryFilter) {
            V5AggregateFunction operand = aggr;
            if (ExpressionAnalyzer.isAnalyticFunction(aggr)) {
                operand = ExpressionAnalyzer.getStdAggregateOperandOfAnalyticFunction(aggr);
            }
            RQPQuery rqpQuery = DistributeAggregatesInAppropriateSubQueries.getSummaryQueryForSummaryFilterAggregate(summaryFilter, aggr, environment, operand);
            return rqpQuery.getGroupingItems();
        }
        V5AggregateBreakClause forClause = aggr.getForClause();
        if (forClause != null) {
            return forClause.getChildren();
        }
        if (ExpressionAnalyzer.isAnalyticFunction(aggr)) {
            return null;
        }
        RQPQuery parentQuery = RQPNode.getRQPQuery(aggr);
        if (aggr.getRollupAggregateNode()) {
            RQPDataItem item = (RQPDataItem)aggr.getAncestorOfType(801008);
            boolean isForFooter = !item.isGroupBodyItemOfNonLastValueSet();
            List<V5DataItem> v5GroupingList = ProcessDataItemRefInValueSet.getGroupingItems(item.getValueSet(), parentQuery, isForFooter);
            return DetectNoOpAggregates.convertListV5DataItemToIXQEQueryNodeArray(parentQuery.getRootRQPQuery(), v5GroupingList);
        }
        RQPQuery rqpQuery = parentQuery.getParentRQPQuery();
        RQPSummaryQuery lowestSumQuery = rqpQuery.getDefaultSummaryQuery();
        if (lowestSumQuery == null) {
            return null;
        }
        return lowestSumQuery.getGroupingItems();
    }

    public static IXQEQueryNode[] convertListV5DataItemToIXQEQueryNodeArray(RQPQuery rqpQuery, List<V5DataItem> v5DataItemList) {
        IXQEQueryNode[] array = new IXQEQueryNode[v5DataItemList.size()];
        for (int i = 0; i < v5DataItemList.size(); ++i) {
            V5DataItem v5DataItem = v5DataItemList.get(i);
            array[i] = rqpQuery.getRQPDataItemByName(v5DataItem.getNameProperty());
        }
        return array;
    }

    static boolean containsDetailExpression(IXQEQueryNode child) {
        IXQEQueryNode ancestorAggr = child.getParent().getAncestorOfType(201031);
        List<IXQEQueryNode> allV5BoundMI = child.getDescendantsOfTypeOrdered(201116, true);
        for (IXQEQueryNode b : allV5BoundMI) {
            if (ancestorAggr != b.getAncestorOfType(201031)) continue;
            return true;
        }
        return false;
    }
}

