/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class DetectSummaryFilterWithForClauseAndLevel
extends Transformation {
    public static final String PROP_IGNORE_LEVEL = "ignoreLevel";

    public DetectSummaryFilterWithForClauseAndLevel() {
        this.mName = "Issue warning for summary filter with for clause and level.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{101011};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query = (V5Query)node.getParent();
        IXQEQueryNode firstSummaryFilter = v5Query.getFirstChildByType(101011);
        int posOfFirst = v5Query.getPositionOfChild(firstSummaryFilter);
        ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_IgnoreScopeLevelOfSummaryFilter, v5Query.getV5QueryName(), Integer.valueOf(v5Query.getPositionOfChild(node) - posOfFirst + 1).toString());
        environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
        node.setPropertyValue(PROP_IGNORE_LEVEL, true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The RQPDataItem node is not under a RQP query", trace);
            return false;
        }
        if (null == node.getFirstChildByType(101012)) {
            return false;
        }
        IXQEQueryNode[] aggregateNodes = ExpressionAnalyzer.getAggregateNodes(node);
        for (int i = 0; i < aggregateNodes.length; ++i) {
            if (null != aggregateNodes[i].getAncestorOfType(201031) || !ExpressionAnalyzer.isStandardAggregate(aggregateNodes[i]) || null == ((V5AggregateFunction)aggregateNodes[i]).getForClause()) continue;
            return true;
        }
        return false;
    }
}

